/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NodeYUI;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ParserYUI;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

final class IRFactoryYUI {
    private ParserYUI parser;
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;

    IRFactoryYUI(ParserYUI parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(135);
    }

    void initScript(ScriptOrFnNode scriptNode, NodeYUI body) {
        NodeYUI children = body.getFirstChild();
        if (children != null) {
            scriptNode.addChildrenToBack(children);
        }
    }

    NodeYUI createLeaf(int nodeType) {
        return new NodeYUI(nodeType);
    }

    NodeYUI createSwitch(NodeYUI expr, int lineno) {
        NodeYUI.Jump switchNode = new NodeYUI.Jump(113, expr, lineno);
        NodeYUI block = new NodeYUI(128, switchNode);
        return block;
    }

    void addSwitchCase(NodeYUI switchBlock, NodeYUI caseExpression, NodeYUI statements) {
        if (switchBlock.getType() != 128) {
            throw Kit.codeBug();
        }
        NodeYUI.Jump switchNode = (NodeYUI.Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 113) {
            throw Kit.codeBug();
        }
        NodeYUI gotoTarget = NodeYUI.newTarget();
        if (caseExpression != null) {
            NodeYUI.Jump caseNode = new NodeYUI.Jump(114, caseExpression);
            caseNode.target = gotoTarget;
            switchNode.addChildToBack(caseNode);
        } else {
            switchNode.setDefault(gotoTarget);
        }
        switchBlock.addChildToBack(gotoTarget);
        switchBlock.addChildToBack(statements);
    }

    void closeSwitch(NodeYUI switchBlock) {
        NodeYUI switchBreakTarget;
        if (switchBlock.getType() != 128) {
            throw Kit.codeBug();
        }
        NodeYUI.Jump switchNode = (NodeYUI.Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 113) {
            throw Kit.codeBug();
        }
        switchNode.target = switchBreakTarget = NodeYUI.newTarget();
        NodeYUI defaultTarget = switchNode.getDefault();
        if (defaultTarget == null) {
            defaultTarget = switchBreakTarget;
        }
        switchBlock.addChildAfter(this.makeJump(5, defaultTarget), switchNode);
        switchBlock.addChildToBack(switchBreakTarget);
    }

    NodeYUI createVariables(int token, int lineno) {
        return new NodeYUI(token, lineno);
    }

    NodeYUI createExprStatement(NodeYUI expr, int lineno) {
        int type = this.parser.insideFunction() ? 132 : 133;
        return new NodeYUI(type, expr, lineno);
    }

    NodeYUI createExprStatementNoReturn(NodeYUI expr, int lineno) {
        return new NodeYUI(132, expr, lineno);
    }

    NodeYUI createDefaultNamespace(NodeYUI expr, int lineno) {
        this.setRequiresActivation();
        NodeYUI n = this.createUnary(73, expr);
        NodeYUI result = this.createExprStatement(n, lineno);
        return result;
    }

    NodeYUI createName(String name) {
        this.checkActivationName(name, 39);
        return NodeYUI.newString(39, name);
    }

    private NodeYUI createName(int type, String name, NodeYUI child) {
        NodeYUI result = this.createName(name);
        result.setType(type);
        if (child != null) {
            result.addChildToBack(child);
        }
        return result;
    }

    NodeYUI createString(String string) {
        return NodeYUI.newString(string);
    }

    NodeYUI createNumber(double number) {
        return NodeYUI.newNumber(number);
    }

    NodeYUI createCatch(String varName, NodeYUI catchCond, NodeYUI stmts, int lineno) {
        if (catchCond == null) {
            catchCond = new NodeYUI(127);
        }
        return new NodeYUI(123, this.createName(varName), catchCond, stmts, lineno);
    }

    NodeYUI createThrow(NodeYUI expr, int lineno) {
        return new NodeYUI(50, expr, lineno);
    }

    NodeYUI createReturn(NodeYUI expr, int lineno) {
        return expr == null ? new NodeYUI(4, lineno) : new NodeYUI(4, expr, lineno);
    }

    NodeYUI createDebugger(int lineno) {
        return new NodeYUI(159, lineno);
    }

    NodeYUI createLabel(int lineno) {
        return new NodeYUI.Jump(129, lineno);
    }

    NodeYUI getLabelLoop(NodeYUI label) {
        return ((NodeYUI.Jump)label).getLoop();
    }

    NodeYUI createLabeledStatement(NodeYUI labelArg, NodeYUI statement) {
        NodeYUI.Jump label = (NodeYUI.Jump)labelArg;
        NodeYUI breakTarget = NodeYUI.newTarget();
        NodeYUI block = new NodeYUI(128, (NodeYUI)label, statement, breakTarget);
        label.target = breakTarget;
        return block;
    }

    NodeYUI createBreak(NodeYUI breakStatement, int lineno) {
        NodeYUI.Jump jumpStatement;
        NodeYUI.Jump n = new NodeYUI.Jump(119, lineno);
        int t = breakStatement.getType();
        if (t == 131 || t == 129) {
            jumpStatement = (NodeYUI.Jump)breakStatement;
        } else if (t == 128 && breakStatement.getFirstChild().getType() == 113) {
            jumpStatement = (NodeYUI.Jump)breakStatement.getFirstChild();
        } else {
            throw Kit.codeBug();
        }
        n.setJumpStatement(jumpStatement);
        return n;
    }

    NodeYUI createContinue(NodeYUI loop, int lineno) {
        if (loop.getType() != 131) {
            Kit.codeBug();
        }
        NodeYUI.Jump n = new NodeYUI.Jump(120, lineno);
        n.setJumpStatement((NodeYUI.Jump)loop);
        return n;
    }

    NodeYUI createBlock(int lineno) {
        return new NodeYUI(128, lineno);
    }

    FunctionNode createFunction(String name) {
        return new FunctionNode(name);
    }

    NodeYUI initFunction(FunctionNode fnNode, int functionIndex, NodeYUI statements, int functionType) {
        NodeYUI lastStmt;
        String name;
        fnNode.itsFunctionType = functionType;
        fnNode.addChildToBack(statements);
        int functionCount = fnNode.getFunctionCount();
        if (functionCount != 0) {
            fnNode.itsNeedsActivation = true;
        }
        if (functionType == 2 && (name = fnNode.getFunctionName()) != null && name.length() != 0) {
            NodeYUI setFn = new NodeYUI(132, new NodeYUI(8, NodeYUI.newString(49, name), new NodeYUI(63)));
            statements.addChildrenToFront(setFn);
        }
        if ((lastStmt = statements.getLastChild()) == null || lastStmt.getType() != 4) {
            statements.addChildToBack(new NodeYUI(4));
        }
        NodeYUI result = NodeYUI.newString(108, fnNode.getFunctionName());
        result.putIntProp(1, functionIndex);
        return result;
    }

    void addChildToBack(NodeYUI parent, NodeYUI child) {
        parent.addChildToBack(child);
    }

    NodeYUI createScopeNode(int token, int lineno) {
        return new NodeYUI.Scope(token, lineno);
    }

    NodeYUI createLoopNode(NodeYUI loopLabel, int lineno) {
        NodeYUI.Scope result = new NodeYUI.Scope(131, lineno);
        if (loopLabel != null) {
            ((NodeYUI.Jump)loopLabel).setLoop(result);
        }
        return result;
    }

    NodeYUI createWhile(NodeYUI loop, NodeYUI cond, NodeYUI body) {
        return this.createLoop((NodeYUI.Jump)loop, 1, body, cond, null, null);
    }

    NodeYUI createDoWhile(NodeYUI loop, NodeYUI body, NodeYUI cond) {
        return this.createLoop((NodeYUI.Jump)loop, 0, body, cond, null, null);
    }

    NodeYUI createFor(NodeYUI loop, NodeYUI init, NodeYUI test, NodeYUI incr, NodeYUI body) {
        if (init.getType() == 152) {
            NodeYUI.Scope let = NodeYUI.Scope.splitScope((NodeYUI.Scope)loop);
            let.setType(152);
            let.addChildrenToBack(init);
            let.addChildToBack(this.createLoop((NodeYUI.Jump)loop, 2, body, test, new NodeYUI(127), incr));
            return let;
        }
        return this.createLoop((NodeYUI.Jump)loop, 2, body, test, init, incr);
    }

    private NodeYUI createLoop(NodeYUI.Jump loop, int loopType, NodeYUI body, NodeYUI cond, NodeYUI init, NodeYUI incr) {
        NodeYUI bodyTarget = NodeYUI.newTarget();
        NodeYUI condTarget = NodeYUI.newTarget();
        if (loopType == 2 && cond.getType() == 127) {
            cond = new NodeYUI(45);
        }
        NodeYUI.Jump IFEQ = new NodeYUI.Jump(6, cond);
        IFEQ.target = bodyTarget;
        NodeYUI breakTarget = NodeYUI.newTarget();
        loop.addChildToBack(bodyTarget);
        loop.addChildrenToBack(body);
        if (loopType == 1 || loopType == 2) {
            loop.addChildrenToBack(new NodeYUI(127, loop.getLineno()));
        }
        loop.addChildToBack(condTarget);
        loop.addChildToBack(IFEQ);
        loop.addChildToBack(breakTarget);
        loop.target = breakTarget;
        NodeYUI continueTarget = condTarget;
        if (loopType == 1 || loopType == 2) {
            loop.addChildToFront(this.makeJump(5, condTarget));
            if (loopType == 2) {
                int initType = init.getType();
                if (initType != 127) {
                    if (initType != 121 && initType != 152) {
                        init = new NodeYUI(132, init);
                    }
                    loop.addChildToFront(init);
                }
                NodeYUI incrTarget = NodeYUI.newTarget();
                loop.addChildAfter(incrTarget, body);
                if (incr.getType() != 127) {
                    incr = new NodeYUI(132, incr);
                    loop.addChildAfter(incr, incrTarget);
                }
                continueTarget = incrTarget;
            }
        }
        loop.setContinue(continueTarget);
        return loop;
    }

    /*
     * Enabled aggressive block sorting
     */
    NodeYUI createForIn(int declType, NodeYUI loop, NodeYUI lhs, NodeYUI obj, NodeYUI body, boolean isForEach) {
        NodeYUI assign;
        NodeYUI lvalue;
        int destructuring = -1;
        int destructuringLen = 0;
        int type = lhs.getType();
        if (type == 121 || type == 152) {
            NodeYUI lastChild = lhs.getLastChild();
            if (lhs.getFirstChild() != lastChild) {
                this.parser.reportError("msg.mult.index");
            }
            if (lastChild.getType() == 65 || lastChild.getType() == 66) {
                type = destructuring = lastChild.getType();
                lvalue = lastChild;
                destructuringLen = lastChild.getIntProp(21, 0);
            } else {
                if (lastChild.getType() != 39) {
                    this.parser.reportError("msg.bad.for.in.lhs");
                    return obj;
                }
                lvalue = NodeYUI.newString(39, lastChild.getString());
            }
        } else if (type == 65 || type == 66) {
            destructuring = type;
            lvalue = lhs;
            destructuringLen = lhs.getIntProp(21, 0);
        } else {
            lvalue = this.makeReference(lhs);
            if (lvalue == null) {
                this.parser.reportError("msg.bad.for.in.lhs");
                return obj;
            }
        }
        NodeYUI localBlock = new NodeYUI(140);
        int initType = isForEach ? 59 : (destructuring != -1 ? 60 : 58);
        NodeYUI init = new NodeYUI(initType, obj);
        init.putProp(3, localBlock);
        NodeYUI cond = new NodeYUI(61);
        cond.putProp(3, localBlock);
        NodeYUI id = new NodeYUI(62);
        id.putProp(3, localBlock);
        NodeYUI newBody = new NodeYUI(128);
        if (destructuring != -1) {
            assign = this.createDestructuringAssignment(declType, lvalue, id);
            if (!(isForEach || destructuring != 66 && destructuringLen == 2)) {
                this.parser.reportError("msg.bad.for.in.destruct");
            }
        } else {
            assign = this.simpleAssignment(lvalue, id);
        }
        newBody.addChildToBack(new NodeYUI(132, assign));
        newBody.addChildToBack(body);
        loop = this.createWhile(loop, cond, newBody);
        loop.addChildToFront(init);
        if (type == 121 || type == 152) {
            loop.addChildToFront(lhs);
        }
        localBlock.addChildToBack(loop);
        return localBlock;
    }

    NodeYUI createTryCatchFinally(NodeYUI tryBlock, NodeYUI catchBlocks, NodeYUI finallyBlock, int lineno) {
        boolean hasFinally;
        boolean bl = hasFinally = finallyBlock != null && (finallyBlock.getType() != 128 || finallyBlock.hasChildren());
        if (tryBlock.getType() == 128 && !tryBlock.hasChildren() && !hasFinally) {
            return tryBlock;
        }
        boolean hasCatch = catchBlocks.hasChildren();
        if (!hasFinally && !hasCatch) {
            return tryBlock;
        }
        NodeYUI handlerBlock = new NodeYUI(140);
        NodeYUI.Jump pn = new NodeYUI.Jump(80, tryBlock, lineno);
        pn.putProp(3, handlerBlock);
        if (hasCatch) {
            NodeYUI catchTarget;
            NodeYUI endCatch = NodeYUI.newTarget();
            pn.addChildToBack(this.makeJump(5, endCatch));
            pn.target = catchTarget = NodeYUI.newTarget();
            pn.addChildToBack(catchTarget);
            NodeYUI catchScopeBlock = new NodeYUI(140);
            NodeYUI cb = catchBlocks.getFirstChild();
            boolean hasDefault = false;
            int scopeIndex = 0;
            while (cb != null) {
                NodeYUI condStmt;
                int catchLineNo = cb.getLineno();
                NodeYUI name = cb.getFirstChild();
                NodeYUI cond = name.getNext();
                NodeYUI catchStatement = cond.getNext();
                cb.removeChild(name);
                cb.removeChild(cond);
                cb.removeChild(catchStatement);
                catchStatement.addChildToBack(new NodeYUI(3));
                catchStatement.addChildToBack(this.makeJump(5, endCatch));
                if (cond.getType() == 127) {
                    condStmt = catchStatement;
                    hasDefault = true;
                } else {
                    condStmt = this.createIf(cond, catchStatement, null, catchLineNo);
                }
                NodeYUI catchScope = new NodeYUI(57, name, this.createUseLocal(handlerBlock));
                catchScope.putProp(3, catchScopeBlock);
                catchScope.putIntProp(14, scopeIndex);
                catchScopeBlock.addChildToBack(catchScope);
                catchScopeBlock.addChildToBack(this.createWith(this.createUseLocal(catchScopeBlock), condStmt, catchLineNo));
                cb = cb.getNext();
                ++scopeIndex;
            }
            pn.addChildToBack(catchScopeBlock);
            if (!hasDefault) {
                NodeYUI rethrow = new NodeYUI(51);
                rethrow.putProp(3, handlerBlock);
                pn.addChildToBack(rethrow);
            }
            pn.addChildToBack(endCatch);
        }
        if (hasFinally) {
            NodeYUI finallyTarget = NodeYUI.newTarget();
            pn.setFinally(finallyTarget);
            pn.addChildToBack(this.makeJump(134, finallyTarget));
            NodeYUI finallyEnd = NodeYUI.newTarget();
            pn.addChildToBack(this.makeJump(5, finallyEnd));
            pn.addChildToBack(finallyTarget);
            NodeYUI fBlock = new NodeYUI(124, finallyBlock);
            fBlock.putProp(3, handlerBlock);
            pn.addChildToBack(fBlock);
            pn.addChildToBack(finallyEnd);
        }
        handlerBlock.addChildToBack(pn);
        return handlerBlock;
    }

    NodeYUI createWith(NodeYUI obj, NodeYUI body, int lineno) {
        this.setRequiresActivation();
        NodeYUI result = new NodeYUI(128, lineno);
        result.addChildToBack(new NodeYUI(2, obj));
        NodeYUI bodyNode = new NodeYUI(122, body, lineno);
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new NodeYUI(3));
        return result;
    }

    public NodeYUI createDotQuery(NodeYUI obj, NodeYUI body, int lineno) {
        this.setRequiresActivation();
        NodeYUI result = new NodeYUI(145, obj, body, lineno);
        return result;
    }

    NodeYUI createArrayLiteral(ObjArray elems, int skipCount, int destructuringLen) {
        int length = elems.size();
        int[] skipIndexes = null;
        if (skipCount != 0) {
            skipIndexes = new int[skipCount];
        }
        NodeYUI array = new NodeYUI(65);
        int i = 0;
        int j = 0;
        while (i != length) {
            NodeYUI elem = (NodeYUI)elems.get(i);
            if (elem != null) {
                array.addChildToBack(elem);
            } else {
                skipIndexes[j] = i;
                ++j;
            }
            ++i;
        }
        if (skipCount != 0) {
            array.putProp(11, skipIndexes);
        }
        array.putIntProp(21, destructuringLen);
        return array;
    }

    NodeYUI createObjectLiteral(ObjArray elems) {
        Object[] properties;
        int size = elems.size() / 2;
        NodeYUI object = new NodeYUI(66);
        if (size == 0) {
            properties = ScriptRuntime.emptyArgs;
        } else {
            properties = new Object[size];
            int i = 0;
            while (i != size) {
                properties[i] = elems.get(2 * i);
                NodeYUI value = (NodeYUI)elems.get(2 * i + 1);
                object.addChildToBack(value);
                ++i;
            }
        }
        object.putProp(12, properties);
        return object;
    }

    NodeYUI createRegExp(int regexpIndex) {
        NodeYUI n = new NodeYUI(48);
        n.putIntProp(4, regexpIndex);
        return n;
    }

    NodeYUI createIf(NodeYUI cond, NodeYUI ifTrue, NodeYUI ifFalse, int lineno) {
        int condStatus = IRFactoryYUI.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            if (ifFalse != null) {
                return ifFalse;
            }
            return new NodeYUI(128, lineno);
        }
        NodeYUI result = new NodeYUI(128, lineno);
        NodeYUI ifNotTarget = NodeYUI.newTarget();
        NodeYUI.Jump IFNE = new NodeYUI.Jump(7, cond);
        IFNE.target = ifNotTarget;
        result.addChildToBack(IFNE);
        result.addChildrenToBack(ifTrue);
        if (ifFalse != null) {
            NodeYUI endTarget = NodeYUI.newTarget();
            result.addChildToBack(this.makeJump(5, endTarget));
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack(ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    NodeYUI createCondExpr(NodeYUI cond, NodeYUI ifTrue, NodeYUI ifFalse) {
        int condStatus = IRFactoryYUI.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            return ifFalse;
        }
        return new NodeYUI(101, cond, ifTrue, ifFalse);
    }

    NodeYUI createUnary(int nodeType, NodeYUI child) {
        int childType = child.getType();
        switch (nodeType) {
            case 31: {
                NodeYUI n;
                if (childType == 39) {
                    child.setType(49);
                    NodeYUI left = child;
                    NodeYUI right = NodeYUI.newString(child.getString());
                    n = new NodeYUI(nodeType, left, right);
                } else if (childType == 33 || childType == 36) {
                    NodeYUI left = child.getFirstChild();
                    NodeYUI right = child.getLastChild();
                    child.removeChild(left);
                    child.removeChild(right);
                    n = new NodeYUI(nodeType, left, right);
                } else if (childType == 67) {
                    NodeYUI ref = child.getFirstChild();
                    child.removeChild(ref);
                    n = new NodeYUI(69, ref);
                } else {
                    n = new NodeYUI(45);
                }
                return n;
            }
            case 32: {
                if (childType != 39) break;
                child.setType(136);
                return child;
            }
            case 27: {
                if (childType != 40) break;
                int value = ScriptRuntime.toInt32(child.getDouble());
                child.setDouble(~value);
                return child;
            }
            case 29: {
                if (childType != 40) break;
                child.setDouble(-child.getDouble());
                return child;
            }
            case 26: {
                int status = IRFactoryYUI.isAlwaysDefinedBoolean(child);
                if (status == 0) break;
                int type = status == 1 ? 44 : 45;
                if (childType == 45 || childType == 44) {
                    child.setType(type);
                    return child;
                }
                return new NodeYUI(type);
            }
        }
        return new NodeYUI(nodeType, child);
    }

    NodeYUI createYield(NodeYUI child, int lineno) {
        if (!this.parser.insideFunction()) {
            this.parser.reportError("msg.bad.yield");
        }
        this.setRequiresActivation();
        this.setIsGenerator();
        if (child != null) {
            return new NodeYUI(72, child, lineno);
        }
        return new NodeYUI(72, lineno);
    }

    NodeYUI createCallOrNew(int nodeType, NodeYUI child) {
        String name;
        int type = 0;
        if (child.getType() == 39) {
            name = child.getString();
            if (name.equals("eval")) {
                type = 1;
            } else if (name.equals("With")) {
                type = 2;
            }
        } else if (child.getType() == 33 && (name = child.getLastChild().getString()).equals("eval")) {
            type = 1;
        }
        NodeYUI node = new NodeYUI(nodeType, child);
        if (type != 0) {
            this.setRequiresActivation();
            node.putIntProp(10, type);
        }
        return node;
    }

    NodeYUI createIncDec(int nodeType, boolean post, NodeYUI child) {
        if ((child = this.makeReference(child)) == null) {
            String msg = nodeType == 106 ? "msg.bad.decr" : "msg.bad.incr";
            this.parser.reportError(msg);
            return null;
        }
        int childType = child.getType();
        switch (childType) {
            case 33: 
            case 36: 
            case 39: 
            case 67: {
                NodeYUI n = new NodeYUI(nodeType, child);
                int incrDecrMask = 0;
                if (nodeType == 106) {
                    incrDecrMask |= 1;
                }
                if (post) {
                    incrDecrMask |= 2;
                }
                n.putIntProp(13, incrDecrMask);
                return n;
            }
        }
        throw Kit.codeBug();
    }

    NodeYUI createPropertyGet(NodeYUI target, String namespace, String name, int memberTypeFlags) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                return this.createName(name);
            }
            this.checkActivationName(name, 33);
            if (ScriptRuntime.isSpecialProperty(name)) {
                NodeYUI ref = new NodeYUI(71, target);
                ref.putProp(17, name);
                return new NodeYUI(67, ref);
            }
            return new NodeYUI(33, target, this.createString(name));
        }
        NodeYUI elem = this.createString(name);
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags |= 1);
    }

    NodeYUI createElementGet(NodeYUI target, String namespace, NodeYUI elem, int memberTypeFlags) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                throw Kit.codeBug();
            }
            return new NodeYUI(36, target, elem);
        }
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags);
    }

    private NodeYUI createMemberRefGet(NodeYUI target, String namespace, NodeYUI elem, int memberTypeFlags) {
        NodeYUI nsNode = null;
        if (namespace != null) {
            nsNode = namespace.equals("*") ? new NodeYUI(42) : this.createName(namespace);
        }
        NodeYUI ref = target == null ? (namespace == null ? new NodeYUI(78, elem) : new NodeYUI(79, nsNode, elem)) : (namespace == null ? new NodeYUI(76, target, elem) : new NodeYUI(77, target, nsNode, elem));
        if (memberTypeFlags != 0) {
            ref.putIntProp(16, memberTypeFlags);
        }
        return new NodeYUI(67, ref);
    }

    NodeYUI createBinary(int nodeType, NodeYUI left, NodeYUI right) {
        switch (nodeType) {
            case 21: {
                if (left.type == 41) {
                    String s2;
                    if (right.type == 41) {
                        s2 = right.getString();
                    } else {
                        if (right.type != 40) break;
                        s2 = ScriptRuntime.numberToString(right.getDouble(), 10);
                    }
                    String s1 = left.getString();
                    left.setString(s1.concat(s2));
                    return left;
                }
                if (left.type != 40) break;
                if (right.type == 40) {
                    left.setDouble(left.getDouble() + right.getDouble());
                    return left;
                }
                if (right.type != 41) break;
                String s1 = ScriptRuntime.numberToString(left.getDouble(), 10);
                String s2 = right.getString();
                right.setString(s1.concat(s2));
                return right;
            }
            case 22: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld - right.getDouble());
                        return left;
                    }
                    if (ld != 0.0) break;
                    return new NodeYUI(29, right);
                }
                if (right.type != 40 || right.getDouble() != 0.0) break;
                return new NodeYUI(28, left);
            }
            case 23: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld * right.getDouble());
                        return left;
                    }
                    if (ld != 1.0) break;
                    return new NodeYUI(28, right);
                }
                if (right.type != 40 || right.getDouble() != 1.0) break;
                return new NodeYUI(28, left);
            }
            case 24: {
                if (right.type != 40) break;
                double rd = right.getDouble();
                if (left.type == 40) {
                    left.setDouble(left.getDouble() / rd);
                    return left;
                }
                if (rd != 1.0) break;
                return new NodeYUI(28, left);
            }
            case 104: {
                int leftStatus = IRFactoryYUI.isAlwaysDefinedBoolean(left);
                if (leftStatus == -1) {
                    return left;
                }
                if (leftStatus != 1) break;
                return right;
            }
            case 103: {
                int leftStatus = IRFactoryYUI.isAlwaysDefinedBoolean(left);
                if (leftStatus == 1) {
                    return left;
                }
                if (leftStatus != -1) break;
                return right;
            }
        }
        return new NodeYUI(nodeType, left, right);
    }

    private NodeYUI simpleAssignment(NodeYUI left, NodeYUI right) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: {
                left.setType(49);
                return new NodeYUI(8, left, right);
            }
            case 33: 
            case 36: {
                NodeYUI obj = left.getFirstChild();
                NodeYUI id = left.getLastChild();
                int type = nodeType == 33 ? 35 : 37;
                return new NodeYUI(type, obj, id, right);
            }
            case 67: {
                NodeYUI ref = left.getFirstChild();
                this.checkMutableReference(ref);
                return new NodeYUI(68, ref, right);
            }
        }
        throw Kit.codeBug();
    }

    private void checkMutableReference(NodeYUI n) {
        int memberTypeFlags = n.getIntProp(16, 0);
        if ((memberTypeFlags & 4) != 0) {
            this.parser.reportError("msg.bad.assign.left");
        }
    }

    NodeYUI createAssignment(int assignType, NodeYUI left, NodeYUI right) {
        int assignOp;
        NodeYUI ref = this.makeReference(left);
        if (ref == null) {
            if (left.getType() == 65 || left.getType() == 66) {
                if (assignType != 89) {
                    this.parser.reportError("msg.bad.destruct.op");
                    return right;
                }
                return this.createDestructuringAssignment(-1, left, right);
            }
            this.parser.reportError("msg.bad.assign.left");
            return right;
        }
        left = ref;
        switch (assignType) {
            case 89: {
                return this.simpleAssignment(left, right);
            }
            case 90: {
                assignOp = 9;
                break;
            }
            case 91: {
                assignOp = 10;
                break;
            }
            case 92: {
                assignOp = 11;
                break;
            }
            case 93: {
                assignOp = 18;
                break;
            }
            case 94: {
                assignOp = 19;
                break;
            }
            case 95: {
                assignOp = 20;
                break;
            }
            case 96: {
                assignOp = 21;
                break;
            }
            case 97: {
                assignOp = 22;
                break;
            }
            case 98: {
                assignOp = 23;
                break;
            }
            case 99: {
                assignOp = 24;
                break;
            }
            case 100: {
                assignOp = 25;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: {
                NodeYUI op = new NodeYUI(assignOp, left, right);
                NodeYUI lvalueLeft = NodeYUI.newString(49, left.getString());
                return new NodeYUI(8, lvalueLeft, op);
            }
            case 33: 
            case 36: {
                NodeYUI obj = left.getFirstChild();
                NodeYUI id = left.getLastChild();
                int type = nodeType == 33 ? 138 : 139;
                NodeYUI opLeft = new NodeYUI(137);
                NodeYUI op = new NodeYUI(assignOp, opLeft, right);
                return new NodeYUI(type, obj, id, op);
            }
            case 67: {
                ref = left.getFirstChild();
                this.checkMutableReference(ref);
                NodeYUI opLeft = new NodeYUI(137);
                NodeYUI op = new NodeYUI(assignOp, opLeft, right);
                return new NodeYUI(141, ref, op);
            }
        }
        throw Kit.codeBug();
    }

    NodeYUI createDestructuringAssignment(int type, NodeYUI left, NodeYUI right) {
        String tempName = this.parser.currentScriptOrFn.getNextTempName();
        NodeYUI result = this.destructuringAssignmentHelper(type, left, right, tempName);
        NodeYUI comma = result.getLastChild();
        comma.addChildToBack(this.createName(tempName));
        return result;
    }

    private NodeYUI destructuringAssignmentHelper(int variableType, NodeYUI left, NodeYUI right, String tempName) {
        NodeYUI result = this.createScopeNode(157, this.parser.getCurrentLineNumber());
        result.addChildToFront(new NodeYUI(152, this.createName(39, tempName, right)));
        try {
            this.parser.pushScope(result);
            this.parser.defineSymbol(152, true, tempName);
        }
        finally {
            this.parser.popScope();
        }
        NodeYUI comma = new NodeYUI(88);
        result.addChildToBack(comma);
        int setOp = variableType == 153 ? 154 : 8;
        ArrayList<String> destructuringNames = new ArrayList<String>();
        boolean empty = true;
        int type = left.getType();
        if (type == 65) {
            int index = 0;
            int[] skipIndices = (int[])left.getProp(11);
            int skip = 0;
            NodeYUI n = left.getFirstChild();
            while (true) {
                if (skipIndices != null) {
                    while (skip < skipIndices.length && skipIndices[skip] == index) {
                        ++skip;
                        ++index;
                    }
                }
                if (n != null) {
                    NodeYUI rightElem = new NodeYUI(36, this.createName(tempName), this.createNumber(index));
                    if (n.getType() == 39) {
                        String name = n.getString();
                        comma.addChildToBack(new NodeYUI(setOp, this.createName(49, name, null), rightElem));
                        if (variableType != -1) {
                            this.parser.defineSymbol(variableType, true, name);
                            destructuringNames.add(name);
                        }
                    } else {
                        comma.addChildToBack(this.destructuringAssignmentHelper(variableType, n, rightElem, this.parser.currentScriptOrFn.getNextTempName()));
                    }
                    ++index;
                    empty = false;
                    n = n.getNext();
                    continue;
                }
                break;
            }
        } else if (type == 66) {
            int index = 0;
            Object[] propertyIds = (Object[])left.getProp(12);
            NodeYUI n = left.getFirstChild();
            while (n != null) {
                NodeYUI rightElem;
                Object id = propertyIds[index];
                NodeYUI nodeYUI = rightElem = id instanceof String ? new NodeYUI(33, this.createName(tempName), this.createString((String)id)) : new NodeYUI(36, this.createName(tempName), this.createNumber(((Number)id).intValue()));
                if (n.getType() == 39) {
                    String name = n.getString();
                    comma.addChildToBack(new NodeYUI(setOp, this.createName(49, name, null), rightElem));
                    if (variableType != -1) {
                        this.parser.defineSymbol(variableType, true, name);
                        destructuringNames.add(name);
                    }
                } else {
                    comma.addChildToBack(this.destructuringAssignmentHelper(variableType, n, rightElem, this.parser.currentScriptOrFn.getNextTempName()));
                }
                ++index;
                empty = false;
                n = n.getNext();
            }
        } else if (type == 33 || type == 36) {
            comma.addChildToBack(this.simpleAssignment(left, this.createName(tempName)));
        } else {
            this.parser.reportError("msg.bad.assign.left");
        }
        if (empty) {
            comma.addChildToBack(this.createNumber(0.0));
        }
        result.putProp(22, destructuringNames);
        return result;
    }

    NodeYUI createUseLocal(NodeYUI localBlock) {
        if (140 != localBlock.getType()) {
            throw Kit.codeBug();
        }
        NodeYUI result = new NodeYUI(54);
        result.putProp(3, localBlock);
        return result;
    }

    private NodeYUI.Jump makeJump(int type, NodeYUI target) {
        NodeYUI.Jump n = new NodeYUI.Jump(type);
        n.target = target;
        return n;
    }

    private NodeYUI makeReference(NodeYUI node) {
        int type = node.getType();
        switch (type) {
            case 33: 
            case 36: 
            case 39: 
            case 67: {
                return node;
            }
            case 38: {
                node.setType(70);
                return new NodeYUI(67, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(NodeYUI node) {
        switch (node.getType()) {
            case 42: 
            case 44: {
                return -1;
            }
            case 45: {
                return 1;
            }
            case 40: {
                double num = node.getDouble();
                if (num == num && num != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private void checkActivationName(String name, int token) {
        if (this.parser.insideFunction()) {
            boolean activation = false;
            if ("arguments".equals(name) || this.parser.compilerEnv.activationNames != null && this.parser.compilerEnv.activationNames.contains(name)) {
                activation = true;
            } else if ("length".equals(name) && token == 33 && this.parser.compilerEnv.getLanguageVersion() == 120) {
                activation = true;
            }
            if (activation) {
                this.setRequiresActivation();
            }
        }
    }

    private void setRequiresActivation() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsNeedsActivation = true;
        }
    }

    private void setIsGenerator() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsIsGenerator = true;
        }
    }
}

