/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebuggableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject,
ConstProperties {
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    public static final int UNINITIALIZED_CONST = 8;
    public static final int CONST = 13;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private static final Slot REMOVED = new Slot(null, 0, 1);
    private transient Slot[] slots;
    private int count;
    private transient Slot firstAdded;
    private transient Slot lastAdded;
    private transient Slot lastAccess = REMOVED;
    private volatile Map<Object, Object> associatedValues;
    private static final int SLOT_QUERY = 1;
    private static final int SLOT_MODIFY = 2;
    private static final int SLOT_REMOVE = 3;
    private static final int SLOT_MODIFY_GETTER_SETTER = 4;
    private static final int SLOT_MODIFY_CONST = 5;

    static {
        ScriptableObject.REMOVED.wasDeleted = true;
    }

    static void checkValidAttributes(int attributes) {
        int mask = 15;
        if ((attributes & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.valueOf(attributes));
        }
    }

    public ScriptableObject() {
    }

    public ScriptableObject(Scriptable scope, Scriptable prototype) {
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scope;
        this.prototypeObject = prototype;
    }

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(String name, Scriptable start) {
        return this.getSlot(name, 0, 1) != null;
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return this.getSlot(null, index, 1) != null;
    }

    @Override
    public Object get(String name, Scriptable start) {
        return this.getImpl(name, 0, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        return this.getImpl(null, index, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.putImpl(name, 0, start, value, 0)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        start.put(name, start, value);
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (this.putImpl(null, index, start, value, 0)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        start.put(index, start, value);
    }

    @Override
    public void delete(String name) {
        this.checkNotSealed(name, 0);
        this.accessSlot(name, 0, 3);
    }

    @Override
    public void delete(int index) {
        this.checkNotSealed(null, index);
        this.accessSlot(null, index, 3);
    }

    @Override
    public void putConst(String name, Scriptable start, Object value) {
        if (this.putImpl(name, 0, start, value, 1)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        if (start instanceof ConstProperties) {
            ((ConstProperties)((Object)start)).putConst(name, start, value);
        } else {
            start.put(name, start, value);
        }
    }

    @Override
    public void defineConst(String name, Scriptable start) {
        if (this.putImpl(name, 0, start, Undefined.instance, 8)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        if (start instanceof ConstProperties) {
            ((ConstProperties)((Object)start)).defineConst(name, start);
        }
    }

    @Override
    public boolean isConst(String name) {
        Slot slot = this.getSlot(name, 0, 1);
        if (slot == null) {
            return false;
        }
        return (slot.getAttributes() & 5) == 5;
    }

    public final int getAttributes(String name, Scriptable start) {
        return this.getAttributes(name);
    }

    public final int getAttributes(int index, Scriptable start) {
        return this.getAttributes(index);
    }

    public final void setAttributes(String name, Scriptable start, int attributes) {
        this.setAttributes(name, attributes);
    }

    public void setAttributes(int index, Scriptable start, int attributes) {
        this.setAttributes(index, attributes);
    }

    public int getAttributes(String name) {
        return this.findAttributeSlot(name, 0, 1).getAttributes();
    }

    public int getAttributes(int index) {
        return this.findAttributeSlot(null, index, 1).getAttributes();
    }

    public void setAttributes(String name, int attributes) {
        this.checkNotSealed(name, 0);
        this.findAttributeSlot(name, 0, 2).setAttributes(attributes);
    }

    public void setAttributes(int index, int attributes) {
        this.checkNotSealed(null, index);
        this.findAttributeSlot(null, index, 2).setAttributes(attributes);
    }

    public void setGetterOrSetter(String name, int index, Callable getterOrSetter, boolean isSetter) {
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        this.checkNotSealed(name, index);
        GetterSlot gslot = (GetterSlot)this.getSlot(name, index, 4);
        gslot.checkNotReadonly();
        if (isSetter) {
            gslot.setter = getterOrSetter;
        } else {
            gslot.getter = getterOrSetter;
        }
        gslot.value = Undefined.instance;
    }

    public Object getGetterOrSetter(String name, int index, boolean isSetter) {
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        Slot slot = this.getSlot(name, index, 1);
        if (slot == null) {
            return null;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot gslot = (GetterSlot)slot;
            Object result = isSetter ? gslot.setter : gslot.getter;
            return result != null ? result : Undefined.instance;
        }
        return Undefined.instance;
    }

    protected boolean isGetterOrSetter(String name, int index, boolean setter) {
        Slot slot = this.getSlot(name, index, 1);
        if (slot instanceof GetterSlot) {
            if (setter && ((GetterSlot)slot).setter != null) {
                return true;
            }
            if (!setter && ((GetterSlot)slot).getter != null) {
                return true;
            }
        }
        return false;
    }

    void addLazilyInitializedValue(String name, int index, LazilyLoadedCtor init, int attributes) {
        if (name != null && index != 0) {
            throw new IllegalArgumentException(name);
        }
        this.checkNotSealed(name, index);
        GetterSlot gslot = (GetterSlot)this.getSlot(name, index, 4);
        gslot.setAttributes(attributes);
        gslot.getter = null;
        gslot.setter = null;
        gslot.value = init;
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    @Override
    public void setPrototype(Scriptable m) {
        this.prototypeObject = m;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public void setParentScope(Scriptable m) {
        this.parentScopeObject = m;
    }

    @Override
    public Object[] getIds() {
        return this.getIds(false);
    }

    @Override
    public Object[] getAllIds() {
        return this.getIds(true);
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return ScriptableObject.getDefaultValue(this, typeHint);
    }

    public static Object getDefaultValue(Scriptable object, Class<?> typeHint) {
        Context cx = null;
        int i = 0;
        while (i < 2) {
            Object[] args;
            String methodName;
            boolean tryToString;
            if (typeHint == ScriptRuntime.StringClass) {
                tryToString = i == 0;
            } else {
                boolean bl = tryToString = i == 1;
            }
            if (tryToString) {
                methodName = "toString";
                args = ScriptRuntime.emptyArgs;
            } else {
                String hint;
                methodName = "valueOf";
                args = new Object[1];
                if (typeHint == null) {
                    hint = "undefined";
                } else if (typeHint == ScriptRuntime.StringClass) {
                    hint = "string";
                } else if (typeHint == ScriptRuntime.ScriptableClass) {
                    hint = "object";
                } else if (typeHint == ScriptRuntime.FunctionClass) {
                    hint = "function";
                } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                    hint = "boolean";
                } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                    hint = "number";
                } else {
                    throw Context.reportRuntimeError1("msg.invalid.type", typeHint.toString());
                }
                args[0] = hint;
            }
            Object v = ScriptableObject.getProperty(object, methodName);
            if (v instanceof Function) {
                Function fun = (Function)v;
                if (cx == null) {
                    cx = Context.getContext();
                }
                if ((v = fun.call(cx, fun.getParentScope(), object, args)) != null) {
                    Object u;
                    if (!(v instanceof Scriptable)) {
                        return v;
                    }
                    if (typeHint == ScriptRuntime.ScriptableClass || typeHint == ScriptRuntime.FunctionClass) {
                        return v;
                    }
                    if (tryToString && v instanceof Wrapper && (u = ((Wrapper)v).unwrap()) instanceof String) {
                        return u;
                    }
                }
            }
            ++i;
        }
        String arg = typeHint == null ? "undefined" : typeHint.getName();
        throw ScriptRuntime.typeError1("msg.default.value", arg);
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo(instance, this);
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    protected Object equivalentValues(Object value) {
        return this == value ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, false, false);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz, boolean sealed) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, sealed, false);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scope, Class<T> clazz, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction ctor = ScriptableObject.buildClassCtor(scope, clazz, sealed, mapInheritance);
        if (ctor == null) {
            return null;
        }
        String name = ctor.getClassPrototype().getClassName();
        ScriptableObject.defineProperty(scope, name, ctor, 2);
        return name;
    }

    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable scope, Class<T> clazz, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject ctor;
        Class<T> superScriptable;
        String name;
        Class<T> superClass;
        Method[] methods = FunctionObject.getMethodList(clazz);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals("init")) {
                Class<?>[] parmTypes = method.getParameterTypes();
                if (parmTypes.length == 3 && parmTypes[0] == ScriptRuntime.ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{Context.getContext(), scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                    method.invoke(null, args);
                    return null;
                }
                if (parmTypes.length == 1 && parmTypes[0] == ScriptRuntime.ScriptableClass && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{scope};
                    method.invoke(null, args);
                    return null;
                }
            }
            ++i;
        }
        Constructor<?>[] ctors = clazz.getConstructors();
        Constructor<?> protoCtor = null;
        int i2 = 0;
        while (i2 < ctors.length) {
            if (ctors[i2].getParameterTypes().length == 0) {
                protoCtor = ctors[i2];
                break;
            }
            ++i2;
        }
        if (protoCtor == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", clazz.getName());
        }
        Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.emptyArgs);
        String className = proto.getClassName();
        Scriptable superProto = null;
        if (mapInheritance && ScriptRuntime.ScriptableClass.isAssignableFrom(superClass = clazz.getSuperclass()) && !Modifier.isAbstract(superClass.getModifiers()) && (name = ScriptableObject.defineClass(scope, superScriptable = ScriptableObject.extendsScriptable(superClass), sealed, mapInheritance)) != null) {
            superProto = ScriptableObject.getClassPrototype(scope, name);
        }
        if (superProto == null) {
            superProto = ScriptableObject.getObjectPrototype(scope);
        }
        proto.setPrototype(superProto);
        String functionPrefix = "jsFunction_";
        String staticFunctionPrefix = "jsStaticFunction_";
        String getterPrefix = "jsGet_";
        String setterPrefix = "jsSet_";
        String ctorName = "jsConstructor";
        Executable ctorMember = FunctionObject.findSingleMethod(methods, "jsConstructor");
        if (ctorMember == null) {
            if (ctors.length == 1) {
                ctorMember = ctors[0];
            } else if (ctors.length == 2) {
                if (ctors[0].getParameterTypes().length == 0) {
                    ctorMember = ctors[1];
                } else if (ctors[1].getParameterTypes().length == 0) {
                    ctorMember = ctors[0];
                }
            }
            if (ctorMember == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", clazz.getName());
            }
        }
        if ((ctor = new FunctionObject(className, ctorMember, scope)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", ctorMember.getName());
        }
        ctor.initAsConstructor(scope, proto);
        Method finishInit = null;
        HashSet<String> names = new HashSet<String>(methods.length);
        int i3 = 0;
        while (i3 < methods.length) {
            block33: {
                String prefix;
                String name2;
                block36: {
                    block37: {
                        block35: {
                            block34: {
                                Class<?>[] parmTypes;
                                if (methods[i3] == ctorMember) break block33;
                                name2 = methods[i3].getName();
                                if (!name2.equals("finishInit") || (parmTypes = methods[i3].getParameterTypes()).length != 3 || parmTypes[0] != ScriptRuntime.ScriptableClass || parmTypes[1] != FunctionObject.class || parmTypes[2] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(methods[i3].getModifiers())) break block34;
                                finishInit = methods[i3];
                                break block33;
                            }
                            if (name2.indexOf(36) != -1 || name2.equals("jsConstructor")) break block33;
                            prefix = null;
                            if (!name2.startsWith("jsFunction_")) break block35;
                            prefix = "jsFunction_";
                            break block36;
                        }
                        if (!name2.startsWith("jsStaticFunction_")) break block37;
                        prefix = "jsStaticFunction_";
                        if (!Modifier.isStatic(methods[i3].getModifiers())) {
                            throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
                        }
                        break block36;
                    }
                    if (!name2.startsWith("jsGet_")) break block33;
                    prefix = "jsGet_";
                }
                String propName = name2.substring(prefix.length());
                if (names.contains(propName)) {
                    throw Context.reportRuntimeError2("duplicate.defineClass.name", name2, propName);
                }
                names.add(propName);
                name2 = name2.substring(prefix.length());
                if (prefix == "jsGet_") {
                    if (!(proto instanceof ScriptableObject)) {
                        throw Context.reportRuntimeError2("msg.extend.scriptable", proto.getClass().toString(), name2);
                    }
                    Method setter = FunctionObject.findSingleMethod(methods, "jsSet_" + name2);
                    int attr = 6 | (setter != null ? 0 : 1);
                    ((ScriptableObject)proto).defineProperty(name2, null, methods[i3], setter, attr);
                } else {
                    FunctionObject f = new FunctionObject(name2, methods[i3], proto);
                    if (f.isVarArgsConstructor()) {
                        throw Context.reportRuntimeError1("msg.varargs.fun", ctorMember.getName());
                    }
                    Scriptable dest = prefix == "jsStaticFunction_" ? ctor : proto;
                    ScriptableObject.defineProperty(dest, name2, f, 2);
                    if (sealed) {
                        f.sealObject();
                    }
                }
            }
            ++i3;
        }
        if (finishInit != null) {
            Object[] finishArgs = new Object[]{scope, ctor, proto};
            finishInit.invoke(null, finishArgs);
        }
        if (sealed) {
            ctor.sealObject();
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject();
            }
        }
        return ctor;
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> c) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(c)) {
            return c;
        }
        return null;
    }

    public void defineProperty(String propertyName, Object value, int attributes) {
        this.checkNotSealed(propertyName, 0);
        this.put(propertyName, (Scriptable)this, value);
        this.setAttributes(propertyName, attributes);
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value, int attributes) {
        if (!(destination instanceof ScriptableObject)) {
            destination.put(propertyName, destination, value);
            return;
        }
        ScriptableObject so = (ScriptableObject)destination;
        so.defineProperty(propertyName, value, attributes);
    }

    public static void defineConstProperty(Scriptable destination, String propertyName) {
        if (destination instanceof ConstProperties) {
            ConstProperties cp = (ConstProperties)((Object)destination);
            cp.defineConst(propertyName, destination);
        } else {
            ScriptableObject.defineProperty(destination, propertyName, Undefined.instance, 13);
        }
    }

    public void defineProperty(String propertyName, Class<?> clazz, int attributes) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = FunctionObject.getMethodList(clazz);
        Method getter = FunctionObject.findSingleMethod(methods, getterName);
        Method setter = FunctionObject.findSingleMethod(methods, setterName);
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter == null ? null : setter, attributes);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes) {
        MemberBox getterBox = null;
        if (getter != null) {
            boolean delegatedForm;
            getterBox = new MemberBox(getter);
            if (!Modifier.isStatic(getter.getModifiers())) {
                delegatedForm = delegateTo != null;
                getterBox.delegateTo = delegateTo;
            } else {
                delegatedForm = true;
                getterBox.delegateTo = Void.TYPE;
            }
            String errorId = null;
            Class<?>[] parmTypes = getter.getParameterTypes();
            if (parmTypes.length == 0) {
                if (delegatedForm) {
                    errorId = "msg.obj.getter.parms";
                }
            } else if (parmTypes.length == 1) {
                Class<?> argType = parmTypes[0];
                if (argType != ScriptRuntime.ScriptableClass && argType != ScriptRuntime.ScriptableObjectClass) {
                    errorId = "msg.bad.getter.parms";
                } else if (!delegatedForm) {
                    errorId = "msg.bad.getter.parms";
                }
            } else {
                errorId = "msg.bad.getter.parms";
            }
            if (errorId != null) {
                throw Context.reportRuntimeError1(errorId, getter.toString());
            }
        }
        MemberBox setterBox = null;
        if (setter != null) {
            boolean delegatedForm;
            if (setter.getReturnType() != Void.TYPE) {
                throw Context.reportRuntimeError1("msg.setter.return", setter.toString());
            }
            setterBox = new MemberBox(setter);
            if (!Modifier.isStatic(setter.getModifiers())) {
                delegatedForm = delegateTo != null;
                setterBox.delegateTo = delegateTo;
            } else {
                delegatedForm = true;
                setterBox.delegateTo = Void.TYPE;
            }
            String errorId = null;
            Class<?>[] parmTypes = setter.getParameterTypes();
            if (parmTypes.length == 1) {
                if (delegatedForm) {
                    errorId = "msg.setter2.expected";
                }
            } else if (parmTypes.length == 2) {
                Class<?> argType = parmTypes[0];
                if (argType != ScriptRuntime.ScriptableClass && argType != ScriptRuntime.ScriptableObjectClass) {
                    errorId = "msg.setter2.parms";
                } else if (!delegatedForm) {
                    errorId = "msg.setter1.parms";
                }
            } else {
                errorId = "msg.setter.parms";
            }
            if (errorId != null) {
                throw Context.reportRuntimeError1(errorId, setter.toString());
            }
        }
        GetterSlot gslot = (GetterSlot)this.getSlot(propertyName, 0, 4);
        gslot.setAttributes(attributes);
        gslot.getter = getterBox;
        gslot.setter = setterBox;
    }

    public void defineFunctionProperties(String[] names, Class<?> clazz, int attributes) {
        Method[] methods = FunctionObject.getMethodList(clazz);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            Method m = FunctionObject.findSingleMethod(methods, name);
            if (m == null) {
                throw Context.reportRuntimeError2("msg.method.not.found", name, clazz.getName());
            }
            FunctionObject f = new FunctionObject(name, m, this);
            this.defineProperty(name, f, attributes);
            ++i;
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className) {
        Object proto;
        Object ctor = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), className);
        if (ctor instanceof BaseFunction) {
            proto = ((BaseFunction)ctor).getPrototypeProperty();
        } else if (ctor instanceof Scriptable) {
            Scriptable ctorObj = (Scriptable)ctor;
            proto = ctorObj.get("prototype", ctorObj);
        } else {
            return null;
        }
        if (proto instanceof Scriptable) {
            return (Scriptable)proto;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable parent;
        while ((parent = obj.getParentScope()) != null) {
            obj = parent;
        }
        return obj;
    }

    public synchronized void sealObject() {
        if (this.count >= 0) {
            Slot slot = this.firstAdded;
            while (slot != null) {
                if (slot.value instanceof LazilyLoadedCtor) {
                    LazilyLoadedCtor initializer = (LazilyLoadedCtor)slot.value;
                    try {
                        initializer.init();
                    }
                    finally {
                        slot.value = initializer.getValue();
                    }
                }
                slot = slot.orderedNext;
            }
            this.count ^= 0xFFFFFFFF;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    private void checkNotSealed(String name, int index) {
        if (!this.isSealed()) {
            return;
        }
        String str = name != null ? name : Integer.toString(index);
        throw Context.reportRuntimeError1("msg.modify.sealed", str);
    }

    public static Object getProperty(Scriptable obj, String name) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(name, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static Object getProperty(Scriptable obj, int index) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(index, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static boolean hasProperty(Scriptable obj, String name) {
        return ScriptableObject.getBase(obj, name) != null;
    }

    public static void redefineProperty(Scriptable obj, String name, boolean isConst) {
        ConstProperties cp;
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return;
        }
        if (base instanceof ConstProperties && (cp = (ConstProperties)((Object)base)).isConst(name)) {
            throw Context.reportRuntimeError1("msg.const.redecl", name);
        }
        if (isConst) {
            throw Context.reportRuntimeError1("msg.var.redecl", name);
        }
    }

    public static boolean hasProperty(Scriptable obj, int index) {
        return ScriptableObject.getBase(obj, index) != null;
    }

    public static void putProperty(Scriptable obj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        base.put(name, obj, value);
    }

    public static void putConstProperty(Scriptable obj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        if (base instanceof ConstProperties) {
            ((ConstProperties)((Object)base)).putConst(name, obj, value);
        }
    }

    public static void putProperty(Scriptable obj, int index, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            base = obj;
        }
        base.put(index, obj, value);
    }

    public static boolean deleteProperty(Scriptable obj, String name) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return true;
        }
        base.delete(name);
        return !base.has(name, obj);
    }

    public static boolean deleteProperty(Scriptable obj, int index) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            return true;
        }
        base.delete(index);
        return !base.has(index, obj);
    }

    public static Object[] getPropertyIds(Scriptable obj) {
        if (obj == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] result = obj.getIds();
        ObjToIntMap map = null;
        while ((obj = obj.getPrototype()) != null) {
            int i;
            Object[] ids = obj.getIds();
            if (ids.length == 0) continue;
            if (map == null) {
                if (result.length == 0) {
                    result = ids;
                    continue;
                }
                map = new ObjToIntMap(result.length + ids.length);
                i = 0;
                while (i != result.length) {
                    map.intern(result[i]);
                    ++i;
                }
                result = null;
            }
            i = 0;
            while (i != ids.length) {
                map.intern(ids[i]);
                ++i;
            }
        }
        if (map != null) {
            result = map.getKeys();
        }
        return result;
    }

    public static Object callMethod(Scriptable obj, String methodName, Object[] args) {
        return ScriptableObject.callMethod(null, obj, methodName, args);
    }

    public static Object callMethod(Context cx, Scriptable obj, String methodName, Object[] args) {
        Object funObj = ScriptableObject.getProperty(obj, methodName);
        if (!(funObj instanceof Function)) {
            throw ScriptRuntime.notFunctionError(obj, methodName);
        }
        Function fun = (Function)funObj;
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        if (cx != null) {
            return fun.call(cx, scope, obj, args);
        }
        return Context.call(null, fun, scope, obj, args);
    }

    private static Scriptable getBase(Scriptable obj, String name) {
        while (!obj.has(name, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Scriptable obj, int index) {
        while (!obj.has(index, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    public final Object getAssociatedValue(Object key) {
        Map<Object, Object> h = this.associatedValues;
        if (h == null) {
            return null;
        }
        return h.get(key);
    }

    public static Object getTopScopeValue(Scriptable scope, Object key) {
        scope = ScriptableObject.getTopLevelScope(scope);
        do {
            ScriptableObject so;
            Object value;
            if (!(scope instanceof ScriptableObject) || (value = (so = (ScriptableObject)scope).getAssociatedValue(key)) == null) continue;
            return value;
        } while ((scope = scope.getPrototype()) != null);
        return null;
    }

    public final synchronized Object associateValue(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Object> h = this.associatedValues;
        if (h == null && (h = this.associatedValues) == null) {
            this.associatedValues = h = new HashMap<Object, Object>();
        }
        return Kit.initHash(h, key, value);
    }

    private Object getImpl(String name, int index, Scriptable start) {
        Slot slot = this.getSlot(name, index, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        if (!(slot instanceof GetterSlot)) {
            return slot.value;
        }
        Object getterObj = ((GetterSlot)slot).getter;
        if (getterObj != null) {
            if (getterObj instanceof MemberBox) {
                Object[] args;
                Object getterThis;
                MemberBox nativeGetter = (MemberBox)getterObj;
                if (nativeGetter.delegateTo == null) {
                    getterThis = start;
                    args = ScriptRuntime.emptyArgs;
                } else {
                    getterThis = nativeGetter.delegateTo;
                    args = new Object[]{start};
                }
                return nativeGetter.invoke(getterThis, args);
            }
            Function f = (Function)getterObj;
            Context cx = Context.getContext();
            return f.call(cx, f.getParentScope(), start, ScriptRuntime.emptyArgs);
        }
        Object value = slot.value;
        if (value instanceof LazilyLoadedCtor) {
            LazilyLoadedCtor initializer = (LazilyLoadedCtor)value;
            try {
                initializer.init();
            }
            finally {
                slot.value = value = initializer.getValue();
            }
        }
        return value;
    }

    private boolean putImpl(String name, int index, Scriptable start, Object value, int constFlag) {
        Slot slot;
        if (this != start) {
            slot = this.getSlot(name, index, 1);
            if (slot == null) {
                return false;
            }
        } else {
            this.checkNotSealed(name, index);
            if (constFlag != 0) {
                Slot slot2 = this.getSlot(name, index, 5);
                int attr = slot2.getAttributes();
                if ((attr & 1) == 0) {
                    throw Context.reportRuntimeError1("msg.var.redecl", name);
                }
                if ((attr & 8) != 0) {
                    slot2.value = value;
                    if (constFlag != 8) {
                        slot2.setAttributes(attr & 0xFFFFFFF7);
                    }
                }
                return true;
            }
            slot = this.getSlot(name, index, 2);
        }
        if ((slot.getAttributes() & 1) != 0) {
            return true;
        }
        if (slot instanceof GetterSlot) {
            Object setterObj = ((GetterSlot)slot).setter;
            if (setterObj == null) {
                if (((GetterSlot)slot).getter != null) {
                    throw ScriptRuntime.typeError1("msg.set.prop.no.setter", name);
                }
            } else {
                Context cx = Context.getContext();
                if (setterObj instanceof MemberBox) {
                    Object[] args;
                    Object setterThis;
                    MemberBox nativeSetter = (MemberBox)setterObj;
                    Class<?>[] pTypes = nativeSetter.argTypes;
                    Class<?> valueType = pTypes[pTypes.length - 1];
                    int tag = FunctionObject.getTypeTag(valueType);
                    Object actualArg = FunctionObject.convertArg(cx, start, value, tag);
                    if (nativeSetter.delegateTo == null) {
                        setterThis = start;
                        args = new Object[]{actualArg};
                    } else {
                        setterThis = nativeSetter.delegateTo;
                        args = new Object[]{start, actualArg};
                    }
                    nativeSetter.invoke(setterThis, args);
                } else {
                    Function f = (Function)setterObj;
                    f.call(cx, f.getParentScope(), start, new Object[]{value});
                }
                return true;
            }
        }
        if (this == start) {
            slot.value = value;
            return true;
        }
        return false;
    }

    private Slot findAttributeSlot(String name, int index, int accessType) {
        Slot slot = this.getSlot(name, index, accessType);
        if (slot == null) {
            String str = name != null ? name : Integer.toString(index);
            throw Context.reportRuntimeError1("msg.prop.not.found", str);
        }
        return slot;
    }

    private Slot getSlot(String name, int index, int accessType) {
        Slot slot = this.lastAccess;
        if (!(name == null ? slot.name != null || index != slot.indexOrHash : name != slot.name)) {
            if (!slot.wasDeleted && (accessType != 4 || slot instanceof GetterSlot)) {
                return slot;
            }
        }
        if ((slot = this.accessSlot(name, index, accessType)) != null) {
            this.lastAccess = slot;
        }
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Slot accessSlot(String name, int index, int accessType) {
        int indexOrHash;
        int n = indexOrHash = name != null ? name.hashCode() : index;
        if (accessType == 1 || accessType == 2 || accessType == 5 || accessType == 4) {
            Slot[] slotsLocalRef = this.slots;
            if (slotsLocalRef == null) {
                if (accessType == 1) {
                    return null;
                }
            } else {
                int tableSize = slotsLocalRef.length;
                int slotIndex = ScriptableObject.getSlotIndex(tableSize, indexOrHash);
                Slot slot = slotsLocalRef[slotIndex];
                while (slot != null) {
                    String sname = slot.name;
                    if (sname != null) {
                        if (sname == name) break;
                        if (name != null && indexOrHash == slot.indexOrHash && name.equals(sname)) {
                            slot.name = name;
                            break;
                        }
                    } else if (name == null && indexOrHash == slot.indexOrHash) break;
                    slot = slot.next;
                }
                if (accessType == 1) {
                    return slot;
                }
                if (accessType == 2 ? slot != null : (accessType == 4 ? slot instanceof GetterSlot : accessType == 5 && slot != null)) {
                    return slot;
                }
            }
            ScriptableObject tableSize = this;
            synchronized (tableSize) {
                Slot newSlot;
                int insertPos;
                slotsLocalRef = this.slots;
                if (this.count == 0) {
                    slotsLocalRef = new Slot[5];
                    this.slots = slotsLocalRef;
                    insertPos = ScriptableObject.getSlotIndex(slotsLocalRef.length, indexOrHash);
                } else {
                    Slot prev;
                    int tableSize2 = slotsLocalRef.length;
                    insertPos = ScriptableObject.getSlotIndex(tableSize2, indexOrHash);
                    Slot slot = prev = slotsLocalRef[insertPos];
                    while (slot != null) {
                        if (slot.indexOrHash == indexOrHash && (slot.name == name || name != null && name.equals(slot.name))) break;
                        prev = slot;
                        slot = slot.next;
                    }
                    if (slot != null) {
                        if (accessType == 4 && !(slot instanceof GetterSlot)) {
                            GetterSlot newSlot2 = new GetterSlot(name, indexOrHash, slot.getAttributes());
                            newSlot2.value = slot.value;
                            newSlot2.next = slot.next;
                            if (this.lastAdded != null) {
                                this.lastAdded.orderedNext = newSlot2;
                            }
                            if (this.firstAdded == null) {
                                this.firstAdded = newSlot2;
                            }
                            this.lastAdded = newSlot2;
                            if (prev == slot) {
                                slotsLocalRef[insertPos] = newSlot2;
                            } else {
                                prev.next = newSlot2;
                            }
                            slot.wasDeleted = true;
                            slot.value = null;
                            slot.name = null;
                            if (slot == this.lastAccess) {
                                this.lastAccess = REMOVED;
                            }
                            slot = newSlot2;
                        } else if (accessType == 5) {
                            return null;
                        }
                        return slot;
                    }
                    if (4 * (this.count + 1) > 3 * slotsLocalRef.length) {
                        slotsLocalRef = new Slot[slotsLocalRef.length * 2 + 1];
                        ScriptableObject.copyTable(this.slots, slotsLocalRef, this.count);
                        this.slots = slotsLocalRef;
                        insertPos = ScriptableObject.getSlotIndex(slotsLocalRef.length, indexOrHash);
                    }
                }
                Slot slot = newSlot = accessType == 4 ? new GetterSlot(name, indexOrHash, 0) : new Slot(name, indexOrHash, 0);
                if (accessType == 5) {
                    newSlot.setAttributes(13);
                }
                ++this.count;
                if (this.lastAdded != null) {
                    this.lastAdded.orderedNext = newSlot;
                }
                if (this.firstAdded == null) {
                    this.firstAdded = newSlot;
                }
                this.lastAdded = newSlot;
                ScriptableObject.addKnownAbsentSlot(slotsLocalRef, newSlot, insertPos);
                return newSlot;
            }
        }
        if (accessType == 3) {
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                Slot[] slotsLocalRef = this.slots;
                if (this.count != 0) {
                    Slot prev;
                    int tableSize = this.slots.length;
                    int slotIndex = ScriptableObject.getSlotIndex(tableSize, indexOrHash);
                    Slot slot = prev = slotsLocalRef[slotIndex];
                    while (slot != null) {
                        if (slot.indexOrHash == indexOrHash && (slot.name == name || name != null && name.equals(slot.name))) break;
                        prev = slot;
                        slot = slot.next;
                    }
                    if (slot != null && (slot.getAttributes() & 4) == 0) {
                        --this.count;
                        if (prev == slot) {
                            slotsLocalRef[slotIndex] = slot.next;
                        } else {
                            prev.next = slot.next;
                        }
                        slot.wasDeleted = true;
                        slot.value = null;
                        slot.name = null;
                        if (slot == this.lastAccess) {
                            this.lastAccess = REMOVED;
                        }
                    }
                }
            }
            return null;
        }
        throw Kit.codeBug();
    }

    private static int getSlotIndex(int tableSize, int indexOrHash) {
        return (indexOrHash & Integer.MAX_VALUE) % tableSize;
    }

    private static void copyTable(Slot[] slots, Slot[] newSlots, int count) {
        if (count == 0) {
            throw Kit.codeBug();
        }
        int tableSize = newSlots.length;
        int i = slots.length;
        block0: while (true) {
            Slot slot = slots[--i];
            do {
                if (slot == null) continue block0;
                int insertPos = ScriptableObject.getSlotIndex(tableSize, slot.indexOrHash);
                Slot next = slot.next;
                ScriptableObject.addKnownAbsentSlot(newSlots, slot, insertPos);
                slot.next = null;
                slot = next;
            } while (--count != 0);
            break;
        }
    }

    private static void addKnownAbsentSlot(Slot[] slots, Slot slot, int insertPos) {
        if (slots[insertPos] == null) {
            slots[insertPos] = slot;
        } else {
            Slot prev = slots[insertPos];
            while (prev.next != null) {
                prev = prev.next;
            }
            prev.next = slot;
        }
    }

    Object[] getIds(boolean getAll) {
        Slot[] s = this.slots;
        Object[] a = ScriptRuntime.emptyArgs;
        if (s == null) {
            return a;
        }
        int c = 0;
        Slot slot = this.firstAdded;
        while (slot != null && slot.wasDeleted) {
            slot = slot.orderedNext;
        }
        this.firstAdded = slot;
        if (slot != null) {
            while (true) {
                if (getAll || (slot.getAttributes() & 2) == 0) {
                    if (c == 0) {
                        a = new Object[s.length];
                    }
                    a[c++] = slot.name != null ? slot.name : Integer.valueOf(slot.indexOrHash);
                }
                Slot next = slot.orderedNext;
                while (next != null && next.wasDeleted) {
                    next = next.orderedNext;
                }
                slot.orderedNext = next;
                if (next == null) break;
                slot = next;
            }
        }
        this.lastAdded = slot;
        if (c == a.length) {
            return a;
        }
        Object[] result = new Object[c];
        System.arraycopy(a, 0, result, 0, c);
        return result;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int objectsCount = this.count;
        if (objectsCount < 0) {
            objectsCount ^= 0xFFFFFFFF;
        }
        if (objectsCount == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.slots.length);
            Slot slot = this.firstAdded;
            while (slot != null && slot.wasDeleted) {
                slot = slot.orderedNext;
            }
            this.firstAdded = slot;
            while (slot != null) {
                out.writeObject(slot);
                Slot next = slot.orderedNext;
                while (next != null && next.wasDeleted) {
                    next = next.orderedNext;
                }
                slot.orderedNext = next;
                slot = next;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lastAccess = REMOVED;
        int tableSize = in.readInt();
        if (tableSize != 0) {
            this.slots = new Slot[tableSize];
            int objectsCount = this.count;
            if (objectsCount < 0) {
                objectsCount ^= 0xFFFFFFFF;
            }
            Slot prev = null;
            int i = 0;
            while (i != objectsCount) {
                this.lastAdded = (Slot)in.readObject();
                if (i == 0) {
                    this.firstAdded = this.lastAdded;
                } else {
                    prev.orderedNext = this.lastAdded;
                }
                int slotIndex = ScriptableObject.getSlotIndex(tableSize, this.lastAdded.indexOrHash);
                ScriptableObject.addKnownAbsentSlot(this.slots, this.lastAdded, slotIndex);
                prev = this.lastAdded;
                ++i;
            }
        }
    }

    private static final class GetterSlot
    extends Slot {
        static final long serialVersionUID = -4900574849788797588L;
        Object getter;
        Object setter;

        GetterSlot(String name, int indexOrHash, int attributes) {
            super(name, indexOrHash, attributes);
        }
    }

    private static class Slot
    implements Serializable {
        private static final long serialVersionUID = -6090581677123995491L;
        String name;
        int indexOrHash;
        private volatile short attributes;
        volatile transient boolean wasDeleted;
        volatile Object value;
        volatile transient Slot next;
        volatile transient Slot orderedNext;

        Slot(String name, int indexOrHash, int attributes) {
            this.name = name;
            this.indexOrHash = indexOrHash;
            this.attributes = (short)attributes;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.name != null) {
                this.indexOrHash = this.name.hashCode();
            }
        }

        final int getAttributes() {
            return this.attributes;
        }

        final synchronized void setAttributes(int value) {
            ScriptableObject.checkValidAttributes(value);
            this.attributes = (short)value;
        }

        final void checkNotReadonly() {
            if ((this.attributes & 1) != 0) {
                String str = this.name != null ? this.name : Integer.toString(this.indexOrHash);
                throw Context.reportRuntimeError1("msg.modify.readonly", str);
            }
        }
    }
}

