/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.codingrule.BingdingPropertyExtentFactory;
import com.kingdee.eas.base.codingrule.BingdingPropertyExtentInfo;
import com.kingdee.eas.base.codingrule.CodingRuleCollection;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CodingRuleServerUtil {
    private static final Logger logger = Logger.getLogger(CodingRuleServerUtil.class);

    private static HashMap initBindingProExtent2HashMap(Context ctx, CodingRuleInfo info) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            BingdingPropertyExtentInfo exten = null;
            for (int i = 0; i < info.getBindingProExtent().size(); ++i) {
                exten = BingdingPropertyExtentFactory.getLocalInstance(ctx).getBingdingPropertyExtentInfo((IObjectPK)new ObjectUuidPK(info.getBindingProExtent().get(i).getId().toString()));
                if (exten.getProValue() == null || StringUtils.isEmpty((String)exten.getProValue())) continue;
                map.put(exten.getProName(), exten.getProValue());
            }
            return map;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private static boolean compareHashMap(HashMap map, HashMap map2) {
        Map.Entry entry2 = null;
        HashMap map1 = (HashMap)map.clone();
        for (Map.Entry entry2 : map2.entrySet()) {
            if (map1.get(entry2.getKey()) == null) continue;
            if (!map1.get(entry2.getKey()).equals(entry2.getValue())) {
                return false;
            }
            map1.remove(entry2.getKey());
        }
        return map1.size() <= 0;
    }

    private static CodingRuleInfo checkBindingProExtentInfo(Context ctx, CodingRuleInfo tmpInfo, HashMap infoMap) {
        HashMap tmpMap = null;
        tmpMap = CodingRuleServerUtil.initBindingProExtent2HashMap(ctx, tmpInfo);
        if (tmpMap.size() != infoMap.size()) {
            return null;
        }
        if (tmpMap.size() != 0 && CodingRuleServerUtil.compareHashMap(tmpMap, infoMap)) {
            return tmpInfo;
        }
        return null;
    }

    public static CodingRuleCollection checkBindingProExtent(Context ctx, CodingRuleInfo info) throws BOSException {
        HashMap infoMap = CodingRuleServerUtil.initBindingProExtent2HashMap(ctx, info);
        CodingRuleInfo tmpInfo = null;
        CodingRuleCollection colRe = new CodingRuleCollection();
        CodingRuleCollection col = CodingRuleServerUtil.getCodingRuleCollection(CodingRuleFactory.getLocalInstance(ctx), info);
        for (int i = 0; i < col.size(); ++i) {
            tmpInfo = CodingRuleServerUtil.checkBindingProExtentInfo(ctx, col.get(i), infoMap);
            if (tmpInfo == null) continue;
            colRe.add(tmpInfo);
        }
        CodingRuleCollection coltemp = (CodingRuleCollection)((Object)colRe.clone());
        for (int i = 0; i < colRe.size(); ++i) {
            if (colRe.get(i) != null) continue;
            coltemp.removeObject(i);
        }
        return coltemp;
    }

    private static CodingRuleCollection getCodingRuleCollection(ICodingRule codRule, CodingRuleInfo codRuleInfo) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)codRuleInfo.getBusinessObjectID()));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true));
        if (!StringUtils.isEmpty((String)codRuleInfo.getCustomProperty())) {
            filter.getFilterItems().add(new FilterItemInfo("customProperty", (Object)codRuleInfo.getCustomProperty()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customProperty", null));
        }
        evi.setFilter(filter);
        return codRule.getCodingRuleCollection(evi);
    }

    public static CodingRuleInfo checkBindingProExtentInfo(Context ctx, CodingRuleInfo tmpInfo, CodingRuleInfo info) {
        HashMap infoMap = CodingRuleServerUtil.initBindingProExtent2HashMap(ctx, info);
        return CodingRuleServerUtil.checkBindingProExtentInfo(ctx, tmpInfo, infoMap);
    }
}

