/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.IAuthenMode;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.SecurityException;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardConfigInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public final class PermissionCommonUtil {
    private static final Logger logger = CoreUIObject.getLogger(PermissionCommonUtil.class);
    private static Map permParamMap = new HashMap();
    private static Map sslConfigMap = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    private PermissionCommonUtil() {
    }

    public static ArrayList assortPerms(RolePermCollection rolePerms) {
        assert (rolePerms != null);
        ArrayList<RolePermCollection> list = new ArrayList<RolePermCollection>(3);
        RolePermCollection normalPerms = new RolePermCollection();
        RolePermCollection forbiddenPerms = new RolePermCollection();
        RolePermCollection authorizationPerms = new RolePermCollection();
        int size = rolePerms.size();
        for (int i = 0; i < size; ++i) {
            RolePermInfo rolePermInfo = rolePerms.get(i);
            if (PermType.NORMAL.equals((Object)rolePermInfo.getPermType())) {
                normalPerms.add(rolePermInfo);
                continue;
            }
            if (PermType.FORBIDDEN.equals((Object)rolePermInfo.getPermType())) {
                forbiddenPerms.add(rolePermInfo);
                continue;
            }
            if (!PermType.AUTHORIZATION.equals((Object)rolePermInfo.getPermType())) continue;
            authorizationPerms.add(rolePermInfo);
        }
        list.add(authorizationPerms);
        list.add(normalPerms);
        list.add(forbiddenPerms);
        return list;
    }

    public static ArrayList assortPerms(UserOrgPermCollection userOrgPerms) {
        assert (userOrgPerms != null);
        ArrayList<UserOrgPermCollection> list = new ArrayList<UserOrgPermCollection>(3);
        UserOrgPermCollection authorizationPerms = new UserOrgPermCollection();
        UserOrgPermCollection normalPerms = new UserOrgPermCollection();
        UserOrgPermCollection forbiddenPerms = new UserOrgPermCollection();
        int size = userOrgPerms.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo userOrgPermInfo = userOrgPerms.get(i);
            if (PermType.AUTHORIZATION.equals((Object)userOrgPermInfo.getPermType())) {
                authorizationPerms.add(userOrgPermInfo);
                continue;
            }
            if (PermType.NORMAL.equals((Object)userOrgPermInfo.getPermType())) {
                normalPerms.add(userOrgPermInfo);
                continue;
            }
            if (!PermType.FORBIDDEN.equals((Object)userOrgPermInfo.getPermType())) continue;
            forbiddenPerms.add(userOrgPermInfo);
        }
        list.add(authorizationPerms);
        list.add(normalPerms);
        list.add(forbiddenPerms);
        return list;
    }

    public static String encrypt(String userNumber, String password) throws EASBizException {
        try {
            return CryptoTean.encrypt((String)userNumber, (String)password.trim());
        }
        catch (CryptException e) {
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }

    public static String getKey(UserOrgPermInfo userOrgPermInfo) {
        assert (userOrgPermInfo != null);
        StringBuffer key = new StringBuffer();
        String permId = "0";
        int permType = 0;
        if (userOrgPermInfo != null) {
            if (userOrgPermInfo.getPermItem() != null) {
                permId = userOrgPermInfo.getPermItem().getId().toString();
            }
            if (userOrgPermInfo.getPermType() != null) {
                permType = userOrgPermInfo.getPermType().getValue();
            }
        }
        key.append(permId).append("_").append(permType);
        return key.toString();
    }

    public static String getKey(RolePermInfo rolePermInfo) {
        assert (rolePermInfo != null);
        StringBuffer key = new StringBuffer();
        key.append(rolePermInfo.getPermItem().getId().toString()).append("_").append(rolePermInfo.getPermType().getValue());
        return key.toString();
    }

    public static String getKey(BOSUuid permItemID, PermType permType) {
        StringBuffer key = new StringBuffer();
        key.append(permItemID.toString()).append("_").append(permType.getValue());
        return key.toString();
    }

    public static EntityObjectInfo getLinkEntity(BOSObjectType mainObjectType, LinkPropertyInfo propertyInfo) {
        EntityObjectInfo linkEntity = propertyInfo.getRelationship().getSupplierObject();
        if (!linkEntity.getType().equals((Object)mainObjectType)) {
            return linkEntity;
        }
        return propertyInfo.getRelationship().getClientObject();
    }

    public static boolean isEntry(LinkPropertyInfo linkPropertyInfo) {
        RelationshipInfo relationshipInfo = linkPropertyInfo.getRelationship();
        if (relationshipInfo.getType().equals((Object)RelationshipType.COMPOSITION)) {
            return true;
        }
        return relationshipInfo.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || relationshipInfo.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED);
    }

    public static OrgType getMainBizOrgType(EntityObjectInfo entity) {
        String extendPropertyName = "OrgType";
        String value = entity.getExtendedProperty(extendPropertyName);
        if (!StringUtils.isEmpty((String)value)) {
            Iterator iterator = OrgType.iterator();
            while (iterator.hasNext()) {
                OrgType orgType = (OrgType)iterator.next();
                if (!orgType.getName().equalsIgnoreCase(value)) continue;
                return orgType;
            }
        }
        return OrgType.NONE;
    }

    public static void removeEmptyPackageNode(DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode node = null;
        if (root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                PermissionCommonUtil.removeEmptyPackageNode(node);
                MetaDataBriefInfo metaDataBriefInfo = (MetaDataBriefInfo)node.getUserObject();
                if (node.getChildCount() != 0 || !metaDataBriefInfo.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    public static String getAuthorizeDiscription(AuthorizeTypeEnum type) {
        return PermissionCommonUtil.getAuthorizeDiscription(type, false);
    }

    public static String getAuthorizeDiscription(AuthorizeTypeEnum type, boolean addAlias) {
        String description = type.getAlias();
        String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
        String typeAlias = addAlias ? new StringBuffer().append(type.getAlias()).append(";").toString() : "";
        Object[] params = new Object[]{typeAlias};
        if (type.equals((Object)AuthorizeTypeEnum.dynAndUsb)) {
            description = EASResource.getString((String)RESOURCE, (String)"infoFirstDynThenUsbKey");
        } else if (type.equals((Object)AuthorizeTypeEnum.usbAndDyn)) {
            description = EASResource.getString((String)RESOURCE, (String)"infoFirstUsbKeyThenDyn");
        } else if (type.equals((Object)AuthorizeTypeEnum.caAuth)) {
            description = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"infoCaAuth"), params);
        } else if (type.equals((Object)AuthorizeTypeEnum.dynAuth)) {
            description = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"infoDyncCardAuth"), params);
        } else if (type.equals((Object)AuthorizeTypeEnum.caAuthOnlySignature)) {
            description = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"infoCaAuthOnlySignature"), params);
        } else if (type.equals((Object)AuthorizeTypeEnum.caAuthOnlyVerfiy)) {
            description = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"infoCaAuthOnlyVerfiy"), params);
        } else if (type.equals((Object)AuthorizeTypeEnum.noAuthor)) {
            description = "";
        }
        return description;
    }

    public static boolean isIDAuthorizeEnabled(Context ctx) {
        return PermissionCommonUtil.isEnableParam(ctx, "EnableIDAuthorize");
    }

    public static boolean isPermSubsystemFileEnabled(Context ctx) {
        return PermissionCommonUtil.isEnableParam(ctx, "EnablePermSubsystemFile");
    }

    private static boolean isEnableParam(Context ctx, String param) {
        boolean result = false;
        if (permParamMap.get(param) != null && permParamMap.get(param) instanceof Boolean) {
            result = (Boolean)permParamMap.get(param);
        } else {
            if (ctx == null) {
                result = "true".equalsIgnoreCase(PermissionParameterFactory.getRemoteInstance().getPermissionParameter(param));
            } else {
                try {
                    result = "true".equalsIgnoreCase(PermissionParameterFactory.getLocalInstance(ctx).getPermissionParameter(param));
                }
                catch (BOSException e) {
                    result = false;
                }
            }
            permParamMap.put(param, result);
        }
        return result;
    }

    public static boolean isPasswordIDAuthorizeEnabled(Context ctx) {
        return PermissionCommonUtil.getParameterValue(ctx, null, "isPasswordIDAuthorizeEnabled");
    }

    public static boolean isAuditAdminEnabled(Context ctx) {
        return PermissionCommonUtil.isEnableParam(ctx, "EnableAuditAdmin");
    }

    public static boolean isAuthenticateAdminEnabled(Context ctx) {
        try {
            if (ctx == null) {
                return AuthenModeFactory.getRemoteInstance().isEnabledAuthenticadeAdmin();
            }
            return AuthenModeFactory.getLocalInstance(ctx).isEnabledAuthenticadeAdmin();
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getPermissionParameter(Context ctx, String paramName) {
        String result = "";
        if (permParamMap.get(paramName) != null) {
            result = (String)permParamMap.get(paramName);
        } else {
            if (ctx == null) {
                result = PermissionParameterFactory.getRemoteInstance().getPermissionParameter(paramName);
            } else {
                try {
                    result = PermissionParameterFactory.getLocalInstance(ctx).getPermissionParameter(paramName);
                }
                catch (BOSException e) {
                    result = "";
                }
            }
            permParamMap.put(paramName, result);
        }
        return result;
    }

    public static String getDynamicCardPwdCheckClass(Context ctx) {
        DynamicCardConfigInfo info;
        String result = null;
        ISecurityAuthParamManager manager = PermissionCommonUtil.getSecurityAuthParamManager(ctx);
        if (manager != null && (info = manager.getDynamicCardConfigInfo(null)) != null) {
            result = info.getDynamicCardSupplierClass();
        }
        return result;
    }

    public static String getDynamicCardUserNumberType(Context ctx) {
        DynamicCardConfigInfo info;
        String result = null;
        ISecurityAuthParamManager manager = PermissionCommonUtil.getSecurityAuthParamManager(ctx);
        if (manager != null && (info = manager.getDynamicCardConfigInfo(null)) != null) {
            result = info.getUserNumberType();
        }
        return result;
    }

    public static boolean isMachineRegisterEnabled(Context ctx) {
        boolean isEnabled = false;
        ISecurityAuthParamManager manager = PermissionCommonUtil.getSecurityAuthParamManager(ctx);
        if (manager != null) {
            isEnabled = manager.getMachineCodeAuthState();
        }
        return isEnabled;
    }

    private static ISecurityAuthParamManager getSecurityAuthParamManager(Context ctx) {
        ISecurityAuthParamManager manager = null;
        try {
            manager = ctx == null ? SecurityAuthParamManagerFactory.getRemoteInstance() : SecurityAuthParamManagerFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            logger.info((Object)e);
        }
        return manager;
    }

    public static String getMachineCodeGeneratorPolicy(Context ctx) {
        String paramValue = "3";
        try {
            paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"MachineCodeGeneratorPolicy");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return paramValue;
    }

    public static boolean IsMachineRegisterWithUser(Context ctx) {
        return PermissionCommonUtil.getParameterValue(ctx, null, "isMachineRegisterWithUser");
    }

    public static boolean isFingerprintEnabled(Context ctx) {
        boolean isEnabled = false;
        ISecurityAuthParamManager manager = PermissionCommonUtil.getSecurityAuthParamManager(ctx);
        if (manager != null) {
            isEnabled = manager.isEnableFingerprintAuth();
        }
        return isEnabled;
    }

    private static boolean getParameterValue(Context ctx, IObjectPK orgUnitID, String paramName) {
        boolean result = false;
        try {
            String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)orgUnitID, (String)paramName);
            if ("true".equalsIgnoreCase(paramValue)) {
                result = true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            result = false;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            result = false;
        }
        return result;
    }

    public static boolean checkSSLconfig(String uiclass) throws SecurityException {
        boolean bResult = false;
        if (sslConfigMap == null) {
            try {
                Class<?> c = Class.forName("com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil");
                Method m = c.getMethod("getSSLConfig", new Class[0]);
                sslConfigMap = (Map)m.invoke(c, new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                try {
                    sslConfigMap = PermissionFactory.getRemoteInstance().getSSLConfiguration();
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        }
        if (!StringUtils.isEmpty((String)uiclass) && sslConfigMap != null && "true".equals(sslConfigMap.get(uiclass))) {
            bResult = true;
            String linkStr = System.getProperty("appserver");
            if (!StringUtils.isEmpty((String)linkStr) && !linkStr.substring(0, 4).equalsIgnoreCase("tcps")) {
                throw new SecurityException(SecurityException.SSL_NEEDED);
            }
        }
        return bResult;
    }

    public static boolean passWillBeExpired(UserInfo user) {
        double nowTime;
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(user.getId()))) {
            return false;
        }
        if (user.getSecurity() == null) {
            return false;
        }
        if (user.getSecurity().isPasswordForever()) {
            return false;
        }
        Calendar gcInvalid = PermissionCommonUtil.getExpiredTime(user);
        double invalidTime = gcInvalid.getTimeInMillis();
        int days = (int)Math.round((invalidTime - (nowTime = (double)System.currentTimeMillis())) / 8.64E7 + 0.5);
        return days <= user.getSecurity().getForewarnDay() && days > 0;
    }

    public static String getExpireWarnMsg(UserInfo user) {
        Object[] objects = new Object[]{BOSLocaleUtil.getDateFormat().format(PermissionCommonUtil.getExpiredTime(user).getTime())};
        String str = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"passwordForewarn"), objects);
        return str;
    }

    public static Calendar getExpiredTime(UserInfo user) {
        GregorianCalendar gcInvalid = new GregorianCalendar();
        gcInvalid.setTime(user.getPWEffectiveDate());
        gcInvalid.add(5, user.getSecurity().getPasswordCycle());
        return gcInvalid;
    }

    public static boolean isPassExpired(UserInfo userInfo) {
        if (userInfo.getSecurity() == null) {
            return false;
        }
        if (userInfo.getSecurity().isPasswordForever()) {
            return false;
        }
        Date inuseDate = userInfo.getPWEffectiveDate();
        GregorianCalendar gcInuse = new GregorianCalendar();
        gcInuse.setTime(inuseDate);
        GregorianCalendar gcInvalid = new GregorianCalendar();
        gcInvalid.setTime(inuseDate);
        gcInvalid.add(5, userInfo.getSecurity().getPasswordCycle());
        Date invalidDate = new Date(gcInvalid.getTimeInMillis());
        Date now = new Date();
        return DateTimeUtils.dayAfter((Date)now, (Date)invalidDate);
    }

    public static String getUITitle(String title, String oprtState) {
        String titlePostfix = "";
        if (OprtState.ADDNEW.equals(oprtState)) {
            titlePostfix = EASResource.getString((String)RESOURCE, (String)"add");
        } else if (OprtState.EDIT.equals(oprtState)) {
            titlePostfix = EASResource.getString((String)RESOURCE, (String)"edit");
        } else if (OprtState.VIEW.equals(oprtState)) {
            titlePostfix = EASResource.getString((String)RESOURCE, (String)"view");
        }
        return title + titlePostfix;
    }

    public static void setParam(String param, boolean result) {
        permParamMap.put(param, result);
    }

    public static boolean isAuthenAddnewUserEnabled(Context ctx) throws BOSException {
        boolean isAddnewAuthen = false;
        IAuthenMode iAuthenMode = ctx == null ? AuthenModeFactory.getRemoteInstance() : AuthenModeFactory.getLocalInstance(ctx);
        isAddnewAuthen = iAuthenMode.isEnabled(AuthenModeTypeEnum.NewUserAuthen);
        return isAddnewAuthen;
    }
}

