/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.DiscreteDataContext;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import java.util.List;
import org.apache.log4j.Logger;

public class DiscreteDataSwitch {
    private static Logger logger = Logger.getLogger((String)DiscreteDataSwitch.class.getName());
    private DiscreteDataContext discreteDataCtx;
    private DiscretePermCollection discretePermCol4User;
    private DiscretePermCollection discretePermCol4Role;

    public DiscreteDataSwitch(DiscreteDataContext discreteDataCtx) {
        this.discreteDataCtx = discreteDataCtx;
    }

    public boolean hasUserTarget() {
        return this.discreteDataCtx.getUserDiscreteAccreditBatchInfo() != null && this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getUserIdList() != null && !this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getUserIdList().isEmpty();
    }

    public boolean hasRoleTarget() {
        return this.discreteDataCtx.getUserDiscreteAccreditBatchInfo() != null && this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getRoleIdList() != null && !this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getRoleIdList().isEmpty();
    }

    public boolean hasDataTarget() {
        return this.hasRoleTarget() || this.hasUserTarget();
    }

    public DiscretePermCollection getDiscretePermCol4User() {
        if (this.discretePermCol4User == null) {
            this.discretePermCol4User = this.deal(true);
        }
        return this.discretePermCol4User;
    }

    public DiscretePermCollection getDiscretePermCol4Role() {
        if (this.discretePermCol4Role == null) {
            this.discretePermCol4Role = this.deal(false);
        }
        return this.discretePermCol4Role;
    }

    private DiscretePermCollection deal(boolean isUser) {
        if (isUser) {
            return this.makeUp(this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getBizObjIdList(), this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getUserIdList(), this.discreteDataCtx.getCurOrg(), this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getPermItemIdList(), true);
        }
        return this.makeUp(this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getBizObjIdList(), this.discreteDataCtx.getUserDiscreteAccreditBatchInfo().getRoleIdList(), null, this.getDiscreteDataCtx().getUserDiscreteAccreditBatchInfo().getPermItemIdList(), false);
    }

    private DiscretePermCollection makeUp(List bizDataIdList, List targetList, FullOrgUnitInfo orgInfo, List permItemIdList, boolean isUser) {
        DiscretePermCollection discretePermCol = new DiscretePermCollection();
        if (bizDataIdList == null || targetList == null || permItemIdList == null) {
            logger.info((Object)"data is null!");
            return discretePermCol;
        }
        if (bizDataIdList.isEmpty() || targetList.isEmpty() || permItemIdList.isEmpty()) {
            logger.info((Object)"collection is null!");
            return discretePermCol;
        }
        int size = bizDataIdList.size();
        for (int i = 0; i < size; ++i) {
            String tempBizData = bizDataIdList.get(i).toString();
            int sizej = targetList.size();
            for (int j = 0; j < sizej; ++j) {
                String targetId = targetList.get(j).toString();
                int sizem = permItemIdList.size();
                for (int m = 0; m < sizem; ++m) {
                    DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                    discretePermInfo.setBizDataID(BOSUuid.read((String)tempBizData));
                    PermItemInfo permItemInfo = new PermItemInfo();
                    permItemInfo.setId(BOSUuid.read((String)permItemIdList.get(m).toString()));
                    discretePermInfo.setPermItemInfo(permItemInfo);
                    String[] idAndNumber = targetId.split(" ");
                    if (isUser) {
                        UserInfo userInfo = new UserInfo();
                        userInfo.setId(BOSUuid.read((String)idAndNumber[0]));
                        userInfo.setNumber(idAndNumber[1]);
                        discretePermInfo.setUser(userInfo);
                        discretePermInfo.setOrg(orgInfo);
                    } else {
                        RoleInfo roleInfo = new RoleInfo();
                        roleInfo.setId(BOSUuid.read((String)idAndNumber[0]));
                        roleInfo.setNumber(idAndNumber[1]);
                        discretePermInfo.setRole(roleInfo);
                    }
                    discretePermCol.add(discretePermInfo);
                }
            }
        }
        return discretePermCol;
    }

    public DiscreteDataContext getDiscreteDataCtx() {
        return this.discreteDataCtx;
    }

    public void setDiscreteDataCtx(DiscreteDataContext discreteDataCtx) {
        this.discreteDataCtx = discreteDataCtx;
    }
}

