/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractPasswordInputUI;
import com.kingdee.eas.base.permission.service.helper.IUsbKeyControlExtern;
import com.kingdee.eas.base.permission.service.helper.UsbKeyFactory;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PasswordInputUI
extends KDDialog {
    private static final Logger logger = Logger.getLogger(PasswordInputUI.class);
    public static final String ID = "ID";
    public static final String NUMBER = "NUMBER";
    public static final String LOGIN_WAY = "LOGINWAY";
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private String userName = SysContext.getSysContext().getUserName();
    private LoginAuthorWayEnum loginWay;
    private boolean isLoginSuccessful = false;
    private ResourceBundleHelper resHelper;
    protected KDLabelContainer kDLabelContainer1;
    protected KDLabelContainer kDLabelContainer2;
    protected KDTextField tUserName;
    protected KDButton btnOk;
    protected KDButton btnCancel;
    protected KDPasswordField tPassword;

    public PasswordInputUI() throws Exception {
        this.initUI();
    }

    public PasswordInputUI(Dialog owner) throws Exception {
        super(owner, true);
        this.initUI();
    }

    public PasswordInputUI(Frame owner) throws Exception {
        super(owner, true);
        this.initUI();
    }

    private void initUI() throws Exception {
        this.jbInit();
        this.initUIContentLayout();
    }

    private void jbInit() throws Exception {
        this.resHelper = new ResourceBundleHelper(AbstractPasswordInputUI.class.getName());
        this.setTitle(this.resHelper.getString("this.title"));
        this.kDLabelContainer1 = new KDLabelContainer();
        this.kDLabelContainer2 = new KDLabelContainer();
        this.tUserName = new KDTextField();
        this.btnOk = new KDButton();
        this.btnCancel = new KDButton();
        this.tPassword = new KDPasswordField();
        this.kDLabelContainer1.setName("kDLabelContainer1");
        this.kDLabelContainer2.setName("kDLabelContainer2");
        this.tUserName.setName("tUserName");
        this.btnOk.setName("btnOk");
        this.btnCancel.setName("btnCancel");
        this.tPassword.setName("tPassword");
        this.kDLabelContainer1.setBoundLabelText(this.resHelper.getString("kDLabelContainer1.boundLabelText"));
        this.kDLabelContainer1.setBoundLabelLength(70);
        this.kDLabelContainer1.setBoundLabelUnderline(true);
        this.kDLabelContainer2.setBoundLabelText(this.resHelper.getString("kDLabelContainer2.boundLabelText"));
        this.kDLabelContainer2.setBoundLabelLength(70);
        this.kDLabelContainer2.setBoundLabelUnderline(true);
        this.tUserName.setEnabled(false);
        this.btnOk.setText(this.resHelper.getString("btnOk.text"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PasswordInputUI.this.btnOk_actionPerformed(e);
                }
                catch (Exception exc) {
                    MsgBox.showWarning((String)exc.getMessage());
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                }
            }
        });
        this.btnCancel.setText(this.resHelper.getString("btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PasswordInputUI.this.btnCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    MsgBox.showWarning((String)exc.getMessage());
                    logger.error((Object)exc.getMessage(), (Throwable)exc);
                }
            }
        });
        this.tPassword.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    try {
                        PasswordInputUI.this.btnOk_actionPerformed(null);
                    }
                    catch (Exception exc) {
                        MsgBox.showWarning((String)exc.getMessage());
                        logger.error((Object)exc.getMessage(), (Throwable)exc);
                    }
                }
            }
        });
    }

    public void initUIContentLayout() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(null);
        this.kDLabelContainer1.setBounds(new Rectangle(22, 30, 200, 19));
        contentPane.add((Component)this.kDLabelContainer1, null);
        this.kDLabelContainer2.setBounds(new Rectangle(22, 62, 200, 19));
        contentPane.add((Component)this.kDLabelContainer2, null);
        this.btnOk.setBounds(new Rectangle(75, 100, 73, 21));
        contentPane.add((Component)this.btnOk, null);
        this.btnCancel.setBounds(new Rectangle(155, 100, 73, 21));
        contentPane.add((Component)this.btnCancel, null);
        this.kDLabelContainer1.setBoundEditor((JComponent)this.tUserName);
        this.kDLabelContainer2.setBoundEditor((JComponent)this.tPassword);
        this.setSize(250, 160);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    public void show() {
        try {
            this.init();
            super.show();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init() throws Exception {
        this.tUserName.setText(this.userName);
        if (this.getLoginWay() != null && LoginAuthorWayEnum.NORMAL.equals((Object)this.getLoginWay())) {
            this.setTitle(EASResource.getString((String)RESOURCE, (String)"INPUT_PASSWORD"));
        }
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.tPassword, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
    }

    protected JButton getDefaultButton() {
        return this.btnOk;
    }

    public LoginAuthorWayEnum getLoginWay() {
        return this.loginWay;
    }

    public void setLoginWay(LoginAuthorWayEnum loginWay) {
        this.loginWay = loginWay;
    }

    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        String password = "";
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (this.tPassword.getPassword() != null) {
            password = new String(this.tPassword.getPassword());
        }
        String checkedUserName = null;
        String innerPassword = null;
        String checkPassword = null;
        LoginAuthorWayEnum loginWay = this.getLoginWay();
        if (loginWay == null) {
            loginWay = LoginAuthorWayEnum.DYNAMIC;
        }
        if (LoginAuthorWayEnum.DYNAMIC.equals((Object)loginWay)) {
            String numberType = this.getDynamicCardUserNumberType();
            if (StringUtils.isEmpty((String)numberType)) {
                numberType = "1";
            }
            checkedUserName = "2".equals(numberType) ? user.getNumber() : user.getId().toString();
            checkPassword = innerPassword = LoginHelper.encodePassword((String)checkedUserName, (String)password);
        } else if (LoginAuthorWayEnum.NORMAL.equals((Object)loginWay)) {
            checkedUserName = user.getNumber();
            checkPassword = StringUtils.isEmpty((String)password) ? null : PermissionUtils.encrypt(user.getId().toString(), password);
            innerPassword = LoginHelper.encodePassword((String)checkedUserName, (String)password);
        } else if (LoginAuthorWayEnum.USBKEY.equals((Object)loginWay)) {
            IUsbKeyControlExtern usbKeyProxy = UsbKeyFactory.getUsbKey();
            try {
                usbKeyProxy.verifyPwd(password);
                LoginContext ctx = (LoginContext)SysContext.getSysContext().getProperty((Object)"logincontext");
                innerPassword = LoginHelper.encodePassword((String)checkedUserName, (String)password);
                ctx.put("Password", (Object)innerPassword);
                ctx.setUserPass(innerPassword);
                SystemEntry.instance.innerReLogin();
                this.isLoginSuccessful = true;
                this.dispose();
            }
            catch (Exception e2) {
                String errorMsg = EASResource.getString((String)RESOURCE, (String)"USBKEY_PASSWORD_ERROR");
                MsgBox.showInfo((Component)((Object)this), (String)errorMsg);
                logger.error((Object)"ReloginAction_USBKEY", (Throwable)e2);
            }
            return;
        }
        try {
            if (!SystemEntry.instance.isWebStart()) {
                LoginContext ctx = (LoginContext)SysContext.getSysContext().getProperty((Object)"logincontext");
                ctx.setUserPass(innerPassword);
                SystemEntry.instance.innerReLogin();
            } else {
                SystemEntry.instance.innerReLogin();
                if (!PermissionManagerFactory.getRemoteInstance().checkPassword(checkedUserName, checkPassword, loginWay)) {
                    throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                }
            }
            this.isLoginSuccessful = true;
            this.dispose();
        }
        catch (Exception e1) {
            logger.error((Object)"ReloginAction", (Throwable)e1);
            if (this.isConnectionException(e1)) {
                UserException ue = new UserException(UserException.NETWORK_ERROR);
                MsgBox.showWarning((String)ue.getMessage());
            }
            MsgBox.showWarning((String)e1.getMessage());
        }
    }

    private boolean isConnectionException(Throwable e) {
        while (true) {
            if (e instanceof RPCConnectException) {
                return true;
            }
            if (e.getCause() == null || e.getCause() == e) break;
            e = e.getCause();
        }
        return false;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.dispose();
    }

    public boolean isLoginSuccessful() {
        return this.isLoginSuccessful;
    }

    private String getDynamicCardUserNumberType() {
        try {
            return PermissionCommonUtil.getDynamicCardUserNumberType(null);
        }
        catch (Exception e) {
            String numberType;
            Object numberTypeObj = SysContext.getSysContext().getProperty((Object)"dynamicCardUserNumberType");
            String string = numberType = numberTypeObj == null ? null : numberTypeObj.toString();
            if (numberType == null) {
                throw new RuntimeException(e);
            }
            return numberType;
        }
    }
}

