/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.permission.AuthenSchemePermFactory;
import com.kingdee.eas.base.permission.IAuthenSchemePerm;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IUserOrgPermFacade;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.client.tree.IPermissionTreeBuilder;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.IKDPromptSelector2;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class PermItemMultiPromptDialog
extends KDDialog
implements IKDPromptSelector2 {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static Logger logger = Logger.getLogger(PermItemMultiPromptDialog.class);
    private static final String EXPANDED_KEY = "expanded";
    private static final String NEED_ALL_KEY = "needAll";
    private Set<PermItemInfo> exclusivePermItemSet = new HashSet<PermItemInfo>();
    private static final Icon ICON_LEAF_ADVICE = EASResource.getIcon((String)"imgTree_folder_leafpick");
    private static final Icon ICON_FOLDER_OPEN_ADVICE = EASResource.getIcon((String)"imgTree_folder_openpick");
    private static final Icon ICON_FOLDER_CLOSE_ADVICE = EASResource.getIcon((String)"imgTree_folder_closepick");
    private KDTree sourceTree;
    private KDTree targetTree;
    protected KDLabel lblSource;
    protected KDLabel lblTarget;
    protected KDWorkButton btnAddAll;
    protected KDWorkButton btnAdd;
    protected KDWorkButton btnDelete;
    protected KDWorkButton btnDeleteAll;
    protected KDButton btnConfirm;
    protected KDButton btnCancel;
    protected KDTreeView sourceTreeView;
    protected KDTreeView targetTreeView;
    protected KDSeparator separator;
    private IPermissionTreeBuilder builder;
    private PermItemInfo result;
    private PermItemCollection results = new PermItemCollection();
    private boolean isCancel;

    public PermItemMultiPromptDialog(Frame frame) {
        super(frame, true);
        try {
            this.jbInit();
            this.onLoad();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public PermItemMultiPromptDialog(Frame frame, PermItemCollection targetTreePermOld) {
        super(frame, true);
        try {
            this.results = targetTreePermOld;
            for (int i = 0; i < this.results.size(); ++i) {
                this.exclusivePermItemSet.add(this.results.get(i));
            }
            this.jbInit();
            this.onLoad();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public PermItemMultiPromptDialog(Dialog dialog) {
        super(dialog, true);
        try {
            this.jbInit();
            this.onLoad();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(EASResource.getString((String)RESOURCE, (String)"permName"));
        this.sourceTreeView = new KDTreeView();
        this.targetTreeView = new KDTreeView();
        this.separator = new KDSeparator();
        this.sourceTree = new KDTree();
        this.targetTree = new KDTree();
        this.btnAddAll = new KDWorkButton();
        this.btnAdd = new KDWorkButton();
        this.btnDelete = new KDWorkButton();
        this.btnDeleteAll = new KDWorkButton();
        this.btnConfirm = new KDButton(EASResource.getString((String)RESOURCE, (String)"confirm"));
        this.btnCancel = new KDButton(EASResource.getString((String)RESOURCE, (String)"cancel"));
        this.addListener2Buttons();
        this.sourceTreeView.setShowButton(true);
        this.sourceTreeView.setShowControlPanel(true);
        this.targetTreeView.setShowButton(true);
        this.targetTreeView.setShowControlPanel(true);
        this.setSize(new Dimension(800, 520));
        this.getContentPane().setLayout(null);
        this.sourceTreeView.setBounds(new Rectangle(10, 15, 360, 410));
        this.getContentPane().add((Component)this.sourceTreeView, null);
        this.targetTreeView.setBounds(new Rectangle(410, 15, 360, 410));
        this.getContentPane().add((Component)this.targetTreeView, null);
        this.setLocationRelativeTo(null);
        this.getContentPane().requestFocusInWindow();
        this.separator.setBounds(new Rectangle(0, 435, 800, 2));
        this.getContentPane().add((Component)this.separator, null);
        this.btnConfirm.setBounds(new Rectangle(410, 450, 73, 21));
        this.getContentPane().add((Component)this.btnConfirm, null);
        this.btnCancel.setBounds(new Rectangle(600, 450, 73, 21));
        this.getContentPane().add((Component)this.btnCancel, null);
        this.btnAddAll.setBounds(new Rectangle(375, 136, 30, 19));
        this.btnAdd.setBounds(new Rectangle(375, 165, 30, 19));
        this.btnDelete.setBounds(new Rectangle(375, 188, 30, 19));
        this.btnDeleteAll.setBounds(new Rectangle(375, 217, 30, 19));
        this.add((Component)this.btnAddAll, new KDLayout.Constraints(375, 136, 30, 19, 416));
        this.add((Component)this.btnAdd, new KDLayout.Constraints(375, 165, 30, 19, 416));
        this.add((Component)this.btnDelete, new KDLayout.Constraints(375, 188, 30, 19, 416));
        this.add((Component)this.btnDeleteAll, new KDLayout.Constraints(375, 217, 30, 19, 416));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnDeleteAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.sourceTreeView.setTree(this.sourceTree);
        this.targetTreeView.setTree(this.targetTree);
        UIUtil.addStandardPopupMenu(this.sourceTree);
        UIUtil.addStandardPopupMenu(this.targetTree);
    }

    private void addListener2Buttons() {
        this.btnAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PermItemMultiPromptDialog.this.btnAddAll_onclick(e);
                }
                catch (BOSException ex) {
                    ex.printStackTrace();
                    logger.error((Object)("\u6dfb\u52a0\u5168\u90e8\u6743\u9650\u5f02\u5e38" + ex.getMessage()));
                }
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermItemMultiPromptDialog.this.btnAdd_onclick(e);
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermItemMultiPromptDialog.this.btnDelete_onclick(e);
            }
        });
        this.btnDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermItemMultiPromptDialog.this.btnDeleteAll_onclick(e);
            }
        });
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermItemMultiPromptDialog.this.btnConfirm_onclick(e);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermItemMultiPromptDialog.this.btnCancel_onclick(e);
            }
        });
    }

    private void btnAddAll_onclick(ActionEvent e) throws BOSException {
        this.clearTree(this.targetTree);
        IAuthenSchemePerm iAuthenSchemePerm = AuthenSchemePermFactory.getRemoteInstance();
        PermItemCollection permItemCol = iAuthenSchemePerm.getTargetAllChidPermCol(null);
        this.buildTopTree(this.targetTree, permItemCol);
        try {
            IPermItem iPermItem = PermItemFactory.getRemoteInstance();
            PermItemCollection allLeavePermCol = iPermItem.getAllLeaves();
            for (int i = 0; i < allLeavePermCol.size(); ++i) {
                PermItemInfo leavePerm = allLeavePermCol.get(i);
                this.exclusivePermItemSet.add(leavePerm);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"addTargetNode error");
        }
    }

    private void btnAdd_onclick(ActionEvent e) {
        TreePath selectionTreePath = this.sourceTree.getSelectionPath();
        if (selectionTreePath == null) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5de6\u6811\u7684\u8282\u70b9\uff01");
            return;
        }
        this.addTargetTreeNode(selectionTreePath);
        try {
            IPermItem iPermItem = PermItemFactory.getRemoteInstance();
            KDTreeNode lastNode = (KDTreeNode)selectionTreePath.getLastPathComponent();
            PermItemInfo permItemInfo = (PermItemInfo)lastNode.getUserObject();
            PermItemCollection allLeavePermCol = iPermItem.getAllLeavePermsWithParent(permItemInfo);
            for (int i = 0; i < allLeavePermCol.size(); ++i) {
                PermItemInfo leavePerm = allLeavePermCol.get(i);
                this.exclusivePermItemSet.add(leavePerm);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"addTargetNode error");
        }
        this.updateTree(this.targetTree);
    }

    private void btnDelete_onclick(ActionEvent e) {
        TreePath selectionTreePath = this.targetTree.getSelectionPath();
        if (selectionTreePath == null) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u53f3\u6811\u7684\u8282\u70b9\uff01");
            return;
        }
        KDTreeNode node = (KDTreeNode)selectionTreePath.getLastPathComponent();
        if (node.isRoot()) {
            this.clearTree(this.targetTree);
        } else {
            node.removeFromParent();
        }
        PermItemInfo permItemInfo = (PermItemInfo)node.getUserObject();
        try {
            IPermItem iPermItem = PermItemFactory.getRemoteInstance();
            PermItemCollection allLeavePermCol = iPermItem.getAllLeavePermsWithParent(permItemInfo);
            for (int i = 0; i < allLeavePermCol.size(); ++i) {
                PermItemInfo leavePerm = allLeavePermCol.get(i);
                this.exclusivePermItemSet.remove(leavePerm);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"addTargetNode error");
        }
        this.updateTree(this.targetTree);
    }

    private void btnDeleteAll_onclick(ActionEvent e) {
        this.clearTree(this.targetTree);
        this.exclusivePermItemSet.clear();
    }

    public void onLoad() throws Exception {
        this.prepareButton();
        this.prepareTree();
    }

    private void prepareButton() {
        this.btnAdd.setEnabled(true);
        this.btnAddAll.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnDeleteAll.setEnabled(true);
    }

    private void prepareTree() throws Exception {
        this.prepareSourceTree();
        this.prepareTargetTree();
        this.clearTree(this.sourceTree);
        this.clearTree(this.targetTree);
        this.buildSourceTopTree();
        this.buildTargetTopTree();
    }

    protected void btnCancel_onclick(ActionEvent e) {
        this.isCancel = true;
        this.dispose();
    }

    protected void btnConfirm_onclick(ActionEvent e) {
        KDTree targetTree = this.getTargetTree();
        Object object = targetTree.getModel().getRoot();
        if (object == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"functionIsNotSelected"));
        } else {
            this.getAllChildrenNodePermItem();
            this.isCancel = false;
            this.dispose();
        }
    }

    private KDTree getTargetTree() {
        return this.targetTree;
    }

    private KDTree getSourceTree() {
        return this.sourceTree;
    }

    private void getAllChildrenNodePermItem() {
        for (PermItemInfo permItemInfo : this.exclusivePermItemSet) {
            this.results.add(permItemInfo);
        }
    }

    public void setInputData(HashMap params) throws Exception {
    }

    private void refresh() throws Exception {
        this.buildTree();
    }

    private void buildTree() throws Exception {
        this.prepareSourceTree();
        this.prepareTargetTree();
        this.clearTree(this.sourceTree);
        this.clearTree(this.targetTree);
        this.buildSourceTopTree();
        this.buildTargetTopTree();
    }

    private void prepareTargetTree() {
        this.targetTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode clickTreeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (clickTreeNode == null) {
                    return;
                }
                PermItemInfo permItemInfo = (PermItemInfo)clickTreeNode.getUserObject();
                if (permItemInfo == null) {
                    clickTreeNode.removeAllChildren();
                    return;
                }
                boolean expanded = PermItemMultiPromptDialog.this.getExtendedProperty(permItemInfo, PermItemMultiPromptDialog.EXPANDED_KEY);
                if (expanded) {
                    return;
                }
                try {
                    PermItemMultiPromptDialog.this.buildTargetLevelTree(clickTreeNode);
                    PermItemMultiPromptDialog.this.setExtendedProperty(permItemInfo, PermItemMultiPromptDialog.EXPANDED_KEY, Boolean.TRUE.toString());
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)PermItemMultiPromptDialog.this), (String)"\u6784\u5efa\u6811\u5931\u8d25--buildTargetLevelTree", (String)ThrowableHelper.toString((Exception)e), (int)0);
                    SysUtil.abort();
                }
            }
        });
    }

    private void prepareSourceTree() {
        this.sourceTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode clickTreeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (clickTreeNode == null) {
                    return;
                }
                if (clickTreeNode.getChildCount() > 0) {
                    return;
                }
                try {
                    PermItemMultiPromptDialog.this.buildSourceLevelTree(clickTreeNode);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    MsgBox.showDetailAndOK((Component)((Object)PermItemMultiPromptDialog.this), (String)"\u6784\u5efa\u6811\u5931\u8d25--buildSourceLevelTree", (String)ThrowableHelper.toString((Exception)e), (int)0);
                    SysUtil.abort();
                }
            }
        });
    }

    public void show() {
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.show();
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public Object getData() {
        return this.results;
    }

    private void clearTree(KDTree tree) {
        ((DefaultTreeModel)tree.getModel()).setRoot(null);
    }

    private void buildTopTree(KDTree tree, PermItemCollection permItemCol) {
        Iterator topPermItemIter = permItemCol.iterator();
        PermItemInfo permItemInfo = null;
        KDTreeNode node = null;
        KDTreeNode root = null;
        HashMap<String, KDTreeNode> allPermItem = new HashMap<String, KDTreeNode>();
        while (topPermItemIter.hasNext()) {
            permItemInfo = (PermItemInfo)topPermItemIter.next();
            if (permItemInfo.getParent() == null) {
                if (root != null) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)("\u6811\u7684\u6839\u8282\u70b9\u5e94\u8be5\u53ea\u6709\u4e00\u4e2a : " + tree), (String)ThrowableHelper.toString((Exception)((Object)new BOSException("\u6811\u7684\u6839\u8282\u70b9\u5e94\u8be5\u53ea\u6709\u4e00\u4e2a : " + tree))), (int)0);
                    SysUtil.abort();
                }
                root = new KDTreeNode((Object)permItemInfo);
                root.setText(permItemInfo.getAlias());
                allPermItem.put(permItemInfo.getId().toString(), root);
                continue;
            }
            node = new KDTreeNode((Object)permItemInfo);
            node.setText(permItemInfo.getAlias());
            allPermItem.put(permItemInfo.getId().toString(), node);
        }
        this.buildTopTree(tree, allPermItem, root);
    }

    private void buildTopTree(KDTree tree, Map<String, KDTreeNode> allPermItem, KDTreeNode root) {
        KDTreeNode node = null;
        KDTreeNode parentNode = null;
        PermItemInfo permItemInfo = null;
        PermItemInfo parentPermItemInfo = null;
        for (String key : allPermItem.keySet()) {
            node = allPermItem.get(key);
            permItemInfo = (PermItemInfo)node.getUserObject();
            parentPermItemInfo = permItemInfo.getParent();
            if (parentPermItemInfo == null) continue;
            parentNode = allPermItem.get(parentPermItemInfo.getId().toString());
            parentNode.add((MutableTreeNode)node);
        }
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object obj) {
                if (!KDTreeNode.class.isInstance(obj)) {
                    return super.isLeaf(obj);
                }
                Object userObj = ((KDTreeNode)obj).getUserObject();
                if (!PermItemInfo.class.isInstance(userObj)) {
                    return super.isLeaf(obj);
                }
                return ((PermItemInfo)userObj).isIsLeaf();
            }
        });
    }

    private boolean getExtendedProperty(PermItemInfo permItemInfo, String key) {
        return Boolean.parseBoolean(permItemInfo.getExtendedProperty(key));
    }

    private void setExtendedProperty(PermItemInfo permItemInfo, String key, String value) {
        permItemInfo.setExtendedProperty(key, value);
    }

    private void updateTree(KDTree tree) {
        tree.updateUI();
    }

    private void buildSourceTopTree() throws Exception {
        try {
            IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
            PermItemCollection permItemCol = iuopFacade.getTopSourcePermitems();
            this.buildTopTree(this.sourceTree, permItemCol);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private void buildSourceLevelTree(KDTreeNode clickTreeNode) throws BOSException, EASBizException {
        PermItemInfo clickPermItem = (PermItemInfo)clickTreeNode.getUserObject();
        if (clickPermItem == null) {
            return;
        }
        IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
        PermItemCollection permItemCol = iuopFacade.getlevelPermitemsByParent(clickPermItem.getId().toString());
        this.buildSourceLevelTree(clickTreeNode, permItemCol);
    }

    private void buildSourceLevelTree(KDTreeNode parent, PermItemCollection permItemCol) {
        Iterator permItemIter = permItemCol.iterator();
        KDTreeNode node = null;
        PermItemInfo permItem = null;
        while (permItemIter.hasNext()) {
            permItem = (PermItemInfo)permItemIter.next();
            node = new KDTreeNode((Object)permItem);
            node.setText(permItem.getAlias());
            parent.add((MutableTreeNode)node);
        }
    }

    protected void buildTargetTopTree() {
        try {
            IPermItem iPermItem = PermItemFactory.getRemoteInstance();
            PermItemCollection allParentPermWithLeaves = iPermItem.getAllParentPermWithLeaves(this.results);
            this.buildTopTree(this.targetTree, allParentPermWithLeaves);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildTargetLevelTree(KDTreeNode parent) throws Exception {
        PermItemInfo parentPermItemInfo = (PermItemInfo)parent.getUserObject();
        boolean needAll = this.getExtendedProperty(parentPermItemInfo, NEED_ALL_KEY);
        PermItemCollection childPermItemCol = null;
        if (needAll) {
            childPermItemCol = AuthenSchemePermFactory.getRemoteInstance().getTargetAllChidPermCol(parentPermItemInfo);
        }
        if (childPermItemCol == null || childPermItemCol.isEmpty()) {
            return;
        }
        Iterator childPermItemIter = childPermItemCol.iterator();
        PermItemInfo childPermItemInfo = null;
        KDTreeNode childNode = null;
        while (childPermItemIter.hasNext()) {
            childPermItemInfo = (PermItemInfo)childPermItemIter.next();
            childNode = new KDTreeNode((Object)childPermItemInfo);
            childNode.setText(childPermItemInfo.getAlias());
            parent.add((MutableTreeNode)childNode);
        }
    }

    private void addTargetTreeNode(TreePath selectionTreePath) {
        List<Object> allTreeList = Arrays.asList(selectionTreePath.getPath());
        Iterator<Object> allTreeIter = allTreeList.iterator();
        KDTreeNode root = (KDTreeNode)this.targetTree.getModel().getRoot();
        KDTreeNode nextSelectedNode = (KDTreeNode)allTreeIter.next();
        if (root == null) {
            root = this.findTargetTreeChildNode(null, nextSelectedNode);
            this.targetTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

                @Override
                public boolean isLeaf(Object obj) {
                    if (!KDTreeNode.class.isInstance(obj)) {
                        return super.isLeaf(obj);
                    }
                    Object userObj = ((KDTreeNode)obj).getUserObject();
                    if (!PermItemInfo.class.isInstance(userObj)) {
                        return super.isLeaf(obj);
                    }
                    return ((PermItemInfo)userObj).isIsLeaf();
                }
            });
        }
        KDTreeNode targetTreeNode = root;
        while (allTreeIter.hasNext()) {
            this.expandTargetTreeNode(targetTreeNode);
            nextSelectedNode = (KDTreeNode)allTreeIter.next();
            targetTreeNode = this.findTargetTreeChildNode(targetTreeNode, nextSelectedNode);
        }
        PermItemInfo targetTreePermItemInfo = (PermItemInfo)targetTreeNode.getUserObject();
        this.setExtendedProperty(targetTreePermItemInfo, NEED_ALL_KEY, Boolean.TRUE.toString());
        this.expandTargetTreeNode(targetTreeNode);
    }

    private void expandTargetTreeNode(KDTreeNode needExpandTreeNode) {
        boolean needExpand;
        PermItemInfo needExpandTreePermItemInfo;
        PermItemInfo permItemInfo = needExpandTreePermItemInfo = needExpandTreeNode == null ? null : (PermItemInfo)needExpandTreeNode.getUserObject();
        boolean bl = needExpandTreePermItemInfo == null ? false : (needExpand = !this.getExtendedProperty(needExpandTreePermItemInfo, EXPANDED_KEY));
        if (needExpand) {
            this.targetTree.expandPath(new TreePath(needExpandTreeNode.getPath()));
        }
    }

    private KDTreeNode findTargetTreeChildNode(KDTreeNode parentNode, KDTreeNode needFindNode) {
        KDTreeNode findedNode = null;
        PermItemInfo needFindPermItemInfo = (PermItemInfo)needFindNode.getUserObject();
        String needFindPermItemId = needFindPermItemInfo.getId().toString();
        if (parentNode == null) {
            return this.copyTreeNode(needFindNode);
        }
        Enumeration childrenEnumera = parentNode.children();
        KDTreeNode childNode = null;
        PermItemInfo childPermItemInfo = null;
        String childPermItemId = null;
        while (childrenEnumera.hasMoreElements()) {
            childNode = (KDTreeNode)childrenEnumera.nextElement();
            childPermItemInfo = (PermItemInfo)childNode.getUserObject();
            childPermItemId = childPermItemInfo.getId().toString();
            if (!needFindPermItemId.equals(childPermItemId)) continue;
            return childNode;
        }
        findedNode = this.copyTreeNode(needFindNode);
        parentNode.add((MutableTreeNode)findedNode);
        return findedNode;
    }

    private KDTreeNode copyTreeNode(KDTreeNode node) {
        PermItemInfo permItemInfo = (PermItemInfo)node.getUserObject();
        permItemInfo = (PermItemInfo)permItemInfo.clone();
        permItemInfo.removeExtendedProperty(NEED_ALL_KEY);
        permItemInfo.removeExtendedProperty(EXPANDED_KEY);
        KDTreeNode newTreeNode = new KDTreeNode((Object)permItemInfo);
        newTreeNode.setText(permItemInfo.getAlias());
        return newTreeNode;
    }
}

