/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldAccessCollection;
import com.kingdee.eas.base.permission.FieldAccessFactory;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.GrantRoleFieldFactory;
import com.kingdee.eas.base.permission.IFieldAccess;
import com.kingdee.eas.base.permission.client.AbstractRoleFieldAccessAccreditUI;
import com.kingdee.eas.base.permission.client.util.FieldAccessUtil;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class RoleFieldAccessViewUI
extends AbstractRoleFieldAccessAccreditUI {
    private static final int FIELD_NAME_INDEX = 0;
    private static final int VIEWABLE_INDEX = 1;
    private static final int EDITABLE_INDEX = 2;
    private static final String GRANTABLE = "grantable";
    public static final String TARGET_ROLE_PK = "rolePK";
    private Map loadedData = null;
    private BOSObjectType currentBOSObjectType = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws EASBizException, BOSException {
        this.buildTree();
        this.btnClearAll.setVisible(false);
        this.btnSelectAll.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.setUITitle(EASResource.getString((String)RESOURCE, (String)"RoleFieldPermView"));
    }

    private void buildTree() {
        DefaultKingdeeTreeNode root = this.createNode();
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.tree.setModel((TreeModel)model);
        UIUtil.addStandardPopupMenu(this.tree);
    }

    private DefaultKingdeeTreeNode createNode() {
        return SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_fieldpermission")));
    }

    private IObjectPK getTargetRolePK() {
        if (this.getUIContext().get(TARGET_ROLE_PK) != null) {
            return (IObjectPK)this.getUIContext().get(TARGET_ROLE_PK);
        }
        return null;
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        this.refreshList();
    }

    private void setCurrentEntityType() {
        MetaDataBriefInfo mdbInfo;
        DefaultKingdeeTreeNode node;
        Object userObject;
        Object object = this.tree.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && (userObject = (node = (DefaultKingdeeTreeNode)object).getUserObject()) instanceof MetaDataBriefInfo && (mdbInfo = (MetaDataBriefInfo)userObject).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            this.currentBOSObjectType = mdbInfo.getBOType();
            return;
        }
        this.currentBOSObjectType = null;
    }

    private void refreshList() throws Exception {
        this.setCurrentEntityType();
        if (this.currentBOSObjectType != null) {
            this.loadCurrentFieldAccess(this.currentBOSObjectType);
            this.loadRowData(this.currentBOSObjectType);
        } else {
            this.loadedData = null;
            this.tblMain.removeRows();
        }
    }

    private Map loadCurrentFieldAccess(BOSObjectType objectType) throws BOSException {
        this.loadedData = new HashMap();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjectType", (Object)objectType.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("role.id", (Object)this.getTargetRolePK().toString()));
        entityViewInfo.setFilter(filterInfo);
        IFieldAccess iFieldAccess = FieldAccessFactory.getRemoteInstance();
        FieldAccessCollection collection = iFieldAccess.getFieldAccessCollection(entityViewInfo);
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                FieldAccessInfo info = collection.get(i);
                this.loadedData.put(info.getFieldName(), info);
            }
        }
        return this.loadedData;
    }

    private void loadRowData(BOSObjectType objectType) throws Exception {
        this.tblMain.setRefresh(false);
        this.tblMain.removeRows();
        Set result = FieldAccessUtil.getFieldAccessStrategy(objectType, this.getCurrentCUPK());
        Set fieldInfos = FieldAccessUtil.getEntityFieldInfos(objectType);
        Set grantRoleFields = this.getGrantedRoleFields(objectType);
        for (String[] fieldInfo : fieldInfos) {
            if (!result.contains(fieldInfo[1])) continue;
            IRow row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)fieldInfo[0]);
            row.getCell(0).setUserObject((Object)fieldInfo[1]);
            if (this.loadedData.containsKey(fieldInfo[1])) {
                FieldAccessInfo info = (FieldAccessInfo)this.loadedData.get(fieldInfo[1]);
                row.getCell(1).setValue((Object)info.isViewable());
                row.getCell(2).setValue((Object)info.isEditable());
            } else {
                row.getCell(1).setValue((Object)Boolean.TRUE);
                row.getCell(2).setValue((Object)Boolean.TRUE);
            }
            if (grantRoleFields.contains(fieldInfo[1])) {
                row.getCell(GRANTABLE).setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell(GRANTABLE).setValue((Object)Boolean.FALSE);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private Set getGrantedRoleFields(BOSObjectType objectType) throws Exception {
        return GrantRoleFieldFactory.getRemoteInstance().getGrantedFields(this.getTargetRolePK(), objectType);
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(this.getCurrentCU().getId());
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        boolean flag = e.getValue() == null ? false : (Boolean)e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 1) {
            if (!flag) {
                this.tblMain.getRow(rowIndex).getCell(2).setValue((Object)Boolean.FALSE);
            }
        } else if (colIndex == 2 && flag) {
            this.tblMain.getRow(rowIndex).getCell(1).setValue((Object)Boolean.TRUE);
        }
    }
}

