/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.TreeView;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.base.permission.CustomSystemEnum;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.client.AbstractSyncTreeUI;
import com.kingdee.eas.base.permission.client.helper.PermMutexHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.menusync.IMenuSyncTreeUI;
import com.kingdee.eas.base.permission.client.menusync.NodeInfo;
import com.kingdee.eas.base.permission.client.menusync.SubSysTreeUtil;
import com.kingdee.eas.base.permission.client.menusync.TreeOperator;
import com.kingdee.eas.base.permission.client.menusync.uiimpl.AbstractSubSystemTreeUIImpl;
import com.kingdee.eas.base.permission.client.menusync.uiimpl.PermItemNodeImpl;
import com.kingdee.eas.base.permission.client.menusync.uiimpl.PermTreeUIImpl;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ISubSystemFacade;
import com.kingdee.eas.common.SubSystemEnum;
import com.kingdee.eas.common.SubSystemFacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class SyncTreeUI
extends AbstractSyncTreeUI {
    private static final Logger logger = CoreUIObject.getLogger(SyncTreeUI.class);
    private IMenuSyncTreeUI iMenuSyncTreeUI = null;
    private KDTree treePerm = new KDTree();
    private TreeView trviewPerm = new TreeView(this.treePerm);
    private boolean init_over = false;
    private int indexInt = 0;
    private int MAX_NODE_INDE = 0;
    PermMutexHelper mutexHelper = null;
    private Object lastObj = null;

    public void onLoad() throws Exception {
        this.init_over = false;
        super.onLoad();
        this.initTree();
        this.initCustomList();
        this.actionSave.setEnabled(true);
        this.actionSynAllTree.setVisible(false);
        this.inittreeOperator();
        this.init_over = true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    private void inittreeOperator() {
        TreeOperator treeOperator = new TreeOperator(this.trviewCustom, this.treeCustorm, new PermItemNodeImpl(), this);
        treeOperator.processTree();
    }

    private void initCustomList() {
        List customList = CustomSystemEnum.getEnumList();
        this.cmbSubSystem.addItem((Object)"");
        List subSystemList = SubSystemEnum.getEnumList();
        this.cmbSubSystem.addItems(customList.toArray());
        this.cmbSubSystem.addItems(subSystemList.toArray());
    }

    private void initTree() throws EASBizException, BOSException {
        MenuVisitorHelper.buildSimpleMenuTree((KDTree)this.treeMenu);
        ((DefaultTreeModel)this.treeCustorm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeStandard.getModel()).setRoot(null);
    }

    @Override
    protected void cmbSubSystem_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void cmbSubSystem_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.init_over) {
            return;
        }
        Object obj = e.getItem();
        if (StringUtils.cnulls((Object)this.lastObj).equals(StringUtils.cnulls((Object)obj))) {
            return;
        }
        if (obj != null) {
            if (this.isSltPerm()) {
                this.iMenuSyncTreeUI = new PermTreeUIImpl();
            } else if (obj instanceof SubSystemEnum) {
                this.iMenuSyncTreeUI = new AbstractSubSystemTreeUIImpl();
            }
            if (this.iMenuSyncTreeUI != null) {
                this.setSubTreeView4Wait();
            } else {
                ((DefaultTreeModel)this.getCustomTree(true).getModel()).setRoot(null);
                ((DefaultTreeModel)this.getCustomTree(false).getModel()).setRoot(null);
            }
        } else {
            ((DefaultTreeModel)this.getCustomTree(true).getModel()).setRoot(null);
            ((DefaultTreeModel)this.getCustomTree(false).getModel()).setRoot(null);
        }
        this.synTreeVisible(obj);
        this.lastObj = obj;
    }

    private void synTreeVisible(Object selectItem) {
        if (selectItem != null && selectItem.equals(SubSystemEnum.subsystem)) {
            this.actionSynAllTree.setVisible(true);
        } else {
            this.actionSynAllTree.setVisible(false);
        }
    }

    public IMenuSyncTreeUI getIMenuSyncTreeUI() {
        return this.iMenuSyncTreeUI;
    }

    private boolean isSltPerm() {
        Object obj = this.cmbSubSystem.getSelectedItem();
        return obj instanceof CustomSystemEnum && CustomSystemEnum.PermMenu == obj;
    }

    private void setSubTreeView4Wait() throws EASBizException, BOSException {
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                SyncTreeUI.this.setSubTreeView();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void setSubTreeView() throws EASBizException, BOSException {
        this.iMenuSyncTreeUI.setViewTree(this);
        DefaultKingdeeTreeNode customerRootNode = (DefaultKingdeeTreeNode)this.treeCustorm.getModel().getRoot();
        DefaultKingdeeTreeNode StandardRootNode = (DefaultKingdeeTreeNode)this.treeStandard.getModel().getRoot();
        this.iMenuSyncTreeUI.flagNewNode(customerRootNode, StandardRootNode);
        this.treeCustorm.repaint();
        this.treeStandard.repaint();
    }

    public KDTree getCustomTree(boolean isStandard) {
        if (isStandard) {
            return this.treeStandard;
        }
        return this.treeCustorm;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.mutexHelper = new PermMutexHelper();
        if (!this.mutexHelper.request()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"alreadyUsed"));
            this.abort();
        }
        try {
            Object obj = this.cmbSubSystem.getSelectedItem();
            if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)obj))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"pleaseSelectDataFirst"));
                return;
            }
            LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
            dialog.setLongTimeTask(new ILongTimeTask(){

                @Override
                public Object exec() throws Exception {
                    SyncTreeUI.this.saveAs();
                    return null;
                }

                @Override
                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (this.mutexHelper != null) {
                this.mutexHelper.release();
            }
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
    }

    private void saveAs() throws Exception {
        this.iMenuSyncTreeUI.save(this);
    }

    @Override
    protected void treeCustorm_mouseDragged(MouseEvent e) throws Exception {
        super.treeCustorm_mouseDragged(e);
    }

    @Override
    protected void treeCustorm_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeCustorm_valueChanged(e);
    }

    private DefaultKingdeeTreeNode getCurCustomerNode() {
        Object obj = this.treeCustorm.getLastSelectedPathComponent();
        if (obj == null || !(obj instanceof DefaultKingdeeTreeNode)) {
            return null;
        }
        return (DefaultKingdeeTreeNode)obj;
    }

    private DefaultKingdeeTreeNode getCurStandardNode() {
        Object obj = this.treeStandard.getLastSelectedPathComponent();
        if (obj == null || !(obj instanceof DefaultKingdeeTreeNode)) {
            return null;
        }
        return (DefaultKingdeeTreeNode)obj;
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.treeCustorm.getLastSelectedPathComponent();
        if (obj == null || !(obj instanceof DefaultKingdeeTreeNode) || ((DefaultKingdeeTreeNode)obj).getParent() == null) {
            return;
        }
        DefaultKingdeeTreeNode curNode = (DefaultKingdeeTreeNode)obj;
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)curNode.getParent();
        DefaultKingdeeTreeNode afterNode = (DefaultKingdeeTreeNode)parentNode.getChildAfter((TreeNode)curNode);
        if (afterNode == null) {
            return;
        }
        int size = parentNode.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode itTreeNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (!itTreeNode.equals(curNode)) continue;
            this.treeCustorm.removeNodeFromParent((MutableTreeNode)curNode);
            this.treeCustorm.insertNodeInto((MutableTreeNode)curNode, (MutableTreeNode)parentNode, i + 1);
            break;
        }
        this.trviewCustom.getTree().setSelectionNode(curNode);
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.treeCustorm.getLastSelectedPathComponent();
        if (obj == null || !(obj instanceof DefaultKingdeeTreeNode) || ((DefaultKingdeeTreeNode)obj).getParent() == null) {
            return;
        }
        DefaultKingdeeTreeNode curNode = (DefaultKingdeeTreeNode)obj;
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)curNode.getParent();
        DefaultKingdeeTreeNode beforeNode = (DefaultKingdeeTreeNode)parentNode.getChildBefore((TreeNode)curNode);
        int size = parentNode.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode itTreeNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (!itTreeNode.equals(beforeNode)) continue;
            this.treeCustorm.removeNodeFromParent((MutableTreeNode)curNode);
            this.treeCustorm.insertNodeInto((MutableTreeNode)curNode, (MutableTreeNode)parentNode, i);
            break;
        }
        this.treeCustorm.setSelectionNode(curNode);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode curNode = this.getCurCustomerNode();
        if (curNode == null) {
            return;
        }
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)curNode.getParent();
        if (parentNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_98"));
            return;
        }
        if (this.iMenuSyncTreeUI.mayDelNode(curNode)) {
            this.treeCustorm.removeNodeFromParent((MutableTreeNode)curNode);
            this.treeCustorm.setSelectionNode(parentNode);
            this.treeCustorm_mouseClicked(null);
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode customerNode = this.getCurCustomerNode();
        if (customerNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"sltNodeInRight"));
            return;
        }
        String newNodePromptStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"newNodePrompt"), this.MAX_NODE_INDE);
        String parentName = "";
        Object obj = customerNode.getUserObject();
        if (obj instanceof MetaDataBriefInfo) {
            MetaDataBriefInfo mdbInfo = (MetaDataBriefInfo)obj;
            parentName = mdbInfo.getPackgeName();
        }
        if (this.getCurCustomerNode() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"pleaseSelectDataFirst"));
            return;
        }
        DefaultKingdeeTreeNode curNode = new DefaultKingdeeTreeNode((Object)newNodePromptStr);
        curNode.setText(newNodePromptStr);
        curNode.setUserObject(this.iMenuSyncTreeUI.getNodeUserObject(this.MAX_NODE_INDE, parentName));
        ++this.MAX_NODE_INDE;
        this.treeCustorm.addNodeInto((MutableTreeNode)curNode, (MutableTreeNode)this.getCurCustomerNode());
        this.treeCustorm.fireTreeExpanded(this.treeCustorm.getSelectionPath());
        this.treeCustorm.setSelectionNode(curNode);
        this.treeCustorm_mouseClicked(null);
    }

    @Override
    public void actionModi_actionPerformed(ActionEvent e) throws Exception {
        if (this.mutiNodeName.getSelectedItemData() == null) {
            return;
        }
        DefaultKingdeeTreeNode curNode = this.getCurCustomerNode();
        if (curNode == null) {
            return;
        }
        this.iMenuSyncTreeUI.modiNode(curNode, this.mutiNodeName);
        ((KingdeeTreeUI)this.trviewCustom.getTree().getUI()).resetSize();
    }

    @Override
    protected void treeCustorm_mouseClicked(MouseEvent e) throws Exception {
        Object obj = this.treeCustorm.getLastSelectedPathComponent();
        if (obj == null || !(obj instanceof DefaultKingdeeTreeNode) || ((DefaultKingdeeTreeNode)obj).getParent() == null) {
            return;
        }
        DefaultKingdeeTreeNode curNode = (DefaultKingdeeTreeNode)obj;
        NodeInfo nodeInfo = this.iMenuSyncTreeUI.getNameByNode(curNode);
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.mutiNodeName, (IObjectValue)nodeInfo, (String)"name");
    }

    @Override
    public void actionDeleteCustom_actionPerformed(ActionEvent e) throws Exception {
        if (!MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"restoreCurTree")))) {
            return;
        }
        if (this.curIsPermTree()) {
            IPermItem iPermItem = PermItemFactory.getRemoteInstance();
            iPermItem.deleteCustomPerm();
        } else if (!StringUtils.isEmpty((String)this.getCurSystem())) {
            String curSubSystem = this.getCurSystem();
            ISubSystemFacade subSystemFacade = SubSystemFacadeFactory.getRemoteInstance();
            subSystemFacade.delSubSystemFileByName(curSubSystem);
        }
        this.cmbSubSystem.setSelectedIndex(0);
        ((DefaultTreeModel)this.getCustomTree(false).getModel()).setRoot(null);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"restoreSuccessed"));
        this.flash();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnDeleteCurTree.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDeleteAllTree.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemDelCurTree.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuItemDelAllTree.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.actionLeftToRight.setEnabled(true);
        this.actionAllNewToRight.setEnabled(true);
        this.actionCompare.setEnabled(true);
        this.actionLeftPosition.setEnabled(true);
        this.actionRightPosition.setEnabled(true);
        Icon icon_Moveright = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnLeftToRight.setIcon(icon_Moveright);
        this.btnLeftToRight.setText("");
        Icon icon_MoveAllRight = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAllToRight.setIcon(icon_MoveAllRight);
        this.btnAllToRight.setText("");
        Icon icon_DownView = EASResource.getIcon((String)"imgTbtn_downview");
        this.btnLeftPosition.setIcon(icon_DownView);
        this.btnLeftPosition.setText("");
        Icon icon_TopView = EASResource.getIcon((String)"imgTbtn_topview");
        this.btnRightPosition.setIcon(icon_TopView);
        this.btnRightPosition.setText("");
        Icon icon_Sync = EASResource.getIcon((String)"imgTbtn_treesynchronizate");
        this.btnSynAllTree.setIcon(icon_Sync);
        this.menuItemSynAllTree.setIcon(icon_Sync);
    }

    @Override
    public void actionDelSubSystem_actionPerformed(ActionEvent e) throws Exception {
        if (!MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"restoreAllTree")))) {
            return;
        }
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        iPermItem.deleteCustomPerm();
        ISubSystemFacade subSystemFacade = SubSystemFacadeFactory.getRemoteInstance();
        subSystemFacade.delAllSubSystemFile();
        this.cmbSubSystem.setSelectedIndex(0);
        ((DefaultTreeModel)this.getCustomTree(false).getModel()).setRoot(null);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"restoreSuccessed"));
        this.flash();
    }

    @Override
    public void actionLeftToRight_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode standardNode = this.getCurStandardNode();
        DefaultKingdeeTreeNode customerNode = this.getCurCustomerNode();
        if (standardNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"sltNodeInLeft"));
            return;
        }
        if (customerNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"sltNodeInRight"));
            return;
        }
        if (this.iMenuSyncTreeUI.existNode(standardNode, (DefaultKingdeeTreeNode)this.treeCustorm.getModel().getRoot()) || this.iMenuSyncTreeUI.existNode(standardNode, customerNode)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"isExist"));
            return;
        }
        if (this.isSltPerm() && customerNode.getUserObject() instanceof PermissionItemInfo) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"forbidMoveToRightLeaf"));
            return;
        }
        this.addNodeInto(standardNode, customerNode);
        this.flash();
    }

    private void addNodeInto(DefaultKingdeeTreeNode anewChildeNode, DefaultKingdeeTreeNode parentNode) {
        this.iMenuSyncTreeUI.moveNode(this.treeCustorm, anewChildeNode, parentNode, true);
    }

    @Override
    public void actionAllNewToRight_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode StandardRootNode = (DefaultKingdeeTreeNode)this.treeStandard.getModel().getRoot();
        DefaultKingdeeTreeNode customerRootNode = (DefaultKingdeeTreeNode)this.treeCustorm.getModel().getRoot();
        if (StandardRootNode != null && customerRootNode != null) {
            this.iMenuSyncTreeUI.moveAllNewNode(this.treeCustorm, StandardRootNode, customerRootNode);
        }
        this.flash();
    }

    private void flash() {
        DefaultKingdeeTreeNode StandardRootNode = (DefaultKingdeeTreeNode)this.treeStandard.getModel().getRoot();
        DefaultKingdeeTreeNode customerRootNode = (DefaultKingdeeTreeNode)this.treeCustorm.getModel().getRoot();
        if (StandardRootNode != null && customerRootNode != null) {
            this.iMenuSyncTreeUI.flagNewNode(customerRootNode, StandardRootNode);
            this.treeCustorm.repaint();
            this.treeStandard.repaint();
        }
    }

    @Override
    public void actionCompare_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode customerRootNode = (DefaultKingdeeTreeNode)this.treeCustorm.getModel().getRoot();
        DefaultKingdeeTreeNode StandardRootNode = (DefaultKingdeeTreeNode)this.treeStandard.getModel().getRoot();
        this.iMenuSyncTreeUI.flagNewNode(customerRootNode, StandardRootNode);
    }

    @Override
    public void actionLeftPosition_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode leftNode = this.getCurStandardNode();
        if (leftNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"sltNodeInLeft"));
            this.abort();
        }
        NodeInfo info = this.iMenuSyncTreeUI.getNameByNode(leftNode);
        String name = info.getKey();
        String fullName = info.getFullName();
        DefaultKingdeeTreeNode node = this.iMenuSyncTreeUI.getNodeByName((DefaultKingdeeTreeNode)this.treeCustorm.getModel().getRoot(), name, fullName);
        this.treeCustorm.setSelectionNode(node);
        this.treeCustorm.fireTreeExpanded(this.treeCustorm.getSelectionPath());
        this.treeCustorm.scrollPathToVisible(this.treeCustorm.getSelectionPath());
        this.treeCustorm.repaint();
    }

    @Override
    public void actionRightPosition_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode rightNode = this.getCurCustomerNode();
        if (rightNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"sltNodeInRight"));
            this.abort();
        }
        NodeInfo info = this.iMenuSyncTreeUI.getNameByNode(rightNode);
        String name = info.getKey();
        String fullName = info.getFullName();
        DefaultKingdeeTreeNode node = this.iMenuSyncTreeUI.getNodeByName((DefaultKingdeeTreeNode)this.treeStandard.getModel().getRoot(), name, fullName);
        this.treeStandard.setSelectionNode(node);
        this.treeStandard.fireTreeExpanded(this.treeStandard.getSelectionPath());
        this.treeStandard.scrollPathToVisible(this.treeStandard.getSelectionPath());
    }

    public String getCurSystem() {
        Object obj = this.cmbSubSystem.getSelectedItem();
        if (obj instanceof SubSystemEnum) {
            return ((SubSystemEnum)obj).getValue();
        }
        return "";
    }

    public boolean curIsPermTree() {
        Object obj = this.cmbSubSystem.getSelectedItem();
        return obj instanceof CustomSystemEnum;
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    @Override
    public void actionSynAllTree_actionPerformed(ActionEvent e) throws Exception {
        if (this.isConfirmSynAllTree()) {
            this.synAllTree();
        }
    }

    public static boolean removeNode(DefaultKingdeeTreeNode allTreeNode) {
        for (int i = 0; i < allTreeNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)allTreeNode.getChildAt(i);
            if (!SyncTreeUI.removeNode(node)) continue;
            --i;
        }
        if (allTreeNode.getText().indexOf("a") >= 0 && allTreeNode.getParent() != null) {
            allTreeNode.removeFromParent();
            return true;
        }
        return false;
    }

    private boolean isConfirmSynAllTree() {
        return MsgBox.showConfirm2((Component)((Object)this), (String)(PermissionResUtil.getResource("res_99") + "\uff08" + PermissionResUtil.getResource("res_100") + "\uff09" + PermissionResUtil.getResource("res_101"))) == 0;
    }

    private void synAllTree() throws Exception {
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                SubSysTreeUtil.syncOtherTreeByAllTree();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                SyncTreeUI.this.showInfo(result);
            }
        });
        dialog.show();
    }

    private void showInfo(Object result) {
        if (result.equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_102"));
        }
    }
}

