/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.client.AbstractUserOrgRangeViewListUI;
import com.kingdee.eas.base.permission.client.NewUserPermViewUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class UserOrgRangeViewListUI
extends AbstractUserOrgRangeViewListUI {
    private static final Logger logger = CoreUIObject.getLogger(UserOrgRangeViewListUI.class);
    private static final String permissionResource = "com.kingdee.eas.base.permission.PermissionResource";
    private boolean defOrgType_bizOrg = true;
    private static int USER_ID_INDEX = 12;
    private static String USER_ID_NAME = "user.id";
    private static String ORG_ID_NAME = "org.id";
    private static int ORG_ID_INDEX = 11;

    protected String getEditUIName() {
        return null;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("CurrentUser", (Object)ToolUtils.getCurrentUser().getId().toString());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtn();
        String[] mergeColumnKeys = new String[]{"user.number", "user.name", "CU.name"};
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
        this.setQueryFilter(true);
        new KDTSortManager(this.tblMain).sort(1);
    }

    private void initBtn() {
        KDMenuItem menuItemViewAdminOrg = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"viewAdminOrg"));
        menuItemViewAdminOrg.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAdminOrgView), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        menuItemViewAdminOrg.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnBizOrgRangeView.addAssistMenuItem((JMenuItem)menuItemViewAdminOrg);
        KDMenuItem menuItemViewBizOrg = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"viewBizOrg"));
        menuItemViewBizOrg.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionBizOrgRangeView), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        menuItemViewBizOrg.setIcon(EASResource.getIcon((String)"imgTbtn_cycattemper"));
        this.btnBizOrgRangeView.addAssistMenuItem((JMenuItem)menuItemViewBizOrg);
        this.btnBizOrgRangeView.setIcon(EASResource.getIcon((String)"imgTbtn_cycattemper"));
        this.btnOrgRangeBatchDeal.setVisible(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgRangeFactory.getRemoteInstance();
    }

    private void checkSystemUser() throws Exception {
        if (Administrator.isCUAdmin(null, (IObjectPK)new ObjectUuidPK(this.getTargetUserId()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"adminCanNotViewPerm"));
            this.abort();
        }
    }

    private String getTargetUserId() {
        return this.getUserIdFromTable(this.getUserIdIndexOfTable());
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String idStr;
        if (!this.defOrgType_bizOrg) {
            return;
        }
        this.checkSelected();
        this.checkSystemUser();
        String targetUserId = this.getUserIdFromTable(this.getUserIdIndexOfTable());
        if (StringUtils.isEmpty((String)targetUserId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"userIsNotSelected"));
            this.abort();
        }
        if (Administrator.isCUAdmin(null, (IObjectPK)new ObjectStringPK(targetUserId))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)permissionResource, (String)"adminCanNotViewPerm"));
            this.abort();
        }
        if (StringUtils.isEmpty((String)(idStr = this.getUserIdFromTable(this.getOrgIdIndexOfTable())))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUIResource", (String)"userNotOrgRange"));
            this.abort();
        }
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        dialog.setLongTimeTask(new ILongTimeTask(){

            @Override
            public Object exec() throws Exception {
                UIContext uiContext = new UIContext((Object)UserOrgRangeViewListUI.this);
                uiContext.put((Object)"targetID", (Object)UserOrgRangeViewListUI.this.getUserIdFromTable(UserOrgRangeViewListUI.this.getUserIdIndexOfTable()));
                String orgIdStr = UserOrgRangeViewListUI.this.getUserIdFromTable(UserOrgRangeViewListUI.this.getOrgIdIndexOfTable());
                logger.info((Object)("org id is :" + orgIdStr));
                uiContext.put((Object)"SELECT_ORG_ID", (Object)orgIdStr);
                return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NewUserPermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            }

            @Override
            public void afterExec(Object result) throws Exception {
                UITools.showObject(result);
            }
        });
        dialog.show();
    }

    private int getOrgIdIndexOfTable() {
        return this.tblMain.getColumn(ORG_ID_NAME).getColumnIndex();
    }

    private int getUserIdIndexOfTable() {
        return this.tblMain.getColumn(USER_ID_NAME).getColumnIndex();
    }

    private String getUserIdFromTable(int pos) {
        List userIdList = UITools.getUserIdList(this.tblMain, pos);
        if (userIdList != null && !userIdList.isEmpty()) {
            return (String)userIdList.get(0);
        }
        return "";
    }

    @Override
    public void actionAdminOrgView_actionPerformed(ActionEvent e) throws Exception {
        this.setQueryFilter(false);
        this.defOrgType_bizOrg = false;
        this.setViewPermState();
    }

    @Override
    public void actionBizOrgRangeView_actionPerformed(ActionEvent e) throws Exception {
        this.setQueryFilter(true);
        this.defOrgType_bizOrg = true;
        this.setViewPermState();
    }

    @Override
    public void actionOrgBatchAdd_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionOrgBatchDel_actionPerformed(ActionEvent e) throws Exception {
    }

    private void setQueryFilter(boolean isBizOrgView) throws EASBizException, BOSException {
        this.mainQuery.setFilter(this.getDefautFilter(isBizOrgView));
        this.mainQuery.getSorter().add(new SorterItemInfo("user.number"));
        this.tblMain.refresh();
    }

    private FilterInfo getDefautFilter(boolean isBizOrgView) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        int type = 10;
        if (isBizOrgView) {
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(10)));
        } else {
            type = 20;
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(20)));
        }
        FilterInfo orgRangeFilterInfo = null;
        try {
            orgRangeFilterInfo = new UserListUIHelper().getCurrentRangeUserWith3D(type);
            orgRangeFilterInfo.setMaskString(null);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (orgRangeFilterInfo != null) {
            filterInfo.mergeFilter(orgRangeFilterInfo, "AND");
        }
        return filterInfo;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.defOrgType_bizOrg || e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    private void setViewPermState() {
        this.btnView.setEnabled(this.defOrgType_bizOrg);
        this.actionView.setEnabled(this.defOrgType_bizOrg);
        this.btnView.setVisible(this.defOrgType_bizOrg);
        this.menuView.setVisible(this.defOrgType_bizOrg);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.setViewPermState();
    }

    public void refreshList() throws Exception {
        super.refreshList();
    }

    public void refreshListForOrder() throws Exception {
        super.refreshListForOrder();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            return this.getDefautFilter(this.defOrgType_bizOrg);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            super.handleException((Exception)((Object)e));
            return null;
        }
    }
}

