/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.SelectOrgInfo;
import com.kingdee.eas.base.permission.client.AbstractUserSelectOrgUI;
import com.kingdee.eas.base.permission.client.helper.UnionDateViewHelper;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class UserSelectOrgUI
extends AbstractUserSelectOrgUI {
    private static final Logger logger = CoreUIObject.getLogger(UserSelectOrgUI.class);
    private List selectOrgList = new ArrayList();
    private String targetUser = null;
    public static String CALL_TYPE_USER = "user";
    public static String CALL_TYPE_ROLE = "role";
    private SelectOrgInfo selectOrgInfo = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtn();
        this.targetUser = (String)this.getUIContext().get("targetUser");
        this.selectOrgList = (List)this.getUIContext().get("selectOrgList");
        this.selectOrgInfo = (SelectOrgInfo)this.getUIContext().get("selectOrgInfo");
        if (this.mainQuery != null) {
            this.mainQuery.setFilter(this.getDefaultFilteInfo());
        }
        this.execQuery();
        UIUtil.addFirstTableColInfo(this.tblMain);
        UnionDateViewHelper unionViewHelper = new UnionDateViewHelper(this.tblMain);
        unionViewHelper.addUnionDateView();
        UIUtil.setSelectStatus(this.tblMain, true, this.selectOrgList);
    }

    private void initBtn() {
        Icon SelectAllIcon = EASResource.getIcon((String)"imgTbtn_selectall");
        this.btnSelectAll.setText(null);
        this.btnSelectAll.setIcon(SelectAllIcon);
        Icon SelectNoneAllIcon = EASResource.getIcon((String)"imgTbtn_deleteall");
        this.btnSelectNone.setText(null);
        this.btnSelectNone.setIcon(SelectNoneAllIcon);
        this.btnSelectAll.setEnabled(true);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        List curSelectOrgList = UIUtil.getSelectOrgList(this.tblMain, true);
        if (curSelectOrgList.containsAll(this.selectOrgList) && this.selectOrgList.containsAll(curSelectOrgList)) {
            this.selectOrgList.clear();
            this.selectOrgList.addAll(curSelectOrgList);
            this.destroyWindow();
        } else if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"isConfirmQuit")) == 0) {
            this.destroyWindow();
        }
        this.selectOrgInfo.setSelectAllOrg(false);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        UIUtil.setSelectStatus(this.tblMain, true);
        this.selectOrgInfo.setSelectAllOrg(true);
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectNone_actionPerformed(e);
        UIUtil.setSelectStatus(this.tblMain, false);
    }

    protected void execQuery() {
        super.execQuery();
        int rowSize = this.tblMain.getRowCount();
        logger.info((Object)("rowSize is:" + rowSize));
        UIUtil.addFirstTableColInfo(this.tblMain);
    }

    private String getAllMaySelectOrg() {
        this.selectOrgInfo.setAllMaySelectOrg(this.getAccreditOrgIdStr());
        return this.selectOrgInfo.getAllMaySelectOrg();
    }

    private FilterInfo getDefaultFilteInfo() {
        FilterInfo myFilterInfo = new FilterInfo();
        myFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.getAllMaySelectOrg(), CompareType.INCLUDE));
        return myFilterInfo;
    }

    private String getAccreditOrgIdStr() {
        try {
            return UIUtil.getAccreditOrgIdStr((IObjectPK)new ObjectStringPK(this.targetUser));
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
        }
        return "";
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        List curSelectOrgList = UIUtil.getSelectOrgList(this.tblMain, true);
        this.selectOrgList.clear();
        this.selectOrgList.addAll(curSelectOrgList);
        this.destroyWindow();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int colInt = e.getColIndex();
        if (colInt == 0) {
            int rowInt = e.getRowIndex();
            IRow iRow = this.tblMain.getRow(rowInt);
            Boolean boolValue = (Boolean)iRow.getCell(0).getValue();
            iRow.getCell(0).setValue((Object)(boolValue == false ? 1 : 0));
        }
    }

    protected String getKeyFieldName() {
        return "orgId";
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

