/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIFunctionView {
    private Logger logger = Logger.getLogger((String)UIFunctionView.class.getName());
    public static final String UI_NAME_LIST = "UserListUI";
    public static final String UI_NAME_EDIT = "UserEditUI";
    public static final String FUNCTION_ASSIGN_ROLE = "FUNCTION_ASSIGN_ROLE";
    public static final String FUNCTION_EIDT_USER = "FUNCTION_EIDT_USER";
    public static final String FUNCTION_DELETE_USER = "FUNCTION_DELETE_USER";
    public static final String FUNCTION_SET_PWD = "FUNCTION_SET_PWD";
    public static final String FUNCTION_EIDT_ORG = "FUNCTION_EIDT_ORG";
    public static final String FUNCTION_EIDT_MANAGE_ORG = "FUNCTION_EIDT_MANAGE_ORG";
    public static final String FUNCTION_EIDT_BASEINFO = "FUNCTION_EIDT_BASEINFO";
    public static final String FUNCTION_JOB_TRANSFER = "FUNCTION_JOB_TRANSFER";
    public static final String USER_TYPE_NORMAL = "user";
    public static final String USER_TYPE_BIZADMIN = "bizadmin";
    public static final String USER_TYPE_ADMIN = "admin";
    public static final String USER_TYPE_SUPERADMIN = "superadmin";
    public static final String FILE_NAME = "uiview.xml";
    private static UIFunctionView instance = new UIFunctionView();
    Map uiInfoMap = new HashMap();
    Map directMap = new HashMap();

    private UIFunctionView() {
    }

    public static UIFunctionView getInstance() {
        if (instance == null) {
            instance = new UIFunctionView();
        }
        return instance;
    }

    public boolean hasPermission(UserInfo curUserInfo, UserInfo targetUserInfo, String uiName, String functionName) {
        if (FUNCTION_EIDT_BASEINFO.equals(functionName) && curUserInfo.getId().equals((Object)targetUserInfo.getId()) && targetUserInfo.getNumber().equalsIgnoreCase("administrator")) {
            return true;
        }
        Object obj = this.uiInfoMap.get(uiName);
        Map viewInfoMap = null;
        if (obj == null) {
            viewInfoMap = this.getMapByName(uiName);
            this.uiInfoMap.put(uiName, viewInfoMap);
        } else {
            viewInfoMap = (Map)obj;
        }
        if (viewInfoMap == null) {
            throw new IllegalArgumentException("uiName is error :" + uiName);
        }
        String key = this.formKey(curUserInfo, targetUserInfo, functionName);
        Object valueObj = viewInfoMap.get(key);
        if (valueObj == null || StringUtils.isEmpty((String)valueObj.toString())) {
            throw new IllegalArgumentException("key is not found! key is:" + key);
        }
        return Boolean.valueOf(valueObj.toString());
    }

    private String formKey(UserInfo curUserInfo, UserInfo targetUserInfo, String functionName) {
        StringBuffer sb = new StringBuffer("");
        sb.append(this.getUserType(curUserInfo)).append("-").append(this.getUserType(targetUserInfo)).append("-").append(this.isDirect(curUserInfo, targetUserInfo)).append("-").append(functionName);
        this.logger.debug((Object)("key is:" + sb.toString()));
        return sb.toString();
    }

    private boolean isDirect(UserInfo curUserInfo, UserInfo targetuserInfo) {
        Boolean ret = Boolean.FALSE;
        String key = curUserInfo.getId().toString() + "_" + targetuserInfo.getId().toString();
        if (this.directMap.get(key) != null) {
            ret = (Boolean)this.directMap.get(key);
            return ret;
        }
        UserType curUserType = curUserInfo.getType();
        UserType targetUserType = targetuserInfo.getType();
        if (Administrator.isCUAdminType(curUserType) && Administrator.isCUAdminType(targetUserType) || Administrator.isAuthenAdminType(curUserType) && Administrator.isAuthenAdminType(targetUserType) || Administrator.isAuditAdminType(curUserType) && Administrator.isAuditAdminType(targetUserType)) {
            CtrlUnitInfo targetUserCU = this.getUserCU(targetuserInfo);
            CtrlUnitInfo curUserInfoCU = this.getUserCU(curUserInfo);
            ret = Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(curUserInfo.getId())) ? Boolean.TRUE : (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(targetuserInfo.getId())) || Administrator.isSuperAuAdmin((IObjectPK)new ObjectUuidPK(curUserInfo.getId())) ? Boolean.FALSE : (!targetUserCU.getId().equals((Object)curUserInfoCU.getId()) && targetUserCU.getLongNumber().indexOf(curUserInfoCU.getLongNumber()) != -1 ? Boolean.TRUE : Boolean.FALSE));
            this.directMap.put(key, ret);
            return ret;
        }
        String targetUserOrgRangeId = targetuserInfo.getCU().getId().toString();
        boolean b = false;
        try {
            b = OrgRangeFactory.getRemoteInstance().exists("WHERE org='" + targetUserOrgRangeId + "' AND user='" + curUserInfo.getId().toString() + "'");
        }
        catch (EASBizException e) {
            this.logger.error((Object)e);
            return false;
        }
        catch (BOSException e1) {
            this.logger.error((Object)e1);
            return false;
        }
        if (b) {
            ret = Boolean.TRUE;
            this.directMap.put(key, ret);
            return true;
        }
        OrgRangeType orgRangeType = null;
        if (Administrator.isAdminType(curUserInfo.getType())) {
            orgRangeType = OrgRangeType.BIZ_ORG_TYPE;
        } else if (curUserInfo.isBizAdmin()) {
            orgRangeType = OrgRangeType.MANAGE_ORG_TYPE;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT id WHERE org.id = '").append(targetuserInfo.getCU().getId().toString()).append("'");
        buffer.append(" and user = '").append(curUserInfo.getId().toString()).append("'");
        if (orgRangeType != null) {
            buffer.append(" and type = ").append(orgRangeType.getValue());
        }
        String oql = buffer.toString();
        try {
            ret = OrgRangeFactory.getRemoteInstance().exists(oql);
            this.directMap.put(key, ret);
            return ret;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return false;
        }
    }

    private CtrlUnitInfo getUserCU(UserInfo targetuserInfo) {
        if (targetuserInfo.getCU() == null || targetuserInfo.getCU().getLongNumber() != null) {
            return targetuserInfo.getCU();
        }
        CtrlUnitCollection orgCollection = null;
        try {
            EntityViewInfo ety = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)targetuserInfo.getCU().getId().toString()));
            ety.setFilter(filterInfo);
            ety.getSelector().add(new SelectorItemInfo("longNumber"));
            orgCollection = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(ety);
        }
        catch (BOSException ex) {
            this.logger.error((Object)"", (Throwable)ex);
        }
        if (orgCollection != null && orgCollection.size() > 0) {
            return orgCollection.get(0);
        }
        return targetuserInfo.getCU();
    }

    private String getUserType(UserInfo userInfo) {
        if (userInfo == null) {
            throw new IllegalArgumentException("userInfo is null!");
        }
        if (Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return USER_TYPE_ADMIN;
        }
        if (Administrator.isAdminType(userInfo.getType())) {
            return USER_TYPE_ADMIN;
        }
        if (userInfo.isBizAdmin()) {
            return USER_TYPE_BIZADMIN;
        }
        return USER_TYPE_NORMAL;
    }

    public Map getMapByName(String name) {
        XMLConfiguration xmlReader = XMLConfiguration.getInstance((URL)UIFunctionView.class.getResource(FILE_NAME));
        ConfigurationItem item = xmlReader.getConfigItem(name);
        if (item != null) {
            return item.getProperties();
        }
        return null;
    }
}

