/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermissionRangeFacade;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.PermissionRangeFacadeFactory;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class UIUtil {
    public static final int CHECKBOX_COLNUM = 0;
    public static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static int MAX_GET_DATA_NUM = 100;
    private static final Logger logger = Logger.getLogger(UIUtil.class);

    private UIUtil() {
    }

    public static void addStandardPopupMenu(KDTree tree) {
        EventListener[] ls = tree.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            tree.addTreePopupMenu(new TreePopupMenuListener(){

                public boolean popMenu(TreePopupMenuEvent event) {
                    TreePath[] treePaths = event.getSelectionPaths();
                    if (treePaths != null) {
                        int treePathLength = treePaths.length;
                        return treePathLength == 1;
                    }
                    return false;
                }
            });
        }
    }

    public static String getAccreditOrgIdStr(IObjectPK targetUserPK) throws EASBizException, BOSException {
        Collection orgIdStr = UIUtil.getAccreditOrgIdStrList(targetUserPK);
        return ToolUtils.aryToStr(orgIdStr, false);
    }

    public static Collection getAccreditOrgIdStrList(IObjectPK targetUserPK) throws EASBizException, BOSException {
        IPermissionRangeFacade permissionRange = PermissionRangeFacadeFactory.getRemoteInstance();
        Collection orgIdStr = permissionRange.getOrgRange(targetUserPK, (IObjectPK)new ObjectStringPK(ToolUtils.getCurrentUserPK().toString()));
        return orgIdStr;
    }

    public static void setSelectStatus(KDTable tblMain, boolean setValue) {
        if (tblMain != null && tblMain.getRowCount() > 0) {
            IRow iRow;
            int i = 0;
            while ((iRow = tblMain.getRow(i)) != null) {
                iRow.getCell(0).setValue((Object)setValue);
                ++i;
            }
        }
    }

    public static void setSelectStatus(KDTable tblMain, boolean setValue, List selectOrgList) {
        if (tblMain != null && tblMain.getRowCount() > 0) {
            IRow iRow;
            int i = 0;
            while ((iRow = tblMain.getRow(i)) != null) {
                String keyValue = StringUtils.cnulls((Object)iRow.getCell("orgId").getValue());
                if (selectOrgList != null && !selectOrgList.isEmpty() && selectOrgList.contains(keyValue)) {
                    iRow.getCell(0).setValue((Object)setValue);
                } else {
                    iRow.getCell(0).setValue((Object)(!setValue ? 1 : 0));
                }
                ++i;
            }
        }
    }

    public static List getSelectOrgList(KDTable tblMain, boolean selectFilterOK) {
        ArrayList<String> retList = new ArrayList<String>();
        if (tblMain != null && tblMain.getRowCount() > 0) {
            FullOrgUnitCollection fullOrgCol = UIUtil.getSelectOrgCol(tblMain, selectFilterOK);
            if (fullOrgCol == null || fullOrgCol.isEmpty()) {
                return retList;
            }
            int size = fullOrgCol.size();
            for (int i = 0; i < size; ++i) {
                retList.add(fullOrgCol.get(i).getId().toString());
            }
        }
        return retList;
    }

    public static FullOrgUnitCollection getSelectOrgCol(KDTable tblMain, boolean selectFilterOK) {
        FullOrgUnitCollection fullOrgCol = new FullOrgUnitCollection();
        if (tblMain != null && tblMain.getRowCount() > 0) {
            IRow iRow;
            int i = 0;
            HashSet<Object> alreadySet = new HashSet<Object>();
            while ((iRow = tblMain.getRow(i)) != null) {
                FullOrgUnitInfo fullOrgInfo;
                Boolean cellSelectValue = (Boolean)iRow.getCell(0).getValue();
                if (selectFilterOK) {
                    if (cellSelectValue != null && cellSelectValue.booleanValue()) {
                        fullOrgInfo = UIUtil.getOrgInfoFromTable(iRow);
                        if (fullOrgInfo != null) {
                            logger.info((Object)("org info" + fullOrgInfo.getName() + " " + fullOrgInfo.getNumber() + " " + fullOrgInfo.getId().toString()));
                            if (alreadySet.contains(fullOrgInfo.get(fullOrgInfo.getPKField()))) {
                                logger.info((Object)"repeat org! ");
                            } else {
                                fullOrgCol.add(fullOrgInfo);
                                alreadySet.add(fullOrgInfo.get(fullOrgInfo.getPKField()));
                            }
                        }
                    } else {
                        logger.info((Object)("null row i is:" + i));
                    }
                } else {
                    fullOrgInfo = UIUtil.getOrgInfoFromTable(iRow);
                    if (fullOrgInfo != null) {
                        fullOrgCol.add(fullOrgInfo);
                    }
                }
                logger.info((Object)("i is:" + ++i + " size " + fullOrgCol.size()));
            }
        }
        return fullOrgCol;
    }

    public static FullOrgUnitInfo getOrgInfoFromTable(IRow iRow) {
        if (iRow == null) {
            return null;
        }
        String orgIdStr = (String)iRow.getCell("orgId").getValue();
        String orgNumber = (String)iRow.getCell("orgNumber").getValue();
        String orgName = (String)iRow.getCell("orgName").getValue();
        String isAdmin = iRow.getCell("isAdmin").getValue().toString();
        String isCtrl = iRow.getCell("isCtrl").getValue().toString();
        String isSale = iRow.getCell("isSale").getValue().toString();
        String isPurchase = iRow.getCell("isPurchase").getValue().toString();
        String isStorage = iRow.getCell("isStorage").getValue().toString();
        String isProfit = iRow.getCell("isProfit").getValue().toString();
        String isCost = iRow.getCell("isCost").getValue().toString();
        String isUnion = iRow.getCell("isUnion").getValue().toString();
        String isCompany = iRow.getCell("isCompany").getValue().toString();
        String isHr = iRow.getCell("isHr").getValue().toString();
        FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
        orgInfo.setId(BOSUuid.read((String)orgIdStr));
        orgInfo.setNumber(orgNumber);
        orgInfo.setName(orgName);
        orgInfo.setIsAdminOrgUnit(Boolean.valueOf(isAdmin).booleanValue());
        orgInfo.setIsCU(Boolean.valueOf(isCtrl).booleanValue());
        orgInfo.setIsSaleOrgUnit(Boolean.valueOf(isSale).booleanValue());
        orgInfo.setIsPurchaseOrgUnit(Boolean.valueOf(isPurchase).booleanValue());
        orgInfo.setIsStorageOrgUnit(Boolean.valueOf(isStorage).booleanValue());
        orgInfo.setIsProfitOrgUnit(Boolean.valueOf(isProfit).booleanValue());
        orgInfo.setIsCostOrgUnit(Boolean.valueOf(isCost).booleanValue());
        orgInfo.setIsUnion(Boolean.valueOf(isUnion).booleanValue());
        orgInfo.setIsCompanyOrgUnit(Boolean.valueOf(isCompany).booleanValue());
        orgInfo.setIsHROrgUnit(Boolean.valueOf(isHr).booleanValue());
        return orgInfo;
    }

    public static void addFirstTableColInfo(KDTable tblMain) {
        if (tblMain != null && tblMain.getRowCount() > 0) {
            IRow iRow;
            int i = 0;
            while ((iRow = tblMain.getRow(i)) != null) {
                iRow.getCell(0).setValue((Object)Boolean.FALSE);
                KDCheckBox oneCheckBox = new KDCheckBox();
                iRow.getCell(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)oneCheckBox));
                logger.info((Object)("i is:" + ++i));
            }
        }
        tblMain.repaint();
    }

    public static void sleep() {
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 100; ++j) {
                logger.info((Object)(i + ":" + j));
            }
        }
    }

    public static List getValueFromTable(KDTable tblMain, String valueName) {
        IRow iRow;
        ArrayList<Object> retList = new ArrayList<Object>();
        int i = 0;
        while ((iRow = tblMain.getRow(i)) != null) {
            OrgRangeInfo orgRangeInfo = new OrgRangeInfo();
            Object objID = iRow.getCell(valueName).getValue();
            if (objID != null) {
                retList.add(objID);
            }
            ++i;
        }
        return retList;
    }

    public static FullOrgUnitCollection getSelectOrgCol(KDTable tblMain, String orgIdStr) throws BOSException {
        FullOrgUnitCollection orgCol = UIUtil.getSelectOrgCol(tblMain, false);
        if (orgCol.isEmpty()) {
            return orgCol;
        }
        if (!StringUtils.isEmpty((String)orgIdStr)) {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgIdStr, CompareType.INCLUDE));
            entityViewInfo.setSelector(UIUtil.getSimpleOrgSelector());
            entityViewInfo.setFilter(filterInfo);
            return iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
        }
        return new FullOrgUnitCollection();
    }

    public static FullOrgUnitCollection getSelectOrgCol(Set<String> orgIds) throws BOSException {
        if (orgIds != null && !orgIds.isEmpty()) {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", orgIds, CompareType.INCLUDE));
            entityViewInfo.setSelector(UIUtil.getSimpleOrgSelector());
            entityViewInfo.setFilter(filterInfo);
            return iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
        }
        return new FullOrgUnitCollection();
    }

    private static SelectorItemCollection getSimpleOrgSelector() {
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("ispurchaseorgunit"));
        selectorCol.add(new SelectorItemInfo("isqualityorgunit"));
        selectorCol.add(new SelectorItemInfo("isprofitorgunit"));
        selectorCol.add(new SelectorItemInfo("isousealup"));
        selectorCol.add(new SelectorItemInfo("isgrouping"));
        selectorCol.add(new SelectorItemInfo("isstorageorgunit"));
        selectorCol.add(new SelectorItemInfo("issaleorgunit"));
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("iscu"));
        selectorCol.add(new SelectorItemInfo("ishrorgunit"));
        selectorCol.add(new SelectorItemInfo("isadminorgunit"));
        selectorCol.add(new SelectorItemInfo("iscompanyorgunit"));
        selectorCol.add(new SelectorItemInfo("iscostorgunit"));
        selectorCol.add(new SelectorItemInfo("isassistantorg"));
        selectorCol.add(new SelectorItemInfo("isunion"));
        selectorCol.add(new SelectorItemInfo("orgtypestr"));
        selectorCol.add(new SelectorItemInfo("cu"));
        selectorCol.add(new SelectorItemInfo("maintaincu"));
        return selectorCol;
    }

    public static List getUserIdList(KDTable tblMain, int column) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int size = tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)tblMain, (IBlock)tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                String userId = (String)tblMain.getValueAt(j, column);
                if (StringUtils.isEmpty((String)userId)) continue;
                arrayList.add(userId);
            }
        }
        return arrayList;
    }

    public static void removeRow(KDTable table) {
        for (int i = table.getSelectManager().size() - 1; i >= 0; --i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            int size1 = selectBlock.getTop();
            for (int j = selectBlock.getBottom(); j >= size1; --j) {
                table.removeRow(j);
            }
        }
    }

    public static IUIWindow showWindow(HashMap hm, String uiClass) throws Exception {
        return UITools.showUI(uiClass, hm);
    }
}

