/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EasXtSyncUtil {
    private Logger logger = Logger.getLogger(EasXtSyncUtil.class);
    private Document doc = null;
    private Map config = null;
    private String initCheckTime = "1900-01-01 01:01:01";
    private static EasXtSyncUtil instance = null;
    private long xmlFileTime = 0L;
    private static String FILE_SQL = System.getProperty("eas.properties.dir") + File.separator + "easXtSync.xml";
    private static String FILE_CONFIG = System.getProperty("eas.properties.dir") + File.separator + "easXtSyncConfig.properties";

    private EasXtSyncUtil() {
        this.loadXml();
        this.loadProperties();
    }

    public static EasXtSyncUtil getInstance() {
        if (instance == null) {
            instance = new EasXtSyncUtil();
        }
        return instance;
    }

    public boolean isChangeEip(String eip) {
        return eip != null && !"".equals(eip) && !eip.equals(this.config.get("eip"));
    }

    private boolean isReloadXml() {
        File file = new File(FILE_SQL);
        long lastModefiedTime = file.lastModified();
        if (this.xmlFileTime == 0L || this.xmlFileTime < lastModefiedTime) {
            this.xmlFileTime = lastModefiedTime;
            return true;
        }
        return false;
    }

    private void loadProperties() {
        FileInputStream fileInputStream = null;
        try {
            File file = new File(FILE_CONFIG);
            if (!file.exists()) {
                file.createNewFile();
            }
            if (this.config == null) {
                this.config = new Properties();
            }
            fileInputStream = new FileInputStream(FILE_CONFIG);
            ((Properties)this.config).load(new FileInputStream(FILE_CONFIG));
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public Map getXtConfig() {
        return this.config;
    }

    public String getEip() {
        return (String)this.config.get("eip");
    }

    public String getCloud() {
        return (String)this.config.get("mCloud");
    }

    public boolean isUpdateOrg() {
        return "1".equals((String)this.config.get("isUpdateOrg"));
    }

    public boolean isUpdateName() {
        return "1".equals((String)this.config.get("isUpdateName"));
    }

    public boolean isUpdateEmail() {
        return "1".equals((String)this.config.get("isUpdateEmail"));
    }

    public boolean isUpdatePosition() {
        return "1".equals((String)this.config.get("isUpdatePosition"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXtConfig(Map map) {
        if (map == null) {
            return;
        }
        String eip = ((String)map.get("eip")).trim();
        String mcloud = ((String)map.get("mCloud")).trim();
        String isUpdateOrg = (String)map.get("isUpdateOrg");
        String isUpdateName = (String)map.get("isUpdateName");
        String isUpdateEmail = (String)map.get("isUpdateEmail");
        String isUpdatePosition = (String)map.get("isUpdatePosition");
        Properties p = new Properties();
        p.setProperty("eip", eip);
        p.setProperty("mCloud", mcloud);
        p.setProperty("isUpdateOrg", isUpdateOrg);
        p.setProperty("isUpdateName", isUpdateName);
        p.setProperty("isUpdateEmail", isUpdateEmail);
        p.setProperty("isUpdatePosition", isUpdatePosition);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(FILE_CONFIG);
            p.store(os, "update");
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.config.put("eip", eip);
        this.config.put("mCloud", mcloud);
        this.config.put("isUpdateOrg", isUpdateOrg);
        this.config.put("isUpdateName", isUpdateName);
        this.config.put("isUpdateEmail", isUpdateEmail);
        this.config.put("isUpdatePosition", isUpdatePosition);
    }

    private void loadXml() {
        if (!this.isReloadXml()) {
            return;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(FILE_SQL);
            SAXReader reader = new SAXReader();
            this.doc = reader.read((InputStream)is);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getValue(String key) {
        this.loadXml();
        Element element = this.doc.elementByID(key);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public boolean isFirstCheck(String checkTime) {
        return checkTime.equals(this.initCheckTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downloadPdf() {
        InputStream in = null;
        try {
            in = new FileInputStream(System.getProperty("eas.properties.dir") + File.separator + "cloudPermission.pdf");
            byte[] size = new byte[in.available()];
            in.read(size);
            byte[] byArray = size;
            return byArray;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

