/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.app.AbstractAuthenSchemePermControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AuthenSchemePermControllerBean
extends AbstractAuthenSchemePermControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AuthenSchemePermControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private String rootPermItemId = null;
    private String rootPermItemNumber = "EAS\u7cfb\u7edf";
    private String rootPermItemAlias = "EAS\u7cfb\u7edf";
    private String rootPermItemLongNumber = "EAS\u7cfb\u7edf";
    private int MAX_RECORD_COUNT = 8000;

    private void initRootInfo(Context ctx) throws BOSException {
        if (this.rootPermItemId != null) {
            return;
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select fid id from t_pm_permitem where fnumber = 'EAS\u7cfb\u7edf'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) {
                throw new BOSException("\u67e5\u627e\u4e0d\u5230\u6811\u7684\u6839\u8282\u70b9!");
            }
            this.rootPermItemId = rs.getString("id");
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    @Override
    protected PermItemCollection _getTargetChildPermCol(Context ctx, String authenSchemeId, PermItemInfo targetPermItemInfo) throws BOSException {
        this.initRootInfo(ctx);
        PermItemCollection permItemCol = new PermItemCollection();
        try {
            String targetPermItemId = targetPermItemInfo == null ? this.rootPermItemId : targetPermItemInfo.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append("select perm1.fid id, perm1.falias_l2 alias, ").append("perm1.fnumber number, perm1.fparentid parent, ").append("perm1.fisleaf isleaf, perm1.flongnumber longnumber ").append("from t_pm_permitem as perm1 ").append("where fparentid = '").append(targetPermItemId).append("' ").append("and exists(").append("select 1 ").append("from t_pm_authenschemeperm as scheme ").append("inner join t_pm_permitem as perm2 on perm2.fid = scheme.fpermitemid ").append("where scheme.fauthenschemeid = ? ").append("and (perm2.flongnumber like concat(perm1.flongnumber, '!%') ").append("or perm2.fid = perm1.fid)").append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenSchemeId});
            PermItemInfo permItemInfo = null;
            PermItemInfo parentPermItemInfo = null;
            String parentPermItemId = null;
            while (rowSet.next()) {
                permItemInfo = new PermItemInfo();
                parentPermItemId = rowSet.getString("parent");
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                permItemInfo.setAlias(rowSet.getString("alias"));
                permItemInfo.setNumber(rowSet.getString("number"));
                permItemInfo.setLongNumber(rowSet.getString("longnumber"));
                permItemInfo.setIsLeaf(rowSet.getBoolean("isleaf"));
                if (!StringUtils.isEmpty((String)parentPermItemId)) {
                    parentPermItemInfo = new PermItemInfo();
                    parentPermItemInfo.setId(BOSUuid.read((String)parentPermItemId));
                    permItemInfo.setParent(parentPermItemInfo);
                }
                permItemCol.add(permItemInfo);
            }
            if (!permItemCol.isEmpty() && targetPermItemInfo == null) {
                permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)this.rootPermItemId));
                permItemInfo.setAlias(this.rootPermItemAlias);
                permItemInfo.setNumber(this.rootPermItemNumber);
                permItemInfo.setLongNumber(this.rootPermItemLongNumber);
                permItemCol.add(permItemInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return permItemCol;
    }

    @Override
    protected PermItemCollection _getTargetAllChidPermCol(Context ctx, PermItemInfo targetPermItemInfo) throws BOSException {
        this.initRootInfo(ctx);
        PermItemCollection permItemCol = new PermItemCollection();
        try {
            String targetPermItemId = targetPermItemInfo == null ? this.rootPermItemId : targetPermItemInfo.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.append("select perm.fid id, perm.falias_l2 alias, ").append("perm.fnumber number, perm.fparentid parent, ").append("perm.fisleaf isleaf, perm.flongnumber longnumber ").append("from t_pm_permitem as perm ").append("where perm.fparentid = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{targetPermItemId});
            PermItemInfo permItemInfo = null;
            PermItemInfo parentPermItemInfo = null;
            String parentPermItemId = null;
            while (rowSet.next()) {
                permItemInfo = new PermItemInfo();
                parentPermItemId = rowSet.getString("parent");
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                permItemInfo.setAlias(rowSet.getString("alias"));
                permItemInfo.setNumber(rowSet.getString("number"));
                permItemInfo.setLongNumber(rowSet.getString("longnumber"));
                permItemInfo.setIsLeaf(rowSet.getBoolean("isleaf"));
                permItemInfo.setExtendedProperty("needAll", Boolean.toString(true));
                if (!StringUtils.isEmpty((String)parentPermItemId)) {
                    parentPermItemInfo = new PermItemInfo();
                    parentPermItemInfo.setId(BOSUuid.read((String)parentPermItemId));
                    permItemInfo.setParent(parentPermItemInfo);
                }
                permItemCol.add(permItemInfo);
            }
            if (!permItemCol.isEmpty() && targetPermItemInfo == null) {
                permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)this.rootPermItemId));
                permItemInfo.setAlias(this.rootPermItemAlias);
                permItemInfo.setNumber(this.rootPermItemNumber);
                permItemInfo.setLongNumber(this.rootPermItemLongNumber);
                permItemInfo.setExtendedProperty("needAll", Boolean.toString(true));
                permItemCol.add(permItemInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return permItemCol;
    }

    @Override
    protected Set _getTargetAddLeafChildPermCol(Context ctx, String authenSchemeId, PermItemInfo targetPermItemInfo) throws BOSException {
        HashSet<String> leafPermItemIdSet = new HashSet<String>();
        if (targetPermItemInfo != null && targetPermItemInfo.isIsLeaf()) {
            leafPermItemIdSet.add(targetPermItemInfo.getId().toString());
            return leafPermItemIdSet;
        }
        try {
            String targetPermItemLongnumber = targetPermItemInfo == null ? this.rootPermItemLongNumber : targetPermItemInfo.getLongNumber();
            StringBuffer sql = new StringBuffer();
            sql.append("select perm.fid id ").append("from t_pm_permitem as perm ").append("where perm.flongnumber like ? ").append("and perm.fisleaf = 1 ").append("and not exists(").append("select 1 ").append("from t_pm_authenschemeperm as scheme ").append("where scheme.fauthenschemeid = ? ").append("and perm.fid = scheme.fpermitemid").append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{targetPermItemLongnumber + "!%", authenSchemeId});
            while (rowSet.next()) {
                leafPermItemIdSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return leafPermItemIdSet;
    }

    @Override
    protected Set _getTargetLeafChildPermCol(Context ctx, String authenSchemeId, PermItemInfo targetPermItemInfo) throws BOSException {
        HashSet<String> leafPermItemIdSet = new HashSet<String>();
        if (targetPermItemInfo != null && targetPermItemInfo.isIsLeaf()) {
            leafPermItemIdSet.add(targetPermItemInfo.getId().toString());
            return leafPermItemIdSet;
        }
        try {
            String targetPermItemLongnumber = targetPermItemInfo == null ? this.rootPermItemLongNumber : targetPermItemInfo.getLongNumber();
            StringBuffer sql = new StringBuffer();
            sql.append("select perm.fid id ").append("from t_pm_authenschemeperm as scheme ").append("inner join t_pm_permitem as perm on perm.fid = scheme.fpermitemid ").append("where perm.flongnumber like ? ").append("and scheme.fauthenschemeid = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{targetPermItemLongnumber + "!%", authenSchemeId});
            while (rowSet.next()) {
                leafPermItemIdSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return leafPermItemIdSet;
    }

    @Override
    protected void _saveChange(Context ctx, String authenSchemeId, Set addPermItemSet, Set deletePermItemSet, boolean isNeedAuthenWhenCreateUser) throws BOSException {
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            this.saveNeedAuthenWhenCreateUser(con, authenSchemeId, addPermItemSet, deletePermItemSet, isNeedAuthenWhenCreateUser);
            this.addPermItemInfo(con, authenSchemeId, addPermItemSet);
            this.deletePermItemInfo(con, authenSchemeId, deletePermItemSet);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void saveNeedAuthenWhenCreateUser(Connection con, String authenSchemeId, Set addPermItemSet, Set deletePermItemSet, boolean isNeedAuthenWhenCreateUser) throws BOSException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            block7: {
                preparedStatement = null;
                resultSet = null;
                boolean isNeedAuthenWhenCreateUserInDB = false;
                StringBuffer queryIsNeedAuthenWhenCreateUserSql = new StringBuffer();
                queryIsNeedAuthenWhenCreateUserSql.append("select 1 ").append("from t_pm_authenschemeperm as schemeperm ").append("where schemeperm.fauthenschemeid = ? and ").append("schemeperm.fpermitemid = ?");
                preparedStatement = con.prepareStatement(queryIsNeedAuthenWhenCreateUserSql.toString());
                preparedStatement.setString(1, authenSchemeId);
                preparedStatement.setString(2, "e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM");
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    isNeedAuthenWhenCreateUserInDB = true;
                }
                if (isNeedAuthenWhenCreateUserInDB != isNeedAuthenWhenCreateUser) break block7;
                SQLUtils.cleanup((ResultSet)resultSet, (Statement)preparedStatement);
                return;
            }
            try {
                if (isNeedAuthenWhenCreateUser) {
                    addPermItemSet.add("e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM");
                    break block8;
                }
                deletePermItemSet.add("e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM");
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, preparedStatement);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)preparedStatement);
    }

    private void addPermItemInfo(Connection con, String authenSchemeId, Set addPermItemSet) throws BOSException {
        PreparedStatement statement = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("insert into t_pm_authenschemeperm(fid, fauthenschemeid, fpermitemid) ").append("values(?, ?, ?)");
            statement = con.prepareStatement(sql.toString());
            int count = 0;
            String recordId = null;
            for (Object permItemId : addPermItemSet) {
                recordId = BOSUuid.create((String)"8AB3D21A").toString();
                statement.setString(1, recordId);
                statement.setString(2, authenSchemeId);
                statement.setObject(3, permItemId);
                statement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
    }

    private void deletePermItemInfo(Connection con, String authenSchemeId, Set deletePermItemSet) throws BOSException {
        PreparedStatement statement = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_pm_authenschemeperm ").append("where fauthenschemeid = ? ").append("and fpermitemid = ?");
            statement = con.prepareStatement(sql.toString());
            int count = 0;
            for (Object permItemId : deletePermItemSet) {
                statement.setString(1, authenSchemeId);
                statement.setObject(2, permItemId);
                statement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
    }

    @Override
    protected boolean _isNeedAuthenWhenCreateUser(Context ctx, String authenSchemeId) throws BOSException {
        boolean isNeedAuthenWhenCreateUser = false;
        StringBuffer queryIsNeedAuthenWhenCreateUserSql = new StringBuffer();
        queryIsNeedAuthenWhenCreateUserSql.append("select 1").append("from t_pm_authenschemeperm as schemeperm ").append("where schemeperm.fauthenschemeid = ? and ").append("schemeperm.fpermitemid = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryIsNeedAuthenWhenCreateUserSql.toString(), (Object[])new Object[]{authenSchemeId, "e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM"});
        if (rowSet.size() == 1) {
            isNeedAuthenWhenCreateUser = true;
        }
        return isNeedAuthenWhenCreateUser;
    }
}

