/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.permission.BizObjectForRoleEntryCollection;
import com.kingdee.eas.base.permission.BizObjectForRoleEntryInfo;
import com.kingdee.eas.base.permission.BizObjectForRoleInfo;
import com.kingdee.eas.base.permission.app.AbstractBizObjectForRoleControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BizObjectForRoleControllerBean
extends AbstractBizObjectForRoleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.BizObjectForRoleControllerBean");

    @Override
    protected void _submit(Context ctx, ArrayList roleList) throws BOSException, EASBizException {
        ArrayList<BizObjectForRoleInfo> addList = new ArrayList<BizObjectForRoleInfo>();
        ArrayList<BizObjectForRoleInfo> updateList = new ArrayList<BizObjectForRoleInfo>();
        Connection conn = this.getConnection(ctx);
        Statement st = null;
        try {
            st = conn.createStatement();
            int size = roleList.size();
            for (int i = 0; i < size; ++i) {
                BizObjectForRoleInfo roleInfo = (BizObjectForRoleInfo)roleList.get(i);
                if (roleInfo.getId() != null) {
                    updateList.add(roleInfo);
                    continue;
                }
                addList.add(roleInfo);
            }
            String fids = this.getFIDString(updateList);
            if (fids == null) {
                fids = "'null'";
            }
            st.execute(this.getRemoveAllSql(ctx, fids));
            st.execute(this.getRemoveAllPropSql(ctx, fids));
            for (int i = 0; i < addList.size(); ++i) {
                st.addBatch(this.getInsertSql((BizObjectForRoleInfo)addList.get(i), ctx));
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)st);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private String getFIDString(ArrayList ruleUpdateList) {
        int size = ruleUpdateList.size();
        Object[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            BizObjectForRoleInfo roleInfo = (BizObjectForRoleInfo)ruleUpdateList.get(i);
            ids[i] = "'" + roleInfo.getId().toString() + "'";
        }
        return StringUtils.arrayToString((Object[])ids, (String)",");
    }

    private String getRemoveAllSql(Context ctx, String ids) {
        StringBuffer sql = new StringBuffer("delete from T_PM_BizObjectForRole where fid not in ");
        sql.append(" (").append(ids).append(" )");
        return sql.toString();
    }

    private String getRemoveAllPropSql(Context ctx, String ids) {
        StringBuffer sql = new StringBuffer("delete from T_PM_BizObjectForRoleEntry where FEntityObjID  in ");
        sql.append("(select fid from T_PM_BizObjectForRole where fid not in (").append(ids).append(" ))");
        return sql.toString();
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    private String getInsertSql(BizObjectForRoleInfo roleInfo, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String creator = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String number = roleInfo.getNumber();
        String longNumber = roleInfo.getLongNumber();
        String name_l1 = roleInfo.getName(new Locale("l1"));
        String name_l2 = roleInfo.getName(new Locale("l2"));
        String name_l3 = roleInfo.getName(new Locale("l3"));
        String packageName = roleInfo.getPackageName();
        int leaf = roleInfo.isIsLeaf() ? 1 : 0;
        int level = roleInfo.getLevel();
        String cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        sql.append("insert into T_PM_BizObjectForRole (FID,FCreatorID ,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID ,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,FSimpleName ,FIsLeaf,FLevel,FLongNumber,FDisplayName_l1,FDisplayName_l2,FDisplayName_l3,FPackageName)").append(" values (newbosid('73B4E301'),'").append(creator).append("',getdate(),'").append(creator).append("',getdate(),'").append(cuid).append("','").append(name_l1).append("','").append(name_l2).append("','").append(name_l3).append("','").append(number).append("',null,null,null,null,").append(leaf).append(",").append(level).append(",'").append(longNumber).append("','").append(name_l1).append("','").append(name_l2).append("','").append(name_l3).append("','").append(packageName).append("')");
        return sql.toString();
    }

    private String getUpdateSql(BizObjectForRoleInfo roleInfo) {
        return null;
    }

    @Override
    protected void _submitProp(Context ctx, ArrayList propList) throws BOSException, EASBizException {
        int size = propList.size();
        for (int i = 0; i < size; ++i) {
            BizObjectForRoleInfo roleInfo = (BizObjectForRoleInfo)propList.get(i);
            BizObjectForRoleEntryCollection propColl = roleInfo.getPropEntries();
            this.submitProp(ctx, propColl, roleInfo.getId().toString());
        }
    }

    private void submitProp(Context ctx, BizObjectForRoleEntryCollection propColl, String fid) throws BOSException {
        Connection conn = this.getConnection(ctx);
        ArrayList<String> updateList = new ArrayList<String>();
        ArrayList<String> sqlList = new ArrayList<String>();
        Statement st = null;
        try {
            st = conn.createStatement();
            int size = propColl.size();
            for (int i = 0; i < size; ++i) {
                BizObjectForRoleEntryInfo entryInfo = propColl.get(i);
                if (entryInfo.getId() != null) {
                    updateList.add(entryInfo.getId().toString());
                }
                sqlList.add(this.getSubmitSql(entryInfo, i));
            }
            String entryids = this.getEntryFIDString(updateList);
            if (entryids == null) {
                entryids = "'null'";
            }
            st.execute(this.getRemoveAllPropSqlByEntryID(ctx, entryids, fid));
            for (int i = 0; i < sqlList.size(); ++i) {
                st.addBatch((String)sqlList.get(i));
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)st);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private String getRemoveAllPropSqlByEntryID(Context ctx, String ids, String entityid) {
        StringBuffer sql = new StringBuffer("delete from T_PM_BizObjectForRoleEntry where fid not in (").append(ids).append(" )").append(" and fentityobjid = '").append(entityid).append("'");
        return sql.toString();
    }

    private String getEntryFIDString(ArrayList entryUpdateList) {
        int size = entryUpdateList.size();
        Object[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            BizObjectForRoleEntryInfo roleInfo = (BizObjectForRoleEntryInfo)entryUpdateList.get(i);
            ids[i] = "'" + roleInfo.getId().toString() + "'";
        }
        return StringUtils.arrayToString((Object[])ids, (String)",");
    }

    private String getSubmitSql(BizObjectForRoleEntryInfo entryInfo, int seq) {
        String parentID = entryInfo.getEntityObj().getId().toString();
        String number = entryInfo.getPropNumber();
        String namel1 = entryInfo.getPropName(new Locale("l1"));
        String namel2 = entryInfo.getPropName(new Locale("l2"));
        String namel3 = entryInfo.getPropName(new Locale("l3"));
        StringBuffer sql = new StringBuffer();
        if (entryInfo.getId() == null) {
            sql.append("insert into T_PM_BizObjectForRoleEntry (FID,FSeq,FEntityObjID,FPropNumber,FPropName_L1,FPropName_L2,FPropName_L3)").append(" values (newbosid('1E95EDF1'),").append(seq).append(",'").append(parentID).append("','").append(number).append("','").append(namel1).append("','").append(namel2).append("','").append(namel3).append("')");
            return sql.toString();
        }
        sql.append("update T_PM_BizObjectForRoleEntry set FSeq=").append(seq).append(",FEntityObjID='").append(parentID).append("',FPropNumber='").append(number).append("',FPropName_L1='").append(namel1).append("',FPropName_L2='").append(namel2).append("',FPropName_L3='").append(namel3).append("')");
        return sql.toString();
    }
}

