/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.app.AbstractBaseAuthenRecordAuthen;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreateNewUserAuthenRecordAuthen
extends AbstractBaseAuthenRecordAuthen {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.CreateNewUserAuthenRecordAuthenImpl");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private final String USER_ID_SET = "userIdSet";
    private final String RULE = "rule";

    @Override
    protected String getDescription() {
        return EASResource.getString((String)RESOURCE, (String)"CREATE_AUTHEN_TASK");
    }

    @Override
    protected ResultSet queryNeedAuthenResultSet(Connection conn, String permChangeId) throws BOSException {
        PreparedStatement queryStatement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer queryAuthenSql = new StringBuffer();
            queryAuthenSql.append("select snapview.fuserid userid, snapview.fisrule isrule ").append("from t_pm_authenschemesnapview as snapview ").append("inner join t_pm_authenrecord as record on record.fpermchangeid = snapview.fpermchangerecordid and record.fauthentorid = snapview.fuserid ").append("where snapview.fpermitemid = ? and ").append("record.fauthenstatus = ? and ").append("snapview.fpermchangerecordid = ?");
            queryStatement = conn.prepareStatement(queryAuthenSql.toString());
            queryStatement.setString(1, "e693ae65-00fd-1000-e000-0018c0a813dbPERMITEM");
            queryStatement.setString(2, "10");
            queryStatement.setString(3, permChangeId);
            resultSet = queryStatement.executeQuery();
            return resultSet;
        }
        catch (Exception e) {
            SQLUtils.cleanup(resultSet, queryStatement);
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map getInformation(ResultSet resultSet) throws BOSException {
        try {
            boolean rule = false;
            String userId = null;
            HashSet<String> userIdSet = new HashSet<String>();
            while (resultSet.next()) {
                rule = resultSet.getBoolean("isrule");
                userId = resultSet.getString("userid");
                userIdSet.add(userId);
            }
            HashMap<String, Serializable> information = new HashMap<String, Serializable>();
            information.put("userIdSet", userIdSet);
            information.put("rule", Boolean.valueOf(rule));
            return information;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Set getPassSet(Map information, String currentUserId) {
        Set userIdSet = (Set)information.get("userIdSet");
        boolean rule = (Boolean)information.get("rule");
        HashSet<Boolean> authenPassOrNo = new HashSet<Boolean>();
        if (!userIdSet.contains(currentUserId)) {
            authenPassOrNo.add(false);
            return authenPassOrNo;
        }
        if (!rule || userIdSet.size() == 1) {
            authenPassOrNo.add(true);
        } else {
            authenPassOrNo.add(false);
        }
        return authenPassOrNo;
    }

    @Override
    protected void updatePassData(Connection conn, Set passSet, Map information, String permChangeId) throws BOSException {
        Iterator passOrNotIter = passSet.iterator();
        boolean isPass = (Boolean)passOrNotIter.next();
        PreparedStatement updateUserStatement = null;
        try {
            if (isPass) {
                StringBuffer updateUserSql = new StringBuffer();
                updateUserSql.append("update t_pm_user set fisregister = 1 ").append("where fnumber = (").append("select fassignedobjectnumber ").append("from t_pm_permchangerecord ").append("where fid = ?").append(")");
                updateUserStatement = conn.prepareStatement(updateUserSql.toString());
                updateUserStatement.setString(1, permChangeId);
                updateUserStatement.execute();
                this.cleanData(conn, permChangeId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(updateUserStatement);
        }
    }

    @Override
    protected Set getNoPassSet(Map information, String currentUserId) {
        Set userIdSet = (Set)information.get("userIdSet");
        boolean rule = (Boolean)information.get("rule");
        HashSet<Boolean> authenPassOrNo = new HashSet<Boolean>();
        if (userIdSet.contains(currentUserId)) {
            authenPassOrNo.add(true);
        } else {
            authenPassOrNo.add(false);
        }
        return authenPassOrNo;
    }

    @Override
    protected void updateNoPassData(Connection conn, Set noPassSet, Map information, String permChangeId) throws BOSException {
        Iterator passOrNotIter = noPassSet.iterator();
        boolean isPass = (Boolean)passOrNotIter.next();
        PreparedStatement deleteUserStatement = null;
        try {
            if (isPass) {
                StringBuffer deleteSql = new StringBuffer();
                deleteSql.append("delete from t_pm_user ").append("where fnumber = (").append("select fassignedobjectnumber ").append("from t_pm_permchangerecord ").append("where fid = ?").append(")");
                deleteUserStatement = conn.prepareStatement(deleteSql.toString());
                deleteUserStatement.setString(1, permChangeId);
                deleteUserStatement.execute();
                this.cleanData(conn, permChangeId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(deleteUserStatement);
        }
    }
}

