/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.RoleChangeInfo;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.SimpleUserRoleOrg;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.app.AbstractInheritPermFacadeControllerBean;
import com.kingdee.eas.base.permission.app.util.interior.permgroup.UserPermChangeListener;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class InheritPermFacadeControllerBean
extends AbstractInheritPermFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.InheritPermFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    protected void _inheritParentUserAndRole(Context ctx, IObjectPK orgPK) throws BOSException, EASBizException {
        IObjectPK parentPK = this.getParentPK(ctx, orgPK);
        if (parentPK == null) {
            return;
        }
        HashMap emptyMap = new HashMap();
        HashSet emptySet = new HashSet();
        this._inheritParentUserAndRole(ctx, orgPK, emptySet, emptySet, emptyMap, emptyMap, emptyMap, emptyMap);
    }

    @Override
    protected void _inheritParentUserAndRole(Context ctx, IObjectPK orgPK, Set deletedUsers, Set addedUsers, Map deletedUserRoleMap, Map addedUserRoleMap, Map addedGrantUserRoleMap, Map deetedGrantUserRoleMap) throws BOSException, EASBizException {
        IObjectPK parentPK = this.getParentPK(ctx, orgPK);
        if (parentPK == null) {
            return;
        }
        this.inheritParentUsers(ctx, orgPK, parentPK, deletedUsers, addedUsers);
        this.inheritParentRoles(ctx, orgPK, parentPK, deletedUsers, deletedUserRoleMap, addedUserRoleMap, true);
        this.inheritParentRoles(ctx, orgPK, parentPK, deletedUsers, deetedGrantUserRoleMap, addedGrantUserRoleMap, false);
    }

    private IObjectPK getParentPK(Context ctx, IObjectPK orgPK) throws BOSException, EASBizException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo parentInfo = iFullOrgUnit.getFullOrgUnitInfo(orgPK).getParent();
        if (parentInfo == null) {
            return null;
        }
        return new ObjectUuidPK(parentInfo.getId());
    }

    private void inheritParentUsers(Context ctx, IObjectPK orgPK, IObjectPK parentPK, Set deletedUsers, Set addedUsers) throws BOSException, EASBizException {
        this.inheritParentUsers(ctx, orgPK, parentPK, deletedUsers, false);
        this.inheritParentUsers(ctx, orgPK, parentPK, deletedUsers, true);
        this.addOtherUser(ctx, orgPK, addedUsers, false);
        this.addOtherUser(ctx, orgPK, addedUsers, true);
    }

    private void inheritParentUsers(Context ctx, IObjectPK orgPK, IObjectPK parentPK, Set deletedUsers, boolean isIncludeSub) throws BOSException, EASBizException {
        String deleteUserSql = "";
        String deletedUserIds = ToolUtils.aryToStr(deletedUsers);
        if (deletedUsers != null && deletedUsers.size() > 0) {
            deleteUserSql = "and a.fuserid not in(" + deletedUserIds + ")";
        }
        String inheritOrgRangeSql = "insert into {0}(fid,fuserid,forgid,ftype)  select newbosid({1}),fuserid,{2},10 from {3} a join t_pm_user b on a.fuserid=b.fid  where a.forgid={4} and a.ftype=10 and b.ftype not in (10,60) " + deleteUserSql + " and a.fuserid not in (select fuserid from {5} where forgid={6} and ftype=10)";
        String table = "t_pm_orgrange";
        String bosType = "'" + new OrgRangeInfo().getBOSType().toString() + "'";
        if (isIncludeSub) {
            table = "t_pm_orgrangeincludesuborg";
            bosType = "'" + new OrgRangeIncludeSubOrgInfo().getBOSType().toString() + "'";
        }
        String orgID = "'" + orgPK.toString() + "'";
        String parentID = "'" + parentPK.toString() + "'";
        Object[] params = new String[]{table, bosType, orgID, table, parentID, table, orgID};
        DbUtil.execute((Context)ctx, (String)MessageFormat.format(inheritOrgRangeSql, params));
    }

    private void addOtherUser(Context ctx, IObjectPK orgPK, Set addedUsers, boolean isIncludeSub) throws BOSException, EASBizException {
        if (addedUsers == null || addedUsers.size() < 1) {
            return;
        }
        Set existUsers = this.getExistUsers(ctx, orgPK, isIncludeSub);
        Collection newUsers = CollectionUtils.subtract((Collection)addedUsers, (Collection)existUsers);
        String table = "t_pm_orgrange";
        BOSObjectType bosType = new OrgRangeInfo().getBOSType();
        if (isIncludeSub) {
            table = "t_pm_orgrangeincludesuborg";
            bosType = new OrgRangeIncludeSubOrgInfo().getBOSType();
        }
        String sql = "insert into " + table + "(fid,fuserid,forgid,ftype) values(?,?,?,?)";
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            Iterator itr = newUsers.iterator();
            int i = 0;
            while (itr.hasNext()) {
                ++i;
                ps.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
                ps.setString(2, itr.next().toString());
                ps.setString(3, orgPK.toString());
                ps.setInt(4, 10);
                ps.addBatch();
                if (i % 2000 != 0) continue;
                ps.executeBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"addOtherUser", (Throwable)se);
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private Set getExistUsers(Context ctx, IObjectPK orgPK, boolean isIncludeSub) throws BOSException, EASBizException {
        HashSet<String> existUsers = new HashSet<String>();
        String table = "t_pm_orgrange";
        if (isIncludeSub) {
            table = "t_pm_orgrangeincludesub";
        }
        String orgId = "'" + orgPK + "'";
        String sql = "select fuserid from {0} where forgid={1} and ftype=10";
        Object[] params = new String[]{table, orgId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)MessageFormat.format(sql, params));
        try {
            while (rs.next()) {
                existUsers.add(rs.getString("fuserid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getExistUsers", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return existUsers;
    }

    private void inheritParentRoles(Context ctx, IObjectPK orgPK, IObjectPK parentPK, Set deletedUsers, Map deletedUserRoleMap, Map addedUserRoleMap, boolean isNormal) throws BOSException, EASBizException {
        Map parentUserRoleMap = this.getUserRoleMapByOrgID(ctx, parentPK, isNormal);
        Map existSonUserRoleMap = this.getUserRoleMapByOrgID(ctx, orgPK, isNormal);
        Map netAddUserRoleMap = this.removeUsers(parentUserRoleMap, deletedUsers);
        netAddUserRoleMap = this.substractMap(netAddUserRoleMap, existSonUserRoleMap);
        netAddUserRoleMap = this.substractMap(netAddUserRoleMap, deletedUserRoleMap);
        netAddUserRoleMap = this.unionMap(netAddUserRoleMap, addedUserRoleMap);
        this.insertUserRoles(ctx, orgPK, netAddUserRoleMap, isNormal);
    }

    private void insertUserRoles(Context ctx, IObjectPK orgPK, Map userRoleMap, boolean isNormal) throws BOSException, EASBizException {
        String table = this.getUserRoleOrgTable(isNormal);
        String sql = "insert into " + table + " (fuserid,forgid,froleid) values(?,?,?)";
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            Iterator itr = userRoleMap.keySet().iterator();
            int index = 0;
            while (itr.hasNext()) {
                String userId = (String)itr.next();
                Collection roles = (Collection)userRoleMap.get(userId);
                Iterator roleItr = roles.iterator();
                while (roleItr.hasNext()) {
                    ++index;
                    String roleId = (String)roleItr.next();
                    ps.setString(1, userId);
                    ps.setString(2, orgPK.toString());
                    ps.setString(3, roleId);
                    ps.addBatch();
                    if (index % 2000 != 0) continue;
                    ps.executeBatch();
                }
            }
            ps.executeBatch();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"insertUserRoles", (Throwable)se);
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private Map removeUsers(Map parentUserRoleMap, Set deletedUsers) {
        Iterator itr = deletedUsers.iterator();
        while (itr.hasNext()) {
            parentUserRoleMap.remove(itr.next());
        }
        return parentUserRoleMap;
    }

    private Map substractMap(Map m1, Map m2) {
        for (Object key : m2.keySet()) {
            if (!m1.containsKey(key)) continue;
            Collection c1 = (Collection)m1.get(key);
            Collection c2 = (Collection)m2.get(key);
            Collection c3 = CollectionUtils.subtract((Collection)c1, (Collection)c2);
            m1.put(key, c3);
        }
        return m1;
    }

    private Map unionMap(Map m1, Map m2) {
        for (Object key : m2.keySet()) {
            if (!m1.containsKey(key)) continue;
            Collection c1 = (Collection)m1.get(key);
            Collection c2 = (Collection)m2.get(key);
            Collection c3 = CollectionUtils.union((Collection)c1, (Collection)c2);
            m1.put(key, c3);
        }
        return m1;
    }

    private Map getUserRoleMapByOrgID(Context ctx, IObjectPK orgPK, boolean isNormal) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        String table = this.getUserRoleOrgTable(isNormal);
        String sql = "select fuserid,froleid from " + table + " where forgid='" + orgPK + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                Set<String> roles;
                String userId = rs.getString("fuserid");
                String roleId = rs.getString("froleid");
                if (ret.containsKey(userId)) {
                    roles = (Set)ret.get(userId);
                    roles.add(roleId);
                    continue;
                }
                roles = new HashSet();
                roles.add(roleId);
                ret.put(userId, roles);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getUserRoleMapByOrgID", (Throwable)e);
        }
        return ret;
    }

    @Override
    protected void _changeSubOrgsRoles(Context ctx, RoleChangeInfo roleChangeInfo) throws BOSException, EASBizException {
        IObjectPK orgPK = roleChangeInfo.getOrgPK();
        IObjectPK userPK = roleChangeInfo.getUserPK();
        Collection addedRoleCol = roleChangeInfo.getAddedRoleCol();
        Collection deletedRoleCol = roleChangeInfo.getDeletedRoleCol();
        Collection addedGrantRoleCol = roleChangeInfo.getAddedGrantRoleCol();
        Collection deletedGrantRoleCol = roleChangeInfo.getDeletedGrantRoleCol();
        UserPermChangeListener userPermChangeListener = new UserPermChangeListener(ctx, userPK.toString(), EASResource.getString((String)RESOURCE, (String)"UPDATE_SUBORG_USERROLE"));
        userPermChangeListener.before();
        Collection subOrgIdCol = this.getSubOrgId(ctx, orgPK, userPK);
        this.insertUserOrgRoles(ctx, subOrgIdCol, userPK, addedRoleCol, true);
        this.insertUserOrgRoles(ctx, subOrgIdCol, userPK, addedGrantRoleCol, false);
        this.deleteUserOrgRoles(ctx, subOrgIdCol, userPK, deletedRoleCol, true);
        this.deleteUserOrgRoles(ctx, subOrgIdCol, userPK, deletedGrantRoleCol, false);
        userPermChangeListener.after();
        this.removeCtx(ctx);
    }

    private void removeCtx(Context ctx) {
        ctx.remove((Object)"assignType");
        ctx.remove((Object)"permChangeId");
        ctx.remove((Object)"grantPermChangeId");
    }

    private Collection getSubOrgId(Context ctx, IObjectPK orgPK, IObjectPK userPK) throws BOSException, EASBizException {
        HashSet<IObjectPK> userPKCol = new HashSet<IObjectPK>();
        userPKCol.add(userPK);
        Map userSubOrgIdMap = this.getUserSubOrgIdMap(ctx, orgPK, userPKCol);
        return (Collection)userSubOrgIdMap.get(userPK.toString());
    }

    private Map getUserSubOrgIdMap(Context ctx, IObjectPK orgPK, Collection userPKCol) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(orgPK);
        String longNumber = orgInfo.getLongNumber();
        String sql = "select a.forgid,a.fuserid from t_pm_orgrange a join t_org_baseunit b on a.forgid=b.fid where a.fuserid in ({0})  and b.flongnumber like ''{1}!%''";
        String userPKs = ToolUtils.aryToStr(userPKCol);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)MessageFormat.format(sql, userPKs, longNumber));
        try {
            while (rs.next()) {
                String userId = rs.getString("fuserid");
                String orgId = rs.getString("forgid");
                Collection<String> orgCol = new HashSet<String>();
                if (ret.containsKey(userId)) {
                    orgCol = (Collection)ret.get(userId);
                }
                orgCol.add(orgId);
                ret.put(userId, orgCol);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getSubOrgIdCol", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private String[] getLongNumbers(Context ctx, Collection orgIds) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIds, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("longNumber"));
        view.setFilter(filter);
        FullOrgUnitCollection orgCol = null;
        try {
            orgCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        String[] longNumbers = new String[orgCol.size()];
        for (int i = 0; i < longNumbers.length; ++i) {
            longNumbers[i] = orgCol.get(i).getLongNumber();
        }
        return longNumbers;
    }

    private Map getUserSubOrgIdMap(Context ctx, Map userOrgsMap) throws BOSException, EASBizException {
        if (userOrgsMap == null || userOrgsMap.size() < 1) {
            return new HashMap();
        }
        HashMap ret = new HashMap();
        Iterator userItr = userOrgsMap.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        sb.append("select a.forgid,a.fuserid from t_pm_orgrange a join t_org_baseunit b on a.forgid=b.fid where ");
        while (userItr.hasNext()) {
            String userId = (String)userItr.next();
            Collection orgIdCol = (Collection)userOrgsMap.get(userId);
            String[] longNumbers = this.getLongNumbers(ctx, orgIdCol);
            if (longNumbers.length < 1) continue;
            sb.append(" a.fuserid ='").append(userId).append("' and (");
            for (int i = 0; i < longNumbers.length; ++i) {
                sb.append(" b.flongnumber like '").append(longNumbers[i]).append("!%' ");
                if (i >= longNumbers.length - 1) continue;
                sb.append(" or ");
            }
            sb.append(")");
            if (!userItr.hasNext()) continue;
            sb.append(" or ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String userId = rs.getString("fuserid");
                String orgId = rs.getString("forgid");
                Collection<String> orgCol = new HashSet<String>();
                if (ret.containsKey(userId)) {
                    orgCol = (Collection)ret.get(userId);
                }
                orgCol.add(orgId);
                ret.put(userId, orgCol);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getSubOrgIdCol", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private void insertUserOrgRoles(Context ctx, Collection orgIdCol, IObjectPK userPK, Collection roleCol, boolean isNormal) throws BOSException, EASBizException {
        List newUserRoleOrgList = this.getUserRoleOrgList(orgIdCol, userPK, roleCol);
        List existUserRoleOrgList = this.getExistUserRoleOrgList(ctx, orgIdCol, userPK, roleCol, isNormal);
        Collection addedUserRoleOrgList = CollectionUtils.subtract((Collection)newUserRoleOrgList, (Collection)existUserRoleOrgList);
        this.insertUserOrgRoles(ctx, addedUserRoleOrgList, isNormal, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertUserOrgRoles(Context ctx, Collection addedUserRoleOrgList, boolean isNormal, String permChangeId) throws BOSException, EASBizException {
        PreparedStatement ps;
        Connection con;
        block10: {
            String table = this.getUserRoleOrgTable(isNormal);
            String assignType = (String)ctx.get((Object)"assignType");
            if (!StringUtils.isEmpty((String)assignType) && StringUtils.isEmpty((String)permChangeId)) {
                permChangeId = this.getPermChangeId(ctx, isNormal);
            }
            if (permChangeId != null && !permChangeId.equals("")) {
                Iterator itr = addedUserRoleOrgList.iterator();
                if (!itr.hasNext()) return;
                SimpleUserRoleOrg info = (SimpleUserRoleOrg)itr.next();
                RoleInfo roleInfo = RoleFactory.getLocalInstance(ctx).getRoleInfo((IObjectPK)new ObjectUuidPK(info.getRoleId()));
                RolePermCollection rolePermColl = RolePermFactory.getLocalInstance(ctx).getRolePermCollection("select PermItem where role ='" + roleInfo.getId().toString() + "' ");
                ArrayList<String> permitemIdList = new ArrayList<String>();
                for (int i = 0; i < rolePermColl.size(); ++i) {
                    permitemIdList.add(rolePermColl.get(i).getPermItem().getId().toString());
                }
                if (!isNormal) return;
                String sql = "insert into t_pm_userroleorgchange (fid,FRoleID,FUserID,FOrgID,FAssignType,FAuthenStatus,FPermChangeId) values (newbosid('013DCF9F'),?,?,?,?,?,?)";
                for (SimpleUserRoleOrg simpleUserInfo : addedUserRoleOrgList) {
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{simpleUserInfo.getRoleId().toString(), simpleUserInfo.getUserId().toString(), simpleUserInfo.getOrgId().toString(), "10", "10", permChangeId});
                }
                return;
            }
            String tempTableName = null;
            TableManager tableManager = null;
            Iterator itr = addedUserRoleOrgList.iterator();
            con = null;
            ps = null;
            int i = 0;
            try {
                tableManager = TableManager.getTableManager((Context)ctx);
                tempTableName = tableManager.getTableName("inheritPerm");
                String createSql = "create table " + tempTableName + "(fuserid varchar(44),forgid varchar(44),froleid varchar(44) )";
                tableManager.createTable(createSql);
                String insertTempSql = " insert into " + tempTableName + " (fuserid,forgid,froleid) values(?,?,?)";
                con = this.getConnection(ctx);
                ps = con.prepareStatement(insertTempSql);
                while (itr.hasNext()) {
                    SimpleUserRoleOrg info = (SimpleUserRoleOrg)itr.next();
                    String orgId = info.getOrgId();
                    String roleId = info.getRoleId();
                    String userId = info.getUserId();
                    ps.setString(1, userId);
                    ps.setString(2, orgId);
                    ps.setString(3, roleId);
                    ps.addBatch();
                    if (++i % 2000 != 0) continue;
                    ps.executeBatch();
                }
                ps.executeBatch();
                String sql = " insert into " + table + " (fuserid,forgid,froleid) select fuserid,forgid,froleid from " + tempTableName + " temp where not exists (select 1 from " + table + " where fuserid=temp.fuserid and forgid=temp.forgid and froleid=temp.froleid)";
                DbUtil.execute((Context)ctx, (String)sql);
                if (tableManager == null || tempTableName == null) break block10;
            }
            catch (Exception se) {
                try {
                    logger.error((Object)"insertUserOrgRoles", (Throwable)se);
                    throw new BOSException((Throwable)se);
                }
                catch (Throwable throwable) {
                    if (tableManager != null && tempTableName != null) {
                        tableManager.releaseTable(tempTableName);
                    }
                    SQLUtils.cleanup(ps, con);
                    throw throwable;
                }
            }
            tableManager.releaseTable(tempTableName);
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return;
    }

    private List getExistUserRoleOrgList(Context ctx, Collection orgIdCol, IObjectPK userPK, Collection roleCol, boolean isNormal) throws BOSException, EASBizException {
        HashMap<String, Collection> userOrgIdColMap = new HashMap<String, Collection>();
        userOrgIdColMap.put(userPK.toString(), orgIdCol);
        return this.getExistUserRoleOrgList(ctx, userOrgIdColMap, roleCol, isNormal);
    }

    private List getExistUserRoleOrgList(Context ctx, Map userOrgIdColMap, Collection roleCol, boolean isNormal) throws BOSException, EASBizException {
        if (userOrgIdColMap == null || userOrgIdColMap.size() < 1) {
            return new ArrayList();
        }
        ArrayList<SimpleUserRoleOrg> ret = new ArrayList<SimpleUserRoleOrg>();
        String table = this.getUserRoleOrgTable(isNormal);
        String roleIds = ToolUtils.aryToStr(roleCol);
        StringBuffer sb = new StringBuffer();
        sb.append("select fuserid,forgid,froleid from ").append(table).append(" where froleid in (").append(roleIds).append(")").append(" and (");
        Iterator userItr = userOrgIdColMap.keySet().iterator();
        while (userItr.hasNext()) {
            String userId = (String)userItr.next();
            Collection orgIdCol = (Collection)userOrgIdColMap.get(userId);
            String orgIds = ToolUtils.aryToStr(orgIdCol);
            sb.append(" fuserid = '").append(userId).append("' and forgid in (").append(orgIds).append(")");
            if (!userItr.hasNext()) continue;
            sb.append(" or ");
        }
        sb.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String orgId = rs.getString("forgid");
                String roleId = rs.getString("froleid");
                String userId = rs.getString("fuserid");
                SimpleUserRoleOrg info = new SimpleUserRoleOrg();
                info.setUserId(userId);
                info.setOrgId(orgId);
                info.setRoleId(roleId);
                ret.add(info);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getExistUserRoleOrgList", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private List getUserRoleOrgList(Collection orgIdCol, IObjectPK userPK, Collection roleCol) {
        HashMap<String, Collection> userOrgPKColMap = new HashMap<String, Collection>();
        userOrgPKColMap.put(userPK.toString(), orgIdCol);
        return this.getUserRoleOrgList(userOrgPKColMap, roleCol);
    }

    private List getUserRoleOrgList(Map userOrgPKColMap, Collection roleCol) {
        ArrayList<SimpleUserRoleOrg> ret = new ArrayList<SimpleUserRoleOrg>();
        for (String userId : userOrgPKColMap.keySet()) {
            Collection orgIdCol = (Collection)userOrgPKColMap.get(userId);
            if (orgIdCol == null) continue;
            Iterator orgItr = orgIdCol.iterator();
            while (orgItr.hasNext()) {
                String orgId = orgItr.next().toString();
                for (String roleId : roleCol) {
                    SimpleUserRoleOrg info = new SimpleUserRoleOrg();
                    info.setUserId(userId);
                    info.setRoleId(roleId);
                    info.setOrgId(orgId);
                    ret.add(info);
                }
            }
        }
        return ret;
    }

    private void deleteUserOrgRoles(Context ctx, Collection orgIdCol, IObjectPK userPK, Collection roleCol, boolean isNormal) throws BOSException, EASBizException {
        String assignType = (String)ctx.get((Object)"assignType");
        String permChangeId = null;
        if (!StringUtils.isEmpty((String)assignType)) {
            permChangeId = this.getPermChangeId(ctx, isNormal);
        }
        String orgIds = ToolUtils.aryToStr(orgIdCol);
        String roleIds = ToolUtils.aryToStr(roleCol);
        if (!StringUtils.isEmpty((String)permChangeId)) {
            String tblName = null;
            String changeTblName = null;
            if (isNormal) {
                tblName = "t_pm_UserRoleOrg";
                changeTblName = "t_pm_UserRoleOrgChange";
            } else {
                tblName = "t_pm_GrantUserRoleOrg";
                changeTblName = "t_pm_GrantUserRoleOrgChange";
            }
            String sql = "insert into " + changeTblName + " (fid,FRoleID,FUserID,FOrgID,FAssignType,FAuthenStatus,FPermChangeId) select newbosid('013DCF9F'),froleid,fuserid,forgid,'" + "20" + "','" + "10" + "','" + permChangeId + "' from " + tblName + " tbl where fuserid= ? and forgid in(" + orgIds + ") and froleid in(" + roleIds + ") and exists(select 1 from T_PM_PermAuthentor pm inner join t_pm_roleperm rp on pm.fpermitemid = rp.fpermitemid where rp.froleid = tbl.froleid)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userPK.toString()});
            String table = this.getUserRoleOrgTable(isNormal);
            sql = "delete from " + table + " where fuserid=''{0}'' and forgid in ({1}) and froleid in ({2}) and  not exists (select 1 from T_PM_PermAuthentor pm inner join t_pm_roleperm rp on pm.fpermitemid = rp.fpermitemid where rp.froleid = " + table + ".froleid)";
            Object[] args = new String[]{userPK.toString(), orgIds, roleIds};
            DbUtil.execute((Context)ctx, (String)MessageFormat.format(sql, args));
        } else {
            String table = this.getUserRoleOrgTable(isNormal);
            String sql = "delete from {0} where fuserid=''{1}'' and forgid in ({2}) and froleid in ({3})";
            Object[] args = new String[]{table, userPK.toString(), orgIds, roleIds};
            DbUtil.execute((Context)ctx, (String)MessageFormat.format(sql, args));
        }
    }

    private String getUserRoleOrgTable(boolean isNormal) {
        return isNormal ? "t_pm_userroleorg" : "t_pm_grantuserroleorg";
    }

    protected void _deleteUserSubOrgsRoles(Context ctx, Map userOrgsMap, IObjectPK rolePK, String permChangeId) throws BOSException, EASBizException {
        Map userSubOrgsMap = this.getUserSubOrgIdMap(ctx, userOrgsMap);
        if (userSubOrgsMap.size() < 1) {
            return;
        }
        if (!StringUtils.isEmpty((String)permChangeId)) {
            for (String userId : userSubOrgsMap.keySet()) {
                Collection orgIdCol = (Collection)userSubOrgsMap.get(userId);
                for (String orgId : orgIdCol) {
                    BOSObjectType bosObjectType = new BOSObjectType("AB724BE5");
                    String fid = BOSUuid.create((BOSObjectType)bosObjectType).toString();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("select * from T_PM_UserRoleOrgChange where fuserid =? and froleid = ? ").append("and FOrgID = ? and FASSIGNTYPE =? and FAUTHENSTATUS = ? and FPERMCHANGEID = ? ");
                    IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{userId, rolePK.toString(), orgId, "20", "10", permChangeId});
                    try {
                        if (rowset.next()) continue;
                        buffer = new StringBuffer();
                        buffer.append("INSERT INTO T_PM_UserRoleOrgChange(FID,FASSIGNTYPE,FUserID,FRoleID,FOrgID,FAUTHENSTATUS,FPERMCHANGEID)").append(" VALUES(?,?,?,?,?,?,?)");
                        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{fid, "20", userId, rolePK.toString(), orgId, "10", permChangeId});
                    }
                    catch (SQLException e) {
                        logger.error((Object)"addOtherUser", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("delete from t_pm_userroleorg where froleid='").append(rolePK.toString()).append("' and (");
            Iterator userItr = userSubOrgsMap.keySet().iterator();
            while (userItr.hasNext()) {
                String userId = (String)userItr.next();
                sb.append(" fuserid='").append(userId).append("' and ");
                Collection orgIdCol = (Collection)userSubOrgsMap.get(userId);
                if (orgIdCol.size() < 1) {
                    sb.append(" forgid='' ");
                } else {
                    sb.append(" forgid in (").append(ToolUtils.aryToStr(orgIdCol)).append(") ");
                }
                if (!userItr.hasNext()) continue;
                sb.append(" or ");
            }
            sb.append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    protected boolean _isRoleIncludeAuthenperm(Context ctx, RoleInfo roleInfo) throws BOSException, EASBizException {
        boolean isIncludeAuthenPerm = false;
        String sqlStr = "select 1 from t_pm_role r inner join t_pm_roleperm rp on r.fid = rp.froleid where r.fid = ? and exists (select 1 from t_pm_permauthentor pa where pa.fpermitemid = rp.fpermitemid)";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])new Object[]{roleInfo.getId().toString()});
        try {
            if (rowSet.next()) {
                isIncludeAuthenPerm = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.toString());
            throw new BOSException((Throwable)e);
        }
        return isIncludeAuthenPerm;
    }

    protected void _addUsersSubOrgRole(Context ctx, Collection userPKCol, IObjectPK orgPK, IObjectPK rolePK, String permChangeId) throws BOSException, EASBizException {
        Map userOrgPKColMap = this.getUserSubOrgIdMap(ctx, orgPK, userPKCol);
        HashSet<String> roleCol = new HashSet<String>();
        roleCol.add(rolePK.toString());
        List newUserRoleOrgCol = this.getUserRoleOrgList(userOrgPKColMap, roleCol);
        List existUserRoleOrgCol = this.getExistUserRoleOrgList(ctx, userOrgPKColMap, roleCol, true);
        Collection netAddUserRoleOrgCol = CollectionUtils.subtract((Collection)newUserRoleOrgCol, (Collection)existUserRoleOrgCol);
        this.insertUserOrgRoles(ctx, netAddUserRoleOrgCol, true, permChangeId);
    }

    protected void _insertAuthenRecord(Context ctx, String permChangeId, RoleInfo roleInfo) throws BOSException, EASBizException {
        RolePermCollection rolePermColl = RolePermFactory.getLocalInstance(ctx).getRolePermCollection("select permitem where role = '" + roleInfo.getId().toString() + "'");
        ArrayList<String> permitemIdList = new ArrayList<String>();
        for (int i = 0; i < rolePermColl.size(); ++i) {
            permitemIdList.add(rolePermColl.get(i).getPermItem().getId().toString());
        }
        String permitemIds = ToolUtils.aryToStr(permitemIdList);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_AuthenRecord(FAuthentorID,FID,FPermChangeID,FAuthenStatus) ");
        sql.append("select FAuthentorID,newbosid('8F704622'),'" + permChangeId + "','" + "10" + "' ");
        sql.append("from t_pm_permAuthentor where FPermitemID in (" + permitemIds + ") group by FAuthentorID ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("select top 1 fpermitemid from t_pm_permAuthentor where FPermitemID in (" + permitemIds + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage((IObjectPK)new ObjectUuidPK(permChangeId));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _addAuthenUserOrgRole(Context ctx, UserRoleOrgInfo userRoleOrg, String permChange) throws BOSException, EASBizException {
        String sql = "insert into t_pm_userroleorgchange (fid,FRoleID,FUserID,FOrgID,FAssignType,FAuthenStatus,FPermChangeId) values (newbosid('013DCF9F'),?,?,?,?,?,?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userRoleOrg.getRole().getId().toString(), userRoleOrg.getUser().getId().toString(), userRoleOrg.getOrg().getId().toString(), "10", "10", permChange});
    }

    protected void _insertAuthenRecord(Context ctx, String permChangeId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_AuthenRecord(FAuthentorID,FID,FPermChangeID,FAuthenStatus) ");
        sql.append("values('00000000-0000-0000-0000-00000000000113B7DE7F',newbosid('8F704622'),'" + permChangeId + "','" + "10" + "') ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getPermChangeId(Context ctx, boolean isNormal) {
        String permChangeId = null;
        permChangeId = isNormal ? (String)ctx.get((Object)"permChangeId") : (String)ctx.get((Object)"grantPermChangeId");
        return permChangeId;
    }

    @Override
    protected void _addUsersSubOrgRole(Context ctx, Collection userPKCol, IObjectPK orgPK, IObjectPK rolePK) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteUserSubOrgsRoles(Context ctx, Map userOrgsMap, IObjectPK rolePK) throws BOSException, EASBizException {
    }
}

