/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermUIGroupMappingFactory;
import com.kingdee.eas.base.permission.PermUIGroupMappingInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractPermUIGroupMappingControllerBean;
import com.kingdee.eas.base.permission.util.cloud.ShrCloud;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermUIGroupMappingControllerBean
extends AbstractPermUIGroupMappingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.PermUIGroupMappingControllerBean");

    @Override
    protected void _generatePermItemUIGroupTable(Context ctx) throws BOSException, EASBizException {
        CoreBaseCollection coll = this.assemblePermUIGroupMappingCollection(ctx);
        PermUIGroupMappingFactory.getLocalInstance(ctx).saveBatchData(coll);
    }

    @Override
    protected void _clearPermItemUIGroupTableData(Context ctx) throws BOSException, EASBizException {
        String sql = "delete from T_PM_PermUIGroupMapping";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _reGeneratePermItemUIGroupTable(Context ctx) throws BOSException, EASBizException {
        this._clearPermItemUIGroupTableData(ctx);
        this._generatePermItemUIGroupTable(ctx);
    }

    private CoreBaseCollection assemblePermUIGroupMappingCollection(Context ctx) throws BOSException, EASBizException {
        Map<String, String> uiGroupMap = ShrCloud.readLicenseUIDetailTable(ctx);
        return this.doAssemblePermUIGroupMappingCollection(ctx, uiGroupMap);
    }

    private CoreBaseCollection doAssemblePermUIGroupMappingCollection(Context ctx, Map<String, String> uiGroupMap) throws BOSException, EASBizException {
        IRowSet rowSet = this.getPermItemRowSet(ctx);
        CoreBaseCollection coll = new CoreBaseCollection();
        try {
            while (rowSet.next()) {
                String permItemId = rowSet.getString("fid");
                String uiPk = this.parsePermItemUrlToUipk(rowSet.getString("furl"));
                String group = uiGroupMap.get(uiPk);
                if (StringUtils.isEmpty((String)group)) continue;
                coll.add((CoreBaseInfo)this.createPermUIGroupMappingInfo(ctx, permItemId, group));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return coll;
    }

    private PermUIGroupMappingInfo createPermUIGroupMappingInfo(Context ctx, String permItemId, String group) throws BOSException {
        PermUIGroupMappingInfo permUIGroupMappingInfo = new PermUIGroupMappingInfo();
        permUIGroupMappingInfo.setPermItem(this.createPermItemInfo(permItemId));
        permUIGroupMappingInfo.setGroup(group);
        permUIGroupMappingInfo.setLastUpdateTime(this.getTime());
        permUIGroupMappingInfo.setCreateTime(this.getTime());
        permUIGroupMappingInfo.setLastUpdateUser(this.getUserInfo(ctx));
        return permUIGroupMappingInfo;
    }

    private PermItemInfo createPermItemInfo(String permItemId) {
        PermItemInfo permItemInfo = new PermItemInfo();
        permItemInfo.setId(BOSUuid.read((String)permItemId));
        return permItemInfo;
    }

    private IRowSet getPermItemRowSet(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select permItem.fid ,permItem.falias_l2,permItemUrl.furl as furl,permItemUrl.fname ");
        sql.append(" from T_PM_PermItem permItem ");
        sql.append(" inner join T_PM_PermItemUrl permItemUrl on permItem.fid = permItemUrl.fparentid ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private String parsePermItemUrlToUipk(String permItemUrl) {
        int lastEQPos = permItemUrl.lastIndexOf("=");
        return permItemUrl.substring(lastEQPos + 1).trim();
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

