/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.session.template.AbstractLoginModule;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.strategy.IPasswordVerifyStrategy;
import com.kingdee.eas.base.permission.app.strategy.PasswordVerifyStrategy;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.base.permission.util.PermissionOrgTypeUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class PermissionLoginModule
extends AbstractLoginModule {
    private static Logger logger = Logger.getLogger(PermissionLoginModule.class);

    public void _setUserPK(UserContextCallback userCtxCallback, String userNumber) throws Exception {
        this.checkUserNumberSpelling(userNumber);
        this.setContext(userCtxCallback, userNumber);
    }

    private void setContext(UserContextCallback userCtxCallback, String userNumber) throws EASBizException, UnknownHostException, BOSException {
        Context ctx = userCtxCallback.getUserContext();
        userCtxCallback.setUserPK((IObjectPK)new ObjectUuidPK());
        UserInfo userInfo = UserInfoUtils.getUserInfo4LoinModule(ctx, userNumber);
        if (userInfo == null) {
            throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
        }
        if (userInfo.getDefOrgUnit() == null) {
            throw new UserException(UserException.USER_HAS_NOT_DEF_ORG);
        }
        if (userInfo.getDefOrgUnit() != null && !PermissionOrgTypeUtils.isCanBeDefOrg(userInfo.getDefOrgUnit())) {
            throw new UserException(UserException.DEF_ORG_IS_BAD);
        }
        if (userInfo.getCU() == null || StringUtils.isEmpty((String)userInfo.getCU().getNumber())) {
            throw new UserException(UserException.CTRL_UNIT_ERROR);
        }
        if (userInfo.isIsForbidden()) {
            throw new UserException(UserException.USER_BEEN_FORBIDDEN);
        }
        if (userInfo.isIsDelete()) {
            throw new UserException(UserException.USER_BEEN_DELETE);
        }
        this.initUserInfo(userCtxCallback, userInfo);
    }

    private void initUserInfo(UserContextCallback userCtxCallback, UserInfo userInfo) {
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        userCtxCallback.setUserPK((IObjectPK)userPK);
        ContextUtil.setCurrentUserInfo((Context)userCtxCallback.getUserContext(), (UserInfo)userInfo);
        ContextUtil.setCurrentCtrlUnit((Context)userCtxCallback.getUserContext(), (CtrlUnitInfo)userInfo.getCU());
    }

    private void updateOrgRange(UserContextCallback userCtxCallback, Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        OrgRangeIncludeSubOrgFactory.getLocalInstance(ctx).updateOrgRange(userInfo.getId().toString());
    }

    private void checkUserCertify(Context ctx, UserInfo userInfo) throws UserException {
        if (PermissionCommonUtil.isAuthenticateAdminEnabled(ctx) && !userInfo.isIsRegister() && !Administrator.isSuperCertifyAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            throw new UserException(UserException.USER_NOT_CERTIFY);
        }
    }

    private void checkUserNumberSpelling(String userNumber) throws EASBizException {
        if (StringUtils.isEmpty((String)userNumber)) {
            throw new UserException(UserException.NUMBER_NOT_NULL);
        }
        if (!StringUtils.isEmpty((String)userNumber) && userNumber.indexOf("'") != -1) {
            throw new UserException(UserException.NUMBER_INCLUDE_FORBIDDEN_CHAR);
        }
    }

    public boolean _verifyUserAndPassword(UserContextCallback userCtxCallback, String userNumber, String password) throws Exception {
        Context ctx = userCtxCallback.getUserContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        this.checkUserCertify(ctx, userInfo);
        IPasswordVerifyStrategy strategy = PasswordVerifyStrategy.getStrategy(userInfo.getLoginAuthorWay());
        return strategy.authenticate(userCtxCallback, userNumber, password);
    }
}

