/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.RoleGroupCollection;
import com.kingdee.eas.base.permission.RoleGroupInfo;
import com.kingdee.eas.base.permission.app.AbstractRoleGroupControllerBean;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RoleGroupControllerBean
extends AbstractRoleGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.RoleGroupControllerBean");
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    protected void _removeGroup(Context ctx, List groupList) throws BOSException, EASBizException {
        RoleGroupCollection roleGroupColl = this.getRoleGroupCollection(ctx, "select number,name where id in (" + ToolUtils.aryToStr(groupList) + ")");
        if (roleGroupColl.size() == 0) {
            return;
        }
        StringBuilder logDetail = new StringBuilder();
        for (int i = 0; i < roleGroupColl.size(); ++i) {
            RoleGroupInfo roleGroupInfo = roleGroupColl.get(i);
            logDetail.append(roleGroupInfo.getNumber()).append(" ").append(roleGroupInfo.getName()).append(i == roleGroupColl.size() - 1 ? "" : ",");
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"DELETE_ROLEGROUP"), (BOSObjectType)roleGroupColl.get(0).getBOSType(), null, (String)logDetail.toString(), (String)"bs_permission_role_group_delete");
        String deleteSQL = "delete from T_PM_RoleGroup where fid in (" + ToolUtils.aryToStr(groupList) + ")";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected boolean _isExistRecord(Context ctx, List groupList) throws BOSException, EASBizException {
        String selectSQL = "select 1 from T_PM_Role where fgroupid in (" + ToolUtils.aryToStr(groupList) + ")";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void _deleteLeaf(Context ctx, List groupIds) throws BOSException, EASBizException {
        ArrayList<String> groupIDList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_PM_RoleGroup where ");
        for (Object group : groupIds) {
            if (!(group instanceof RoleGroupInfo)) continue;
            groupIDList.add(((RoleGroupInfo)group).getId().toString());
            sql.append("flongnumber like '" + this.getLongNumber(ctx, ((RoleGroupInfo)group).getId().toString()) + "!%'");
        }
        String leafSQL = "update T_PM_RoleGroup set fisleaf = '1' where fid in (" + ToolUtils.aryToStr(groupIDList) + ") and not exists(" + sql + ")";
        DbUtil.execute((Context)ctx, (String)leafSQL);
    }

    private String getLongNumber(Context ctx, String id) throws BOSException {
        String sql = "select flongnumber from T_PM_RoleGroup where fid ='" + id + "'";
        String longNumber = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                longNumber = rs.getString("flongnumber");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return longNumber;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RoleGroupInfo roleGroupInfo = this.getRoleGroupInfo(ctx, pk);
        RoleGroupInfo newValue = (RoleGroupInfo)model;
        boolean isNotWriteLog = roleGroupInfo.getName().equals(newValue.getName()) && roleGroupInfo.getNumber().equals(newValue.getNumber());
        IObjectPK logPK = null;
        if (!isNotWriteLog) {
            logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"UPDATE_USERGROUP"), (BOSObjectType)model.getBOSType(), null, (String)this.getUpdateLogDetail(newValue, roleGroupInfo), (String)"bs_permission_role_group_update");
        }
        super._update(ctx, pk, model);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, logPK);
        }
    }

    private String getUpdateLogDetail(RoleGroupInfo model, RoleGroupInfo roleGroupInfo) {
        StringBuilder logDetailSb = new StringBuilder();
        try {
            logDetailSb.append(EASResource.getString((String)RESOURCE, (String)"roleGroup") + ": ").append(roleGroupInfo.getNumber()).append(" ").append(roleGroupInfo.getName());
            logDetailSb.append(EASResource.getString((String)RESOURCE, (String)"UPDATE_TO") + " : ").append(model.getNumber()).append(" ").append(model.getName());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return logDetailSb.toString();
    }

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)RESOURCE, (String)"MOVE_ROLEGROUP"), (BOSObjectType)sourceNode.getBOSType(), null, (String)this.getMoveNodeLogDetail((RoleGroupInfo)sourceNode, (RoleGroupInfo)targetNode), (String)"bs_permission_role_group_move");
        super._moveTreeNode(ctx, sourceNode, targetNode);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private String getMoveNodeLogDetail(RoleGroupInfo sourceNode, RoleGroupInfo targetNode) {
        StringBuilder logDetailSb = new StringBuilder();
        try {
            logDetailSb.append(EASResource.getString((String)RESOURCE, (String)"MOVE_ROLEGROUP") + ": ").append(sourceNode.getNumber()).append(" ").append(sourceNode.getName());
            logDetailSb.append("; " + EASResource.getString((String)RESOURCE, (String)"NEW_SUPER") + ": ");
            if (targetNode == null) {
                logDetailSb.append(EASResource.getString((String)RESOURCE, (String)"roleGroup"));
            } else {
                logDetailSb.append(targetNode.getNumber()).append(" ").append(targetNode.getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return logDetailSb.toString();
    }
}

