/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.ComMenuFunctionFactory;
import com.kingdee.eas.base.myeas.IComMenuFunction;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractRoleMenuFacadeControllerBean;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.TempMainMenuItemInfo;
import com.kingdee.eas.base.uiframe.app.MainMenuQuickHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RoleMenuFacadeControllerBean
extends AbstractRoleMenuFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.RoleMenuFacadeControllerBean");

    @Override
    protected MainMenuItemCollection _getAccreditMenuColByRoleId(Context ctx, String roleId) throws BOSException {
        Set<MainMenuItemInfo> accreditMenuSet = this.getAccreditMenuCol(ctx, roleId);
        Set<String> superAndMeLongNumberSet = this.getSuperAndMeLongNumberSet(accreditMenuSet);
        String longNumbers = ToolUtils.aryToStr(superAndMeLongNumberSet);
        IMainMenuItem iMainMenuItem = MainMenuItemFactory.getLocalInstance(ctx);
        String oql = "select id,name,number,isLeaf,longNumber,order,enable,parent.id where longNumber in (" + longNumbers + ")";
        MainMenuItemCollection ret = iMainMenuItem.getMainMenuItemCollection(oql);
        return ret;
    }

    private Set<String> getSuperAndMeLongNumberSet(Set<MainMenuItemInfo> menuSet) {
        HashSet<String> ret = new HashSet<String>();
        String longNumber = null;
        Iterator<MainMenuItemInfo> itr = menuSet.iterator();
        while (itr.hasNext()) {
            longNumber = itr.next().getLongNumber();
            ret.addAll(this.getSuperAndMeLongNumberSet(longNumber));
        }
        return ret;
    }

    private Set<String> getSuperAndMeLongNumberSet(String longNumber) {
        HashSet<String> ret = new HashSet<String>();
        int len = longNumber.length();
        for (int i = 0; i < len; ++i) {
            if ('!' != longNumber.charAt(i)) continue;
            ret.add(longNumber.substring(0, i));
        }
        ret.add(longNumber);
        return ret;
    }

    private Set<MainMenuItemInfo> getAccreditMenuCol(Context ctx, String roleId) throws BOSException {
        String sql = "select fid,flongnumber from t_pm_mainmenuitem where fid in ( select FMainMenuItemID from T_PM_RoleMainMenuItem where FRoleID = ?)";
        HashSet<MainMenuItemInfo> ret = new HashSet<MainMenuItemInfo>();
        try {
            Object[] params = new Object[]{roleId};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            MainMenuItemInfo info = null;
            while (rs.next()) {
                info = new MainMenuItemInfo();
                BOSUuid id = BOSUuid.read((String)rs.getString("fid"));
                info.setId(id);
                String longNumber = rs.getString("flongnumber");
                info.setLongNumber(longNumber);
                ret.add(info);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private Set<UserInfo> getUserSetByRole(Context ctx, String roleId) throws BOSException {
        HashSet<String> roleIdSet = new HashSet<String>();
        roleIdSet.add(roleId);
        return this.getUserSetByRoles(ctx, roleIdSet);
    }

    private Set<UserInfo> getUserSetByRoles(Context ctx, Set<String> roleIdSet) throws BOSException {
        String sql = "select fid ,fnumber from t_pm_user where fid in  (select distinct fuserid from t_pm_userroleorg where froleid in(" + ToolUtils.aryToStr(roleIdSet) + "))";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<UserInfo> userSet = new HashSet<UserInfo>();
        try {
            UserInfo user = null;
            while (rs.next()) {
                user = new UserInfo();
                user.setId(BOSUuid.read((String)rs.getString("fid")));
                user.setNumber(rs.getString("fnumber"));
                userSet.add(user);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return userSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _saveRoleMenu(Context ctx, String roleId, Set menuIdSet) throws BOSException {
        PreparedStatement st;
        Connection con;
        block10: {
            TableManager tm;
            String tempTable;
            block8: {
                boolean bl;
                block9: {
                    con = null;
                    st = null;
                    tempTable = null;
                    tm = null;
                    if (menuIdSet != null && menuIdSet.size() != 0) break block8;
                    String deleteSql = "delete from T_PM_RoleMainMenuItem where FRoleID = ? ";
                    Object[] params = new Object[]{roleId};
                    DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])params);
                    bl = true;
                    if (tm == null || tempTable == null) break block9;
                    tm.releaseTable(tempTable);
                }
                SQLUtils.cleanup(st, (Connection)con);
                return bl;
            }
            try {
                tm = TableManager.getTableManager((Context)ctx);
                tempTable = tm.getTableName("roleMenu");
                con = this.getConnection(ctx);
                if (tm != null) {
                    String createSql = "Create Table " + tempTable + " (FRoleID VARCHAR(44) NOT NULL ,FMainMenuItemID VARCHAR(44) NOT NULL)";
                    tm.createTable(createSql);
                }
                String sql = "insert into " + tempTable + " (FRoleID,FMainMenuItemID) values(?,?)";
                st = con.prepareStatement(sql);
                Iterator menuIdItr = menuIdSet.iterator();
                while (menuIdItr.hasNext()) {
                    String menuId = StringUtils.cnulls(menuIdItr.next());
                    st.setString(1, roleId);
                    st.setString(2, menuId);
                    st.addBatch();
                }
                st.executeBatch();
                String insertSql = "insert into T_PM_RoleMainMenuItem(FRoleID,FMainMenuItemID) select FRoleID,FMainMenuItemID from " + tempTable + " where not exists (select 1 from T_PM_RoleMainMenuItem where FRoleID= " + tempTable + ".FRoleID and FMainMenuItemID=" + tempTable + ".FMainMenuItemID)";
                DbUtil.execute((Context)ctx, (String)insertSql);
                String deleteSql = "delete from T_PM_RoleMainMenuItem where FRoleID = ? and FMainMenuItemID not in (" + ToolUtils.aryToStr(menuIdSet) + ")";
                Object[] params = new Object[]{roleId};
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])params);
                if (tm == null || tempTable == null) break block10;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tm != null && tempTable != null) {
                        tm.releaseTable(tempTable);
                    }
                    SQLUtils.cleanup(st, con);
                    throw throwable;
                }
            }
            tm.releaseTable(tempTable);
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
        this.addComFunctionToUserOfRole(ctx, roleId, menuIdSet);
        return true;
    }

    private void addComFunctionToUserOfRole(Context ctx, String roleId, Set menuIdSet) throws BOSException {
        IComMenuFunction iComMenuFunction = ComMenuFunctionFactory.getLocalInstance((Context)ctx);
        Set<UserInfo> userInfoSet = this.getUserSetByRole(ctx, roleId);
        iComMenuFunction.addBatchByUserAndMenu(userInfoSet, menuIdSet);
    }

    @Override
    protected void _saveRoleComFunToUser(Context ctx, Set userIdSet, Set roleIdSet) throws BOSException {
        Set<String> menuIdSet = this.getMenuIdSetByRoleSet(ctx, roleIdSet);
        Set<UserInfo> userInfoSet = this.getUserInfoSet(ctx, userIdSet);
        IComMenuFunction iComMenuFunction = ComMenuFunctionFactory.getLocalInstance((Context)ctx);
        iComMenuFunction.addBatchByUserAndMenu(userInfoSet, menuIdSet);
    }

    private Set<UserInfo> getUserInfoSet(Context ctx, Set userIdSet) throws BOSException {
        String sql = "select FId,FNumber from T_PM_User where FID in (" + ToolUtils.aryToStr(userIdSet) + ")";
        HashSet<UserInfo> userInfoSet = new HashSet<UserInfo>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            UserInfo user = null;
            while (rs.next()) {
                user = new UserInfo();
                user.setId(BOSUuid.read((String)rs.getString("FId")));
                user.setNumber(rs.getString("FNumber"));
                userInfoSet.add(user);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return userInfoSet;
    }

    private Set<String> getMenuIdSetByRoleSet(Context ctx, Set<String> roleIdSet) throws BOSException {
        String sql = "select FMainMenuItemID from T_PM_RoleMainMenuItem where FRoleID in (" + ToolUtils.aryToStr(roleIdSet) + ")";
        HashSet<String> menuIdSet = new HashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                menuIdSet.add(rs.getString("FMainMenuItemID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return menuIdSet;
    }

    @Override
    protected Set _getMayAccreditMenuColByRoleId(Context ctx, String roleId) throws BOSException {
        String l = ctx.getLocale().toString();
        HashSet<MainMenuItemInfo> hasPermMenuSet = new HashSet<MainMenuItemInfo>();
        try {
            List tempMainMenuItemList = new MainMenuQuickHelper().getAllMenuList(ctx);
            Set<String> permIdsOfRole = this.getPermIdSetOfRole(ctx, roleId);
            MainMenuItemCollection branchMenuCol = new MainMenuItemCollection();
            MainMenuItemInfo info = null;
            String function = null;
            String name = "FName_" + l;
            MainMenuItemInfo parent = null;
            String parentId = null;
            if (tempMainMenuItemList != null) {
                for (int i = 0; i < tempMainMenuItemList.size(); ++i) {
                    TempMainMenuItemInfo tempMainMenuItemInfo = (TempMainMenuItemInfo)tempMainMenuItemList.get(i);
                    info = new MainMenuItemInfo();
                    info.setId(BOSUuid.read((String)tempMainMenuItemInfo.getId()));
                    info.setName(tempMainMenuItemInfo.getName_L2());
                    info.setLongNumber(tempMainMenuItemInfo.getLongNumber());
                    info.setVisible(tempMainMenuItemInfo.getVisible());
                    function = tempMainMenuItemInfo.getFunction();
                    info.setIsLeaf(tempMainMenuItemInfo.getIsLeaf());
                    parentId = tempMainMenuItemInfo.getParent();
                    if (!StringUtils.isEmpty((String)parentId)) {
                        parent = new MainMenuItemInfo();
                        parent.setId(BOSUuid.read((String)tempMainMenuItemInfo.getParent()));
                        info.setParent(parent);
                    }
                    info.setOrder(tempMainMenuItemInfo.getOrder());
                    info.setMenutype(BizTypeEnum.getEnum((String)tempMainMenuItemInfo.getMenuType()));
                    if (!info.isVisible() || BizTypeEnum.webmenu.equals((Object)info.getMenutype())) continue;
                    if (info.isIsLeaf()) {
                        if (!StringUtils.isEmpty((String)function) && !permIdsOfRole.contains(function)) continue;
                        hasPermMenuSet.add(info);
                        continue;
                    }
                    branchMenuCol.add(info);
                }
            }
            Set<String> hasPermLongNumberSet = this.getSuperAndMeLongNumberSet(hasPermMenuSet);
            MainMenuItemInfo branch = null;
            int size = branchMenuCol.size();
            for (int i = 0; i < size; ++i) {
                branch = branchMenuCol.get(i);
                if (!hasPermLongNumberSet.contains(branch.getLongNumber())) continue;
                hasPermMenuSet.add(branch);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return hasPermMenuSet;
    }

    private Set<String> getPermIdSetOfRole(Context ctx, String roleId) throws BOSException {
        String sql = "select fpermitemid from t_pm_roleperm where froleid = ?";
        Object[] params = new Object[]{roleId};
        HashSet<String> ret = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs.next()) {
                ret.add(rs.getString("fpermitemid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }
}

