/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.AuthenRecordFactory;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermException;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermException;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.app.AbstractRolePermControllerBean;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.helper.RolePermHelper;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RolePermControllerBean
extends AbstractRolePermControllerBean {
    private static Logger logger = Logger.getLogger(RolePermControllerBean.class);

    @Override
    protected RolePermCollection _getTargetRolePerms(Context ctx, IObjectPK rolePK) throws BOSException, EASBizException {
        assert (rolePK != null);
        RolePermCollection collection = new RolePermCollection();
        try {
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            StringBuffer buffer = new StringBuffer(400);
            buffer.append("SELECT RolePerm.FID, RolePerm.FRoleID, RolePerm.FPermItemID, RolePerm.FPermType, ").append(" RolePerm.FRuleStructure , RolePerm.FRuleExpr, ").append(" PermItem.").append(aliasField).append(", ").append(" PermItem.FOrgRelation, ").append(" PermItem.FIsLeaf, PermItem.FParentID, PermItem.FObjectType, PermItem.FIsApplyToF7 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE RolePerm.FRoleID = ? ");
            Object[] params = new Object[]{rolePK.toString()};
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)rolePK.toString()));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
            while (rowSet.next()) {
                RolePermInfo info = new RolePermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                permItemInfo.setAlias(rowSet.getString(aliasField));
                permItemInfo.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
                permItemInfo.setIsLeaf(rowSet.getInt("FIsLeaf") == 1);
                permItemInfo.setObjectType(rowSet.getString("FObjectType"));
                permItemInfo.setEnableDataPermission(rowSet.getInt("FIsApplyToF7") == 1);
                String parentID = rowSet.getString("FParentID");
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    permItemInfo.setParent(parent);
                }
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setPermItem(permItemInfo);
                info.setPermType(PermType.getEnum(rowSet.getInt("FPermType")));
                info.setRuleExpr(rowSet.getString("FRuleExpr"));
                info.setRuleStructure(rowSet.getString("FRuleStructure"));
                info.setRole(roleInfo);
                collection.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new RolePermException(RolePermException.GET_ROLEPERM_FAIL, e);
        }
        return collection;
    }

    @Override
    protected RolePermCollection _getSourceRolePerms(Context ctx) throws BOSException, EASBizException {
        RolePermCollection rolePerms = new RolePermCollection();
        IPermItem iPermItem = PermItemFactory.getLocalInstance(ctx);
        PermItemCollection piBranches = iPermItem.getAllLeaves();
        int size = piBranches.size();
        for (int i = 0; i < size; ++i) {
            RolePermInfo rolePermInfo = new RolePermInfo();
            rolePermInfo.setPermItem(piBranches.get(i));
            rolePerms.add(rolePermInfo);
        }
        return rolePerms;
    }

    @Override
    protected void _saveRolePerms(Context ctx, IObjectPK rolePK, RolePermCollection rolePerms) throws BOSException, EASBizException {
        assert (rolePerms != null);
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection(ctx);
            RoleInfo roleInfo = RoleFactory.getLocalInstance(ctx).getRoleInfo(rolePK);
            RolePermCollection oldRolePerms = RolePermFactory.getLocalInstance(ctx).getRolePermCollection("select id,role.id,permItem.id,permType,ruleStructure,ruleExpr where role.id = '" + rolePK + "'");
            boolean isEnabledAuthen = AuthenModeFactory.getLocalInstance(ctx).isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
            for (int i = 0; i < rolePerms.size(); ++i) {
                RoleInfo role = new RoleInfo();
                role.setId(BOSUuid.read((String)rolePK.toString()));
                rolePerms.get(i).setRole(role);
            }
            RolePermCollection[] rolePermsDiff = RolePermHelper.getDiffUserOrgPerm(ctx, oldRolePerms, rolePerms);
            RolePermCollection allAddRPs = rolePermsDiff[0];
            RolePermCollection allDelRPs = rolePermsDiff[1];
            RolePermCollection updateRPs = rolePermsDiff[2];
            GroupLicenseUseInfoUtil.changeRolePermitem(ctx, roleInfo, allAddRPs, allDelRPs);
            if (updateRPs.size() > 0) {
                this.dealUpdatePerms(ctx, updateRPs);
            }
            RolePermHelper.removeRolePerms(ctx, allDelRPs);
            this.dealAddNewAndUpdatePerm(ctx, connection, statement, allAddRPs, isEnabledAuthen, roleInfo);
            this.handleCallBack(ctx, rolePK);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new UserOrgPermException(RolePermException.ACCREDIT_FAIL, e);
        }
        finally {
            SQLUtils.cleanup(statement, (Connection)connection);
        }
    }

    @Override
    protected void _saveRolePerms(Context ctx, RolePermCollection[] results) throws BOSException, EASBizException {
        assert (results != null);
        if (this.canIgnore(results)) {
            return;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection(ctx);
            IObjectPK rolePK = this.getRolePK(results);
            RoleInfo roleInfo = RoleFactory.getLocalInstance(ctx).getRoleInfo(rolePK);
            String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            RolePermCollection allRPs = this.getRPs(ctx, rolePK);
            Set existRPKeys = this.createRPSet(allRPs);
            Set addRPKeys = this.createRPSet(results[0]);
            boolean isEnabledAuthen = AuthenModeFactory.getLocalInstance(ctx).isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
            StringBuffer sql = null;
            sql = new StringBuffer();
            RolePermCollection delRPs = results[1];
            RolePermCollection allDelRPs = this.getAllDelRPs(ctx, delRPs, existRPKeys, addRPKeys);
            RolePermCollection updateRPs = results[2];
            RolePermCollection addRPs = results[0];
            RolePermCollection allAddRPs = this.getAllAddRPs(ctx, addRPs, existRPKeys, addRPKeys);
            GroupLicenseUseInfoUtil.changeRolePermitem(ctx, roleInfo, allAddRPs, allDelRPs);
            if (updateRPs.size() > 0) {
                this.dealUpdatePerms(ctx, updateRPs);
            }
            if (allDelRPs.size() > 0) {
                sql.append("DELETE FROM T_PM_RolePerm WHERE FID = ? ");
                statement = connection.prepareStatement(sql.toString());
                this.delRPBatch(statement, allDelRPs);
                statement.executeBatch();
            }
            sql = new StringBuffer();
            this.dealAddNewAndUpdatePerm(ctx, connection, statement, allAddRPs, isEnabledAuthen, roleInfo);
            this.handleCallBack(ctx, rolePK);
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new UserOrgPermException(RolePermException.ACCREDIT_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    private void dealUpdatePerms(Context ctx, RolePermCollection updateRPs) throws BOSException {
        String sql = "UPDATE T_PM_RolePerm SET FRuleStructure = ?, FRuleExpr = ? WHERE FID = ? ";
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)this.getUpdateRPBatchParams(updateRPs));
    }

    private void dealAddNewAndUpdatePerm(Context ctx, Connection connection, PreparedStatement statement, RolePermCollection allAddRPs, boolean isEnabledAuthen, RoleInfo roleInfo) throws Exception {
        if (allAddRPs == null || allAddRPs.isEmpty()) {
            return;
        }
        TableManager manager = TableManager.getTableManager((Context)ctx);
        String tableName = manager.getTableName("roleperm");
        String createSql = "create table " + tableName + " (FRoleID varchar(44),FpermItemId varchar(44),FpermType INT,FRuleStructure NCLOB(11034),FRuleExpr NCLOB(11034),FpermAssignType INT,FRolePerm varchar(44))";
        manager.createTable(createSql);
        String insertTmpSql = "insert into " + tableName + " (FRoleID,FpermItemId,FpermType,FRuleStructure,FRuleExpr,FpermAssignType,FRolePerm) values(?,?,?,?,?,?,?)";
        statement = connection.prepareStatement(insertTmpSql);
        if (allAddRPs.size() > 0) {
            for (int i = 0; i < allAddRPs.size(); ++i) {
                RolePermInfo rolePermInfo = allAddRPs.get(i);
                statement.setString(1, rolePermInfo.getRole().getId().toString());
                statement.setString(2, rolePermInfo.getPermItem().getId().toString());
                statement.setInt(3, rolePermInfo.getPermType().getValue());
                statement.setString(4, rolePermInfo.getRuleStructure());
                statement.setString(5, rolePermInfo.getRuleExpr());
                statement.setInt(6, 1);
                statement.setString(7, BOSUuid.create((String)"9FBAB53A").toString());
                statement.addBatch();
            }
        }
        statement.executeBatch();
        if (isEnabledAuthen) {
            this.dealPermWhenNeedAuthen(ctx, tableName, allAddRPs, roleInfo);
        } else {
            this.dealPermWhenNotNeedAuthen(ctx, tableName, allAddRPs);
        }
    }

    private void dealPermWhenNotNeedAuthen(Context ctx, String tableName, RolePermCollection allAddRPs) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (allAddRPs.size() > 0) {
            sql.append("INSERT INTO T_PM_RolePerm (FID, FRoleID, FPermItemID,FPermType,FRuleExpr, FRuleStructure ) VALUES (?, ? , ? , ? , ? , ? )");
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)this.getAddRPBatchParams(allAddRPs));
        }
    }

    private void insertAuthenRecord(Context ctx, Set<String> authentorSet, String permChangeId, String ctrlUnitId) throws SQLException, BOSException, EASBizException {
        if (authentorSet.size() == 0) {
            return;
        }
        for (String authentorId : authentorSet) {
            String sql = "INSERT INTO T_PM_AuthenRecord(FID,FPermChangeID,FAuthenStatus,FAuthentorID,FCU) VALUES(newbosid('8F704622'),'" + permChangeId + "','" + "10" + "','" + authentorId + "','" + ctrlUnitId + "')";
            DbUtil.execute((Context)ctx, (String)sql);
            AuthenRecordFactory.getLocalInstance(ctx).sendAuthenMessage(permChangeId, authentorId);
        }
    }

    private Set<String> getAuthentorByTable(Context ctx, String roleId, String tableName, int permType) throws BOSException, SQLException {
        HashSet<String> authentorSet = new HashSet<String>();
        StringBuffer queryAuthentorSql = new StringBuffer();
        queryAuthentorSql.append("select distinct asou.fuserid userid ").append("from t_pm_authenschemeorguser as asou ").append("inner join t_pm_authenschemeperm as schemeperm on schemeperm.fauthenschemeid = asou.fauthenschemeid ").append("inner join T_PM_UserRoleOrg as rp on asou.forgid = rp.forgid ").append("inner join ").append(tableName).append(" as tbl on tbl.fpermitemid = schemeperm.fpermitemid ").append("inner join T_ORG_BaseUnit org on org.fid=asou.forgid and (org.FINVALIDDATE > now() or org.FINVALIDDATE is null)").append("where rp.FROLEID = '" + roleId + "' ").append("and tbl.FRoleID = '" + roleId + "' ").append("and tbl.fpermtype = " + permType);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryAuthentorSql.toString());
        while (rowSet.next()) {
            authentorSet.add(rowSet.getString("userid"));
        }
        return authentorSet;
    }

    private void dealPermWhenNeedAuthen(Context ctx, String tableName, RolePermCollection allAddRPs, RoleInfo roleInfo) throws BOSException, EASBizException, SQLException {
        if (allAddRPs == null || allAddRPs.isEmpty()) {
            return;
        }
        String ctrlUnitId = roleInfo.getCU().getId().toString();
        this.copyNotNeedAuthenPerms(ctx, tableName, ctrlUnitId);
        this.copyNeedAuthenPerms(ctx, tableName, ctrlUnitId, roleInfo, 10);
    }

    private void copyNotNeedAuthenPerms(Context ctx, String tableName, String ctrlUnitId) throws BOSException {
        String sql = "INSERT INTO T_PM_RolePerm (FID,FRoleId,FPermItemID,FPermType, FRuleStructure,FRuleExpr) SELECT FRolePerm,FRoleId,FpermItemId,FpermType,FRuleStructure,FRuleExpr from " + tableName + " tbl where tbl.FpermAssignType=1 and (FPermType=" + 20 + " or tbl.FpermItemId not in (select schemeperm.fpermitemid from t_pm_authenschemeperm as schemeperm inner join t_pm_authenschemeorguser as asou on asou.fauthenschemeid = schemeperm.fauthenschemeid inner join T_PM_UserRoleOrg as rp on asou.forgid = rp.forgid  where rp.FRoleId = tbl.FRoleId and schemeperm.fpermitemid = tbl.fpermitemid))";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void copyNeedAuthenPerms(Context ctx, String tableName, String ctrlUnitId, RoleInfo roleInfo, int permType) throws BOSException, SQLException, EASBizException {
        Set<String> authentorSet = this.getAuthentorByTable(ctx, roleInfo.getId().toString(), tableName, permType);
        if (authentorSet == null || authentorSet.isEmpty()) {
            return;
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String permChangeId = UserOrgPermFacadeFactory.getLocalInstance(ctx).insertPermChange(currentUserInfo.getId().toString(), "40", roleInfo.getNumber(), roleInfo.getName(), "role");
        this.insertIntoTableChange(ctx, tableName, ctrlUnitId, permType, permChangeId);
        this.insertAuthenSnapViewInfo(ctx, tableName, permChangeId, ctrlUnitId, permType);
        this.insertAuthenRecord(ctx, authentorSet, permChangeId, ctrlUnitId);
    }

    private void insertIntoTableChange(Context ctx, String tableName, String ctrlUnitId, int permType, String permChangeId) throws BOSException {
        String sql = "INSERT INTO T_PM_RolePermChange (FID,FRolePerm,FPermChangeID,FRoleId,FPermItemID,FASSIGNTYPE,FPermType, FRuleStructure,FRuleExpr, FAuthenStatus,FCtrlUnitID) SELECT newbosid('A884618A'),FRolePerm,'" + permChangeId + "',FRoleId,FpermItemId,'" + "10" + "',FpermType,FRuleStructure,FRuleExpr,'" + "10" + "','" + ctrlUnitId + "'from " + tableName + " tbl where tbl.FpermAssignType=1 and tbl.FPermType=" + permType + " AND tbl.FpermItemId in ( select schemeperm.fpermitemid from t_pm_authenschemeperm as schemeperm inner join t_pm_authenschemeorguser as asou on asou.fauthenschemeid = schemeperm.fauthenschemeid inner join T_PM_UserRoleOrg as rp on asou.forgid = rp.forgid where rp.FRoleId = tbl.FRoleId and schemeperm.fpermitemid = tbl.fpermitemid)";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void insertAuthenSnapViewInfo(Context ctx, String tableName, String permChangeId, String targetOrgId, int permType) throws BOSException {
        PreparedStatement preparedStatement = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_authenschemesnapview(fid, froleid, fuserid, fpermitemid, fpermchangerecordid, fisrule)").append("select newbosid('38B94EC5'), null , asou.fuserid, tbl.fpermitemid, '").append(permChangeId).append("', authenrule.fisrule ").append("from ").append(tableName).append(" as tbl ").append("inner join t_pm_authenschemeperm as schemeperm on tbl.fpermitemid = schemeperm.fpermitemid ").append("inner join t_pm_authenschemeorguser as asou on schemeperm.fauthenschemeid = asou.fauthenschemeid ").append("inner join t_pm_authenschemerule as authenrule on authenrule.fauthenschemeid = asou.fauthenschemeid and authenrule.forgid = asou.forgid ").append("inner join T_PM_UserRoleOrg  as uro on asou.forgid = uro.forgid ").append("where uro.FRoleId = tbl.FRoleId and ").append("tbl.fpermtype = ?");
            preparedStatement = conn.prepareStatement(insertSql.toString());
            preparedStatement.setInt(1, permType);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preparedStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preparedStatement);
    }

    private List getUpdateRPBatchParams(RolePermCollection allUpdateRPs) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        int size = allUpdateRPs.size();
        for (int i = 0; i < size; ++i) {
            RolePermInfo info = allUpdateRPs.get(i);
            Object[] params = new Object[]{null == info.getRuleStructure() ? "" : info.getRuleStructure(), null == info.getRuleExpr() ? "" : info.getRuleExpr(), info.getId().toString()};
            ret.add(params);
        }
        return ret;
    }

    private List getAddRPBatchParams(RolePermCollection allAddRPs) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        int size = allAddRPs.size();
        for (int i = 0; i < size; ++i) {
            Object[] params = new Object[6];
            BOSUuid id = BOSUuid.create((BOSObjectType)this.getBOSType());
            RolePermInfo info = allAddRPs.get(i);
            params[0] = id.toString();
            params[1] = info.getRole().getId().toString();
            params[2] = info.getPermItem().getId().toString();
            params[3] = info.getPermType().getValue();
            params[4] = null == info.getRuleExpr() ? "" : info.getRuleExpr();
            params[5] = null == info.getRuleStructure() ? "" : info.getRuleStructure();
            ret.add(params);
        }
        return ret;
    }

    private void handleCallBack(Context ctx, IObjectPK rolePK) throws EASBizException, BOSException {
        PermissionChangeHelper helper = new PermissionChangeHelper();
        helper.setRolePK(rolePK);
        helper.exceChange(ctx);
    }

    private void cleanRolePermCache(Context ctx, RolePermCollection[] results) throws BOSException, EASBizException {
        if (results.length > 0) {
            BOSUuid roleID = null;
            for (int index = 0; index < results.length; ++index) {
                if (results[index].get(0) == null) continue;
                roleID = results[index].get(0).getRole().getId();
                break;
            }
            if (roleID != null) {
                UserRoleOrgManagerFactory.getLocalInstance(ctx).cleanRolePermCache(roleID);
            }
        }
    }

    private boolean canIgnore(RolePermCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i].size() <= 0) continue;
            return false;
        }
        return true;
    }

    private IObjectPK getRolePK(RolePermCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i] == null || results[i].size() <= 0) continue;
            return new ObjectUuidPK(results[i].get(0).getRole().getId());
        }
        throw new IllegalArgumentException("result is error");
    }

    private Set createRPSet(RolePermCollection rps) {
        HashSet<String> set = new HashSet<String>(1000);
        RolePermInfo rolePermInfo = null;
        int size = rps.size();
        for (int i = 0; i < size; ++i) {
            rolePermInfo = rps.get(i);
            set.add(PermissionCommonUtil.getKey(rolePermInfo));
        }
        return set;
    }

    private RolePermCollection getRPs(Context context, IObjectPK rolePK) throws BOSException, EASBizException {
        assert (rolePK != null);
        RolePermCollection rps = new RolePermCollection();
        String sql = "SELECT FPermItemID, FPermType FROM T_PM_RolePerm WHERE FRoleID = ? ";
        Object[] params = new Object[]{rolePK.toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql, (Object[])params);
        RolePermInfo rolePermInfo = null;
        try {
            while (rowSet.next()) {
                rolePermInfo = new RolePermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FPermItemID")));
                rolePermInfo.setPermItem(permItemInfo);
                rolePermInfo.setPermType(PermType.getEnum(rowSet.getInt("FPermType")));
                rps.add(rolePermInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new RolePermException(RolePermException.GET_ROLEPERM_FAIL, e);
        }
        return rps;
    }

    private RolePermCollection getAllDelRPs(Context context, RolePermCollection delRPs, Set existRPkeys, Set addRPKeys) throws BOSException, EASBizException {
        RolePermCollection result = (RolePermCollection)((Object)delRPs.clone());
        Set currentDelRPs = this.createRPSet(result);
        int size = currentDelRPs.size();
        for (int i = 0; i < size; ++i) {
            RolePermInfo info = delRPs.get(i);
            PermItemCollection beenDepPerms = PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()));
            if (beenDepPerms == null) continue;
            int size1 = beenDepPerms.size();
            for (int j = 0; j < size1; ++j) {
                String key;
                PermItemInfo beenDepPerm = beenDepPerms.get(j);
                if (!info.getPermItem().getOrgRelation().equals((Object)beenDepPerms.get(j).getOrgRelation()) || !existRPkeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) && !addRPKeys.contains(key) || currentDelRPs.contains(key)) continue;
                result.removeObject(info.getId());
            }
        }
        return result;
    }

    private RolePermCollection getAllAddRPs(Context context, RolePermCollection addRPs, Set existRPKeys, Set addRPKeys) throws BOSException, EASBizException {
        RolePermCollection result = new RolePermCollection();
        RolePermCollection rps = (RolePermCollection)((Object)addRPs.clone());
        int size = addRPs.size();
        for (int i = 0; i < size; ++i) {
            PermItemInfo beenDepPerm;
            PermItemCollection beenDepPerms;
            RolePermInfo newRP;
            String key;
            int j;
            int size1;
            RolePermInfo info = addRPs.get(i);
            if (info.getPermType().equals((Object)PermType.NORMAL)) {
                PermItemInfo depPerm;
                PermItemCollection depPerms = PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()));
                if (depPerms == null) continue;
                if (info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) {
                    size1 = depPerms.size();
                    for (j = 0; j < size1; ++j) {
                        depPerm = depPerms.get(j);
                        if (!depPerm.getOrgRelation().equals((Object)OrgType.NONE) || existRPKeys.contains(key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType())) || addRPKeys.contains(key)) continue;
                        newRP = (RolePermInfo)info.clone();
                        newRP.setPermItem(depPerm);
                        newRP.setRuleStructure(null);
                        newRP.setRuleExpr(null);
                        rps.add(newRP);
                        addRPKeys.add(key);
                    }
                    continue;
                }
                size1 = depPerms.size();
                for (j = 0; j < size1; ++j) {
                    depPerm = depPerms.get(j);
                    if (depPerm.getOrgRelation().equals((Object)info.getPermItem().getOrgRelation())) {
                        key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType());
                        if (existRPKeys.contains(key) || addRPKeys.contains(key)) continue;
                        newRP = (RolePermInfo)info.clone();
                        newRP.setPermItem(depPerm);
                        newRP.setRuleStructure(null);
                        newRP.setRuleExpr(null);
                        rps.add(newRP);
                        addRPKeys.add(key);
                        continue;
                    }
                    if (!depPerm.getOrgRelation().equals((Object)OrgType.NONE) || existRPKeys.contains(key = PermissionCommonUtil.getKey(depPerm.getId(), info.getPermType())) || addRPKeys.contains(key)) continue;
                    newRP = (RolePermInfo)info.clone();
                    newRP.setPermItem(depPerm);
                    newRP.setRuleStructure(null);
                    newRP.setRuleExpr(null);
                    rps.add(newRP);
                    addRPKeys.add(key);
                }
                continue;
            }
            if (!info.getPermType().equals((Object)PermType.FORBIDDEN) || (beenDepPerms = PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()))) == null) continue;
            if (info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) {
                size1 = beenDepPerms.size();
                for (j = 0; j < size1; ++j) {
                    beenDepPerm = beenDepPerms.get(j);
                    if (!beenDepPerm.getOrgRelation().equals((Object)OrgType.NONE) || existRPKeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) || addRPKeys.contains(key)) continue;
                    newRP = (RolePermInfo)info.clone();
                    newRP.setPermItem(beenDepPerm);
                    newRP.setRuleStructure(null);
                    newRP.setRuleExpr(null);
                    rps.add(newRP);
                    addRPKeys.add(key);
                }
                continue;
            }
            size1 = beenDepPerms.size();
            for (j = 0; j < size1; ++j) {
                beenDepPerm = beenDepPerms.get(j);
                if (!beenDepPerm.getOrgRelation().equals((Object)info.getPermItem().getOrgRelation()) || existRPKeys.contains(key = PermissionCommonUtil.getKey(beenDepPerm.getId(), info.getPermType())) || addRPKeys.contains(key)) continue;
                newRP = (RolePermInfo)info.clone();
                newRP.setPermItem(beenDepPerm);
                newRP.setRuleStructure(null);
                newRP.setRuleExpr(null);
                rps.add(newRP);
                addRPKeys.add(key);
            }
        }
        RolePermInfo rolePermInfo = null;
        int size2 = rps.size();
        for (int i = 0; i < size2; ++i) {
            rolePermInfo = rps.get(i);
            if (existRPKeys.contains(PermissionCommonUtil.getKey(rolePermInfo))) continue;
            result.add(rolePermInfo);
        }
        return result;
    }

    private void delRPBatch(PreparedStatement statement, RolePermCollection rps) throws SQLException {
        int size = rps.size();
        for (int i = 0; i < size; ++i) {
            RolePermInfo info = rps.get(i);
            statement.setString(1, info.getId().toString());
            statement.addBatch();
        }
    }

    @Override
    protected void _saveSimpleRoleInfo(Context ctx, RolePermInfo rolePermInfo) throws BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer("insert into  t_pm_roleperm(fid,froleid,fpermitemid,fpermType,fruleStructure,fruleExpr)values(?,?,?,?,?,?)");
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(insertSql.toString());
            ps.setString(1, rolePermInfo.getId().toString());
            ps.setString(2, rolePermInfo.getRole().getId().toString());
            ps.setString(3, rolePermInfo.getPermItem().getId().toString());
            ps.setInt(4, rolePermInfo.getPermType().getValue());
            ps.setString(5, rolePermInfo.getRuleStructure());
            ps.setString(6, rolePermInfo.getRuleExpr());
            ps.execute();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("sql error! sql is:" + insertSql.toString(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)con);
        }
    }

    @Override
    protected void _deleteSimpleInfo(Context ctx, String permItemId, String roleId) throws BOSException, EASBizException {
        String delSql = "delete from t_pm_roleperm where fpermitemid = ? and froleId = ?";
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(delSql);
            ps.setString(1, permItemId);
            ps.setString(2, roleId);
            ps.execute();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("sql error! sql is:" + delSql, (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)con);
        }
    }

    @Override
    protected RolePermCollection _findRolePermInfo(Context ctx, String roleId, String permItemId, PermType permTypeEnum) throws BOSException {
        String oql = "select * " + this.getWhereStr(roleId, permItemId, permTypeEnum);
        return this.getRolePermCollection(ctx, oql);
    }

    private String getWhereStr(String roleId, String permItemId, PermType permTypeEnum) {
        String retStr = "";
        if (!StringUtils.isEmpty((String)roleId) || !StringUtils.isEmpty((String)permItemId) || permTypeEnum != null) {
            retStr = " where ";
        }
        String whereStr = "";
        if (!StringUtils.isEmpty((String)roleId)) {
            whereStr = " role.id = '" + roleId + "'";
        }
        if (!StringUtils.isEmpty((String)permItemId)) {
            whereStr = whereStr + " and permItem.id = '" + permItemId + "'";
        }
        if (permTypeEnum != null) {
            whereStr = whereStr + " and permType = " + permTypeEnum.getValue();
        }
        if ((whereStr = whereStr.trim()).startsWith("and")) {
            whereStr = whereStr.substring(4, whereStr.length());
        }
        return retStr + whereStr;
    }
}

