/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.DynamicCardUserFactory;
import com.kingdee.eas.base.permission.IDynamicCardUser;
import com.kingdee.eas.base.permission.IPasswordVerifyFacade;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PasswordVerifyFacadeFactory;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.SecondAuthorizeException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.AbstractSecondAuthorizeFacadeControllerBean;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class SecondAuthorizeFacadeControllerBean
extends AbstractSecondAuthorizeFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.SecondAuthorizeFacadeControllerBean");
    private static final String CACHE_PERM_ITEM = "permission.permItem";

    @Override
    protected String _getAuthorzizeByPermission(Context ctx) throws BOSException {
        String key = CacheUtil.getCacheKey(new Object[]{"permission.secondauthorize"});
        String secondAuthorizeInfo = (String)CacheUtil.getCacheValue(CACHE_PERM_ITEM, key);
        if (secondAuthorizeInfo != null) {
            logger.debug((Object)("_getAuthorzizeByPermission, key:" + key + ", hit: true"));
            return secondAuthorizeInfo;
        }
        JSONObject json = new JSONObject();
        try {
            String sql = "select ca.FAuthorizeType FAuthorizeType, perm.fnumber FPermItem from T_PM_IDSecondAuthorize ca, t_pm_permitem perm where ca.fpermitem=perm.fid and (FAuthorizeType = 5 or FAuthorizeType = 2)";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String permID = rowSet.getString("FPermItem");
                int authType = rowSet.getInt("FAuthorizeType");
                json.put(permID, (Object)AuthorizeTypeEnum.getEnum(authType).getName());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.info((Object)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.info((Object)e);
        }
        secondAuthorizeInfo = json.toString();
        CacheUtil.putCacheValue(CACHE_PERM_ITEM, key, secondAuthorizeInfo);
        return secondAuthorizeInfo;
    }

    @Override
    protected boolean _authorize(Context ctx, String password, String permName) throws BOSException {
        AuthorizeTypeEnum authorizeType = this.getAuthorizeTypeByPermName(ctx, permName);
        if (authorizeType == null) {
            return true;
        }
        boolean result = false;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (password == null) {
            return false;
        }
        String checkedUserName = null;
        String innerPassword = null;
        LoginAuthorWayEnum loginWay = null;
        try {
            if (AuthorizeTypeEnum.dynAuth.equals((Object)authorizeType)) {
                if (!this.isDyPasswordUser(user.getId().toString())) {
                    throw new SecondAuthorizeException(SecondAuthorizeException.DYPWD_IS_NOT_CONFIG);
                }
                String numberType = PermissionCommonUtil.getDynamicCardUserNumberType(ctx);
                if (StringUtils.isEmpty((String)numberType)) {
                    numberType = "1";
                }
                checkedUserName = "2".equals(numberType) ? user.getNumber() : user.getId().toString();
                innerPassword = CryptoTean.encrypt((String)checkedUserName, (String)password);
                loginWay = LoginAuthorWayEnum.DYNAMIC;
            } else if (AuthorizeTypeEnum.pwdAuthor.equals((Object)authorizeType)) {
                checkedUserName = user.getNumber();
                innerPassword = CryptoTean.encrypt((String)checkedUserName, (String)password);
                loginWay = LoginAuthorWayEnum.NORMAL;
            }
            IPasswordVerifyFacade pvf = PasswordVerifyFacadeFactory.getRemoteInstance();
            result = pvf.verifyUserAndPassword(loginWay, checkedUserName, innerPassword);
            if (!result) {
                if (AuthorizeTypeEnum.dynAuth.equals((Object)authorizeType)) {
                    throw new SecondAuthorizeException(SecondAuthorizeException.DYPWD_ERROR);
                }
                if (AuthorizeTypeEnum.pwdAuthor.equals((Object)authorizeType)) {
                    throw new SecondAuthorizeException(SecondAuthorizeException.PWD_ERROR);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private AuthorizeTypeEnum getAuthorizeTypeByPermName(Context ctx, String permName) throws BOSException {
        AuthorizeTypeEnum typeEnum = null;
        String sql = "select ca.FAuthorizeType FAuthorizeType, perm.fnumber FPermItem from T_PM_IDSecondAuthorize ca, t_pm_permitem perm where ca.fpermitem=perm.fid and perm.fnumber = '" + permName + "' and (FAuthorizeType = 5 or FAuthorizeType = 2)";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                typeEnum = AuthorizeTypeEnum.getEnum(rowSet.getInt("FAuthorizeType"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.info((Object)e);
        }
        return typeEnum;
    }

    private boolean isDyPasswordUser(String user) {
        try {
            IDynamicCardUser service = DynamicCardUserFactory.getRemoteInstance();
            return service.exists("where dynamicState = 0 and user ='" + user + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return false;
    }
}

