/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.app.AbstractBaseAuthenRecordAuthen;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserAssignPermAuthenRecordAuthen
extends AbstractBaseAuthenRecordAuthen {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserAssignPermAuthenRecordAuthenImpl");
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private int MAX_RECORD_COUNT = 8000;
    private final String PERMITEM_TO_USER_MAP = "permItem2UserMap";
    private final String PERMITEM_TO_RULE = "permItem2Rule";
    private final String PERMITEM_TO_ASSIGNTYPE = "permItem2AssignType";
    private Context ctx;

    public UserAssignPermAuthenRecordAuthen(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    protected String getDescription() {
        return EASResource.getString((String)RESOURCE, (String)"AUTHEN_CREATE_TASK");
    }

    @Override
    protected ResultSet queryNeedAuthenResultSet(Connection conn, String permChangeId) throws BOSException {
        PreparedStatement queryStatement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer queryAllCanAuthenPermInfo = new StringBuffer();
            queryAllCanAuthenPermInfo.append("select change.fpermitemid permItem, snapview.fisrule isrule, ").append("snapview.fuserid userid, change.fassigntype assigntype ").append("from t_pm_userorgpermchange as change ").append("inner join t_pm_authenschemesnapview as snapview on change.fpermchangeid = snapview.fpermchangerecordid and change.fpermitemid = snapview.fpermitemid ").append("inner join t_pm_authenrecord as record on record.fpermchangeid = change.fpermchangeid and record.fauthentorid = snapview.fuserid ").append("where change.fauthenstatus = ? and ").append("record.fauthenstatus = ? and ").append("snapview.fpermchangerecordid = ?");
            queryStatement = conn.prepareStatement(queryAllCanAuthenPermInfo.toString());
            queryStatement.setString(1, "10");
            queryStatement.setString(2, "10");
            queryStatement.setString(3, permChangeId);
            resultSet = queryStatement.executeQuery();
            return resultSet;
        }
        catch (Exception e) {
            SQLUtils.cleanup(resultSet, queryStatement);
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map getInformation(ResultSet resultSet) throws BOSException {
        try {
            HashMap<String, HashSet<String>> permItem2UserMap = new HashMap<String, HashSet<String>>();
            HashMap<String, Boolean> permItem2Rule = new HashMap<String, Boolean>();
            HashMap<String, String> permItem2AssignType = new HashMap<String, String>();
            while (resultSet.next()) {
                String permItemId = resultSet.getString("permItem");
                boolean rule = resultSet.getBoolean("isrule");
                String userId = resultSet.getString("userid");
                String assigntType = resultSet.getString("assigntype");
                HashSet<String> userIdSet = (HashSet<String>)permItem2UserMap.get(permItemId);
                if (userIdSet == null) {
                    userIdSet = new HashSet<String>();
                    permItem2UserMap.put(permItemId, userIdSet);
                }
                userIdSet.add(userId);
                permItem2Rule.put(permItemId, rule);
                permItem2AssignType.put(permItemId, assigntType);
            }
            HashMap<String, HashMap<String, Object>> information = new HashMap<String, HashMap<String, Object>>();
            information.put("permItem2UserMap", permItem2UserMap);
            information.put("permItem2Rule", permItem2Rule);
            information.put("permItem2AssignType", permItem2AssignType);
            return information;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Set getPassSet(Map information, String currentUserId) {
        HashSet permItemIdSet = new HashSet();
        Map permItem2UserMap = (Map)information.get("permItem2UserMap");
        Map permItem2Rule = (Map)information.get("permItem2Rule");
        Set permItemKeySet = permItem2UserMap.keySet();
        for (Object permItemId : permItemKeySet) {
            boolean rule = (Boolean)permItem2Rule.get(permItemId);
            Set userIdSet = (Set)permItem2UserMap.get(permItemId);
            if (!userIdSet.contains(currentUserId) || rule && userIdSet.size() != 1) continue;
            permItemIdSet.add(permItemId);
        }
        return permItemIdSet;
    }

    @Override
    protected void updatePassData(Connection conn, Set passSet, Map information, String permChangeId) throws BOSException {
        PreparedStatement queryPermStatement = null;
        PreparedStatement insertPermStatement = null;
        PreparedStatement updatePermStatement = null;
        PreparedStatement updateAuthenStatusStatement = null;
        try {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select fuserorgperm, fownerid, forgid, fpermitemid, fpermtype, frulestructure, fruleexpr, fctrlunitid ").append("from t_pm_userorgpermchange ").append("where  ").append("fpermchangeid = ? and ").append("(not exists (").append("select 1 ").append("from t_pm_userorgperm uop ").append("where uop.fowner = t_pm_userorgpermchange.fownerid and ").append("uop.fpermitemid = t_pm_userorgpermchange.fpermitemid and ").append("uop.fpermtype = t_pm_userorgpermchange.fpermtype and ").append("uop.forgid = t_pm_userorgpermchange.forgid and ").append("uop.fid is not null").append(") or fassigntype <> 10 )");
            queryPermStatement = conn.prepareStatement(querySql.toString());
            queryPermStatement.setString(1, permChangeId);
            ResultSet rs = queryPermStatement.executeQuery();
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into t_pm_userorgperm(fid, fowner, forgid, fpermitemid, fpermtype, frulestructure, fruleexpr, fctrlunitid)values(?,?,?,?,?,?,?,?) ");
            insertPermStatement = conn.prepareStatement(insertSql.toString());
            StringBuffer updatePermSql = new StringBuffer();
            updatePermSql.append("update t_pm_userorgperm  ").append("set frulestructure=?, fruleexpr=? ").append(" where fid = ?");
            updatePermStatement = conn.prepareStatement(updatePermSql.toString());
            StringBuffer updateAuthenStatusSql = new StringBuffer();
            updateAuthenStatusSql.append("update t_pm_userorgpermchange ").append("set fauthenstatus = ? ").append("where fpermchangeid = ? and ").append("fpermitemid = ?");
            updateAuthenStatusStatement = conn.prepareStatement(updateAuthenStatusSql.toString());
            Map permItem2AssignType = (Map)information.get("permItem2AssignType");
            int insertCount = 0;
            int updatePermCount = 0;
            int updateStatusCount = 0;
            String assigntType = null;
            while (rs.next()) {
                String fuserorgperm = rs.getString("fuserorgperm");
                String fownerid = rs.getString("fownerid");
                String forgid = rs.getString("forgid");
                String fpermitemid = rs.getString("fpermitemid");
                String fpermtype = rs.getString("fpermtype");
                String frulestructure = rs.getString("frulestructure");
                String fruleexpr = rs.getString("fruleexpr");
                String fctrlunitid = rs.getString("fctrlunitid");
                if (passSet.contains(fpermitemid)) {
                    assigntType = (String)permItem2AssignType.get(fpermitemid);
                    if ("10".equals(assigntType)) {
                        insertPermStatement.setObject(1, fuserorgperm);
                        insertPermStatement.setString(2, fownerid);
                        insertPermStatement.setString(3, forgid);
                        insertPermStatement.setString(4, fpermitemid);
                        insertPermStatement.setInt(5, Integer.valueOf(fpermtype));
                        insertPermStatement.setString(6, frulestructure);
                        insertPermStatement.setString(7, fruleexpr);
                        insertPermStatement.setString(8, fctrlunitid);
                        insertPermStatement.addBatch();
                        ArrayList<String> permitems = new ArrayList<String>();
                        permitems.add(fpermitemid);
                        try {
                            GroupLicenseUseInfoUtil.assignPermitem(this.ctx, fownerid, permitems);
                        }
                        catch (EASBizException e) {
                            throw new BOSException((Throwable)e);
                        }
                        ++insertCount;
                    } else if ("30".equals(assigntType)) {
                        updatePermStatement.setString(1, frulestructure);
                        updatePermStatement.setString(2, fctrlunitid);
                        updatePermStatement.setString(3, fuserorgperm);
                        updatePermStatement.addBatch();
                        ++updatePermCount;
                    }
                }
                updateAuthenStatusStatement.setString(1, "20");
                updateAuthenStatusStatement.setString(2, permChangeId);
                updateAuthenStatusStatement.setObject(3, fpermitemid);
                updateAuthenStatusStatement.addBatch();
                ++updateStatusCount;
                if (insertCount > this.MAX_RECORD_COUNT) {
                    insertPermStatement.executeBatch();
                    insertPermStatement.clearBatch();
                    insertCount = 0;
                }
                if (updatePermCount > this.MAX_RECORD_COUNT) {
                    updatePermStatement.executeBatch();
                    updatePermStatement.clearBatch();
                    updatePermCount = 0;
                }
                if (updateStatusCount <= this.MAX_RECORD_COUNT) continue;
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                updateStatusCount = 0;
            }
            if (insertCount > 0) {
                insertPermStatement.executeBatch();
                insertPermStatement.clearBatch();
                insertCount = 0;
            }
            if (updatePermCount > 0) {
                updatePermStatement.executeBatch();
                updatePermStatement.clearBatch();
                updatePermCount = 0;
            }
            if (updateStatusCount > 0) {
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                updateStatusCount = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertPermStatement);
                SQLUtils.cleanup(updatePermStatement);
                SQLUtils.cleanup(updateAuthenStatusStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertPermStatement);
        SQLUtils.cleanup((Statement)updatePermStatement);
        SQLUtils.cleanup((Statement)updateAuthenStatusStatement);
    }

    @Override
    protected Set getNoPassSet(Map information, String currentUserId) {
        HashSet permItemIdSet = new HashSet();
        Map permItem2UserMap = (Map)information.get("permItem2UserMap");
        Map permItem2Rule = (Map)information.get("permItem2Rule");
        Set permItemKeySet = permItem2UserMap.keySet();
        for (Object permItemIdObj : permItemKeySet) {
            Set userIdSet = (Set)permItem2UserMap.get(permItemIdObj);
            if (!userIdSet.contains(currentUserId)) continue;
            permItemIdSet.add(permItemIdObj);
        }
        return permItemIdSet;
    }

    @Override
    protected void updateNoPassData(Connection conn, Set noPassSet, Map information, String permChangeId) throws BOSException {
        PreparedStatement updateAuthenStatusStatement = null;
        try {
            StringBuffer updateAuthenStatusSql = new StringBuffer();
            updateAuthenStatusSql.append("update t_pm_userorgpermchange ").append("set fauthenstatus = ? ").append("where fpermchangeid = ? and ").append("fpermitemid = ?");
            updateAuthenStatusStatement = conn.prepareStatement(updateAuthenStatusSql.toString());
            int count = 0;
            for (Object permItemIdObj : noPassSet) {
                updateAuthenStatusStatement.setString(1, "30");
                updateAuthenStatusStatement.setString(2, permChangeId);
                updateAuthenStatusStatement.setObject(3, permItemIdObj);
                updateAuthenStatusStatement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                updateAuthenStatusStatement.executeBatch();
                updateAuthenStatusStatement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateAuthenStatusStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateAuthenStatusStatement);
    }
}

