/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.app.AbstractUserLoginStatsControllerBean;
import com.kingdee.eas.base.permission.app.daq.util.DataAcquisitionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class UserLoginStatsControllerBean
extends AbstractUserLoginStatsControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserLoginStatsControllerBean");

    @Override
    protected int[] _getUserLoginReport(Context ctx, Date beginTime, Date endTime, int type) throws BOSException, EASBizException {
        int[] result = null;
        try {
            beginTime = DataAcquisitionUtil.initTime(beginTime, 0);
            endTime = DataAcquisitionUtil.initTime(endTime, 23);
            String sql = "select FDataAcqTime,FUserId from T_PM_UserLoginStats where FDataAcqTime > ? and FDataAcqTime < ? order by FDataAcqTime";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(beginTime.getTime()), new Timestamp(endTime.getTime())});
            int size = DataAcquisitionUtil.getSizeByType(type, beginTime, endTime);
            result = new int[size];
            if (rs.size() < 1) {
                return result;
            }
            Timestamp tsCache = null;
            int groovedCache = 0;
            Object[] userArr = new Object[size];
            while (rs.next()) {
                Timestamp ts = rs.getTimestamp("FDataAcqTime");
                String userId = rs.getString("FUserId");
                if (ts.equals(tsCache)) {
                    List userIds = (List)userArr[groovedCache];
                    if (userIds.contains(userId)) continue;
                    userIds.add(userId);
                    int n = groovedCache;
                    result[n] = result[n] + 1;
                    continue;
                }
                tsCache = ts;
                int grooved = DataAcquisitionUtil.dataDistribution(type, new Date(ts.getTime()), beginTime);
                ArrayList<String> users = (ArrayList<String>)userArr[grooved];
                if (users == null) {
                    userArr[grooved] = users = new ArrayList<String>();
                }
                if (!users.contains(userId)) {
                    users.add(userId);
                    int n = grooved;
                    result[n] = result[n] + 1;
                }
                groovedCache = grooved;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

