/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RoleException;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgException;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.util.PermBizHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserRoleDataTransmission
extends AbstractDataTransmission {
    private Logger logger = Logger.getLogger(UserRoleDataTransmission.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private Map userMap = new HashMap();
    private Map orgMap = new HashMap();
    private Map roleMap = new HashMap();
    private Map orgRangeCheck = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            RoleInfo role;
            FullOrgUnitInfo fullOrgUnitInfo;
            String userNumber = (String)((DataToken)hsData.get((Object)"FUserNumber")).data;
            String orgNumber = (String)((DataToken)hsData.get((Object)"FOrgNumber")).data;
            String roleNumber = (String)((DataToken)hsData.get((Object)"FRoleNumber")).data;
            String roleType = (String)((DataToken)hsData.get((Object)"FRoleType")).data;
            UserInfo userInfo = (UserInfo)this.userMap.get(userNumber);
            if (this.userMap.get(userNumber) == null) {
                userInfo = PermBizHelper.findUserInfoByNumber(ctx, userNumber);
                this.userMap.put(userNumber, userInfo);
            }
            if ((fullOrgUnitInfo = (FullOrgUnitInfo)this.orgMap.get(orgNumber)) == null) {
                fullOrgUnitInfo = PermBizHelper.findFullOrgUnfoByNumber(ctx, orgNumber);
                this.orgMap.put(orgNumber, fullOrgUnitInfo);
            }
            if ((role = (RoleInfo)this.roleMap.get(roleNumber)) == null) {
                role = PermBizHelper.findRoleInfoByNumber(ctx, roleNumber);
                this.roleMap.put(roleNumber, role);
            }
            if (!"10".equalsIgnoreCase(roleType) && !"30".equalsIgnoreCase(roleType)) {
                throw new RoleException(RoleException.ROLE_IMPORT_TYPE_ERROR);
            }
            PermType permType = PermBizHelper.findPermType(roleType);
            if (!userInfo.isBizAdmin() && PermType.AUTHORIZATION.equals((Object)permType)) {
                throw new UserRoleOrgException(UserRoleOrgException.NORMAL_USER_CANNOT_AUTHORIZ);
            }
            String key = userInfo.getId().toString() + fullOrgUnitInfo.getId().toString();
            Object value = this.orgRangeCheck.get(key);
            if (value == null) {
                String sql = "select top 1 1 from t_pm_orgrange where fuserid =? and forgid=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), fullOrgUnitInfo.getId().toString()});
                if (!rs.next()) {
                    this.orgRangeCheck.put(key, false);
                    throw new UserRoleOrgException(UserRoleOrgException.ORGRANGE_ERROR, new Object[]{fullOrgUnitInfo.getNumber(), userInfo.getNumber()});
                }
                this.orgRangeCheck.put(key, true);
            } else {
                boolean isInRange = (Boolean)value;
                if (!isInRange) {
                    throw new UserRoleOrgException(UserRoleOrgException.ORGRANGE_ERROR, new Object[]{fullOrgUnitInfo.getNumber(), userInfo.getNumber()});
                }
            }
            int type = Administrator.isBizAdmin(ctx, ctx.getCaller()) ? 30 : 10;
            StringBuilder sb = new StringBuilder();
            sb.append("select top 1 1 from t_org_baseunit org where fid=? and exists (select 1 from t_pm_orgrange ogr ").append(" where ogr.forgid = org.FCONTROLUNITID and ogr.fuserid =? and ogr.ftype=?)");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{fullOrgUnitInfo.getId().toString(), ctx.getCaller().toString(), type});
            if (!rs.next()) {
                throw new UserRoleOrgException(UserRoleOrgException.ORG_CANNOT_MANAGER, new Object[]{fullOrgUnitInfo.getNumber(), ctx.getUserName()});
            }
            String userCheck = "select top 1 1 from t_pm_orgrange where fuserid=? and forgid=? and ftype=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)userCheck, (Object[])new Object[]{ctx.getCaller().toString(), userInfo.getCU().getId().toString(), type});
            if (!rs.next()) {
                throw new UserRoleOrgException(UserRoleOrgException.USER_CANNOT_MANAGER, new Object[]{userInfo.getNumber(), ctx.getUserName()});
            }
            String roleCheck = "select top 1 1 from t_pm_orgrange where fuserid =? and forgid=? and ftype =?";
            rs = DbUtil.executeQuery((Context)ctx, (String)roleCheck, (Object[])new Object[]{userInfo.getId().toString(), fullOrgUnitInfo.getId().toString(), roleType});
            if (!rs.next()) {
                if (PermType.AUTHORIZATION.equals((Object)permType)) {
                    throw new UserRoleOrgException(UserRoleOrgException.ROLE_AUTHORIZATION_ERROR, new Object[]{role.getNumber(), fullOrgUnitInfo.getNumber(), userInfo.getNumber()});
                }
                if (PermType.NORMAL.equals((Object)permType)) {
                    throw new UserRoleOrgException(UserRoleOrgException.ROLE_ADD_ERROR, new Object[]{role.getNumber(), fullOrgUnitInfo.getNumber(), userInfo.getNumber()});
                }
            }
            UserRoleOrgInfo uro = new UserRoleOrgInfo();
            uro.setUser(userInfo);
            uro.setOrg(fullOrgUnitInfo);
            uro.setRole(role);
            return new UserRoleOrgInfoWrapper(uro, permType);
        }
        catch (EASBizException e) {
            this.logger.error((Object)("bizException ! hsData is:" + hsData), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)("bosException !hsData is:" + hsData), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("FUserNumber", StringUtils.cnulls((String)rs.getString("userId.number")));
            result.put("FUserName", StringUtils.cnulls((String)rs.getString("userId.name")));
            result.put("FOrgNumber", StringUtils.cnulls((String)rs.getString("orgId.number")));
            result.put("FOrgName", StringUtils.cnulls((String)rs.getString("orgId.name")));
            result.put("FRoleNumber", StringUtils.cnulls((String)rs.getString("roleId.number")));
            result.put("FRoleName", StringUtils.cnulls((String)rs.getString("roleId.name")));
            result.put("FRoleType", 10);
        }
        catch (SQLException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            UserRoleOrgInfoWrapper wrapper = (UserRoleOrgInfoWrapper)coreBaseInfo;
            ArrayList<String> assignRoleIdList = new ArrayList<String>();
            assignRoleIdList.add(wrapper.getUserRoleOrgInfo().getRoleId());
            if (!GroupLicenseUseInfoUtil.assignRoles(ctx, wrapper.getUserRoleOrgInfo().getUserId(), assignRoleIdList)) {
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"ASSIGN_DATA_NOTENOUGH"));
            }
            UserRoleOrgManagerFactory.getLocalInstance(ctx).addnew(wrapper.getUserRoleOrgInfo(), wrapper.getType());
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage() + EASResource.getString((String)RESOURCE, (String)"SUBMIT_DATA_FAILD"), ex.getCause());
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.base.permission.app.UserRoleOrgQuery";
    }

    static class UserRoleOrgInfoWrapper
    extends CoreBaseInfo {
        private UserRoleOrgInfo uro = null;
        private PermType type = null;

        public UserRoleOrgInfoWrapper(UserRoleOrgInfo uro, PermType type) {
            this.uro = uro;
            this.type = type;
        }

        public UserRoleOrgInfo getUserRoleOrgInfo() {
            return this.uro;
        }

        public PermType getType() {
            return this.type;
        }
    }
}

