/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan.invaliddata;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.ScanStatusEnum;
import com.kingdee.eas.base.permission.app.clear.common.AbstractScan;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearScanUnit;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearStrategyScan;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class InvalidDataScan
extends AbstractScan
implements IPermClearStrategyScan {
    protected List<IPermClearScanUnit> scanUnits = new ArrayList<IPermClearScanUnit>();
    private int scanCounts = 0;

    @Override
    public String serialize() {
        return new Gson().toJson((Object)this);
    }

    @Override
    public void unSerialize(String clobContent) {
        InvalidDataScan permRankScan = new InvalidDataScan();
        if (!StringUtils.isEmpty((String)clobContent)) {
            try {
                permRankScan = (InvalidDataScan)new Gson().fromJson(clobContent, InvalidDataScan.class);
                this.scanUnits = permRankScan.scanUnits;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    public void execScaning(Context ctx) throws BOSException, SQLException {
        for (IPermClearScanUnit scanUnit : this.scanUnits) {
            scanUnit.scan(ctx);
            ++this.scanCounts;
        }
    }

    @Override
    public boolean refreshScan() {
        boolean isExistsSuccess = false;
        for (IPermClearScanUnit scanUnit : this.scanUnits) {
            scanUnit.refreshScan();
            if (scanUnit.getScanStatus() != ScanStatusEnum.FINISHED) continue;
            isExistsSuccess = true;
        }
        if (this.isScanFinished) {
            this.scanStatus = isExistsSuccess ? ScanStatusEnum.FINISHED : ScanStatusEnum.FAIL;
        }
        return this.isScanFinished;
    }

    @Override
    public int getCounts() {
        return this.scanUnits.size();
    }

    @Override
    public int getScanCounts() {
        return this.scanCounts;
    }

    @Override
    public int getScanDataCounts() {
        int counts = 0;
        for (IPermClearScanUnit scanUnit : this.scanUnits) {
            counts += scanUnit.getScanDataCounts();
        }
        return counts;
    }

    @Override
    public int getScanUsersCounts() {
        int counts = 0;
        for (IPermClearScanUnit scanUnit : this.scanUnits) {
            counts += scanUnit.getScanUsersCounts();
        }
        return counts;
    }

    @Override
    public int getScanRoleCounts() {
        int counts = 0;
        for (IPermClearScanUnit scanUnit : this.scanUnits) {
            counts += scanUnit.getScanRoleCounts();
        }
        return counts;
    }

    @Override
    public int getScanPermCounts() {
        int counts = 0;
        for (IPermClearScanUnit scanUnit : this.scanUnits) {
            counts += scanUnit.getScanPermCounts();
        }
        return counts;
    }

    @Override
    public int getScanOrgCounts() {
        int counts = 0;
        for (IPermClearScanUnit scanUnit : this.scanUnits) {
            counts += scanUnit.getScanOrgCounts();
        }
        return counts;
    }
}

