/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.task.job;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.permission.PermClearTaskStatusEnum;
import com.kingdee.eas.base.permission.app.clear.common.PermClearUtils;
import com.kingdee.eas.base.permission.app.clear.task.InnerTaskRunData;
import com.kingdee.eas.base.permission.app.clear.task.job.IClearJob;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.impl.JobDetailImpl;

public abstract class AbstractClearJob
implements IClearJob,
Job {
    public static final String CTX = "eas-context";
    protected String taskId = null;
    protected String startTime = null;
    protected String endTime = null;
    protected PermClearTaskStatusEnum taskStatus;
    protected String errorMsg = null;
    protected InnerTaskRunData runData = null;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.taskStatus = PermClearTaskStatusEnum.execing;
        JobDetailImpl jobDetail = (JobDetailImpl)jobExecutionContext.getJobDetail();
        this.taskId = jobDetail.getName();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        Context ctx = (Context)jobDataMap.get((Object)CTX);
        this.startTime = PermClearUtils.getDateStr(new Date());
        try {
            this.executeCleanBefore(ctx, this.taskId);
            this.executeClean(ctx, this.taskId);
            this.taskStatus = PermClearTaskStatusEnum.execFinished;
        }
        catch (Exception e) {
            this.taskStatus = PermClearTaskStatusEnum.execFail;
            this.errorMsg = e.getMessage();
            Logger.error((Throwable)e);
        }
        this.endTime = PermClearUtils.getDateStr(new Date());
        try {
            this.executeCleanAfter(ctx, this.taskId);
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    @Override
    public void executeCleanBefore(Context ctx, String taskId) throws BOSException {
        this.runData = new InnerTaskRunData();
        this.runData.setStartTime(PermClearUtils.getDateStr(new Date()));
        this.runData.setRunServer(System.getProperty("EAS_INSTANCE_HOME"));
        DbUtil.execute((Context)ctx, (String)"update T_PM_PermClearTask set ftaskStatus=?,FInnerTaskRunData=? where fid = ?", (Object[])new Object[]{PermClearTaskStatusEnum.execing.getValue(), this.runData.serialize(), taskId});
    }

    @Override
    public abstract void executeClean(Context var1, String var2) throws BOSException;

    @Override
    public void executeCleanAfter(Context ctx, String taskId) throws BOSException {
        this.runData.setEndTime(PermClearUtils.getDateStr(new Date()));
        this.runData.setErrorMsg(this.errorMsg);
        DbUtil.execute((Context)ctx, (String)"update T_PM_PermClearTask set ftaskStatus=?,FInnerTaskRunData=? where fid = ?", (Object[])new Object[]{this.taskStatus.getValue(), this.runData.serialize(), taskId});
    }
}

