/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IRolePerm;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.UserRolePermCollection;
import com.kingdee.eas.base.permission.UserRolePermInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class UserRolePermHelper {
    public UserOrgPermCollection getUserRoleAuthorizationPerm(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws EASBizException, BOSException {
        UserOrgPermCollection permCol = new UserOrgPermCollection();
        if (!Administrator.isBizAdmin(ctx, userPK)) {
            return permCol;
        }
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance(ctx);
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(userPK.toString());
        ArrayList<String> orgList = new ArrayList<String>();
        orgList.add(orgPK.toString());
        UserRolePermCollection userRolePermCol = iUserRoleOrgManager.getUserRolePermCol(userList, orgList, null);
        if (userRolePermCol == null) {
            return permCol;
        }
        IRolePerm iRolePerm = RolePermFactory.getLocalInstance(ctx);
        HashSet permItemIdMap = new HashSet();
        int size = userRolePermCol.size();
        for (int i = 0; i < size; ++i) {
            UserRolePermInfo userRolePermInfo = userRolePermCol.get(i);
            RoleInfo roleInfo = userRolePermInfo.getRoleId();
            if (roleInfo == null || roleInfo.getId() == null) continue;
            RolePermCollection rolePermCol = iRolePerm.findRolePermInfo(roleInfo.getId().toString(), null, PermType.AUTHORIZATION);
            this.setPermItemIdMapFrom(permItemIdMap, rolePermCol);
        }
        return this.convertPermItemMap2UserOrgPermCol(ctx, permItemIdMap);
    }

    private UserOrgPermCollection convertPermItemMap2UserOrgPermCol(Context ctx, Set permItemIdMap) throws BOSException {
        UserOrgPermCollection userOrgPermCol = new UserOrgPermCollection();
        if (permItemIdMap == null || permItemIdMap.isEmpty()) {
            return userOrgPermCol;
        }
        String idListStr = ToolUtils.aryToStr(permItemIdMap, true);
        IPermItem iPermItem = PermItemFactory.getLocalInstance(ctx);
        PermItemCollection permItemCol = iPermItem.getPermItemCollection("select * where id in (" + idListStr + ")");
        if (permItemCol == null || permItemCol.isEmpty()) {
            return userOrgPermCol;
        }
        int size = permItemCol.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo userOrgPermInfo = new UserOrgPermInfo();
            userOrgPermInfo.setPermItem(permItemCol.get(i));
            userOrgPermCol.add(userOrgPermInfo);
        }
        return userOrgPermCol;
    }

    private void setPermItemIdMapFrom(Set permItemIdMap, RolePermCollection rolePermCol) {
        if (rolePermCol == null || rolePermCol.isEmpty()) {
            return;
        }
        int size = rolePermCol.size();
        for (int i = 0; i < size; ++i) {
            RolePermInfo rolePermInfo = rolePermCol.get(i);
            if (rolePermInfo == null || rolePermInfo.getPermItem() == null || rolePermInfo.getPermItem().getId() == null) continue;
            permItemIdMap.add(rolePermInfo.getPermItem().getId().toString());
        }
    }

    public UserOrgPermCollection interPermItemCol(UserOrgPermCollection src, UserOrgPermCollection dest) {
        int i;
        if (src == null || src.isEmpty()) {
            return dest;
        }
        if (dest == null || dest.isEmpty()) {
            return src;
        }
        HashSet<String> srcPermIdSet = new HashSet<String>();
        srcPermIdSet.add("");
        int size = src.size();
        for (i = 0; i < size; ++i) {
            srcPermIdSet.add(this.getIdFromCol(src.get(i)));
        }
        size = dest.size();
        for (i = 0; i < size; ++i) {
            if (srcPermIdSet.contains(this.getIdFromCol(dest.get(i)))) continue;
            src.add(dest.get(i));
        }
        return src;
    }

    private String getIdFromCol(UserOrgPermInfo src) {
        if (src != null && src.getPermItem() != null && src.getPermItem().getId() != null) {
            return src.getPermItem().getId().toString();
        }
        return "";
    }

    public void exportLongNumberLevel(Context ctx, IRowSet rs, Hashtable result) throws TaskExternalException {
        try {
            String longNubmerStr;
            String[] longNumberArr;
            String longNumberResult;
            if (rs.getString("permItem.longNumber") != null && (longNumberResult = StringUtils.cnulls((String)rs.getString("permItem.longNumber")).replaceAll("!", ">")).length() != 0 && longNumberResult.indexOf(">") != -1 && (longNumberArr = (longNubmerStr = longNumberResult.substring(longNumberResult.indexOf(">") + 1)).split(">")).length > 1) {
                result.put("F1LevelCategory", longNumberArr[0]);
                if (longNumberArr.length > 2) {
                    result.put("F2LevelCategory", longNumberArr[1]);
                }
                if (longNumberArr.length > 3) {
                    String PermNameStr1 = longNubmerStr.substring(longNubmerStr.indexOf(">") + 1);
                    String PermNameStr2 = PermNameStr1.substring(PermNameStr1.indexOf(">") + 1);
                    String detailPermName = PermNameStr2.substring(0, PermNameStr2.lastIndexOf(">"));
                    result.put("FDetailCategory", detailPermName);
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

