/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.scheduler.job;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.EASCloudEnum;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.app.scheduler.job.ReLoadJobConfigsJob;
import com.kingdee.eas.base.uiframe.EasCloud;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LicenseUpdateJob
implements Job {
    private static final Logger logger = Logger.getLogger(ReLoadJobConfigsJob.class);
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        try {
            Context ctx = new Context();
            EASCloudEnum easCloudEnum = LicenseUpdateJob.getEASCloudEnum(ctx);
            if (EASCloudEnum.CLOUD_PUBLIC.equals((Object)easCloudEnum) || EASCloudEnum.CLOUD_PUBLIC_SIMPLE.equals((Object)easCloudEnum)) {
                String licenseFilePath = this.downloadLicenseFile(ctx);
                String fileId = String.valueOf(System.currentTimeMillis());
                this.uploadLicenseFile(ctx, fileId, licenseFilePath);
                String result = CloudRegistSrvAgentFactory.getLocalInstanceWithContext((Context)ctx).getRebelLicenseStatus(fileId);
                JSONObject o = JSONObject.parseObject((String)result);
                boolean success = o.getBoolean("success");
                if (!success) {
                    throw new BOSException(EASResource.getString((String)RESOURCE, (String)"\u4e0b\u8f7d\u7684license\u6587\u4ef6\u89e3\u6790\u5931\u8d25"));
                }
                logger.error((Object)"\u6267\u884clicense\u81ea\u52a8\u66f4\u65b0\u6210\u529f\uff01");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u6267\u884clicense\u81ea\u52a8\u66f4\u65b0\u5931\u8d25\uff01" + e));
            e.printStackTrace();
        }
    }

    public static EASCloudEnum getEASCloudEnum(Context ctx) {
        EASCloudEnum easCloudEnum = null;
        try {
            easCloudEnum = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getRemoteEASCloudVersion();
        }
        catch (LicenseException e) {
            logger.error((Object)"com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool.getEASCloudEnum", (Throwable)e);
        }
        if (easCloudEnum == null) {
            easCloudEnum = EASCloudEnum.CLOUD_PRIVATE;
        }
        return easCloudEnum;
    }

    private String downloadLicenseFile(Context ctx) throws Exception {
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        String prod_inst_code = baseInfo.getProductInstanceID();
        File file = File.createTempFile(System.currentTimeMillis() + "", ".zip");
        System.out.println("path=" + file.getPath());
        if (2 == baseInfo.getLicenseType()) {
            EasCloud.downloadLicenseKBC((String)prod_inst_code, (String)file.getPath());
        } else {
            EasCloud.downloadLicense((String)prod_inst_code, (String)file.getPath());
        }
        System.out.println("******download over***");
        return file.getPath();
    }

    private void uploadLicenseFile(Context ctx, String fileId, String licenseFilePath) throws BOSException {
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(licenseFilePath));
            int position = 0;
            int readSize = 0x500000;
            int totalSize = input.available();
            readSize = readSize < totalSize ? readSize : totalSize;
            ICloudRegistSrv irs = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx);
            while (position < totalSize) {
                byte[] bf = new byte[readSize];
                input.read(bf, 0, readSize);
                irs.uploadCloudLicenseFile(fileId, bf);
                readSize = totalSize - (position += readSize) < readSize ? totalSize - position : readSize;
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2);
                }
            }
        }
    }
}

