/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermDebugHelper;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.service.IFunctionPermissionService;
import com.kingdee.eas.base.permission.app.util.DebugHelper;
import com.kingdee.eas.base.permission.app.util.FilterHelper;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.FunctionPermissionFilter;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FunctionPermissionService
implements IFunctionPermissionService {
    private static Logger logger = Logger.getLogger((String)FunctionPermissionService.class.getName());
    private Context context = null;

    public FunctionPermissionService(Context context) {
        this.context = context;
    }

    private Set checkMatchOrgType(IObjectPK[] orgPKs, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        HashSet<String> noMatchOrgs = new HashSet<String>();
        if (permItemInfo == null || orgPKs == null || orgPKs.length == 0 || OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            return noMatchOrgs;
        }
        HashSet<IObjectPK> orgS = new HashSet<IObjectPK>();
        for (int i = 0; i < orgPKs.length; ++i) {
            if (orgPKs[i] == null) continue;
            orgS.add(orgPKs[i]);
        }
        if (orgS.size() == 0) {
            return noMatchOrgs;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", orgS, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add("id");
        selectColl.add("OrgTypeStr");
        viewInfo.setSelector(selectColl);
        try {
            FullOrgUnitCollection orgUnitColl = FullOrgUnitFactory.getLocalInstance((Context)this.context).getFullOrgUnitCollection(viewInfo);
            if (orgUnitColl == null || orgUnitColl.size() == 0) {
                return noMatchOrgs;
            }
            String orgTypeStr = null;
            String orgID = null;
            Object[] orgTypeArray = null;
            String permItemName = permItemInfo.getOrgRelation().getName();
            for (int i = 0; i < orgUnitColl.size(); ++i) {
                FullOrgUnitInfo fullOrgInfo = orgUnitColl.get(i);
                orgID = fullOrgInfo.getId().toString();
                orgTypeStr = fullOrgInfo.getOrgTypeStr();
                if (orgTypeStr == null) {
                    noMatchOrgs.add(orgID);
                    continue;
                }
                orgTypeArray = orgTypeStr.split(";");
                Arrays.sort(orgTypeArray);
                if (Arrays.binarySearch(orgTypeArray, permItemName) >= 0) continue;
                noMatchOrgs.add(orgID);
                orgTypeStr = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
        return noMatchOrgs;
    }

    private boolean checkMatchPermType(PermItemInfo permItemInfo, IObjectPK userPK) throws EASBizException, BOSException {
        if (permItemInfo == null || userPK == null) {
            return true;
        }
        PermItemType permItemType = permItemInfo.getType();
        if (PermItemType.SYSTEM_ADMIN_FUNCTION == permItemType) {
            if (Administrator.isCUAdmin(this.context, userPK)) {
                return true;
            }
            if (Administrator.isCertifyAdmin(this.context, userPK)) {
                return true;
            }
            return this.isAuditAdminEnabled() && Administrator.isAuditAdmin(this.context, userPK);
        }
        if (PermItemType.BIZ_ADMIN_FUNCTION == permItemType) {
            return Administrator.isBizAdmin(this.context, userPK) || Administrator.isCUAdmin(this.context, userPK);
        }
        if (PermItemType.BIZ_FUNCTION == permItemType) {
            return !Administrator.isCUAdmin(this.context, userPK);
        }
        return true;
    }

    @Override
    public Set checkBatchPermission(IObjectPK userPK, IObjectPK[] orgPKs, String permItemName) throws BOSException, EASBizException {
        HashSet<String> orgSet = new HashSet<String>();
        HashSet<String> retOrgSet = new HashSet<String>();
        for (int i = 0; i < orgPKs.length; ++i) {
            orgSet.add(orgPKs[i].toString());
        }
        if (FunctionPermissionFilter.getFilter().isCanIgnore(permItemName)) {
            return orgSet;
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        if (!this.checkMatchPermType(permItemInfo, userPK)) {
            return new HashSet();
        }
        Set noMatchOrgS = this.checkMatchOrgType(orgPKs, permItemInfo);
        if (this.isIngorePermission(userPK, permItemName)) {
            return orgSet;
        }
        UserInfo userInfo = PermissionUtil.getUserInfo(this.context, userPK);
        boolean isCUAdmin = userInfo.getType().equals((Object)UserType.SYSTEM);
        boolean isBizAdmin = userInfo.isBizAdmin();
        boolean isCertifyAdmin = UserType.AUTHENTICATEADMIN.equals((Object)userInfo.getType());
        boolean isAuditAdmin = UserType.AUDITADMIN.equals((Object)userInfo.getType());
        if (isCUAdmin) {
            boolean flag;
            boolean bl = flag = PermItemType.SYSTEM_ADMIN_FUNCTION.equals((Object)permItemInfo.getType()) || PermItemType.BIZ_ADMIN_FUNCTION.equals((Object)permItemInfo.getType()) || PermItemType.INTEGRATION_FUNCTION.equals((Object)permItemInfo.getType());
            if (flag) {
                return orgSet;
            }
            return new HashSet();
        }
        if (isCertifyAdmin && "'bs_certify_authenticateAdmin','bs_permission_USBKeyUser_view','bs_permission_dynamicCard_View','bs_permission_IDSecondAuthenticate','bs_permission_authenrecord_deal','bs_log_config'".indexOf(permItemInfo.getName()) != -1) {
            return orgSet;
        }
        if (isAuditAdmin && "'bs_permission_auditAdmin','bs_log_config'".indexOf(permItemInfo.getName()) != -1) {
            return orgSet;
        }
        if (isBizAdmin && PermItemType.BIZ_ADMIN_FUNCTION.equals((Object)permItemInfo.getType())) {
            return orgSet;
        }
        if (PermItemType.SYSTEM_ADMIN_FUNCTION.equals((Object)permItemInfo.getType())) {
            return new HashSet();
        }
        String userID = userPK.toString();
        String orgIDs = ToolUtils.aryToStr(ToolUtils.objAryToList(orgPKs));
        String permItemID = permItemInfo.getId().toString();
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            StringBuffer sql = new StringBuffer(2000);
            sql.append(" SELECT UserOrgPerm.FPermType AS FPermType ,UserOrgPerm.FOrgID as FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner =  ").append("'" + userID + "'").append(" AND UserOrgPerm.FOrgID ='").append("11111111-1111-1111-1111-111111111111CCE7AED4'").append(" AND UserOrgPerm.FPermItemID =  ").append("'" + permItemID + "'").append(" AND UserOrgPerm.FPermType <> ").append(30).append(" ").append(" UNION ").append(" SELECT RolePerm.FPermType AS FPermType,UserRoleOrg.FOrgID as FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE UserRoleOrg.FUserID =  ").append("'" + userID + "'");
            sql.append(" AND UserRoleOrg.FOrgID='").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ");
            sql.append(" AND RolePerm.FPermItemID =  ").append("'" + permItemID + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString());
            try {
                boolean hasPermFlag = false;
                while (rowSet.next()) {
                    int permType = rowSet.getInt("FPermType");
                    if (permType == 10) {
                        hasPermFlag = true;
                        continue;
                    }
                    if (permType != 20) continue;
                    return new HashSet();
                }
                if (hasPermFlag) {
                    return orgSet;
                }
                return new HashSet();
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
            }
        }
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" SELECT UserOrgPerm.FPermType AS FPermType ,UserOrgPerm.FOrgID as FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner =  ").append("'" + userID + "'").append(" AND UserOrgPerm.FOrgID in (").append(orgIDs + ") ").append(" AND UserOrgPerm.FPermItemID =  ").append("'" + permItemID + "'").append(" AND UserOrgPerm.FPermType <> ").append(30).append(" ").append(" UNION ").append(" SELECT RolePerm.FPermType AS FPermType,UserRoleOrg.FOrgID as FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE UserRoleOrg.FUserID =  ").append("'" + userID + "'");
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            sql.append(" AND ( 1 = 1 OR UserRoleOrg.FOrgID in (").append(orgIDs).append(") ");
        } else {
            sql.append(" AND UserRoleOrg.FOrgID in (").append(orgIDs).append(") ");
        }
        sql.append(" AND RolePerm.FPermItemID =  ").append("'" + permItemID + "'").append(" AND PermItem.FOrgRelation =  ").append(permItemInfo.getOrgRelation().getValue());
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString());
        try {
            HashSet<String> forbiddenOrg = new HashSet<String>();
            while (rowSet.next()) {
                int permType = rowSet.getInt("FPermType");
                String string = rowSet.getString("FOrgID");
                if (permType == 10) {
                    retOrgSet.add(string);
                    continue;
                }
                if (permType != 20) continue;
                forbiddenOrg.add(string);
            }
            for (Object e : forbiddenOrg) {
                if (!retOrgSet.contains(e)) continue;
                retOrgSet.remove(e);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
        retOrgSet.removeAll(noMatchOrgS);
        return retOrgSet;
    }

    @Override
    public boolean hasPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName, boolean extOrgFromCtx) throws BOSException, EASBizException {
        Boolean result = false;
        result = this.hasPermission_old(userPK, orgPK, permItemName, extOrgFromCtx);
        return result;
    }

    public boolean hasPermission_old(IObjectPK userPK, IObjectPK orgPK, String permItemName, boolean extOrgFromCtx) throws BOSException, EASBizException {
        if (FunctionPermissionFilter.getFilter().isCanIgnore(permItemName)) {
            return true;
        }
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        UserInfo userInfo = PermissionUtil.getUserInfo(this.context, userPK);
        boolean isCUAdmin = UserType.SYSTEM.equals((Object)userInfo.getType());
        if (isCUAdmin && OperationType.READ == permItemInfo.getOperationType()) {
            return true;
        }
        if (!this.checkMatchPermType(permItemInfo, userPK)) {
            return false;
        }
        Set noMatchOrgS = this.checkMatchOrgType(new IObjectPK[]{orgPK}, permItemInfo);
        if (!noMatchOrgS.isEmpty()) {
            return false;
        }
        IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK(this.context, permItemInfo.getOrgRelation(), orgPK, null, extOrgFromCtx);
        if (permissionOrgPK == null) {
            return false;
        }
        if (this.isIngorePermission(userPK, permItemName)) {
            return true;
        }
        boolean isBizAdmin = userInfo.isBizAdmin();
        boolean isCertifyAdmin = UserType.AUTHENTICATEADMIN.equals((Object)userInfo.getType());
        boolean isAuditAdmin = UserType.AUDITADMIN.equals((Object)userInfo.getType());
        if (isCUAdmin) {
            boolean flag;
            boolean bl = flag = PermItemType.SYSTEM_ADMIN_FUNCTION.equals((Object)permItemInfo.getType()) || PermItemType.BIZ_ADMIN_FUNCTION.equals((Object)permItemInfo.getType()) || PermItemType.INTEGRATION_FUNCTION.equals((Object)permItemInfo.getType());
            if (!flag) {
                DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
            }
            return flag;
        }
        if (isCertifyAdmin && permItemName.equals("bs_certify_authenticateAdmin")) {
            return "00000000-0000-0000-0000-00000000000113B7DE7F".equals(userPK.toString());
        }
        if (isCertifyAdmin && "'bs_certify_authenticateAdmin','bs_permission_USBKeyUser_view','bs_permission_dynamicCard_View','bs_permission_IDSecondAuthenticate','bs_permission_authenrecord_deal','bs_log_config'".indexOf(permItemInfo.getName()) != -1) {
            return true;
        }
        if (isCertifyAdmin && "'bs_permission_IDSecondAuthenticate'".indexOf(permItemInfo.getName()) != -1) {
            return true;
        }
        if (isAuditAdmin && "'bs_permission_auditAdmin','bs_log_config'".indexOf(permItemInfo.getName()) != -1) {
            return true;
        }
        if (isBizAdmin && PermItemType.BIZ_ADMIN_FUNCTION.equals((Object)permItemInfo.getType())) {
            return true;
        }
        if (PermItemType.SYSTEM_ADMIN_FUNCTION.equals((Object)permItemInfo.getType())) {
            DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
            return false;
        }
        String userID = userPK.toString();
        String orgID = permissionOrgPK.toString();
        String permItemID = permItemInfo.getId().toString();
        Object[] params = new Object[]{userID, orgID, permItemID, userID, orgID, permItemID, new Integer(permItemInfo.getOrgRelation().getValue())};
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" SELECT UserOrgPerm.FPermType AS FPermType FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ");
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            sql.append(" AND ( 1 = 1 OR UserOrgPerm.FOrgID = ? ) ");
        } else {
            sql.append(" AND UserOrgPerm.FOrgID = ? ");
        }
        sql.append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType <> ").append(30);
        sql.append(" UNION ").append(" SELECT RolePerm.FPermType AS FPermType FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE UserRoleOrg.FUserID = ? ");
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            sql.append(" AND ( 1 = 1 OR UserRoleOrg.FOrgID = ? ) ");
        } else {
            sql.append(" AND UserRoleOrg.FOrgID = ? ");
        }
        sql.append(" AND RolePerm.FPermItemID = ? ").append(" AND PermItem.FOrgRelation = ? ").append(FilterHelper.getS1BaseDataFilter(permissionOrgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
        try {
            boolean flag = false;
            while (rowSet.next()) {
                int permType = rowSet.getInt("FPermType");
                if (permType == 20) {
                    DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
                    return false;
                }
                if (permType != 10) continue;
                flag = true;
            }
            if (!flag) {
                DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
            }
            return flag;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
    }

    @Override
    public Map hasBatchPermission(IObjectPK userPK, IObjectPK orgPK, Map permItemNames, boolean extOrgFromCtx) throws BOSException, EASBizException {
        HashMap<Integer, Boolean> ret = new HashMap<Integer, Boolean>();
        HashMap permItemNamesCopy = new HashMap();
        HashMap<Integer, String> permOrgMap = new HashMap<Integer, String>();
        permItemNamesCopy.putAll(permItemNames);
        Set permIndexSet = permItemNamesCopy.keySet();
        for (Integer permIndex : permIndexSet) {
            String permItemName = (String)permItemNamesCopy.get(permIndex);
            if (FunctionPermissionFilter.getFilter().isCanIgnore(permItemName)) {
                PermDebugHelper.logInfo("hasPermission:isCanIgnore: " + permItemName + " return true");
                ret.put(permIndex, Boolean.TRUE);
                permItemNames.remove(permIndex);
                continue;
            }
            StringBuffer paramLog = new StringBuffer().append("FunctionPermissionService.hasPermission param:").append("userPK:").append(userPK).append(",orgPK:").append(orgPK).append(",permItemName:").append(permItemName).append(",extOrgFromCtx:").append(extOrgFromCtx);
            PermDebugHelper.logInfo(paramLog.toString());
            PermDebugHelper.putPermLog(paramLog.toString());
            PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
            if (!this.checkMatchPermType(permItemInfo, userPK)) {
                logger.info((Object)("user and permItemType not match! userPK is:" + StringUtils.cnulls((Object)userPK) + " and permItemType is: " + permItemInfo.getType().getAlias() + " permItemNumber is:" + permItemInfo.getNumber()));
                ret.put(permIndex, Boolean.FALSE);
                permItemNames.remove(permIndex);
                continue;
            }
            Set noMatchOrgS = this.checkMatchOrgType(new IObjectPK[]{orgPK}, permItemInfo);
            if (!noMatchOrgS.isEmpty()) {
                logger.info((Object)("Organization type and permItem orgRelation type not match! orgPK is:" + ToolUtils.aryToStr(noMatchOrgS) + " and permItemType is: " + permItemInfo.getOrgRelation().getAlias() + " permItemNumber is:" + permItemInfo.getNumber()));
                ret.put(permIndex, Boolean.FALSE);
                permItemNames.remove(permIndex);
                continue;
            }
            IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK(this.context, permItemInfo.getOrgRelation(), orgPK, null, extOrgFromCtx);
            if (permissionOrgPK == null) {
                PermDebugHelper.logInfo("hasPermission permissionOrgPK is null");
                ret.put(permIndex, Boolean.FALSE);
                permItemNames.remove(permIndex);
                permOrgMap.remove(permIndex);
                continue;
            }
            permOrgMap.put(permIndex, permissionOrgPK.toString());
            if (this.isIngorePermission(userPK, permItemName)) {
                ret.put(permIndex, Boolean.TRUE);
                permItemNames.remove(permIndex);
                permOrgMap.remove(permIndex);
                continue;
            }
            UserInfo userInfo = PermissionUtil.getUserInfo(this.context, userPK);
            boolean isCUAdmin = userInfo.getType().equals((Object)UserType.SYSTEM);
            boolean isBizAdmin = userInfo.isBizAdmin();
            boolean isCertifyAdmin = UserType.AUTHENTICATEADMIN.equals((Object)userInfo.getType());
            boolean isAuditAdmin = UserType.AUDITADMIN.equals((Object)userInfo.getType());
            if (isCUAdmin) {
                boolean flag;
                boolean bl = flag = PermItemType.SYSTEM_ADMIN_FUNCTION.equals((Object)permItemInfo.getType()) || PermItemType.BIZ_ADMIN_FUNCTION.equals((Object)permItemInfo.getType()) || PermItemType.INTEGRATION_FUNCTION.equals((Object)permItemInfo.getType());
                if (!flag) {
                    DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
                }
                ret.put(permIndex, flag);
                permItemNames.remove(permIndex);
                permOrgMap.remove(permIndex);
                continue;
            }
            if (isCertifyAdmin && "'bs_certify_authenticateAdmin','bs_permission_USBKeyUser_view','bs_permission_dynamicCard_View','bs_permission_IDSecondAuthenticate','bs_permission_authenrecord_deal','bs_log_config'".indexOf(permItemInfo.getName()) != -1) {
                ret.put(permIndex, Boolean.TRUE);
                permItemNames.remove(permIndex);
                permOrgMap.remove(permIndex);
                continue;
            }
            if (isAuditAdmin && "'bs_permission_auditAdmin','bs_log_config'".indexOf(permItemInfo.getName()) != -1) {
                ret.put(permIndex, Boolean.TRUE);
                permItemNames.remove(permIndex);
                permOrgMap.remove(permIndex);
                continue;
            }
            if (isBizAdmin && PermItemType.BIZ_ADMIN_FUNCTION.equals((Object)permItemInfo.getType())) {
                ret.put(permIndex, Boolean.TRUE);
                permItemNames.remove(permIndex);
                permOrgMap.remove(permIndex);
                continue;
            }
            if (!PermItemType.SYSTEM_ADMIN_FUNCTION.equals((Object)permItemInfo.getType())) continue;
            DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
            ret.put(permIndex, Boolean.FALSE);
            permItemNames.remove(permIndex);
            permOrgMap.remove(permIndex);
        }
        if (permItemNames.size() > 0) {
            permIndexSet = permItemNames.keySet();
            Iterator it = permIndexSet.iterator();
            HashSet<String> permIdSet = new HashSet<String>();
            HashSet orgIdSet = new HashSet();
            HashMap<String, String> permIdNameMap = new HashMap<String, String>();
            while (it.hasNext()) {
                Integer permIndex = (Integer)it.next();
                String permItemName = (String)permItemNames.get(permIndex);
                PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
                if (permItemInfo == null) continue;
                permIdSet.add(permItemInfo.getId().toString());
                orgIdSet.add(permOrgMap.get(permIndex));
                permIdNameMap.put(permItemInfo.getId().toString(), permItemName);
            }
            IObjectPK newOrgPK = orgPK;
            if (orgPK == null) {
                newOrgPK = new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
            }
            String userID = userPK.toString();
            StringBuffer sql = new StringBuffer(2000);
            ArrayList<String> listParams = new ArrayList<String>();
            sql.append(" SELECT uop.FPermItemID AS FPermItemID,uop.FPermType AS FPermType,ob.FOrgTypeStr AS FOrgTypeStr FROM T_PM_UserOrgPerm uop ").append(" INNER JOIN  T_Org_BaseUnit ob ON ob.FID = uop.FOrgID ").append(" INNER JOIN T_PM_PermItem pitem ON pitem.FID = uop.FPERMITEMID ").append(" WHERE uop.FOwner = ?");
            listParams.add(userID);
            sql.append(this.getOrgIDFilter(orgIdSet, "uop.FOrgID", listParams, "pitem.FORGRELATION")).append(this.getIDFilter(permIdSet, "uop.FPermItemID", listParams)).append(" AND uop.FPermType <> ").append(30).append(" ").append(" UNION ALL").append(" SELECT rp.FPermItemID AS FPermItemID,rp.FPermType AS FPermType,ob.FOrgTypeStr AS FOrgTypeStr FROM T_PM_RolePerm rp ").append(" INNER JOIN  T_PM_UserRoleOrg uro ON uro.FRoleID = rp.FRoleID ").append(" INNER JOIN  T_Org_BaseUnit ob ON ob.FID = uro.FOrgID ").append(" INNER JOIN T_PM_PermItem pitem ON pitem.FID = rp.FPermItemID ").append(" WHERE uro.FUserID = ?");
            listParams.add(userID);
            sql.append(this.getOrgIDFilter(orgIdSet, "uro.FOrgID", listParams, "pitem.FORGRELATION")).append(this.getIDFilter(permIdSet, "rp.FPermItemID", listParams)).append(" AND rp.FPermType <> ").append(30).append(" ").append(FilterHelper.getS1BaseDataFilter(newOrgPK, "pitem.FObjectType", "pitem.FOperationType"));
            PermDebugHelper.logInfo("check function perm sql is:" + sql.toString());
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])listParams.toArray());
            try {
                HashSet<String> hasBeenJudgedPerm = new HashSet<String>();
                while (rowSet.next()) {
                    String permItemId = rowSet.getString("FPermItemID");
                    int permType = rowSet.getInt("FPermType");
                    String orgTypeStr = rowSet.getString("FOrgTypeStr");
                    OrgTypeHelper orgTypeHelper = new OrgTypeHelper(orgTypeStr);
                    String permItemName = (String)permIdNameMap.get(permItemId);
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
                    OrgType orgType = permItemInfo.getOrgRelation();
                    if (!orgType.equals((Object)OrgType.NONE) && !orgTypeHelper.isOrgType(orgType) || hasBeenJudgedPerm.contains(permItemId)) continue;
                    if (permType == 20) {
                        DebugHelper.debugNoFunctionPermission(this.context, userPK, orgPK, permItemName);
                        StringBuffer permIsForbiddenLog = new StringBuffer().append(",no permission because permission :").append(permItemName).append("is forbidden");
                        PermDebugHelper.logInfo(permIsForbiddenLog.toString());
                        this.processResultMap(ret, permItemNames, permItemName, Boolean.FALSE);
                        hasBeenJudgedPerm.add(permItemId);
                        continue;
                    }
                    if (permType != 10) continue;
                    this.processResultMap(ret, permItemNames, permItemName, Boolean.TRUE);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
            }
        }
        return ret;
    }

    private String getIDFilter(Set idSet, String fieldName, List listParams) {
        StringBuffer sql = new StringBuffer();
        if (idSet == null || idSet.size() == 0) {
            return "";
        }
        sql.append(" AND (");
        Iterator idItr = idSet.iterator();
        int i = 0;
        while (idItr.hasNext()) {
            String idStr = (String)idItr.next();
            if (i == 0) {
                sql.append(fieldName).append(" = ?");
            } else {
                sql.append(" OR ").append(fieldName).append(" = ?");
            }
            listParams.add(idStr);
            ++i;
        }
        sql.append(") \r\n ");
        return sql.toString();
    }

    private String getOrgIDFilter(Set idSet, String fieldName, List listParams, String orgRelationField) {
        StringBuffer sql = new StringBuffer();
        if (idSet == null || idSet.size() == 0) {
            return "";
        }
        sql.append(" AND (");
        Iterator idItr = idSet.iterator();
        int i = 0;
        while (idItr.hasNext()) {
            String idStr = (String)idItr.next();
            if (i == 0) {
                sql.append(fieldName).append(" = ?");
            } else {
                sql.append(" OR ").append(fieldName).append(" = ?");
            }
            listParams.add(idStr);
            ++i;
        }
        sql.append(" OR ").append(orgRelationField).append(" = -1");
        sql.append(") \r\n ");
        return sql.toString();
    }

    private void processResultMap(Map ret, Map permItemNames, String permName, Boolean flag) {
        Set permIndexSet = permItemNames.keySet();
        for (Integer permIndex : permIndexSet) {
            if (!permName.equals(permItemNames.get(permIndex))) continue;
            ret.put(permIndex, flag);
        }
    }

    private boolean isIngorePermission(IObjectPK userPK, String permItemName) {
        return "bs_permission_user_view".equals(permItemName) && Administrator.isSuperCUAdmin(userPK);
    }

    private boolean isCertifyAdminEnabled() throws BOSException, EASBizException {
        return PermissionCommonUtil.isAuthenticateAdminEnabled(this.context);
    }

    private boolean isAuditAdminEnabled() throws BOSException, EASBizException {
        return PermissionCommonUtil.isAuditAdminEnabled(this.context);
    }

    private boolean isMachineRegisterEnabled() {
        return PermissionCommonUtil.isMachineRegisterEnabled(this.context);
    }

    @Override
    public void checkPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName, boolean extOrgFromCtx) throws EASBizException, BOSException {
        if (!this.hasPermission(userPK, orgPK, permItemName, extOrgFromCtx)) {
            UserInfo user = UserFactory.getLocalInstance(this.context).getUserByID(userPK);
            String userName = user != null ? user.getNumber() : "";
            PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
            if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
                Object[] object = new Object[]{userName, permItemInfo.getAlias()};
                throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION_2, object);
            }
            IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK(this.context, permItemInfo.getOrgRelation(), orgPK, null, extOrgFromCtx);
            if (permissionOrgPK == null) {
                Object[] object = new Object[]{userName, permItemInfo.getAlias()};
                throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION_2, object);
            }
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)this.context);
            FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo(permissionOrgPK);
            Object[] object = new Object[]{userName, fullOrgUnitInfo.getName(), permItemInfo.getAlias()};
            throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION_2, object);
        }
    }

    @Override
    public Collection getAuthorizedUsers(IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        assert (permItemName != null && orgPK != null);
        HashSet<String> result = new HashSet<String>();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        ObjectUuidPK permItemPK = new ObjectUuidPK(permItemInfo.getId());
        String orgID = orgPK.toString();
        String permItemID = permItemPK.toString();
        if (permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            orgID = "11111111-1111-1111-1111-111111111111CCE7AED4";
        }
        Object[] params = new Object[]{orgID, permItemID, new Integer(10), orgID, permItemID, new Integer(10), orgID, permItemID, new Integer(20), orgID, permItemID, new Integer(20)};
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT DISTINCT A.FUserID AS FID  FROM ( ");
        sql.append(" SELECT UserOrgPerm.FOwner AS FUserID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOrgID = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ");
        sql.append(" UNION ");
        sql.append(" SELECT UserRoleOrg.FUserID AS FUserID FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_RolePerm RolePerm ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE ");
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            sql.append(" ( 1 = 1 OR UserRoleOrg.FOrgID = ? ) ");
        } else {
            sql.append(" UserRoleOrg.FOrgID = ? ");
        }
        sql.append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ").append(" ) A WHERE A.FUserID NOT IN ( ");
        sql.append(" SELECT UserOrgPerm.FOwner AS FUserID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOrgID = ? ").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ");
        sql.append(" UNION ").append(" SELECT UserRoleOrg.FUserID AS FUserID FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_RolePerm RolePerm ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE ");
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            sql.append(" ( 1 = 1 OR UserRoleOrg.FOrgID = ? ) ");
        } else {
            sql.append(" UserRoleOrg.FOrgID = ? ");
        }
        sql.append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ");
        sql.append(" ) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return result;
    }

    private String queryPermissionSql() throws BOSException, EASBizException {
        String userID = this.context.getCaller().toString();
        boolean isCertifyAdminEnabled = this.isCertifyAdminEnabled();
        boolean isIDAuthorizeEnabled = PermissionCommonUtil.isIDAuthorizeEnabled(this.context);
        StringBuffer sql = new StringBuffer(1000);
        if (Administrator.isCUAdmin(this.context, this.context.getCaller())) {
            String excludePermItem = "'bs_certify_authenticateAdmin','bs_permission_authenrecord_deal'";
            if (isCertifyAdminEnabled) {
                excludePermItem = excludePermItem + "," + "'bs_certify_authenticateAdmin','bs_permission_USBKeyUser_view','bs_permission_dynamicCard_View','bs_permission_IDSecondAuthenticate','bs_permission_authenrecord_deal','bs_log_config'" + ",'bs_permission_IDSecondAuthenticate'";
            } else if (!isIDAuthorizeEnabled) {
                excludePermItem = excludePermItem + "," + "'bs_permission_IDSecondAuthenticate'";
            }
            excludePermItem = excludePermItem + ",'bs_permission_auditAdmin'";
            sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND ( FType = ").append(10).append(" AND FName NOT IN  (" + excludePermItem + ")").append(" OR FType = ").append(15).append(" OR FType = ").append(30).append(" ) ");
        } else if (this.isAuditAdminEnabled() && Administrator.isAuditAdmin(this.context, this.context.getCaller())) {
            sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(10).append(" AND FName IN ('bs_permission_auditAdmin','bs_log_config')");
        } else if (Administrator.isBizAdmin(this.context, this.context.getCaller())) {
            sql.append(this.getUserAndRolePermSql(userID)).append(" UNION all ").append(" SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(15);
        } else {
            sql.append(this.getUserAndRolePermSql(userID));
        }
        if (Administrator.isCertifyAdmin(this.context, this.context.getCaller())) {
            sql.append(" UNION All ");
            if (isCertifyAdminEnabled) {
                String includePermItem = "'bs_certify_authenticateAdmin','bs_permission_USBKeyUser_view','bs_permission_dynamicCard_View','bs_permission_IDSecondAuthenticate','bs_permission_authenrecord_deal','bs_log_config'";
                if (isIDAuthorizeEnabled) {
                    includePermItem = includePermItem + ",'bs_permission_IDSecondAuthenticate'";
                }
                sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(10).append(" AND FName IN (" + includePermItem + ")");
                if (!"00000000-0000-0000-0000-00000000000113B7DE7F".equals(this.context.getCaller().toString())) {
                    sql.append(" AND FName NOT IN ('bs_certify_authenticateAdmin')");
                }
            } else if ("00000000-0000-0000-0000-00000000000113B7DE7F".equals(this.context.getCaller().toString())) {
                sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(10).append(" AND FName IN ('bs_certify_authenticateAdmin')");
            } else {
                sql.append("SELECT FID AS FPermItemID FROM T_PM_PermItem ").append(" WHERE FIsLeaf = 1 ").append(" AND FType = ").append(10).append(" AND FName IN ('')");
            }
        }
        return sql.toString();
    }

    private String getUserAndRolePermSql(String userID) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID AS FPermItemID FROM T_PM_PermItem permitem where permitem.FISLEAF = 1 and (").append("  exists ( SELECT 1 from t_pm_userorgperm UserOrgPerm where UserOrgPerm.FOWNER ='" + userID + "'  and UserOrgPerm.FPERMITEMID = permitem.fid AND UserOrgPerm.FPermType = 10)").append(" or exists( SELECT 1 FROM t_pm_role role inner join t_pm_roleperm RolePerm on role.FID =RolePerm.FRoleID where RolePerm.FPERMITEMID =permitem.fid and RolePerm.FPermType = 10").append(" and exists (select 1 from T_PM_UserRoleOrg USERROLEORG where USERROLEORG.FUSERID = '" + userID + "' and USERROLEORG.FROLEID = role.FID)))");
        return sql.toString();
    }

    private boolean isShowAllOrg() throws BOSException {
        try {
            String isShowAllOrg = ParamManager.getParamValue((Context)this.context, null, (String)"IsShowAllOrgMenu");
            if (isShowAllOrg != null && "false".equalsIgnoreCase(isShowAllOrg)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"isShowAllOrg", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private String getUnionOrgSql(Context ctx, String userID, String tableAlias) throws BOSException, EASBizException {
        String orgSql = "";
        HashSet<String> orgIds = new HashSet<String>();
        String sql = "select a.forgid from t_pm_orgrange a join t_org_baseunit b on a.forgid=b.fid where a.fuserid='" + userID + "' and a.ftype=10 and b.fisunion=1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                orgIds.add(rs.getString("forgid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getUnionOrgSql", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (orgIds.size() > 0) {
            orgSql = " or " + tableAlias + ".FOrgID in (" + ToolUtils.aryToStr(orgIds) + ") ";
        }
        return orgSql;
    }

    @Override
    public String getFunctionPermissionsByMenu() throws BOSException, EASBizException {
        assert (this.context != null);
        String sql = this.queryPermissionSql();
        return sql;
    }

    @Override
    public Set getPermissions() throws BOSException, EASBizException {
        assert (this.context != null);
        HashSet<String> result = new HashSet<String>();
        String sql = this.queryPermissionSql();
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql);
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("FPermItemID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
        return result;
    }
}

