/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLockTypeEnum;
import com.kingdee.eas.base.permission.app.strategy.PasswordVerifyStrategy;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class CommonVerifyStrategy
extends PasswordVerifyStrategy {
    private static Logger logger = Logger.getLogger((String)CommonVerifyStrategy.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean authenticate(UserContextCallback userCtxCallback, String userName, String userPassword) throws Exception {
        this.checkPasswordSpelling(userPassword);
        Context ctx = userCtxCallback.getUserContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String logonPassword = PermissionUtil.decrypt(userInfo.getNumber(), userPassword);
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            if (!PermissionUtil.matchPassword(userInfo, logonPassword)) {
                logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userName));
                throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
            }
            if (StringUtils.isEmpty((String)logonPassword)) {
                throw new UserException(UserException.EMPTY_PASSWORD);
            }
            if ("kdadmin".equals(logonPassword)) {
                throw new UserException(UserException.DEFAULT_PASSWORD);
            }
        } else {
            boolean isLogon = false;
            this.checkUserInfoValidity(userInfo);
            try {
                block29: {
                    if (userInfo.isIsLocked()) {
                        int lockedMinutes = UserLockTypeEnum.UPDATE_PASSWORD.equals((Object)userInfo.getLockType()) ? userInfo.getSecurity().getLockUpdatePwTime() : userInfo.getSecurity().getLockTime();
                        int goneMinutes = (int)((System.currentTimeMillis() - userInfo.getLockedTime().getTime()) / 60000L);
                        if (goneMinutes - lockedMinutes >= 0) {
                            this.autoUnlock(ctx, userInfo);
                            userInfo.setErrCount(0);
                            isLogon = PermissionUtil.matchPassword(userInfo, logonPassword);
                            if (!isLogon) {
                                if (!userInfo.getSecurity().isNeedLocked()) {
                                    logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userName));
                                    throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                                }
                                if (userInfo.getSecurity().getLockCount() <= userInfo.getErrCount() + 1) {
                                    throw new UserException(UserException.USER_IS_LOCKED, new Object[]{new Integer(lockedMinutes)});
                                }
                                logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userName));
                                throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                            }
                            break block29;
                        } else {
                            if (UserLockTypeEnum.UPDATE_PASSWORD.equals((Object)userInfo.getLockType())) {
                                throw new UserException(UserException.USER_IS_LOCKED_BY_UPDATEPW, new Object[]{String.valueOf(lockedMinutes - goneMinutes)});
                            }
                            throw new UserException(UserException.USER_IS_LOCKED, new Object[]{String.valueOf(lockedMinutes - goneMinutes)});
                        }
                    }
                    isLogon = PermissionUtil.matchPassword(userInfo, logonPassword);
                    if (!isLogon) {
                        if (!userInfo.getSecurity().isNeedLocked()) {
                            logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userName));
                            throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                        }
                        if (userInfo.getSecurity().getLockCount() <= userInfo.getErrCount() + 1) {
                            throw new UserException(UserException.USER_IS_LOCKED, new Object[]{new Integer(userInfo.getSecurity().getLockTime())});
                        }
                        logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userName));
                        throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                    }
                }
                if ("256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(userInfo.getId().toString())) {
                    if (StringUtils.isEmpty((String)logonPassword)) {
                        throw new UserException(UserException.USER_EMPTY_PASSWORD);
                    }
                    if ("kduser".equals(logonPassword)) {
                        throw new UserException(UserException.USER_DEFAULT_PASSWORD);
                    }
                }
                if ("00000000-0000-0000-0000-00000000000113B7DE7F".equals(userInfo.getId().toString())) {
                    if (StringUtils.isEmpty((String)logonPassword)) {
                        throw new UserException(UserException.EMPTY_PASSWORD);
                    }
                    if ("authenticate".equals(logonPassword)) {
                        throw new UserException(UserException.DEFAULT_PASSWORD);
                    }
                }
                if ("00000000-0000-0000-0000-00000000000213B7DE7F".equals(userInfo.getId().toString()) && StringUtils.isEmpty((String)logonPassword)) {
                    throw new UserException(UserException.EMPTY_PASSWORD);
                }
                if ("Wp3rRSFxRCaPFjuE2apQjRO33n8=".equals(userInfo.getId().toString()) && StringUtils.isEmpty((String)logonPassword)) {
                    throw new UserException(UserException.EMPTY_PASSWORD);
                }
                if (isLogon) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String datetime = formatter.format(new Date());
                    Object[] params = new Object[]{datetime, userInfo.getId().toString()};
                    String sql = "UPDATE T_PM_User SET FLastLoginTime = to_date(?) WHERE FID = ?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
                }
            }
            finally {
                this.handleAfterLogon(ctx, userInfo, isLogon, logonPassword);
            }
        }
        try {
            this.changePasswordType(ctx, userInfo, logonPassword);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("\u7528\u6237\u53d8\u66f4\u5bc6\u7801\u52a0\u5bc6\u7b56\u7565\u5931\u8d25\uff1a" + userInfo.getNumber()));
        }
        return true;
    }

    private void checkPasswordSpelling(String userPassword) throws UserException {
        if (!StringUtils.isEmpty((String)userPassword) && userPassword.indexOf("'") != -1) {
            throw new UserException(UserException.PASSWORD_INCLUDE_FORBIDDEN_CHAR);
        }
    }

    private void checkUserInfoValidity(UserInfo userInfo) throws EASBizException {
        if (userInfo.isIsForbidden()) {
            throw new UserException(UserException.USER_BEEN_FORBIDDEN);
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (DateTimeUtils.dayAfter((Date)userInfo.getEffectiveDate(), (Date)currentDate)) {
            throw new UserException(UserException.USER_NOT_INUSE);
        }
        if (DateTimeUtils.dayAfter((Date)currentDate, (Date)userInfo.getInvalidationDate())) {
            throw new UserException(UserException.USER_BEEN_INVALID);
        }
    }

    private void autoUnlock(Context ctx, UserInfo userInfo) throws EASBizException, BOSException {
        IUser iUser = UserFactory.getLocalInstance(ctx);
        iUser.lockUsers((IObjectPK[])new ObjectUuidPK[]{new ObjectUuidPK(userInfo.getId())}, false);
    }

    private void handleAfterLogon(Context ctx, UserInfo userInfo, boolean isLogon, String logonPassword) throws BOSException {
        if (userInfo.getSecurity().isNeedLocked()) {
            Object[] params;
            String sql = null;
            if (isLogon) {
                params = new Object[]{userInfo.getId().toString()};
                sql = "UPDATE T_PM_User SET FErrCount = 0, FLockedTime = NULL, FIsLocked = 0,FLockType = 0 WHERE FID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            } else if (!userInfo.isIsLocked()) {
                if (userInfo.getSecurity().getLockCount() <= userInfo.getErrCount() + 1) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String datetime = formatter.format(new Date());
                    Object[] params2 = new Object[]{datetime, userInfo.getId().toString()};
                    sql = "UPDATE T_PM_User SET FLockedTime = to_date(?), FIsLocked = 1, FErrCount =  FErrCount + 1,FLockType = 1 WHERE FID = ? ";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])params2);
                } else {
                    params = new Object[]{userInfo.getId().toString()};
                    sql = "UPDATE T_PM_User SET FErrCount = FErrCount + 1 WHERE FID = ? ";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
                }
            }
        }
        if (userInfo.getSecurity() != null && !userInfo.getSecurity().isRequireChgPW() && !userInfo.isChangedPW()) {
            Object[] params = new Object[]{userInfo.getId().toString()};
            String sql = "UPDATE T_PM_User SET FIsChangedPW = 1 WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    private void changePasswordType(Context ctx, UserInfo userInfo, String logonPassword) throws BOSException, EASBizException {
        PasswordType type = PermissionUtils.getPasswordType(ctx);
        if (!userInfo.getPasswordType().equals((Object)type) && !StringUtils.isEmpty((String)logonPassword)) {
            String sql = "update t_pm_user set fpassword=?,fpasswordType=? where fid=?";
            String password = PermissionUtils.encrypt(userInfo.getId().toString(), logonPassword, type);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{password, type.getValue(), userInfo.getId().toString()});
            userInfo.setPasswordType(type);
            userInfo.setPassword(password);
        }
    }
}

