/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Set;

public final class FilterHelper {
    private FilterHelper() {
    }

    public static String getOrgRelationFilter(Context context, IObjectPK orgPK, String field) throws EASBizException, BOSException {
        assert (orgPK != null);
        StringBuffer sql = new StringBuffer(500);
        FullOrgUnitInfo fullOrgUnitInfo = PermissionUtil.getFullOrgUnitInfo(context, orgPK);
        sql.append(" AND ( ( ").append(field).append(" = ").append(-1).append(" ) ");
        Set orgTypeSet = OrgCommonUtils.getOrgTypeCol((FullOrgUnitInfo)fullOrgUnitInfo);
        for (OrgType orgType : orgTypeSet) {
            FilterHelper.setOrgFilter4OrgRelationFilter(field, sql, orgType.getValue());
        }
        sql.append(" ) ");
        return sql.toString();
    }

    private static void setOrgFilter4OrgRelationFilter(String field, StringBuffer sql, int orgTypeValue) {
        sql.append(" OR ").append(" ( ").append(field).append(" = ").append(orgTypeValue).append(" ) ");
    }

    public static String getRoleOrgRelationFilter(Context context, IObjectPK orgPK, String field) throws EASBizException, BOSException {
        assert (orgPK != null);
        StringBuffer sql = new StringBuffer(500);
        FullOrgUnitInfo fullOrgUnitInfo = PermissionUtil.getFullOrgUnitInfo(context, orgPK);
        Set orgTypeSet = OrgCommonUtils.getOrgTypeCol((FullOrgUnitInfo)fullOrgUnitInfo);
        for (OrgType orgType : orgTypeSet) {
            FilterHelper.setOrgTypeFilter4Role(field, sql, orgType.getValue());
        }
        return sql.toString();
    }

    private static void setOrgTypeFilter4Role(String field, StringBuffer sql, int orgTypeValue) {
        if (!StringUtils.isEmpty((String)sql.toString())) {
            sql.append(" OR ").append(field).append(" = ").append(orgTypeValue);
        } else {
            sql.append(" ").append(field).append(" = ").append(orgTypeValue);
        }
    }

    private static String buildS1BaseDataFilter(String objectTypeField, String operationTypeField) {
        StringBuffer buffer = new StringBuffer();
        Set s1ObjectTypes = ConfigurationLoader.getInstance().getConfigurationInfo().getS1BaseDataTypes();
        int size = s1ObjectTypes.size();
        if (size > 0) {
            StringBuffer filter = new StringBuffer().append(" ( ");
            Iterator iterator = s1ObjectTypes.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                String objectType = (String)iterator.next();
                if (i == size - 1) {
                    filter.append(" N'").append(objectType).append("' ) ");
                } else {
                    filter.append(" N'").append(objectType).append("', ");
                }
                ++i;
            }
            buffer.append(" AND ( ").append(objectTypeField).append(" IS NULL ").append(" OR  ").append(objectTypeField).append(" NOT IN ").append(filter).append(" OR ( ").append(operationTypeField).append(" = '").append("READ").append("' ").append(" AND ").append(objectTypeField).append(" IN ").append(filter).append(" ) ) ");
        }
        return buffer.toString();
    }

    public static String getS1BaseDataFilter(IObjectPK orgPK, String objectTypeField, String operationTypeField) {
        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(orgPK.toString())) {
            return "";
        }
        CustomCacheService cacheService = new CustomCacheService("permission.SD_Filter");
        String key = objectTypeField + operationTypeField;
        if (cacheService.contains(key)) {
            return (String)cacheService.get(key);
        }
        String filter = FilterHelper.buildS1BaseDataFilter(objectTypeField, operationTypeField);
        cacheService.put(key, (Object)filter);
        return filter;
    }
}

