/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util.interior;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUsageInfo;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.license.file.regist.embeddb.JDBCUtils;
import com.kingdee.eas.base.permission.SynStateEnum;
import com.kingdee.eas.base.permission.app.GroupLicenseUseInfo;
import com.kingdee.eas.base.permission.app.util.PermThreadPool;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseConstantHelper;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupHelper;
import com.kingdee.eas.base.permission.app.util.interior.UserLicenseGroupTool;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupInfoEx;
import com.kingdee.eas.base.permission.app.util.interior.bean.UserLicenseGroupsInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class LicenseUseSrvSingletonManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.interior.LicenseUseSrvSingletonManager");
    private static volatile LicenseUseSrvSingletonManager instance = null;
    private Map<String, GroupLicenseUseInfo> mpLicenseUseInfo = new ConcurrentHashMap<String, GroupLicenseUseInfo>();
    private static Future<LicenseUseSrvSingletonManager> future = null;
    private static int INIT_MAXWAIT = 120;
    private static long licenseUpdateTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LicenseUseSrvSingletonManager getInstance(Context ctx) throws EASBizException, BOSException {
        if (instance != null) return instance;
        Class<LicenseUseSrvSingletonManager> clazz = LicenseUseSrvSingletonManager.class;
        synchronized (LicenseUseSrvSingletonManager.class) {
            if (instance != null) return instance;
            instance = LicenseUseSrvSingletonManager.newInstance(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private static LicenseUseSrvSingletonManager newInstance(Context ctx) throws BOSException, EASBizException {
        final Context ctx1 = ctx;
        if (future == null || future.isCancelled()) {
            future = PermThreadPool.getExecutorService().submit(new Callable<LicenseUseSrvSingletonManager>(){

                @Override
                public LicenseUseSrvSingletonManager call() throws Exception {
                    return new LicenseUseSrvSingletonManager(ctx1);
                }
            });
        }
        try {
            return future.get(INIT_MAXWAIT, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (TimeoutException e) {
            logger.error((Object)e);
            throw new EASBizException(EASBizException.DBDEADLOCK);
        }
    }

    private LicenseUseSrvSingletonManager(Context ctx) {
        logger.error((Object)"================ LicenseUseSrvSingletonManager initnow=============");
        try {
            this.dealLicenseGroupUsageInfo(ctx);
        }
        catch (Exception e) {
            logger.error((Object)("================ dealLicenseUseInfo ERROR=============" + e));
        }
    }

    private void dealLicenseUseInfo(Context ctx, Map<String, GroupLicenseUseInfo> mpLicenseUseInfo) throws LicenseException {
        Map<String, LicenseUsageInfo> validLicenseUsagesMap = UserLicenseGroupTool.getValidLicenseUsagesMap(ctx);
        for (Map.Entry<String, LicenseUsageInfo> entry : validLicenseUsagesMap.entrySet()) {
            String groupNum = entry.getKey();
            GroupLicenseUseInfo glui = mpLicenseUseInfo.get(groupNum);
            LicenseUsageInfo usageInfo = validLicenseUsagesMap.get(groupNum);
            if (glui == null) {
                glui = new GroupLicenseUseInfo(usageInfo.getModuleName(), usageInfo.getMaxLicenseNum(), usageInfo.getSupliedLicenseNum(), usageInfo.getModuleAlias(), new ArrayList<String>());
                mpLicenseUseInfo.put(usageInfo.getModuleName(), glui);
                continue;
            }
            if (glui.getRegistedUsers() == null) {
                glui.setRegistedUsers(new ArrayList<String>());
            } else {
                glui.getRegistedUsers().clear();
            }
            glui.setTotal(usageInfo.getMaxLicenseNum());
            glui.setNum(usageInfo.getSupliedLicenseNum());
            glui.setAlias(usageInfo.getModuleAlias());
        }
    }

    private void getGroupsFromUserLicenseGroup(Context ctx) {
        this.mergeOtherDBUserLicenseGroup(ctx, this.mpLicenseUseInfo);
    }

    private void mergeOtherDBUserLicenseGroup(Context ctx, Map<String, GroupLicenseUseInfo> mpLicenseUseInfo) {
        DCRegister dcRegister = new DCRegister();
        ArrayList dcList = null;
        try {
            dcList = dcRegister.getDCList();
        }
        catch (Exception e1) {
            logger.error((Object)"mergeOtherDataCenterUserGroup.mergCouldUserGroupNumberByOtherDatasource.dcRegister.getDCList.exception:{}", (Throwable)e1);
        }
        if (dcList == null || dcList.size() < 0) {
            return;
        }
        Iterator it = dcList.iterator();
        while (it.hasNext()) {
            String dataSourceAIS = ((DCInfo)it.next()).getNumber();
            try {
                Connection conn = DbConnector.getConnection((String)dataSourceAIS);
                this.mergeUserLicenseGroup(mpLicenseUseInfo, conn);
            }
            catch (Exception e) {
                logger.error((Object)("mergeOtherDataCenterUserGroup.mergCouldUserGroupNumberByOtherDatasource.ejbUtil.getConnection() error.ctx.getAis=" + ctx.getAIS()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeUserLicenseGroup(Map<String, GroupLicenseUseInfo> licenseUseInfoMap, Connection conn) {
        long t1 = System.currentTimeMillis();
        StringBuilder sql = new StringBuilder();
        sql.append("select licGroup.Fuserid fid,licGroup.Fgroupnumber groupnumber ,pmUser.Fnumber userNumber,pmUser.Fuid fuid from t_pm_user pmUser ").append(" inner join T_PM_UserLicenseGroup licGroup  on pmUser.Fid = licGroup.Fuserid where licGroup.fisactive = 1 and fisdelete = 0 and fforbidden = 0 ").append(" and lower(pmuser.Fnumber) not in('administrator','user','authenadmin','sscadmin','auditadmin','virtualuser') and pmuser.ftype not in(10,60,70) ");
        if (conn == null) {
            return;
        }
        Statement sta = null;
        ResultSet rs = null;
        try {
            sta = conn.createStatement();
            sta.setFetchSize(1000);
            rs = sta.executeQuery(sql.toString());
            while (rs.next()) {
                GroupLicenseUseInfo gui;
                String uid = rs.getString("fuid");
                String groupNum = rs.getString("groupnumber");
                String userNumber = rs.getString("userNumber");
                if (groupNum == null || (gui = licenseUseInfoMap.get(groupNum)) == null || gui.getRegistedUsers() == null || userNumber == null || gui.getRegistedUsers().contains(userNumber.toLowerCase())) continue;
                gui.getRegistedUsers().add(userNumber.toLowerCase());
                gui.setNum(gui.getNum() + 1);
            }
            long t2 = System.currentTimeMillis();
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>mergeUserLicenseGroup>>>>>>>>>>>>>>>>>>>>>>>>>" + (t2 - t1)));
        }
        catch (Exception e) {
            try {
                logger.error((Object)">>>>>>>>>>>>>>>>>>>>>>>mergeUserLicenseGroup>>>>>>>>>>>>>>>>>>>:{}", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(rs, (Statement)sta, (Connection)conn);
                throw throwable;
            }
            SQLUtil.cleanup((ResultSet)rs, (Statement)sta, (Connection)conn);
        }
        SQLUtil.cleanup((ResultSet)rs, (Statement)sta, (Connection)conn);
    }

    public void dealLicenseGroupUsageInfo(Context ctx) {
        try {
            this.dealLicenseUseInfo(ctx, this.mpLicenseUseInfo);
        }
        catch (LicenseException e) {
            logger.error((Object)"LicenseUseManager.dealLicenseUseInfo():dealLicenseGroupUsageInfo.");
        }
        this.getGroupsFromUserLicenseGroup(ctx);
    }

    public void dealLicenseGroupUsageInfo(Context ctx, Map<String, CloudRegistUserInfo> mplicenseUsersInfo) {
        try {
            this.dealLicenseUseInfo(ctx, this.mpLicenseUseInfo);
        }
        catch (LicenseException e) {
            logger.error((Object)"LicenseUseManager.dealLicenseUseInfo():dealLicenseGroupUsageInfo.");
        }
        this.getGroupsFromUserLicenseGroup(ctx);
    }

    public void initUserLicenseGroup(Context ctx) throws BOSException {
        this.loadDataFromLicense(ctx);
    }

    public void resetAllUserSyncState(Context ctx) {
        String resetSQL = "Update T_PM_User set FIsSynToCloud = 0 ";
        try {
            DbUtil.execute((Context)ctx, (String)resetSQL);
        }
        catch (BOSException e) {
            logger.error((Object)(">>>>>>>>>>>>>>>>>>>>resetUserSyncState error>>>>>>>>>>>>>>>>>>>>>>>>>>" + (Object)((Object)e)));
        }
    }

    private void loadDataFromLicense(Context ctx) throws BOSException {
        Map licenseUsersInfo = null;
        try {
            licenseUsersInfo = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getRegistUserMapGroup();
        }
        catch (LicenseException e) {
            logger.error((Object)"LicenseUseManager.loadDataFromLicense():getRegistUserMapGroup error.");
        }
        this.dealUserAndLicGroupbyDatasources(ctx, licenseUsersInfo);
        this.dealLicenseGroupUsageInfo(ctx, licenseUsersInfo);
    }

    private void dealUserAndLicGroupbyDatasources(Context ctx, Map<String, CloudRegistUserInfo> mplicenseUsersInfo) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e2) {
            logger.error((Object)e2);
            throw new BOSException((Throwable)e2);
        }
        if (ctx == null) {
            return;
        }
        String updateSql = "update  T_PM_User set fissyntocloud = 0";
        Statement state = null;
        Statement state1 = null;
        try {
            state = conn.createStatement();
            state.execute(updateSql);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        String selSql = "select fid,fnumber,fforbidden,fisdelete from t_pm_user where lower(fnumber) not in('administrator','user','authenadmin','sscadmin','auditadmin','virtualuser') and ftype not in(10,60,70)";
        String delSql = "delete from T_PM_UserLicenseGroup";
        String userLicenseSql = "select count(fgroupnumber) cost,fgroupNumber groupNum from t_pm_userlicensegroup where fisactive =1 group by fgroupnumber";
        HashMap<String, Object> mpNumberUserId = new HashMap<String, Object>();
        Map<String, String> moduleAliasMap = UserLicenseGroupTool.getModuleAliasMap(ctx);
        HashMap<String, Integer> groupMap = new HashMap<String, Integer>();
        HashMap<String, Integer> LicGroupMap = new HashMap<String, Integer>();
        Map<String, Set> mpUserGroups1 = this.getCloudUserGroupMappingByUserorgperm_new(ctx);
        Map<String, Set> mpUserGroups2 = this.getCloudUserMappingGroupByUserroleorg_new(ctx);
        HashSet<String> invalidUserSet = new HashSet<String>();
        try {
            state1 = conn.createStatement();
            ResultSet rs1 = state.executeQuery(userLicenseSql);
            boolean i = true;
            while (rs1.next()) {
                String group = rs1.getString("groupNum");
                int cost = rs1.getInt("cost");
                groupMap.put(group, cost);
            }
            rs1.close();
            state.executeUpdate(delSql);
            state.clearBatch();
            ResultSet rs = state.executeQuery(selSql);
            while (rs.next()) {
                boolean isForbidden = rs.getBoolean("fforbidden");
                boolean isDelete = rs.getBoolean("fisdelete");
                String userId = rs.getString("fid");
                String userNumber = rs.getString("fnumber").toLowerCase();
                mpNumberUserId.put(userNumber, userId);
                if (!isForbidden && !isDelete) continue;
                invalidUserSet.add(userNumber);
            }
            rs.close();
            UserLicenseGroupHelper userLicGroupHelper = new UserLicenseGroupHelper(ctx);
            HashMap<String, Set> userGroupsFromLic = new HashMap<String, Set>();
            if (mplicenseUsersInfo != null) {
                for (CloudRegistUserInfo cui : mplicenseUsersInfo.values()) {
                    String userNumber = cui.getErpNumber().toLowerCase();
                    String fid = (String)mpNumberUserId.get(userNumber);
                    if (fid == null || fid.trim().length() == 0 || UserLicenseConstantHelper.IGNORE_SYNTOCLOUD_USERS.contains(fid.trim()) || cui == null || cui.getGroup() == null) continue;
                    for (String group : cui.getGroup()) {
                        if (group == null || group.trim().length() == 0) continue;
                        if (userGroupsFromLic.get(group) != null) {
                            ((Set)userGroupsFromLic.get(group)).add(userNumber);
                        } else {
                            HashSet<String> userSet = new HashSet<String>();
                            userSet.add(userNumber);
                            userGroupsFromLic.put(group, userSet);
                        }
                        UserLicenseGroupsInfo userlicgroups = new UserLicenseGroupsInfo(ctx, fid);
                        UserLicenseGroupInfoEx licgroupinfo = new UserLicenseGroupInfoEx();
                        licgroupinfo.setUser(userlicgroups.getUser());
                        licgroupinfo.setGroupNumber(group);
                        licgroupinfo.setName(moduleAliasMap.get(group));
                        licgroupinfo.setSynUser(SynStateEnum.SYN_YES);
                        if (!invalidUserSet.contains(userNumber)) {
                            licgroupinfo.setIsActive(true);
                            if (LicGroupMap.get(group) != null) {
                                int cost = (Integer)LicGroupMap.get(group);
                                LicGroupMap.put(group, cost + 1);
                            } else {
                                LicGroupMap.put(group, 1);
                            }
                        } else {
                            licgroupinfo.setIsActive(false);
                        }
                        userlicgroups.addLicGroups(licgroupinfo);
                        userLicGroupHelper.addAddUserLicenseGroupInfo(licgroupinfo);
                    }
                }
            }
            Map<String, Set> userlicGroups = this.mergeUserGroups(mpUserGroups1, mpUserGroups2, userGroupsFromLic);
            Map<String, GroupLicenseUseInfo> licenseUsagesMap = this.getGroupsUseInfo(ctx);
            for (Map.Entry<String, Set> userlicGroupsEntry : userlicGroups.entrySet()) {
                UserLicenseGroupInfoEx licgroupinfo;
                UserLicenseGroupsInfo userlicgroups;
                String userId;
                String group = userlicGroupsEntry.getKey();
                Set userSet = userlicGroupsEntry.getValue();
                Set userSetTemp = (Set)((HashSet)userSet).clone();
                GroupLicenseUseInfo licenseUsageInfo = licenseUsagesMap.get(group);
                if (licenseUsageInfo == null) continue;
                int activeNum = licenseUsageInfo.getNum();
                int localNum = groupMap.get(group) == null ? 0 : (Integer)groupMap.get(group);
                int otherNum = activeNum - localNum;
                int licGroupCost = LicGroupMap.get(group) == null ? 0 : (Integer)LicGroupMap.get(group);
                userSetTemp.remove("user");
                userSetTemp.removeAll(invalidUserSet);
                logger.error((Object)("=======dealUserAndLicGroupbyDatasources=====groupNum: " + group));
                logger.error((Object)("=======dealUserAndLicGroupbyDatasources=====activeNum: " + activeNum));
                logger.error((Object)("=======dealUserAndLicGroupbyDatasources=====localNum: " + localNum));
                logger.error((Object)("=======dealUserAndLicGroupbyDatasources=====otherNum: " + otherNum));
                logger.error((Object)("=======dealUserAndLicGroupbyDatasources=====licGroupCost: " + licGroupCost));
                logger.error((Object)("=======dealUserAndLicGroupbyDatasources=====userSetTemp: " + userSetTemp.size()));
                logger.error((Object)("=======dealUserAndLicGroupbyDatasources=====userSet: " + userSet.size()));
                if (otherNum + userSetTemp.size() + licGroupCost <= licenseUsageInfo.getTotal()) {
                    for (String userNumber : userSet) {
                        userId = (String)mpNumberUserId.get(userNumber);
                        userlicgroups = new UserLicenseGroupsInfo(ctx, userId);
                        licgroupinfo = new UserLicenseGroupInfoEx();
                        licgroupinfo.setUser(userlicgroups.getUser());
                        licgroupinfo.setGroupNumber(group);
                        licgroupinfo.setName(moduleAliasMap.get(group));
                        licgroupinfo.setSynUser(SynStateEnum.SYN_NO);
                        if (!invalidUserSet.contains(userNumber)) {
                            licgroupinfo.setIsActive(true);
                        } else {
                            licgroupinfo.setIsActive(false);
                        }
                        userlicgroups.addLicGroups(licgroupinfo);
                        userLicGroupHelper.addAddUserLicenseGroupInfo(licgroupinfo);
                    }
                    continue;
                }
                for (String userNumber : userSet) {
                    userId = (String)mpNumberUserId.get(userNumber);
                    userlicgroups = new UserLicenseGroupsInfo(ctx, userId);
                    licgroupinfo = new UserLicenseGroupInfoEx();
                    licgroupinfo.setUser(userlicgroups.getUser());
                    licgroupinfo.setGroupNumber(group);
                    licgroupinfo.setName(moduleAliasMap.get(group));
                    licgroupinfo.setSynUser(SynStateEnum.SYN_NO);
                    licgroupinfo.setIsActive(false);
                    userlicgroups.addLicGroups(licgroupinfo);
                    userLicGroupHelper.addAddUserLicenseGroupInfo(licgroupinfo);
                }
            }
            userLicGroupHelper.exec();
        }
        catch (Exception e) {
            logger.error((Object)"LicenseUseManager.dealUserLicGroupbyDatasources-1");
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)state, (Connection)conn);
            SQLUtils.cleanup(null, (Statement)state1, (Connection)conn);
        }
    }

    private Map<String, Set> mergeUserGroups(Map<String, Set> mpUserGroups1, Map<String, Set> mpUserGroups2, Map<String, Set> userGroupsFromLic) {
        Iterator<Map.Entry<String, Set>> mpUserGroupsItr = mpUserGroups1.entrySet().iterator();
        while (mpUserGroupsItr.hasNext()) {
            Map.Entry<String, Set> mpUserGroupsEntry = mpUserGroupsItr.next();
            String group = mpUserGroupsEntry.getKey();
            Set userSet = mpUserGroupsEntry.getValue();
            if (mpUserGroups2.get(group) == null) continue;
            mpUserGroups2.get(group).addAll(userSet);
            mpUserGroupsItr.remove();
        }
        if (mpUserGroups1.size() > 0) {
            mpUserGroups2.putAll(mpUserGroups1);
        }
        for (Map.Entry<String, Set> mpUserGroupsEntry : userGroupsFromLic.entrySet()) {
            String group = mpUserGroupsEntry.getKey();
            Set userSet = mpUserGroupsEntry.getValue();
            if (mpUserGroups2.get(group) == null) continue;
            mpUserGroups2.get(group).removeAll(userSet);
        }
        return mpUserGroups2;
    }

    private Map<String, Set> getCloudUserGroupMappingByUserorgperm_new(Context ctx) throws BOSException {
        StringBuilder sqlUserOrgPerm = new StringBuilder();
        Map<String, String> permUIGroup = UserLicenseGroupTool.getPermGroupMap(ctx);
        sqlUserOrgPerm.append("select distinct u.fnumber , pi.fid from t_pm_userorgperm up ").append(" inner join T_PM_PermItem pi on pi.fid = up.fpermitemid ").append(" inner join T_PM_User u on up.fowner = u.fid ").append(" where lower(u.Fnumber) not in('administrator','user','authenadmin','sscadmin','auditadmin','virtualuser') and u.ftype not in(10,60,70)");
        Connection conn = null;
        Statement state = null;
        ResultSet rs = null;
        HashMap<String, Set> mpUserGroupMap = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            state = conn.createStatement();
            state.setFetchSize(1000);
            rs = state.executeQuery(sqlUserOrgPerm.toString());
            mpUserGroupMap = new HashMap<String, Set>();
            while (rs.next()) {
                String key = rs.getString(2);
                String group = permUIGroup.get(key);
                if (group == null) continue;
                String value = rs.getString(1).toLowerCase();
                if (mpUserGroupMap.get(group) != null) {
                    ((Set)mpUserGroupMap.get(group)).add(value);
                    continue;
                }
                HashSet<String> userSet = new HashSet<String>();
                userSet.add(value);
                mpUserGroupMap.put(group, userSet);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"LicenseUseManager.getCloudUserGroupMappingByUserorgperm-1", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)state, (Connection)conn);
        return mpUserGroupMap;
    }

    private Map<String, Set> getCloudUserMappingGroupByUserroleorg_new(Context ctx) throws BOSException {
        StringBuilder sqlUserRoleOrg = new StringBuilder();
        Map<String, String> permUIGroup = UserLicenseGroupTool.getPermGroupMap(ctx);
        sqlUserRoleOrg.append("select distinct u.fnumber , pi.fid from t_pm_userroleorg uroleorg ").append(" inner join t_pm_role urole on urole.fid = uroleorg.FRoleID  ").append(" inner join t_pm_roleperm rp on rp.FRoleID = urole.fid  ").append(" inner join T_PM_PermItem pi on pi.fid = rp.fpermitemid  ").append(" inner join T_PM_User u on uroleorg.fuserid = u.fid ").append(" where lower(u.Fnumber) not in('administrator','user','authenadmin','sscadmin','auditadmin','virtualuser') and u.ftype not in(10,60,70)");
        Connection conn = null;
        Statement state = null;
        ResultSet rs = null;
        HashMap<String, Set> mpUserGroupMap = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            state = conn.createStatement();
            state.setFetchSize(1000);
            rs = state.executeQuery(sqlUserRoleOrg.toString());
            mpUserGroupMap = new HashMap<String, Set>();
            while (rs.next()) {
                String key = rs.getString(2);
                String group = permUIGroup.get(key);
                if (group == null) continue;
                String value = rs.getString(1).toLowerCase();
                if (mpUserGroupMap.get(group) != null) {
                    ((Set)mpUserGroupMap.get(group)).add(value);
                    continue;
                }
                HashSet<String> userSet = new HashSet<String>();
                userSet.add(value);
                mpUserGroupMap.put(group, userSet);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"LicenseUseManager.getCloudUserMappingGroupByUserroleorg-1", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)state, (Connection)conn);
        return mpUserGroupMap;
    }

    public boolean disAssignUserGroups(List<String> groups) {
        if (groups == null || this.mpLicenseUseInfo == null) {
            return true;
        }
        for (String group : groups) {
            GroupLicenseUseInfo guin = this.mpLicenseUseInfo.get(group);
            if (guin == null || guin.getNum() <= 0) continue;
            guin.setNum(guin.getNum() - 1);
        }
        return true;
    }

    public boolean disAssignUsersGroup(String groupNumber, int nums) {
        if (this.mpLicenseUseInfo == null) {
            return true;
        }
        GroupLicenseUseInfo guin = this.mpLicenseUseInfo.get(groupNumber);
        if (guin == null) {
            return true;
        }
        if (nums < guin.getNum()) {
            guin.setNum(guin.getNum() - nums);
        } else {
            guin.setNum(0);
        }
        return true;
    }

    public int getGroupRemainNum(String groupNumber) {
        if (this.mpLicenseUseInfo == null) {
            return -1;
        }
        if (StringUtils.isEmpty((String)groupNumber)) {
            return -1;
        }
        GroupLicenseUseInfo guin = this.mpLicenseUseInfo.get(groupNumber);
        if (guin == null) {
            return -1;
        }
        return guin.getTotal() - guin.getNum();
    }

    public Map<String, GroupLicenseUseInfo> getGroupsUseInfo(Context ctx) {
        return this.mpLicenseUseInfo;
    }

    public boolean checkAssignUsersGroup(String groupNumber, int nums) {
        if (this.mpLicenseUseInfo == null) {
            return true;
        }
        GroupLicenseUseInfo guin = this.mpLicenseUseInfo.get(groupNumber);
        return guin == null || guin.getTotal() >= guin.getNum() + nums;
    }

    public boolean assignUserGroups(List<String> groups) {
        GroupLicenseUseInfo guin;
        if (groups == null || this.mpLicenseUseInfo == null) {
            return true;
        }
        for (String group : groups) {
            guin = this.mpLicenseUseInfo.get(group);
            if (guin.getTotal() >= guin.getNum() + 1) continue;
            return false;
        }
        for (String group : groups) {
            guin = this.mpLicenseUseInfo.get(group);
            if (guin.getTotal() < guin.getNum() + 1) {
                return false;
            }
            guin.setNum(guin.getNum() + 1);
        }
        return true;
    }

    public boolean assignUsersGroups(String groupNumbers, int nums) {
        if (groupNumbers == null || this.mpLicenseUseInfo == null) {
            return true;
        }
        String[] gns = groupNumbers.split(";");
        if (gns.length <= 0) {
            return true;
        }
        for (int i = 0; i < gns.length; ++i) {
            GroupLicenseUseInfo guin = this.mpLicenseUseInfo.get(gns[i]);
            guin.setNum(guin.getNum() + nums);
        }
        return true;
    }

    public boolean assignUsersGroup(String groupNumber, int nums) {
        GroupLicenseUseInfo guin = this.mpLicenseUseInfo.get(groupNumber);
        if (guin == null) {
            return true;
        }
        if (this.checkAssignUsersGroup(groupNumber, nums)) {
            guin.setNum(guin.getNum() + nums);
        } else {
            guin.setNum(guin.getTotal());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getExtraUserData(Context ctx, Map<String, String> paramMap, Locale l) throws SQLException, BOSException {
        HashMap<String, Serializable> result;
        block13: {
            Connection conn = EJBFactory.getConnection((Context)ctx);
            PreparedStatement pstmt = null;
            String startIndex = paramMap.get("startIndex");
            String rowCount = paramMap.get("rowCount");
            String searchStr = paramMap.get("searchStr");
            String groupNumber = paramMap.get("groupNumber");
            List userList = UserLicenseGroupTool.getGroupUsers(ctx, groupNumber);
            int totalSize = userList.size();
            int _startIndex = 0;
            if (!StringUtils.isEmpty((String)startIndex)) {
                _startIndex = Integer.parseInt(startIndex);
            }
            int _rowCount = 0;
            if (!StringUtils.isEmpty((String)rowCount)) {
                _rowCount = Integer.parseInt(rowCount);
            }
            String sql = this.getUserSelectSql(totalSize, searchStr, l);
            sql = sql + " OFFSET " + _startIndex + " ROWS FETCH NEXT " + _rowCount + " ROWS ONLY";
            Object[] params = new String[]{};
            if (!StringUtils.isEmpty((String)searchStr)) {
                params = new String[9];
                Arrays.fill(params, searchStr);
            }
            ResultSet rs = null;
            result = new HashMap<String, Serializable>();
            ArrayList list = new ArrayList();
            try {
                String countSql = this.getUserCountSql(searchStr);
                int count = this.getRecords(conn, pstmt, countSql, params);
                result.put("records", Integer.valueOf(count));
                String userId = "";
                String userNumber = "";
                String userName = "";
                String CU = "";
                String groupName = "";
                String groupId = "";
                String type = "";
                String isForbidden = "";
                if (!userList.isEmpty() && userList.size() != 0) {
                    int PERSIZE = 5000;
                    int totalCount = (totalSize - 1) / PERSIZE + 1;
                    int begin = 0;
                    int end = 0;
                    List subList = new ArrayList();
                    for (int i = 0; i < totalCount; ++i) {
                        begin = i * PERSIZE;
                        end = (i + 1) * PERSIZE > totalSize ? totalSize : (i + 1) * PERSIZE;
                        subList = userList.subList(begin, end);
                        String tempSQL = sql;
                        String orgParam = ToolUtils.aryToStr(subList, (boolean)true);
                        tempSQL = tempSQL.replace("!", orgParam);
                        rs = DbUtil.executeQuery((Context)ctx, (String)tempSQL);
                        while (rs.next()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            userId = rs.getString("id");
                            userNumber = rs.getString("number");
                            userName = rs.getString("name");
                            CU = rs.getString("CU");
                            groupName = rs.getString("gname");
                            groupId = rs.getString("gid");
                            isForbidden = rs.getString("isForbidden");
                            type = rs.getString("type");
                            map.put("id", userId);
                            map.put("number", userNumber);
                            map.put("name", userName);
                            map.put("CU.name", CU);
                            map.put("group.name", groupName);
                            map.put("ugId", groupId);
                            map.put("isForbidden", isForbidden);
                            map.put("type", type);
                            list.add(map);
                        }
                    }
                } else {
                    rs = this.executeQuery(conn, pstmt, sql, params);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        userId = rs.getString("id");
                        userNumber = rs.getString("number");
                        userName = rs.getString("name");
                        CU = rs.getString("CU");
                        groupName = rs.getString("gname");
                        groupId = rs.getString("gid");
                        isForbidden = rs.getString("isForbidden");
                        type = rs.getString("type");
                        map.put("id", userId);
                        map.put("number", userNumber);
                        map.put("name", userName);
                        map.put("CU.name", CU);
                        map.put("group.name", groupName);
                        map.put("ugId", groupId);
                        map.put("isForbidden", isForbidden);
                        map.put("type", type);
                        list.add(map);
                    }
                }
                result.put("rows", list);
                JDBCUtils.closeResultSet((ResultSet)rs);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                break block13;
            }
            finally {
                JDBCUtils.closeResultSet(rs);
                JDBCUtils.closeStatement(pstmt);
            }
            JDBCUtils.closeStatement(pstmt);
        }
        return result;
    }

    public String getUserSelectSql(int totalSize, String searchStr, Locale l) {
        String sql = "";
        if (totalSize > 0) {
            sql = "select u.fid id,u.fnumber number,u.fname_" + l.getLanguage().toString() + " name,cu.fname_" + l.getLanguage().toString() + " CU,g.fid gid,g.fname_l2 gname,u.fisForbidden isForbidden,u.ftype type from T_PM_User u LEFT OUTER JOIN T_PM_UserGroup g ON u.FGroupID = g.FID  INNER JOIN T_ORG_CtrlUnit cu ON u.FControlUnitID = cu.FID WHERE u.FIsDelete = 0 AND u.FAgentUser = 0 and u.fid not in(!) and u.fnumber not in('administrator','user','auditadmin','sscadmin','authenadmin')";
            if (!StringUtils.isEmpty((String)searchStr)) {
                sql = sql + " and (u.fnumber like ? or u.fname_" + l.getLanguage().toString() + " like ? or cu.fname_" + l.getLanguage().toString() + " like ? or g.fname_l2 like ?  or u.fisForbidden like ? or u.ftype like ? )";
            }
            sql = sql + " order by u.fnumber desc ";
        } else {
            sql = "select u.fid id,u.fnumber number,u.fname_" + l.getLanguage().toString() + " name,cu.fname_" + l.getLanguage().toString() + " CU,g.fid gid,g.fname_l2 gname,u.fisForbidden isForbidden,u.ftype type from T_PM_User u LEFT OUTER JOIN T_PM_UserGroup g ON u.FGroupID = g.FID  INNER JOIN T_ORG_CtrlUnit cu ON u.FControlUnitID = cu.FID WHERE u.FIsDelete = 0 AND u.FAgentUser = 0 and u.fnumber not in('administrator','user','auditadmin','sscadmin','authenadmin')";
            if (!StringUtils.isEmpty((String)searchStr)) {
                sql = sql + " and (u.fnumber like ? or u.fname_" + l.getLanguage().toString() + " like ? or cu.fname_" + l.getLanguage().toString() + " like ? or g.fname_l2 like ?  or u.fisForbidden like ? or u.ftype like ? )";
            }
            sql = sql + " order by u.fnumber desc ";
        }
        return sql;
    }

    public String getUserCountSql(String whereSql) {
        String sql = "select count(1) count  from t_pm_user u where u.FIsDelete = 0 AND u.FAgentUser = 0 and u.fnumber not in('administrator','user','auditadmin','sscadmin','authenadmin')";
        if (!StringUtils.isEmpty((String)whereSql)) {
            sql = sql + " and (u.fnumber like ? or u.fname_l2 like ? or cu.fname_l2 like ? or g.fname_l2 like ?  or u.fisForbidden like ? or u.ftype like ? )";
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRecords(Connection conn, PreparedStatement pstmt, String countSql, Object[] params) {
        ResultSet rs = null;
        int count = 0;
        try {
            rs = this.executeQuery(conn, pstmt, countSql, params);
            while (rs.next()) {
                count = rs.getInt("count");
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeResultSet(rs);
                JDBCUtils.closeStatement((Statement)pstmt);
                throw throwable;
            }
            JDBCUtils.closeResultSet((ResultSet)rs);
            JDBCUtils.closeStatement((Statement)pstmt);
        }
        JDBCUtils.closeResultSet((ResultSet)rs);
        JDBCUtils.closeStatement((Statement)pstmt);
        return count;
    }

    private ResultSet executeQuery(Connection conn, PreparedStatement pstmt, String sql, Object[] params) {
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (int j = 0; j < params.length; ++j) {
                if (params[j] != null) {
                    pstmt.setString(j + 1, "%" + params[j] + "%");
                    continue;
                }
                pstmt.setNull(j + 1, 12);
            }
            rs = pstmt.executeQuery();
            return rs;
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + sql), (Throwable)exc);
            return rs;
        }
    }

    public Map<String, GroupLicenseUseInfo> getGroupsUseInfos(Context ctx) {
        HashMap<String, GroupLicenseUseInfo> mpLicenseUseInfo = new HashMap<String, GroupLicenseUseInfo>();
        try {
            this.dealLicenseUseInfo(ctx, mpLicenseUseInfo);
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        this.mergeOtherDBUserLicenseGroup(ctx, mpLicenseUseInfo);
        return mpLicenseUseInfo;
    }

    public long getLicenseUpdateTime(Context ctx) {
        if (licenseUpdateTime == 0L) {
            licenseUpdateTime = System.currentTimeMillis();
        }
        return licenseUpdateTime;
    }

    public void noticLicenseUpdate(Context ctx) {
        licenseUpdateTime = System.currentTimeMillis();
    }

    public boolean isBeforeLicenseUpdate(Context ctx, long time) {
        return time < licenseUpdateTime;
    }
}

