/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.hr.contract.ContractBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractEndBizBill;
import com.kingdee.eas.hr.contract.ContractEndBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractEndBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractEndBizBillInfo;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.app.AbstractContractEndBizBillControllerBean;
import com.kingdee.eas.hr.contract.app.ContractEndBillBizBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.HRContractInfoUtils;
import com.kingdee.eas.hr.contract.util.SHRContractUploadAttachmentUtils;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.app.BillTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractEndBizBillControllerBean
extends AbstractContractEndBizBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ContractEndBizBillControllerBean.class);

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.contract.app.ContractEndBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return ContractEndBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new ContractEndBillBizBean();
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        Date effectDate;
        Date now;
        EmployeeContractInfo ecInfo;
        ContractEndBizBillEntryInfo cebbeInfo = (ContractEndBizBillEntryInfo)entry;
        IEmployeeContract iECF = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractCollection ecCol = iECF.getEmployeeContractCollection("where contractNo = '" + cebbeInfo.getContractNo() + "'");
        if (ecCol.size() > 0 && (ecInfo = ecCol.get(0)) != null) {
            ecInfo.setEndDateReal(cebbeInfo.getBizDate());
            ecInfo.setAppraisal(cebbeInfo.getAppraisal());
            ecInfo.setAppraDate(cebbeInfo.getAppraDate());
            ecInfo.setPenalty(cebbeInfo.getPenalty());
            ecInfo.setCompensation(cebbeInfo.getCompensation());
            ecInfo.setReason(cebbeInfo.getEndReason());
            ecInfo.setDescription(cebbeInfo.getDescription());
            ecInfo.setState(EmployeeContractState.END);
            ecInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            ecInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(cebbeInfo.getEffectDate(), cebbeInfo.getBizDate()));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("endDateReal"));
            selector.add(new SelectorItemInfo("appraisal"));
            selector.add(new SelectorItemInfo("appraDate"));
            selector.add(new SelectorItemInfo("penalty"));
            selector.add(new SelectorItemInfo("compensation"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("description"));
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            iECF.updatePartial((CoreBaseInfo)ecInfo, selector);
            this.reverseEmployeeContractAttachment(ctx, ecInfo, entry);
            String curDate = HRUtil.getCurrentDate();
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_HR_EmployeeContract SET FNewState=4 where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(ecInfo.getEmployee().getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append(" update T_HR_HRContractInfo SET FNewState=4 where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(ecInfo.getEmployee().getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if ((now = new Date()).after(effectDate = cebbeInfo.getBizDate())) {
            this.updateHRContractInfo_afterEffect(ctx, cebbeInfo);
        }
    }

    protected void updateHRContractInfo_afterEffect(Context ctx, ContractEndBizBillEntryInfo cebbeInfo) throws EASBizException, BOSException {
        HRContractInfoCollection coll = HRContractInfoUtils.getCurrentHRContractCollection(ctx, cebbeInfo.getContractNo());
        BigDecimal contractLimitAutoReal = ContractUtils.calContractLimit(cebbeInfo.getEffectDate(), cebbeInfo.getBizDate());
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo hRContractInfo = coll.get(i);
            if (hRContractInfo == null) continue;
            hRContractInfo.setState(EmployeeContractState.END);
            hRContractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            SelectorItemCollection selector = new SelectorItemCollection();
            hRContractInfo.setEndDateReal(cebbeInfo.getBizDate());
            if (!StringUtils.isEmpty((String)cebbeInfo.getContractLimit())) {
                hRContractInfo.setContractLimitAuto(new BigDecimal(cebbeInfo.getContractLimit()));
            } else {
                hRContractInfo.setContractLimitAuto(null);
            }
            if (cebbeInfo.getBill() != null && hRContractInfo.getBillID() != null && cebbeInfo.getBill().getId().toString().equals(hRContractInfo.getBillID().toString())) {
                hRContractInfo.setIsDisplay(true);
            } else {
                hRContractInfo.setIsDisplay(false);
            }
            hRContractInfo.setReason(cebbeInfo.getEndReason());
            hRContractInfo.setDescription(cebbeInfo.getDescription());
            hRContractInfo.setContractLimitAutoReal(contractLimitAutoReal);
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("endDateReal"));
            selector.add(new SelectorItemInfo("contractLimitAuto"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("description"));
            selector.add(new SelectorItemInfo("isDisplay"));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractEndBizBillInfo cebbInfo = (ContractEndBizBillInfo)model;
        this.checkEntry(ctx, cebbInfo);
        this.checkEntryIsInOther(ctx, cebbInfo);
        this.checkDate(ctx, cebbInfo);
        this.checkContractEndException(ctx, cebbInfo);
        IObjectPK objectPk = super._addnew(ctx, model);
        this.addNewHrContractInfo(ctx, cebbInfo, objectPk);
        return objectPk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ContractEndBizBillInfo cebbInfo = (ContractEndBizBillInfo)model;
        this.checkEntry(ctx, cebbInfo);
        this.checkEntryIsInOther(ctx, cebbInfo);
        this.checkDate(ctx, cebbInfo);
        this.checkContractEndException(ctx, cebbInfo);
        super._update(ctx, pk, model);
        this.updateHrContractInfo(ctx, cebbInfo, pk);
    }

    protected void checkContractEndException(Context ctx, ContractEndBizBillInfo cebbInfo) throws EASBizException, BOSException {
        ContractEndBizBillEntryInfo cebbeInfo = null;
        EmployeeContractInfo contract = null;
        int size = cebbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            cebbeInfo = cebbInfo.getEntrys().get(i);
            contract = this.assembleContractFromEntry(cebbeInfo, cebbInfo);
            contract.put("entryIndex", (Object)i);
            ContractUtils.checkContractEndException(ctx, contract, null);
        }
    }

    protected EmployeeContractInfo assembleContractFromEntry(ContractEndBizBillEntryInfo entry, ContractEndBizBillInfo bill) {
        EmployeeContractInfo contract = new EmployeeContractInfo();
        contract.setContractNo(entry.getContractNo());
        contract.setEndDateReal(entry.getBizDate());
        contract.setHrOrgUnit(bill.getHrOrgUnit());
        return contract;
    }

    protected void checkDate(Context ctx, ContractEndBizBillInfo cebbInfo) throws EASBizException, BOSException {
        ContractEndBizBillEntryInfo cebbeInfo = null;
        int size = cebbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            cebbeInfo = cebbInfo.getEntrys().get(i);
            String personParm = ContractUtils.getPersonInfo(ctx, cebbeInfo.getPerson().getId().toString());
            if (cebbeInfo.getPenalty() != null && cebbeInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.PENALTY_ISMINUS, new Object[]{personParm});
            }
            if (cebbeInfo.getCompensation() == null || cebbeInfo.getCompensation().compareTo(ContractUtils.ZERO) >= 0) continue;
            throw new ContractException(ContractException.COMPENSATION_ISMINUS, new Object[]{personParm});
        }
    }

    protected void checkEntry(Context ctx, ContractEndBizBillInfo cebbInfo) throws BOSException, EASBizException {
        ContractEndBizBillEntryInfo cebbeInfo1 = null;
        ContractEndBizBillEntryInfo cebbeInfo2 = null;
        int count = cebbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            cebbeInfo1 = cebbInfo.getEntrys().get(i);
            int size = cebbInfo.getEntrys().size() - i;
            for (int j = i + 1; j < size; ++j) {
                cebbeInfo2 = cebbInfo.getEntrys().get(j);
                if (!cebbeInfo1.getContractNo().equals(cebbeInfo2.getContractNo())) continue;
                throw new ContractException(ContractException.CONTRACT_REPEAT, new Object[]{new Integer(i + 1), new Integer(j + 1)});
            }
            ContractUtils.checkContractInBillByType(ctx, cebbeInfo1.getContractNo(), cebbInfo.getId(), BillTypeEnum.END, i + 1);
            EmployeeContractInfo empContract = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo("select id where contractNo='" + cebbeInfo1.getContractNo() + "'");
            ContractUtils.checkContractInBillByHRContractInfo(ctx, empContract.getId().toString(), cebbInfo.getId());
        }
    }

    protected void checkEntryIsInOther(Context ctx, ContractEndBizBillInfo cebbInfo) throws BOSException, EASBizException {
        ContractEndBizBillEntryInfo cebbeInfo = null;
        EmployeeContractInfo ecInfo = null;
        int count = cebbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            cebbeInfo = cebbInfo.getEntrys().get(i);
            ecInfo = new EmployeeContractInfo();
            ecInfo.setContractNo(cebbeInfo.getContractNo());
            ecInfo.setEmployee(cebbeInfo.getPerson());
            ContractUtils.checkContractIsInOther(ctx, ecInfo, ContractEndBizBill.class.getName(), i + 1);
        }
    }

    @Override
    protected void setHRContractInfoInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billId, CoreBaseInfo entryInfo, HRContractInfoInfo contractInfo) throws EASBizException, BOSException {
        super.setHRContractInfoInfo(ctx, billInfo, billId, entryInfo, contractInfo);
        String contractNo = (String)entryInfo.get("contractNo");
        String oql = "select id where contractNo='" + contractNo + "'";
        IEmployeeContract iEmployeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
        if (iEmployeeContract.exists(oql)) {
            EmployeeContractInfo empContract = iEmployeeContract.getEmployeeContractInfo(oql);
            contractInfo.put("employeeContract", empContract);
            contractInfo.put("sourceContract", empContract);
        }
        contractInfo.put("delegatePerson", entryInfo.get("delegatePerson"));
        contractInfo.put("reason", entryInfo.get("endReason"));
        contractInfo.put("toUnit", entryInfo.get("toUnit"));
        contractInfo.put("endDateReal", entryInfo.get("bizDate"));
        contractInfo.put("effectDate", entryInfo.get("effectDate"));
        contractInfo.put("contractLimitAutoReal", ContractUtils.calContractLimit((Date)entryInfo.get("effectDate"), (Date)entryInfo.get("bizDate")));
        contractInfo.setIsDisplay(false);
    }

    public void setBillRelateInfo(Context ctx, BOSUuid entryID) throws EASBizException, BOSException {
        if (entryID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, (Object)bill);
        }
        ContractEndBizBillEntryInfo cebbeInfo = (ContractEndBizBillEntryInfo)entry;
        IEmployeeContract iECF = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractCollection ecCol = iECF.getEmployeeContractCollection("where contractNo = '" + (cebbeInfo == null ? "" : cebbeInfo.getContractNo()) + "'");
        if (ecCol.size() > 0) {
            EmployeeContractInfo ecInfo = ecCol.get(0);
            SelectorItemCollection selector = new SelectorItemCollection();
            if (ecInfo != null) {
                ecInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            }
            selector.add(new SelectorItemInfo("newState"));
            iECF.updatePartial((CoreBaseInfo)ecInfo, selector);
            this.updateHRContractInfo_beforeJob(ctx, cebbeInfo);
        }
    }

    protected void updateHRContractInfo_beforeJob(Context ctx, ContractEndBizBillEntryInfo csbbeInfo) throws EASBizException, BOSException {
        HRContractInfoCollection coll = HRContractInfoUtils.getCurrentHRContractCollection(ctx, csbbeInfo.getContractNo());
        HRContractInfoInfo hRContractInfo = null;
        SelectorItemCollection selector = null;
        BigDecimal contractLimitAutoReal = ContractUtils.calContractLimit(csbbeInfo.getEffectDate(), csbbeInfo.getBizDate());
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            hRContractInfo = coll.get(i);
            if (hRContractInfo == null) continue;
            selector = new SelectorItemCollection();
            hRContractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            selector.add(new SelectorItemInfo("newState"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
    }

    protected Date getBackGroundJobDate(IObjectValue ov) throws BOSException, EASBizException {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException();
        }
        Date date = ov.getDate(this.getEntryEffectDateField());
        if (null != random) {
            date = DateTimeUtils.addMinute((Date)date, (long)(60 + random.nextInt(60)));
            date = DateTimeUtils.addSecond((Date)date, (long)random.nextInt(60));
        }
        date = DateTimeUtils.addDay((Date)date, (long)1L);
        return date;
    }

    protected void _auditEntryEffect(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        IHRBillBizBean bizBean = this.getParentBizBean();
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        HRBillBaseEntryInfo entry = null;
        String entryField = this.getEntryField();
        String billField = this.getBillField();
        if (bizBean != null) {
            bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        this.initBizBean(ctx);
        if (entries != null) {
            Date now = new Date();
            Date effectDate = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (HRBillBaseEntryInfo)entries.getObject(i);
                entry.put(billField, (Object)model);
                effectDate = this.getEffectDate(entry);
                if (effectDate != null && now.before(effectDate)) {
                    this._beforeEffectBeforeBackJob(ctx, entry);
                    if (bizBean != null) {
                        bizBean._beforeEffectBeforeBackJob(ctx, entry);
                    }
                    this.setBillRelateInfo(ctx, entry.getId());
                    this.createBackGroundJob(ctx, (IObjectValue)entry, "entryID");
                    continue;
                }
                this._beforeEffectOnNoJob(ctx, entry);
                if (bizBean != null) {
                    bizBean._beforeEffectOnNoJob(ctx, entry);
                }
                this._entryEffectCommon(ctx, entry.getId());
            }
        }
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (bizBean != null) {
            bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
    }

    protected void initBizBean(Context ctx) throws BOSException, EASBizException {
        IHRBillBizBean bizBean = this.getParentBizBean();
        if (bizBean == null && (bizBean = this.getBizBean()) != null) {
            BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)bizBean.getExtendBillName(ctx));
            PlugInBeanProxy plugIn = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(this.getBOSType());
            if (entity != null) {
                String fullName = entity.getFullName();
                try {
                    plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                }
                catch (Exception e) {
                    throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                }
            }
            IReflectMethod[] decorators = null;
            if (plugIn != null && billExtend != null) {
                decorators = new IReflectMethod[]{plugIn, billExtend};
            } else if (billExtend != null) {
                decorators = new IReflectMethod[]{billExtend};
            } else if (plugIn != null) {
                decorators = new IReflectMethod[]{plugIn};
            }
            if (decorators != null) {
                try {
                    bizBean = new HRBillBeanBizFactory(bizBean).getBizProxy(decorators);
                }
                catch (Throwable e) {
                    throw new BOSException("bizBean:" + bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                }
            }
        }
    }

    protected void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        String oql = "where billID = '" + billId + "'";
        HRContractInfoInfo hrContractInfo = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoInfo(oql);
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        if (DateTimeUtils.dayBefore((Date)curDate, (Date)hrContractInfo.getEntryBizDate())) {
            this.updateContractInfo_beforeEffect(ctx, hrContractInfo);
            this.processUnEffectUnAudit(ctx, billId);
        } else {
            this.recoveryEmployeeContract(ctx, hrContractInfo, curDate);
            this.recoveryHRContract(ctx, hrContractInfo, curDate);
        }
    }

    protected void recoveryEmployeeContract(Context ctx, HRContractInfoInfo hrContract, Date curDate) throws EASBizException, BOSException {
        EmployeeContractInfo employeeContractInfo = ContractUtils.getEmployeeContractInfo(ctx, hrContract.getEmployeeContract().getId().toString());
        employeeContractInfo.setAppraisal(null);
        employeeContractInfo.setAppraDate(null);
        employeeContractInfo.setPenalty(null);
        employeeContractInfo.setCompensation(null);
        employeeContractInfo.setReason(null);
        employeeContractInfo.setDescription(null);
        if (employeeContractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)curDate, (Date)employeeContractInfo.getEndDate())) {
            employeeContractInfo.setState(EmployeeContractState.END);
            employeeContractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            employeeContractInfo.setEndDateReal(employeeContractInfo.getEndDate());
            employeeContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(employeeContractInfo.getEffectDate(), employeeContractInfo.getEndDate()));
        } else {
            employeeContractInfo.setState(EmployeeContractState.RECORD);
            employeeContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
            employeeContractInfo.setEndDateReal(null);
            employeeContractInfo.setContractLimitAutoReal(null);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("endDateReal"));
        selector.add(new SelectorItemInfo("appraisal"));
        selector.add(new SelectorItemInfo("appraDate"));
        selector.add(new SelectorItemInfo("penalty"));
        selector.add(new SelectorItemInfo("compensation"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)employeeContractInfo, selector);
    }

    protected void recoveryHRContract(Context ctx, HRContractInfoInfo hrContract, Date curDate) throws EASBizException, BOSException {
        HRContractInfoCollection coll = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection("where contractNo = '" + hrContract.getContractNo() + "'");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            SelectorItemCollection selector;
            HRContractInfoInfo hRContractInfo = coll.get(i);
            if (hRContractInfo == null) continue;
            if (hrContract.getBillID() != null && hRContractInfo.getBillID() != null && hrContract.getBillID().toString().equals(hRContractInfo.getBillID().toString())) {
                selector = new SelectorItemCollection();
                hRContractInfo.setState(EmployeeContractState.NEW);
                hRContractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
                hRContractInfo.setBillState(HRBillStateEnum.SAVED);
                hRContractInfo.setIsDisplay(false);
                selector.add(new SelectorItemInfo("state"));
                selector.add(new SelectorItemInfo("newState"));
                selector.add(new SelectorItemInfo("billState"));
                selector.add(new SelectorItemInfo("isDisplay"));
                HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
                continue;
            }
            if (hRContractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)curDate, (Date)hRContractInfo.getEndDate())) {
                hRContractInfo.setState(EmployeeContractState.END);
                hRContractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
                hRContractInfo.setEndDateReal(hRContractInfo.getEndDate());
                hRContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(hRContractInfo.getEffectDate(), hRContractInfo.getEndDate()));
            } else {
                hRContractInfo.setState(EmployeeContractState.RECORD);
                hRContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                hRContractInfo.setEndDateReal(null);
                hRContractInfo.setContractLimitAutoReal(null);
            }
            selector = new SelectorItemCollection();
            hRContractInfo.setIsDisplay(true);
            hRContractInfo.setReason(null);
            hRContractInfo.setDescription(null);
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("endDateReal"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("description"));
            selector.add(new SelectorItemInfo("isDisplay"));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
    }

    protected void updateContractInfo_beforeEffect(Context ctx, HRContractInfoInfo hrContractInfoInfo) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_HR_EmployeeContract SET FNewState=FState where  fid='").append(hrContractInfoInfo.getEmployeeContract().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        HRContractInfoCollection coll = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection("where contractNo = '" + hrContractInfoInfo.getContractNo() + "'");
        HRContractInfoInfo hRContractInfo = null;
        SelectorItemCollection selector = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            hRContractInfo = coll.get(i);
            if (hRContractInfo == null) continue;
            if (hrContractInfoInfo.getBillID() != null && hRContractInfo.getBillID() != null && hrContractInfoInfo.getBillID().toString().equals(hRContractInfo.getBillID().toString())) {
                selector = new SelectorItemCollection();
                hRContractInfo.setNewState(EmployeeContractNewStateEnum.ADDED);
                hRContractInfo.setBillState(HRBillStateEnum.SAVED);
                selector.add(new SelectorItemInfo("newState"));
                selector.add(new SelectorItemInfo("billState"));
                HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
                continue;
            }
            selector = new SelectorItemCollection();
            hRContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
            selector.add(new SelectorItemInfo("newState"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
    }

    protected void createBackGroundJob(Context ctx, IObjectValue ov, String jobKey) throws EASBizException, BOSException {
        super.createBackGroundJob(ctx, ov, jobKey);
        String enrtryID = ov.get("id").toString();
        SHRContractUploadAttachmentUtils.saveContractAttachmentReverse(ctx, enrtryID);
    }
}

