/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.contract.ContractBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.ContractRenewBizBill;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillFactory;
import com.kingdee.eas.hr.contract.ContractRenewBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IContractRenewBizBillEntry;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.IOtherContractRenewBizBillEntry;
import com.kingdee.eas.hr.contract.OtherContractRenewBizBillEntryCollection;
import com.kingdee.eas.hr.contract.OtherContractRenewBizBillEntryFactory;
import com.kingdee.eas.hr.contract.OtherContractRenewBizBillEntryInfo;
import com.kingdee.eas.hr.contract.app.AbstractContractRenewBizBillControllerBean;
import com.kingdee.eas.hr.contract.app.ContractRenewBillBizBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.HRContractInfoUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractSourceStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.IEmployeeOtherContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.app.BillTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ContractRenewBizBillControllerBean
extends AbstractContractRenewBizBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ContractRenewBizBillControllerBean.class);
    protected static final String ENTRY_ENTITYNAME = "com.kingdee.eas.hr.contract.app.ContractRenewBizBillEntry";
    private IHRBillBizBean bizBean = null;

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.contract.app.ContractRenewBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return ContractRenewBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new ContractRenewBillBizBean();
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        Date effectDate;
        Date now;
        IEmployeeContract iECF = EmployeeContractFactory.getLocalInstance((Context)ctx);
        ContractRenewBizBillEntryInfo crbbeInfo = (ContractRenewBizBillEntryInfo)entry;
        ContractRenewBizBillInfo crbbInfo = (ContractRenewBizBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(crbbeInfo.getBill().getId()));
        EmployeeContractInfo employeeContract = new EmployeeContractInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_HR_EmployeeContract where fcontractno = '").append(crbbeInfo.getContractNo()).append("'").append(" and fEmployeeId='").append(crbbeInfo.getPerson().getId()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        LabContractFirstPartyInfo firstParty = crbbeInfo.getLabContractFirstParty();
        if (rs.size() == 0) {
            employeeContract.setContractNo(crbbeInfo.getContractNo());
            employeeContract.setEmployee(crbbeInfo.getPerson());
            employeeContract.setContractTemplet(crbbeInfo.getContractTemplet());
            employeeContract.setRecordDate(crbbeInfo.getSignDate());
            employeeContract.setEffectDate(crbbeInfo.getBizDate());
            employeeContract.setEndDate(crbbeInfo.getEndDate());
            employeeContract.setDescription(crbbeInfo.getDescription());
            employeeContract.setState(EmployeeContractState.RECORD);
            employeeContract.setReason(crbbeInfo.getRenewReason());
            employeeContract.setToUnit(crbbeInfo.getToUnit());
            employeeContract.setDelegatePerson(crbbeInfo.getDelegatePerson(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            employeeContract.setDelegatePerson(crbbeInfo.getDelegatePerson(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            employeeContract.setDelegatePerson(crbbeInfo.getDelegatePerson(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            employeeContract.setToUnitAddress(crbbeInfo.getToUnitAddress(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            employeeContract.setToUnitAddress(crbbeInfo.getToUnitAddress(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            employeeContract.setToUnitAddress(crbbeInfo.getToUnitAddress(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            employeeContract.setEmpIdentityNum(crbbeInfo.getIdCardNo());
            employeeContract.setEmpAddress(crbbeInfo.getAddress());
            employeeContract.setCredentialsType(crbbeInfo.getCredentialsType());
            employeeContract.setEmpPassPortNum(crbbeInfo.getPassportNo());
            employeeContract.setHrOrgUnit(crbbInfo.getHrOrgUnit());
            employeeContract.setContSerLimit(crbbeInfo.getContractServerLimit());
            employeeContract.setVip(false);
            employeeContract.setTestBeginDate(crbbeInfo.getTestBeginDate());
            employeeContract.setTestEndDate(crbbeInfo.getTestEndDate());
            employeeContract.setNewState(EmployeeContractNewStateEnum.RECORDED);
            employeeContract.setContractLimitType(crbbeInfo.getContractLimitType());
            employeeContract.setThirdDelegatePerson(crbbeInfo.getThirdDelegatePerson());
            employeeContract.setThirdUnitName(crbbeInfo.getThirdUnit());
            employeeContract.setThirdUnitAddress(crbbeInfo.getThirdUnitAddress());
            if (!StringUtils.isEmpty((String)crbbeInfo.getContractLimit())) {
                employeeContract.setContractLimitAuto(new BigDecimal(crbbeInfo.getContractLimit()));
            }
            employeeContract.setPenalty(crbbeInfo.getPenalty());
            employeeContract.setCompensation(crbbeInfo.getCompensation());
            employeeContract.setAppraisal(crbbeInfo.getAppraisal());
            employeeContract.setAppraDate(crbbeInfo.getAppraDate());
            employeeContract.setIsInAdmin(crbbeInfo.isIsInAdmin());
            employeeContract.setContractSourceState(EmployeeContractSourceStateEnum.FROM_RESUMED);
            employeeContract.setPositionString(crbbeInfo.getPositionString());
            employeeContract.setContractAgreedSalary(crbbeInfo.getContractAgreedSalary());
            employeeContract.setLabContractFirstParty(firstParty);
            employeeContract.setAdminOrg(crbbeInfo.getAdminOrg());
            employeeContract.setIsChanged(false);
            if (crbbInfo.getApproveType().getValue() == 1) {
                employeeContract.setIsWorkflow(true);
            } else {
                employeeContract.setIsWorkflow(false);
            }
            ContractTempletInfo templetInfo = crbbeInfo.getContractTemplet();
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId()));
            if (templetInfo.isIsElectronicSign() && crbbInfo.isIsSSCShare()) {
                employeeContract.setContractClassify(ContractClassifyEnum.ElectronicSsc);
                employeeContract.setSignStatus(EContractSignState.complete);
                employeeContract.setIsElectronicSign(templetInfo.isIsElectronicSign());
            } else if (templetInfo.isIsElectronicSign() && !crbbInfo.isIsSSCShare()) {
                employeeContract.setContractClassify(ContractClassifyEnum.ElectronicEmp);
                employeeContract.setSignStatus(EContractSignState.uninitiated);
                employeeContract.setIsElectronicSign(false);
            } else {
                employeeContract.setContractClassify(ContractClassifyEnum.Normal);
                employeeContract.setSignStatus(EContractSignState.uninitiated);
                employeeContract.setIsElectronicSign(false);
            }
            EmployeeContractInfo sourceContract = crbbeInfo.getSourceContract();
            sourceContract = iECF.getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(sourceContract.getId()));
            SelectorItemCollection selector = new SelectorItemCollection();
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (DateTimeUtils.dayBefore((Date)crbbeInfo.getBizDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)crbbeInfo.getBizDate(), (Date)curDate)) {
                sourceContract.setState(EmployeeContractState.END);
                selector.add(new SelectorItemInfo("state"));
            }
            sourceContract.setNewState(EmployeeContractNewStateEnum.RESUMED);
            selector.add(new SelectorItemInfo("newState"));
            iECF.updatePartial((CoreBaseInfo)sourceContract, selector);
            employeeContract.setSourceContract(sourceContract);
            employeeContract.setCreator(crbbInfo.getCreator());
            employeeContract.setCreateTime(crbbInfo.getCreateTime());
            employeeContract.setIsContinuousSigned(true);
            employeeContract.setContinuousSignedCount(sourceContract.getContinuousSignedCount() + 1);
            employeeContract.put("notNeedGenerateObjectNumber", (Object)true);
            IObjectPK contractId = iECF.addnew((CoreBaseInfo)employeeContract);
            this.updateSourceContractDate(ctx, employeeContract);
            employeeContract.setId(BOSUuid.read((String)contractId.toString()));
            this.reverseEmployeeContractAttachment(ctx, employeeContract, entry);
            super._entryEffect(ctx, entry);
        }
        if (!(now = new Date()).before(effectDate = this.getEffectDate(entry))) {
            this.updateHRContractInfo_afterEffect(ctx, crbbeInfo);
        }
        if (null != crbbInfo.getOtherEntrys()) {
            this.otherFollowLaborContract(ctx, crbbInfo);
        }
    }

    protected void otherFollowLaborContract(Context ctx, ContractRenewBizBillInfo billInfo) throws EASBizException, BOSException {
        ContractRenewBizBillEntryInfo billEntryInfo = billInfo.getEntrys().get(0);
        OtherContractRenewBizBillEntryCollection otherEntrys = billInfo.getOtherEntrys();
        if (otherEntrys != null && otherEntrys.size() > 0) {
            logger.info("otherEntrys_ size is " + otherEntrys.size());
            IOtherContractRenewBizBillEntry iOtherContractRenewBizBillEntry = OtherContractRenewBizBillEntryFactory.getLocalInstance(ctx);
            IEmployeeOtherContract iEmployeeOtherContract = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < otherEntrys.size(); ++i) {
                String otherEntryId = otherEntrys.get(i).getId().toString();
                String oql = "where id = '" + otherEntryId + "'";
                logger.info("oql_ is : " + oql);
                OtherContractRenewBizBillEntryInfo otherEntryInfo = iOtherContractRenewBizBillEntry.getOtherContractRenewBizBillEntryInfo(oql);
                EmployeeOtherContractInfo oContractInfo = new EmployeeOtherContractInfo();
                oContractInfo.setContractNo(otherEntryInfo.getContractNo());
                oContractInfo.setEmployee(otherEntryInfo.getPerson());
                oContractInfo.setContractLimitType(otherEntryInfo.getContractLimitType());
                oContractInfo.setContractTemplet(otherEntryInfo.getContractTemplet());
                oContractInfo.setRecordDate(otherEntryInfo.getSignDate());
                oContractInfo.setEffectDate(otherEntryInfo.getBizDate());
                oContractInfo.setEndDate(otherEntryInfo.getEndDate());
                oContractInfo.setDescription(billEntryInfo.getDescription());
                oContractInfo.setState(EmployeeContractState.RECORD);
                oContractInfo.setReason(billEntryInfo.getRenewReason());
                oContractInfo.setToUnit(billEntryInfo.getToUnit());
                oContractInfo.setLabContractFirstParty(billEntryInfo.getLabContractFirstParty());
                oContractInfo.setDelegatePerson(billEntryInfo.getDelegatePerson(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                oContractInfo.setDelegatePerson(billEntryInfo.getDelegatePerson(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                oContractInfo.setDelegatePerson(billEntryInfo.getDelegatePerson(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                oContractInfo.setToUnitAddress(billEntryInfo.getToUnitAddress(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                oContractInfo.setToUnitAddress(billEntryInfo.getToUnitAddress(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                oContractInfo.setToUnitAddress(billEntryInfo.getToUnitAddress(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                oContractInfo.setEmpIdentityNum(otherEntryInfo.getIdCardNo());
                oContractInfo.setEmpAddress(otherEntryInfo.getAdrress());
                oContractInfo.setEmpPassPortNum(otherEntryInfo.getPassportNo());
                oContractInfo.setHrOrgUnit(billInfo.getHrOrgUnit());
                oContractInfo.setContSerLimit(billEntryInfo.getContractServerLimit());
                oContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
                oContractInfo.setContractLimitType(otherEntryInfo.getContractLimitType());
                oContractInfo.setThirdDelegatePerson(billEntryInfo.getThirdDelegatePerson());
                oContractInfo.setThirdUnitName(billEntryInfo.getThirdUnit());
                oContractInfo.setThirdUnitAddress(billEntryInfo.getThirdUnitAddress());
                if (!StringUtils.isEmpty((String)otherEntryInfo.getContractLimit())) {
                    oContractInfo.setContractLimitAuto(new BigDecimal(otherEntryInfo.getContractLimit()));
                }
                oContractInfo.setPenalty(billEntryInfo.getPenalty());
                oContractInfo.setCompensation(billEntryInfo.getCompensation());
                oContractInfo.setAppraisal(billEntryInfo.getAppraisal());
                oContractInfo.setAppraDate(billEntryInfo.getAppraDate());
                oContractInfo.setIsInAdmin(billEntryInfo.isIsInAdmin());
                oContractInfo.setContractSourceState(EmployeeContractSourceStateEnum.FROM_ADDED);
                oContractInfo.setIsChanged(false);
                if (billInfo.getApproveType().getValue() == 1) {
                    oContractInfo.setIsWorkflow(true);
                } else {
                    oContractInfo.setIsWorkflow(false);
                }
                oContractInfo.setEntryID(otherEntryInfo.getId().toString());
                oContractInfo.setPositionString(billEntryInfo.getPositionString());
                oContractInfo.setContractAgreedSalary(billEntryInfo.getContractAgreedSalary());
                oContractInfo.setAdminOrg(otherEntryInfo.getAdminOrg());
                oContractInfo.setPreEntryPerson(null);
                oContractInfo.setSignStatus(EContractSignState.complete);
                oContractInfo.setContractClassify(ContractClassifyEnum.ElectronicSsc);
                oContractInfo.setCredentialsType(billEntryInfo.getCredentialsType());
                IObjectPK contractId = iEmployeeOtherContract.addnew((CoreBaseInfo)oContractInfo);
                oContractInfo.setId(BOSUuid.read((String)contractId.toString()));
            }
        }
    }

    private void updateSourceContractDate(Context ctx, EmployeeContractInfo employeeContract) throws EASBizException, BOSException {
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        EmployeeContractInfo sourceContract = employeeContract.getSourceContract();
        SelectorItemCollection selector = new SelectorItemCollection();
        if ((DateTimeUtils.dayBefore((Date)employeeContract.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)employeeContract.getEffectDate(), (Date)curDate)) && sourceContract.getEndDate() != null && !DateTimeUtils.dayBefore((Date)sourceContract.getEndDate(), (Date)employeeContract.getEffectDate())) {
            sourceContract.setEndDateReal(HRUtil.getBeforeDate((Date)employeeContract.getEffectDate()));
            selector.add(new SelectorItemInfo("endDateReal"));
            sourceContract.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceContract.getEffectDate(), sourceContract.getEndDateReal()));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        }
        EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)sourceContract, selector);
    }

    private void updateHRContractInfo_afterEffect(Context ctx, ContractRenewBizBillEntryInfo crbbeInfo) throws EASBizException, BOSException {
        HRContractInfoInfo hRContractInfo = HRContractInfoUtils.getHRContractInfo(ctx, crbbeInfo.getBill().getId().toString(), crbbeInfo.getContractNo());
        hRContractInfo.setState(EmployeeContractState.RECORD);
        hRContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
        hRContractInfo.setReason(crbbeInfo.getRenewReason());
        hRContractInfo.setDescription(crbbeInfo.getDescription());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("employeeContract"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("description"));
        String oql = "select id where contractNo='" + crbbeInfo.getContractNo() + "'";
        IEmployeeContract iEmployeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo contractInfo = iEmployeeContract.getEmployeeContractInfo(oql);
        hRContractInfo.setEmployeeContract(contractInfo);
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        iHRContractInfo.updatePartial(hRContractInfo, selector);
        EmployeeContractInfo sourceContract = crbbeInfo.getSourceContract();
        oql = "select * where employeeContract.id='" + sourceContract.getId() + "'";
        HRContractInfoCollection infoColl = iHRContractInfo.getHRContractInfoCollection(oql);
        selector = new SelectorItemCollection();
        if (infoColl.size() > 0) {
            HRContractInfoInfo sourceHRContractInfo = infoColl.get(0);
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (DateTimeUtils.dayBefore((Date)crbbeInfo.getBizDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)crbbeInfo.getBizDate(), (Date)curDate)) {
                sourceHRContractInfo.setState(EmployeeContractState.END);
                if (sourceHRContractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)sourceHRContractInfo.getEndDate(), (Date)crbbeInfo.getBizDate())) {
                    sourceHRContractInfo.setEndDateReal(HRUtil.getBeforeDate((Date)crbbeInfo.getBizDate()));
                    selector.add(new SelectorItemInfo("endDateReal"));
                    sourceHRContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceHRContractInfo.getEffectDate(), sourceHRContractInfo.getEndDateReal()));
                    selector.add(new SelectorItemInfo("contractLimitAutoReal"));
                }
            } else {
                sourceHRContractInfo.setState(EmployeeContractState.RESUME);
            }
            sourceHRContractInfo.setNewState(EmployeeContractNewStateEnum.RESUMED);
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("newState"));
            iHRContractInfo.updatePartial(sourceHRContractInfo, selector);
        }
    }

    @Override
    protected String _getOrgRange(Context ctx, String hrId) throws BOSException, EASBizException {
        String adminStr = null;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("select ADMINORG.FID from T_ORG_Admin ADMINORG ");
        sql.append("left join T_ORG_UnitRelation UNITRELATION on ADMINORG.FID = UNITRELATION.FFromUnitID ");
        sql.append("left join T_PM_OrgRange ORGRANGE on ADMINORG.FID = ORGRANGE.FORGID ");
        sql.append("left join T_PM_USER PUSER on PUSER.FID = ORGRANGE.FUSERID ");
        sql.append("where  ORGRANGE.FType = 20 and ADMINORG.FIsSealUp = 0 ");
        sql.append("and (UNITRELATION.FToUnitID = '");
        sql.append(hrId);
        sql.append("' and UNITRELATION.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5') ");
        sql.append("and PUSER.FID = '");
        sql.append(userId);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer adminIdStr = new StringBuffer();
        try {
            while (rs.next()) {
                adminIdStr.append("'");
                adminIdStr.append(rs.getString(1));
                adminIdStr.append("',");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (adminIdStr.length() > 0) {
            adminStr = adminIdStr.substring(0, adminIdStr.length() - 1);
        }
        return adminStr;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractRenewBizBillInfo crbbInfo = (ContractRenewBizBillInfo)model;
        this.updateContractRenewBizBillEntryContractNo(ctx, crbbInfo);
        this.checkEnrollAgain(ctx, crbbInfo);
        this.checkSourceContractNewState(ctx, crbbInfo);
        this.checkEntry(ctx, crbbInfo);
        this.checkEntryIsInOther(ctx, crbbInfo);
        this.checkDate(ctx, crbbInfo);
        this.checkContNoIsRepeat(ctx, crbbInfo);
        this.checkHasContractByDate(ctx, (IObjectValue)crbbInfo);
        this.checkLabPartyIsOpenElec(ctx, crbbInfo);
        IObjectPK objectPk = super._addnew(ctx, model);
        this.addNewHrContractInfo(ctx, crbbInfo, objectPk);
        return objectPk;
    }

    private void checkEnrollAgain(Context ctx, ContractRenewBizBillInfo crbbInfo) throws BOSException, EASBizException {
        ContractRenewBizBillEntryInfo crbbeInfo = null;
        int count = crbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            crbbeInfo = crbbInfo.getEntrys().get(i);
            if (crbbeInfo.getSourceContract() == null) continue;
            HashMap<Object, Object> personMap = new HashMap<Object, Object>();
            if (!ContractUtils.checkIsEnrollAgainPersonWhenRenewAction(ctx, crbbeInfo.getSourceContract().getId().toString(), personMap)) continue;
            throw new ContractException(ContractException.ENROLL_AGAIN_CANT_RENEW, new Object[]{personMap.get("number") + "_" + personMap.get("name")});
        }
    }

    @Override
    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        super.setNumberFromCodingRule(ctx, model);
        if (model instanceof ContractRenewBizBillInfo) {
            OtherContractRenewBizBillEntryCollection otherEntries;
            ContractRenewBizBillInfo billInfo = (ContractRenewBizBillInfo)model;
            if (billInfo.getId() != null) {
                return;
            }
            CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            ContractRenewBizBillEntryCollection entries = billInfo.getEntrys();
            if (entries != null) {
                ContractRenewBizBillEntryInfo entry = null;
                EmployeeContractInfo contractInfo = new EmployeeContractInfo();
                String number = null;
                String orgID = curCuInfo.getId().toString();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    entry = entries.get(i);
                    this.assembleContractInfoForCoding(ctx, contractInfo, entry);
                    contractInfo.setContractNo(billInfo.getNumber());
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (StringUtils.isEmpty((String)orgID) || !iCodingRuleManager.isExist((IObjectValue)contractInfo, orgID)) continue;
                    number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)contractInfo, orgID);
                    while (this.isEmpContractNumberExist(ctx, number)) {
                        number = iCodingRuleManager.getNumber((IObjectValue)contractInfo, orgID);
                    }
                    if (number == null) continue;
                    entry.setContractNo(number);
                }
            }
            if ((otherEntries = billInfo.getOtherEntrys()).size() > 0) {
                OtherContractRenewBizBillEntryInfo otherEntry = null;
                EmployeeOtherContractInfo contractOtherInfo = new EmployeeOtherContractInfo();
                String number = null;
                String orgID = curCuInfo.getId().toString();
                int size = otherEntries.size();
                for (int i = 0; i < size; ++i) {
                    otherEntry = otherEntries.get(i);
                    this.assembleOtherContractInfoForCoding(ctx, contractOtherInfo, otherEntry);
                    contractOtherInfo.setContractNo(billInfo.getNumber());
                    contractOtherInfo.setLabContractFirstParty(otherEntry.getLabContractFirstParty());
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (StringUtils.isEmpty((String)orgID) || !iCodingRuleManager.isExist((IObjectValue)contractOtherInfo, orgID)) continue;
                    number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)contractOtherInfo, orgID);
                    while (this.isEmpOtherContractNumberExist(ctx, number)) {
                        number = iCodingRuleManager.getNumber((IObjectValue)contractOtherInfo, orgID);
                    }
                    if (number == null) continue;
                    otherEntry.setContractNo(number);
                }
            }
            this.updateContractRenewBizBillEntryContractNo(ctx, (ContractRenewBizBillInfo)model);
        }
    }

    protected void assembleContractInfoForCoding(Context ctx, EmployeeContractInfo contractInfo, ContractRenewBizBillEntryInfo entry) {
        String entityName = "com.kingdee.eas.hr.emp.app.EmployeeContract";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        Enumeration e = entry.keys();
        block0: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.isContractExcludeField(key)) continue;
            int size = propColl.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo propInfo = propColl.get(i);
                String propName = propInfo.getName();
                if (!propName.equalsIgnoreCase(key)) continue;
                Object value = entry.get(propName);
                Object retValue = ContractUtils.getEnumValue(value);
                contractInfo.put(propName, retValue);
                continue block0;
            }
        }
        contractInfo.setEmployee(entry.getPerson());
        contractInfo.setEffectDate(entry.getBizDate());
        contractInfo.setRecordDate(entry.getSignDate());
    }

    protected void assembleOtherContractInfoForCoding(Context ctx, EmployeeOtherContractInfo otherContractInfo, OtherContractRenewBizBillEntryInfo entry) {
        String entityName = "com.kingdee.eas.hr.emp.app.EmployeeOtherContract";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        Enumeration e = entry.keys();
        block0: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.isContractExcludeField(key)) continue;
            int size = propColl.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo propInfo = propColl.get(i);
                String propName = propInfo.getName();
                if (!propName.equalsIgnoreCase(key)) continue;
                Object value = entry.get(propName);
                Object retValue = ContractUtils.getEnumValue(value);
                otherContractInfo.put(propName, retValue);
                continue block0;
            }
        }
        otherContractInfo.setEmployee(entry.getPerson());
        otherContractInfo.setEffectDate(entry.getBizDate());
        otherContractInfo.setRecordDate(entry.getSignDate());
    }

    protected boolean isEmpContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeContractFactory.getLocalInstance((Context)ctx).exists(oql);
    }

    protected boolean isEmpOtherContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeOtherContractFactory.getLocalInstance((Context)ctx).exists(oql);
    }

    protected void preProcess(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof ContractRenewBizBillInfo) {
            ContractRenewBizBillInfo oldContractRenewBizBillInfo = this.getContractRenewBizBillInfo(ctx, pk);
            ContractRenewBizBillEntryCollection oldEntries = null;
            if (oldContractRenewBizBillInfo != null) {
                oldEntries = oldContractRenewBizBillInfo.getEntrys();
            }
            ContractRenewBizBillEntryCollection entries = ((ContractRenewBizBillInfo)model).getEntrys();
            ContractRenewBizBillEntryInfo oldEntry = null;
            ContractRenewBizBillEntryInfo entry = null;
            EmployeeContractInfo contractInfo = null;
            String contno = null;
            if (oldEntries != null) {
                boolean isDelete = true;
                int oldsize = oldEntries.size();
                for (int i = 0; i < oldsize; ++i) {
                    oldEntry = oldEntries.get(i);
                    if (entries != null) {
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            entry = entries.get(j);
                            if (!oldEntry.getId().equals((Object)entry.getId())) continue;
                            isDelete = false;
                            break;
                        }
                    }
                    if (isDelete) {
                        contractInfo = new EmployeeContractInfo();
                        contractInfo.setContractNo(((ContractRenewBizBillInfo)model).getNumber());
                        this._dispachIntermitNumber(ctx, oldEntry, contractInfo);
                        continue;
                    }
                    isDelete = true;
                }
            }
            if (entries != null) {
                contractInfo = new EmployeeContractInfo();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    entry = entries.get(i);
                    if (entry.getId() != null) continue;
                    contractInfo.setEmployee(entry.getPerson());
                    contractInfo.setContractNo(((ContractRenewBizBillInfo)model).getNumber());
                    contno = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).getNumberFromCodingRule((IObjectValue)contractInfo, null, null);
                    if (contno == null) continue;
                    entry.setContractNo(contno);
                }
            }
        }
    }

    private void _dispachIntermitNumber(Context ctx, ContractRenewBizBillEntryInfo entry, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        if (entry != null && entry.getContractNo() != null) {
            CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)contractInfo, null, entry.getContractNo());
        }
    }

    protected void _dispachIntermitNumber(Context ctx, IObjectPK pk) throws CodingRuleException, EASBizException, BOSException {
        ContractRenewBizBillEntryCollection entries;
        super._dispachIntermitNumber(ctx, pk);
        ContractRenewBizBillInfo contractrenewbizbillInfo = this.getContractRenewBizBillInfo(ctx, pk);
        if (contractrenewbizbillInfo != null && (entries = contractrenewbizbillInfo.getEntrys()) != null) {
            ContractRenewBizBillEntryInfo entry = null;
            EmployeeContractInfo contractInfo = new EmployeeContractInfo();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                if (entry.getContractNo() == null) continue;
                contractInfo.setContractNo(contractrenewbizbillInfo.getNumber());
                CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)contractInfo, null, entry.getContractNo());
            }
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ContractRenewBizBillInfo crbbInfo = (ContractRenewBizBillInfo)model;
        this.checkEnrollAgain(ctx, crbbInfo);
        this.checkEntry(ctx, crbbInfo);
        this.checkEntryIsInOther(ctx, crbbInfo);
        this.checkSourceContractNewState(ctx, crbbInfo);
        this.checkDate(ctx, crbbInfo);
        this.checkContNoIsRepeat(ctx, crbbInfo);
        this.checkHasContractByDate(ctx, (IObjectValue)crbbInfo);
        this.checkLabPartyIsOpenElec(ctx, crbbInfo);
        this.preProcess(ctx, pk, model);
        super._update(ctx, pk, model);
        this.updateHrContractInfo(ctx, crbbInfo, pk);
    }

    private void checkDate(Context ctx, ContractRenewBizBillInfo crbbInfo) throws EASBizException, BOSException {
        ContractRenewBizBillEntryInfo crbbeInfo = null;
        int size = crbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            crbbeInfo = crbbInfo.getEntrys().get(i);
            String personParm = ContractUtils.getPersonInfo(ctx, crbbeInfo.getPerson().getId().toString());
            if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)crbbeInfo.getContractLimitType()) && crbbeInfo.getEndDate() == null) {
                throw new ContractException(ContractException.ENDDATE_ISNULL, new Object[]{personParm});
            }
            ContractTempletInfo templetInfo = crbbeInfo.getContractTemplet();
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
            if (crbbeInfo.getEndDate() != null) {
                if (DateTimeUtils.dayAfter((Date)crbbeInfo.getBizDate(), (Date)crbbeInfo.getEndDate())) {
                    throw new ContractException(ContractException.BIZDATE_AFTER_ENDDATE, new Object[]{personParm});
                }
                if (DateTimeUtils.dayAfter((Date)crbbeInfo.getSignDate(), (Date)crbbeInfo.getEndDate())) {
                    throw new ContractException(ContractException.SIGNDATE_AFTER_ENDDATE, new Object[]{personParm});
                }
            }
            if (crbbeInfo.getPenalty() != null && crbbeInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.PENALTY_ISMINUS, new Object[]{personParm});
            }
            if (crbbeInfo.getCompensation() != null && crbbeInfo.getCompensation().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.COMPENSATION_ISMINUS, new Object[]{personParm});
            }
            if (crbbeInfo.getContinuousSignedCount() < 0) {
                throw new ContractException(ContractException.CONTINUESIGNCOUNT_ISMINUS, new Object[]{personParm});
            }
            if (templetInfo.getInvalidDate() == null || !DateTimeUtils.dayBefore((Date)templetInfo.getInvalidDate(), (Date)new Date())) continue;
            throw new ContractException(ContractException.CONTEMPLET_INVALID, new Object[]{personParm});
        }
    }

    private void checkContNoIsRepeat(Context ctx, ContractRenewBizBillInfo crbbInfo) throws BOSException, EASBizException {
        CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String orgID = curCuInfo.getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo contractInfo = new EmployeeContractInfo();
        if (!(!StringUtils.isEmpty((String)orgID) && iCodingRuleManager.isExist((IObjectValue)contractInfo, orgID))) {
            IEmployeeContract employeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
            IContractRenewBizBillEntry iCRBBE = ContractRenewBizBillEntryFactory.getLocalInstance(ctx);
            ContractRenewBizBillEntryInfo crbbeInfo = null;
            int size = crbbInfo.getEntrys().size();
            for (int i = 0; i < size; ++i) {
                crbbeInfo = crbbInfo.getEntrys().get(i);
                StringBuffer sql = new StringBuffer();
                sql.append("select id  where contractNo = '" + crbbeInfo.getContractNo() + "'");
                EmployeeContractCollection ecCol = employeeContract.getEmployeeContractCollection(sql.toString());
                StringBuffer whereStr = new StringBuffer("select id where contractNo = '");
                whereStr.append(crbbeInfo.getContractNo());
                if (crbbInfo.getId() != null) {
                    whereStr.append("' and bill <> '");
                    whereStr.append(crbbInfo.getId().toString());
                }
                whereStr.append("' and (bill.billState in (0, 1, 2) or (bill.billState = 3 and bizDate >= ");
                whereStr.append(HRUtil.getCurrentDate());
                whereStr.append("))");
                ContractRenewBizBillEntryCollection csbbCol = iCRBBE.getContractRenewBizBillEntryCollection(whereStr.toString());
                if (ecCol.size() <= 0 && csbbCol.size() <= 0) continue;
                throw new ContractException(ContractException.CONTRACTNO_REPEAT, new Object[]{crbbeInfo.getContractNo()});
            }
        }
    }

    private void checkHasContractByDate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractRenewBizBillInfo crbbInfo = (ContractRenewBizBillInfo)model;
        int size = crbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            ContractRenewBizBillEntryInfo crbbeInfo = crbbInfo.getEntrys().get(i);
            ContractTypeInfo contractTypeInfo = ContractTypeFactory.getLocalInstance((Context)ctx).getContractTypeInfo((IObjectPK)new ObjectUuidPK(crbbeInfo.getContractType().getId().toString()));
            if (!contractTypeInfo.isIsLaborContract()) continue;
            HRContractInfoInfo contractInfo = new HRContractInfoInfo();
            contractInfo.setBillID(crbbInfo.getId());
            contractInfo.setEmployee(crbbeInfo.getPerson());
            contractInfo.setEffectDate(crbbeInfo.getBizDate());
            contractInfo.setContractLimitType(crbbeInfo.getContractLimitType());
            contractInfo.setEndDate(crbbeInfo.getEndDate());
            contractInfo.setSourceContract(crbbeInfo.getSourceContract());
            contractInfo.put("hrOrgUnit", crbbInfo.getHrOrgUnit());
            HashSet<String> excludeContractNo = new HashSet<String>();
            excludeContractNo.add(crbbeInfo.getContractNo());
            ContractUtils.checkContractTimeIsCrossing(ctx, contractInfo, excludeContractNo, true);
        }
    }

    private void checkEntry(Context ctx, ContractRenewBizBillInfo crbbInfo) throws BOSException, EASBizException {
        ContractRenewBizBillEntryInfo crbbeInfo1 = null;
        ContractRenewBizBillEntryInfo crbbeInfo2 = null;
        int count = crbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            crbbeInfo1 = crbbInfo.getEntrys().get(i);
            int size = crbbInfo.getEntrys().size() - i;
            for (int j = i + 1; j < size; ++j) {
                crbbeInfo2 = crbbInfo.getEntrys().get(j);
                if (!crbbeInfo1.getSourceContract().getId().equals((Object)crbbeInfo2.getSourceContract().getId())) continue;
                throw new ContractException(ContractException.CONTRACT_REPEAT, new Object[]{new Integer(i + 1), new Integer(j + 1)});
            }
            ContractUtils.checkContractInBillByType(ctx, crbbeInfo1.getSourceContract().getId().toString(), crbbInfo.getId(), BillTypeEnum.RENEW, i + 1);
            ContractUtils.checkContractInBillByHRContractInfo(ctx, crbbeInfo1.getSourceContract().getId().toString(), crbbInfo.getId());
        }
    }

    protected void checkLabPartyIsOpenElec(Context ctx, ContractRenewBizBillInfo csbbInfo) throws EASBizException, BOSException {
        ContractRenewBizBillEntryCollection entrys;
        if (csbbInfo.isIsSSCShare() && (entrys = csbbInfo.getEntrys()) != null && entrys.size() > 0) {
            for (int dex = 0; dex < entrys.size(); ++dex) {
                ContractRenewBizBillEntryInfo entryInfo = entrys.get(0);
                ContractTempletInfo contractTemplet = entryInfo.getContractTemplet();
                if (contractTemplet.get("isElectronicSign") == null) {
                    contractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTemplet.getId()));
                }
                if (!contractTemplet.isIsElectronicSign()) continue;
                LabContractFirstPartyInfo labContractFirstParty = entryInfo.getLabContractFirstParty();
                ElectronicContractUtils.checkLabContractFirstPartyIsOpenElec((Context)ctx, (LabContractFirstPartyInfo)labContractFirstParty);
                ElectronicContractUtils.checkKDContractConfigIsAuth((Context)ctx, (LabContractFirstPartyInfo)labContractFirstParty);
            }
        }
    }

    private void checkEntryIsInOther(Context ctx, ContractRenewBizBillInfo crbbInfo) throws BOSException, EASBizException {
        ContractRenewBizBillEntryInfo crbbeInfo = null;
        int count = crbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            crbbeInfo = crbbInfo.getEntrys().get(i);
            crbbeInfo.getSourceContract().setEmployee(crbbeInfo.getPerson());
            ContractUtils.checkContractIsInOther(ctx, crbbeInfo.getSourceContract(), ContractRenewBizBill.class.getName(), i + 1);
        }
    }

    private void checkSourceContractNewState(Context ctx, ContractRenewBizBillInfo crbbInfo) throws BOSException, EASBizException {
        ContractRenewBizBillEntryInfo crbbeInfo = null;
        int count = crbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            crbbeInfo = crbbInfo.getEntrys().get(i);
            String sourceContractId = "";
            if (crbbeInfo.getSourceContract() == null) continue;
            sourceContractId = crbbeInfo.getSourceContract().getId().toString();
            try {
                Date endDate;
                EmployeeContractInfo employeeContractInfo = new EmployeeContractInfo();
                EmployeeContractCollection coll = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection("select * where id = '" + sourceContractId + "'");
                if (coll.size() > 0) {
                    employeeContractInfo = coll.get(0);
                    ContractUtils.checkContractChangeOrRenewException(ctx, crbbeInfo.getPerson().getId().toString(), employeeContractInfo, "CONTRACT_OPT_RENEW");
                }
                if ((endDate = ContractUtils.getContractEndDateField(employeeContractInfo)) != null) {
                    Date renewDate = HRUtil.getAftereDate((Date)endDate);
                    if (DateTimeUtils.dayAfter((Date)crbbeInfo.getBizDate(), (Date)renewDate)) {
                        String personParm = ContractUtils.getPersonInfo(ctx, crbbeInfo.getPerson().getId().toString());
                        throw new ContractException(ContractException.RENEWDATE_TOO_LATE, new Object[]{personParm});
                    }
                }
                EmployeeContractInfo currentContractInfo = new EmployeeContractInfo();
                currentContractInfo.setHrOrgUnit(crbbInfo.getHrOrgUnit());
                currentContractInfo.setEffectDate(crbbeInfo.getBizDate());
                currentContractInfo.setEndDate(crbbeInfo.getEndDate());
                currentContractInfo.setEmployee(crbbeInfo.getPerson());
                ContractUtils.checkSourceContractTimeIsCrossing(ctx, currentContractInfo, employeeContractInfo);
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IObjectCollection entries;
        if (billID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        String entryField = this.getEntryField();
        String billField = this.getBillField();
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        this.bizBean = this.getBizBeanProxy(ctx);
        if (this.bizBean != null) {
            this.bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        if ((entries = (IObjectCollection)model.get(entryField)) != null) {
            Date effectDate = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (HRBillBaseEntryInfo)entries.getObject(i);
                entry.put(billField, (Object)model);
                if (this.getEntryEffectDateField() != null && (effectDate = entry.getDate(this.getEntryEffectDateField())) != null) {
                    effectDate = DateTimeUtils.truncateDate((Date)effectDate);
                }
                this._beforeEffectOnNoJob(ctx, entry);
                if (this.bizBean != null) {
                    this.bizBean._beforeEffectOnNoJob(ctx, entry);
                }
                this.entryEffectCommon(ctx, entry.getId());
            }
        }
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
        ContractUtils.syncBillStateToHRContractInfo(ctx, billID, HRBillStateEnum.AUDITED);
    }

    public void entryEffectCommon(Context ctx, BOSUuid entryID) throws BOSException, EASBizException {
        if (entryID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, (Object)bill);
        }
        this._entryEffect(ctx, entry);
        if (this.bizBean != null) {
            this.bizBean._entryEffect(ctx, entry);
        }
        this._mappingSubmit(ctx, bill);
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getOriginLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    @Override
    protected void setHRContractInfoInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billId, CoreBaseInfo entryInfo, HRContractInfoInfo contractInfo) throws EASBizException, BOSException {
        super.setHRContractInfoInfo(ctx, billInfo, billId, entryInfo, contractInfo);
        contractInfo.put("reason", entryInfo.get("renewReason"));
        contractInfo.put("toUnit", entryInfo.get("toUnit"));
        contractInfo.put("delegatePerson", entryInfo.get("delegatePerson"));
        ContractRenewBizBillEntryInfo ccbbInfo = (ContractRenewBizBillEntryInfo)entryInfo;
        contractInfo.setSourceContract(ccbbInfo.getSourceContract());
    }

    public void setBillRelateInfo(Context ctx, BOSUuid entryID) throws EASBizException, BOSException {
        if (entryID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, (Object)bill);
        }
        this._entryEffect(ctx, entry);
    }

    protected boolean isNeedMappingReWrite(Context ctx, HRBillBaseInfo bill) {
        return false;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setLabContractFirstPartyName(ctx, model);
        IObjectPK retValue = super._submit(ctx, model);
        this.afterProcessContractReNewData(ctx, model, true);
        return retValue;
    }

    private void afterProcessContractReNewData(Context ctx, IObjectValue model, boolean isAddNew) throws EASBizException, BOSException {
        ContractRenewBizBillInfo billInfo = (ContractRenewBizBillInfo)model;
        if (!billInfo.isIsSSCShare()) {
            return;
        }
        try {
            ContractRenewBizBillEntryCollection entryColl = billInfo.getEntrys();
            ContractRenewBizBillEntryInfo entryInfo = entryColl.get(0);
            ContractTempletInfo templetInfo = entryInfo.getContractTemplet();
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
            if (templetInfo.isIsElectronicSign()) {
                String clazzName = "com.kingdee.shr.econtractservice.service.ContractBizBillService";
                String methodName = "processEContractData";
                Class<?> clazz = Class.forName(clazzName);
                Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])new Class[]{Context.class, IObjectValue.class, Boolean.class});
                if (method == null) {
                    throw new BOSException("can not find com.kingdee.shr.econtractservice.service.ContractBizBillService processEContractData");
                }
                ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])new Object[]{ctx, model, isAddNew});
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof UndeclaredThrowableException) {
                Throwable t = e.getCause();
                logger.error(t.getMessage(), t);
                if (t instanceof EASBizException) {
                    throw (EASBizException)t;
                }
                if (t instanceof BOSException) {
                    throw (BOSException)t;
                }
                throw new BOSException(t.getMessage(), t);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        this.beforeAbortBizBill(ctx, billId);
        super._abortBizBill(ctx, billId);
        this.afterAbortBizBill(ctx, billId);
    }

    private void beforeAbortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
    }

    private void afterAbortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IObjectPK[] iObjectPKArray = ElectronicContractRelationFactory.getLocalInstance(ctx).delete("where billID = '" + billId + "'");
        }
    }

    private void updateContractRenewBizBillEntryContractNo(Context ctx, ContractRenewBizBillInfo billInfo) throws EASBizException, BOSException {
        if (!billInfo.isIsSSCShare()) {
            return;
        }
        ContractRenewBizBillEntryCollection entryColl = billInfo.getEntrys();
        if (entryColl != null && entryColl.size() > 0) {
            for (int index = 0; index < entryColl.size(); ++index) {
                ContractRenewBizBillEntryInfo entryInfo = entryColl.get(index);
                ContractTempletInfo templetInfo = entryInfo.getContractTemplet();
                templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
                if (!templetInfo.isIsElectronicSign()) continue;
                String oldNumber = entryInfo.getContractNo();
                String newNumber = ElectronicContractUtils.generateContractNumber((Context)ctx, (String)entryInfo.getContractNo());
                if (newNumber.equals(oldNumber)) continue;
                entryInfo.setContractNo(newNumber);
            }
        }
    }

    protected void setLabContractFirstPartyName(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractRenewBizBillInfo csbbInfo = (ContractRenewBizBillInfo)model;
        ContractRenewBizBillEntryCollection entryColl = csbbInfo.getEntrys();
        if (entryColl != null && entryColl.size() > 0) {
            for (int index = 0; index < entryColl.size(); ++index) {
                ContractRenewBizBillEntryInfo entryInfo = entryColl.get(index);
                LabContractFirstPartyInfo labContractFirstParty = entryInfo.getLabContractFirstParty();
                if (labContractFirstParty == null || labContractFirstParty.getId() == null) continue;
                String labContractFirstPartyName = labContractFirstParty.getName();
                if (StringUtils.isEmpty((String)labContractFirstPartyName)) {
                    labContractFirstPartyName = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(labContractFirstParty.getId())).getName();
                }
                entryInfo.setLCFPName(labContractFirstPartyName);
            }
        }
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        String oql = "where billID = '" + billId + "'";
        HRContractInfoCollection hrContractInfoCollection = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection(oql);
        for (int i = 0; i < hrContractInfoCollection.size(); ++i) {
            HRContractInfoInfo hrContractInfo = hrContractInfoCollection.get(i);
            String empContractId = hrContractInfo.getEmployeeContract().getId().toString();
            EmployeeContractInfo employeeContractInfo = ContractUtils.getEmployeeContractInfo(ctx, empContractId);
            ContractUtils.checkContractIsInOtherBill(ctx, employeeContractInfo, ContractRenewBizBill.class.getName(), 1);
            ContractUtils.checkContractIsInOther(ctx, employeeContractInfo);
            ContractUtils.deleteEmpEleContractSignRecordInfo(ctx, employeeContractInfo);
            EmpElectronicContractUtilsEx.deleteContractBillMiddleInfo(ctx, employeeContractInfo.getId().toString());
            this.recoverySourceContract(ctx, hrContractInfo);
            this.recoveryHRContract(ctx, hrContractInfo);
            ContractUtils.deleteEmployeeContractInfo(ctx, empContractId);
            this.recoveryContractPage(ctx, hrContractInfo);
        }
    }

    private void recoverySourceContract(Context ctx, HRContractInfoInfo hrContract) throws BOSException, EASBizException {
        if (null != hrContract.getEmployeeContract().getId()) {
            EmployeeContractInfo contractInfo = ContractUtils.getEmployeeContractInfo(ctx, hrContract.getEmployeeContract().getId().toString());
            StringBuffer sql = null;
            sql = new StringBuffer().append("update t_hr_employeeContract set FIsChanged = 0");
            sql.append(", FIsNewestContract = 1");
            sql.append(", FVIP = 1");
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (contractInfo.getSourceContract().getEndDate() != null && !DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)contractInfo.getEffectDate()) && !DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)curDate)) {
                if (DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)curDate)) {
                    sql.append(", FEndDateReal = FEndDate, FContractLimitAutoReal = FContractLimitAuto, FState = 4, FNewState = 4");
                } else {
                    sql.append(", FEndDateReal = null, FContractLimitAutoReal = null, FState = 1, FNewState = 1");
                }
            } else {
                sql.append(", FNewState = FState");
            }
            sql.append(" where  FID ='").append(hrContract.getSourceContract().getId().toString()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void recoveryHRContract(Context ctx, HRContractInfoInfo hrContract) throws BOSException, EASBizException {
        ContractRenewBizBillInfo csbbInfo = ContractRenewBizBillFactory.getLocalInstance(ctx).getContractRenewBizBillInfo((IObjectPK)new ObjectUuidPK(hrContract.getBillID()));
        this.recoveryHrContractInfo(ctx, csbbInfo, (IObjectPK)new ObjectUuidPK(hrContract.getBillID()));
        EmployeeContractInfo contractInfo = ContractUtils.getEmployeeContractInfo(ctx, hrContract.getEmployeeContract().getId().toString());
        StringBuffer hrSql = null;
        hrSql = new StringBuffer().append("update t_hr_hrcontractinfo set ");
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        if (contractInfo.getSourceContract().getEndDate() != null && !DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)contractInfo.getEffectDate()) && !DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)curDate)) {
            if (DateTimeUtils.dayBefore((Date)contractInfo.getSourceContract().getEndDate(), (Date)curDate)) {
                hrSql.append(" FEndDateReal = FEndDate, FContractLimitAutoReal = FContractLimitAuto, FState = 4, FNewState = 4");
            } else {
                hrSql.append(" FEndDateReal = null, FContractLimitAutoReal = null, FState = 1, FNewState = 1");
            }
        } else {
            hrSql.append("FNewState = FState");
        }
        hrSql.append(" where  FEmployeeContractID = '").append(hrContract.getSourceContract().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)hrSql.toString());
    }

    private void recoveryContractPage(Context ctx, HRContractInfoInfo hrContract) throws BOSException, EASBizException {
        if (null != hrContract.getEmployeeContract().getId() && null != hrContract.getSourceContract().getId()) {
            String sql = "update T_HR_ContractPageInfo set FEMPLOYEECONTRACTID= '" + hrContract.getSourceContract().getId().toString() + "' where FEMPLOYEECONTRACTID= '" + hrContract.getEmployeeContract().getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }
}

