/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.contract.ContractBillMiddleInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.EmpEleContractCompanyTaskFactory;
import com.kingdee.eas.hr.contract.EmpEleContractCompanyTaskInfo;
import com.kingdee.eas.hr.contract.EmpEleContractException;
import com.kingdee.eas.hr.contract.EmpEleContractSendMessageFacadeFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignCallBackRecordFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.IEmpEleContractCompanyTask;
import com.kingdee.eas.hr.contract.IEmpEleContractSignRecord;
import com.kingdee.eas.hr.contract.ISHRElectronicTemplate;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateCollection;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateFactory;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.hr.contract.app.AbstractEmpEleContractTaskFacadeControllerBean;
import com.kingdee.eas.hr.contract.util.ElectronicContractUtils;
import com.kingdee.eas.hr.elecontract.util.EmpEleContractFollowUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthRecordFactory;
import com.kingdee.shr.elecontract.util.CheckHRCloudLicenseUtils;
import com.kingdee.shr.elecontract.util.TSPServerInstance;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpEleContractTaskFacadeControllerBean
extends AbstractEmpEleContractTaskFacadeControllerBean {
    private static final long serialVersionUID = 4223169309821693715L;
    private static final Logger logger = LoggerFactory.getLogger(EmpEleContractTaskFacadeControllerBean.class);

    @Override
    protected Object _processSignCallBack(Context ctx, Map param, IObjectValue contractBillMiddleInfo) throws BOSException, EASBizException {
        try {
            String contractId;
            String contractNO = (String)param.get("contractNO");
            int resultCode = Integer.parseInt(String.valueOf(param.get("resultCode")));
            Timestamp curTimestamp = EmpElectronicContractUtilsEx.getCurTimestamp();
            boolean isPersonSignCallBack = this.isPersonSignCallBack(ctx, param);
            ContractBillMiddleInfo contractBillMiddle = (ContractBillMiddleInfo)contractBillMiddleInfo;
            String string = contractId = contractBillMiddle.getContractId() != null ? contractBillMiddle.getContractId().toString() : "";
            if (StringUtils.isEmpty((String)contractId)) {
                logger.error("EmpEleContractTaskFacadeControllerBean contractBillMiddle : " + contractBillMiddle.getId());
                return null;
            }
            IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
            EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
            if (empEleContractSignRecordInfo == null) {
                return null;
            }
            HRBillBaseInfo billBaseInfo = null;
            BOSUuid billBosId = empEleContractSignRecordInfo.getBillId();
            if (billBosId != null) {
                IHRBillBase billBase = (IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billBosId.getType());
                billBaseInfo = billBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billBosId));
            }
            logger.error("EmpEleContractTaskFacadeControllerBean isPersonSignCallBack : " + isPersonSignCallBack);
            logger.error("EmpEleContractTaskFacadeControllerBean isIsCompanySign() : " + empEleContractSignRecordInfo.isIsCompanySign());
            EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
            int signStatusValue = signStatus != null ? signStatus.getValue() : -999;
            logger.error("EmpEleContractTaskFacadeControllerBean signStatusValue : " + signStatusValue);
            if (isPersonSignCallBack) {
                if (0 != signStatusValue) {
                    return null;
                }
                logger.error("EmpEleContractTaskFacadeControllerBean person sign call back start");
                if (!this.hasPersonSignCallBackSuccessRecord(ctx, param)) {
                    logger.error("EmpEleContractTaskFacadeControllerBean person sign call back");
                    if (1 == resultCode) {
                        empEleContractSignRecordInfo.setIsPersonSign(true);
                        empEleContractSignRecordInfo.setPersonSignTime(EmpElectronicContractUtilsEx.getCurTimestamp());
                        empEleContractSignRecordInfo.setSignStatus(EContractSignState.signing);
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("isPersonSign"));
                        selector.add(new SelectorItemInfo("personSignTime"));
                        selector.add(new SelectorItemInfo("signStatus"));
                        empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                        EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.signing);
                        EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.signing);
                        EmpEleContractFollowUtils.doUpdateStateInBill(ctx, billBaseInfo);
                        this.afterPersonSignCallBackSuccess(ctx, contractBillMiddle, param, contractNO);
                    } else if (0 == resultCode) {
                        logger.error("EmpEleContractTaskFacadeControllerBean person sign call back fail" + resultCode);
                        this.afterPersonSignCallBackFail(ctx, contractBillMiddle, param, contractNO);
                    }
                }
            } else if (this.isCompanySignCallBack(ctx, param) && 1 == signStatusValue && !empEleContractSignRecordInfo.isIsCompanySign()) {
                logger.error("EmpEleContractTaskFacadeControllerBean company sign call back start");
                if (!this.hasCompanySignCallBackSuccessRecord(ctx, param)) {
                    logger.error("EmpEleContractTaskFacadeControllerBean company sign call back");
                    EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = EmpElectronicContractUtilsEx.getEmpEleContractCompanyTaskInfo(ctx, contractNO);
                    if (1 == resultCode) {
                        SelectorItemCollection selector;
                        if (empEleContractCompanyTaskInfo != null) {
                            selector = new SelectorItemCollection();
                            empEleContractCompanyTaskInfo.setIsCallBack(true);
                            empEleContractCompanyTaskInfo.setCallBackTime(curTimestamp);
                            empEleContractCompanyTaskInfo.setResultCode(String.valueOf(param.get("resultCode")));
                            empEleContractCompanyTaskInfo.setResultDesc(String.valueOf(param.get("resultDesc")));
                            empEleContractCompanyTaskInfo.setUserId(String.valueOf(param.get("userId")));
                            empEleContractCompanyTaskInfo.setIsFinish(true);
                            selector.add(new SelectorItemInfo("isCallBack"));
                            selector.add(new SelectorItemInfo("callBackTime"));
                            selector.add(new SelectorItemInfo("resultCode"));
                            selector.add(new SelectorItemInfo("resultDesc"));
                            selector.add(new SelectorItemInfo("userId"));
                            selector.add(new SelectorItemInfo("isFinish"));
                            EmpEleContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(empEleContractCompanyTaskInfo, selector);
                        }
                        empEleContractSignRecordInfo.setIsCompanySign(true);
                        empEleContractSignRecordInfo.setCompanySignTime(curTimestamp);
                        empEleContractSignRecordInfo.setSignStatus(EContractSignState.complete);
                        empEleContractSignRecordInfo.setIsSigned(true);
                        empEleContractSignRecordInfo.setSignedTime(curTimestamp);
                        selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("isCompanySign"));
                        selector.add(new SelectorItemInfo("companySignTime"));
                        selector.add(new SelectorItemInfo("signStatus"));
                        selector.add(new SelectorItemInfo("isSigned"));
                        selector.add(new SelectorItemInfo("signedTime"));
                        if (!empEleContractSignRecordInfo.isIsPersonSign()) {
                            empEleContractSignRecordInfo.setIsPersonSign(true);
                            empEleContractSignRecordInfo.setPersonSignTime(curTimestamp);
                            selector.add(new SelectorItemInfo("isPersonSign"));
                            selector.add(new SelectorItemInfo("personSignTime"));
                        }
                        empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                        EmpElectronicContractUtilsEx.updateKDContractConfigRecordState(ctx, contractNO);
                        EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.complete);
                        EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.complete);
                        EmpEleContractFollowUtils.doUpdateStateInBill(ctx, billBaseInfo);
                        IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
                        EmployeeContractInfo employeeContractInfo = EmpElectronicContractUtilsEx.getEmployeeContractInfo(employeeContractLocalInstance, contractId);
                        boolean isSigned = true;
                        if (empEleContractSignRecordInfo.getBillId() != null) {
                            isSigned = EmpEleContractFollowUtils.isSignComplete(ctx, empEleContractSignRecordInfo.getBillId().toString());
                        }
                        if (isSigned) {
                            logger.error("EmpEleContractTaskFacadeControllerBean_processSignCallBack sendSignCompleteMessage ");
                            EmpEleContractSendMessageFacadeFactory.getLocalInstance(ctx).sendSignCompleteMessage(empEleContractSignRecordInfo, employeeContractInfo);
                        }
                    } else if (0 == resultCode) {
                        if (!empEleContractSignRecordInfo.isIsCompanySign() || empEleContractSignRecordInfo.getCompanySignTime() != null) {
                            // empty if block
                        }
                        empEleContractCompanyTaskInfo.setIsCallBack(true);
                        empEleContractCompanyTaskInfo.setCallBackTime(curTimestamp);
                        empEleContractCompanyTaskInfo.setResultCode(String.valueOf(param.get("resultCode")));
                        empEleContractCompanyTaskInfo.setResultDesc(String.valueOf(param.get("resultDesc")));
                        empEleContractCompanyTaskInfo.setUserId(String.valueOf(param.get("userId")));
                        empEleContractCompanyTaskInfo.setIsFinish(false);
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("isCallBack"));
                        selector.add(new SelectorItemInfo("callBackTime"));
                        selector.add(new SelectorItemInfo("resultCode"));
                        selector.add(new SelectorItemInfo("resultDesc"));
                        selector.add(new SelectorItemInfo("isFinish"));
                        EmpEleContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(empEleContractCompanyTaskInfo, selector);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected boolean isPersonSignCallBack(Context ctx, Map param) throws BOSException, EASBizException {
        String kdAppId = (String)param.get("kdAppId");
        String resultDesc = (String)param.get("resultDesc");
        String userId = (String)param.get("userId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("kdContractConfig.clientKDAppId", (Object)kdAppId));
        filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        return SSCPersonAuthRecordFactory.getLocalInstance((Context)ctx).exists(filterInfo) || resultDesc.contains("\u624b\u7b7e");
    }

    protected boolean isCompanySignCallBack(Context ctx, Map param) throws BOSException, EASBizException {
        String kdAppId = (String)param.get("kdAppId");
        String resultDesc = (String)param.get("resultDesc");
        String userId = (String)param.get("userId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("clientKDAppId", (Object)kdAppId));
        filterInfo.getFilterItems().add(new FilterItemInfo("clientEnterpriseId", (Object)userId));
        return KDContractConfigFactory.getLocalInstance((Context)ctx).exists(filterInfo) || resultDesc.contains("\u81ea\u52a8\u7b7e");
    }

    protected boolean hasPersonSignCallBackSuccessRecord(Context ctx, Map param) throws BOSException, EASBizException {
        String contractNO = (String)param.get("contractNO");
        String userId = (String)param.get("userId");
        String signBackId = (String)param.get("signBackId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("resultCode", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        filterInfo.getFilterItems().add(new FilterItemInfo("resultDesc", (Object)"%\u624b\u7b7e%", CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)signBackId, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 AND #1 AND (#2 OR #3) AND #4");
        logger.error("EmpEleContractTaskFacadeControllerBean hasPersonSignCallBackSuccessRecord filterInfo : " + filterInfo);
        boolean exists = EmpEleContractSignCallBackRecordFactory.getLocalInstance(ctx).exists(filterInfo);
        logger.error("EmpEleContractTaskFacadeControllerBean hasPersonSignCallBackSuccessRecord exists : " + exists);
        return exists;
    }

    protected boolean hasCompanySignCallBackSuccessRecord(Context ctx, Map param) throws BOSException, EASBizException {
        String contractNO = (String)param.get("contractNO");
        String userId = (String)param.get("userId");
        String signBackId = (String)param.get("signBackId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("resultCode", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        filterInfo.getFilterItems().add(new FilterItemInfo("resultDesc", (Object)"%\u81ea\u52a8\u7b7e%", CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)signBackId, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 AND #1 AND (#2 OR #3) AND #4");
        logger.error("EmpEleContractTaskFacadeControllerBean hasCompanySignCallBackSuccessRecord filterInfo : " + filterInfo);
        boolean exists = EmpEleContractSignCallBackRecordFactory.getLocalInstance(ctx).exists(filterInfo);
        logger.error("EmpEleContractTaskFacadeControllerBean hasCompanySignCallBackSuccessRecord exists : " + exists);
        return exists;
    }

    protected void reduceLicenseIfSingleSign(Context ctx, ContractBillMiddleInfo contractBillMiddleInfo, String contractNO) {
        ContractTempletInfo contractTempletInfo = contractBillMiddleInfo.getContractTemplet();
        if (contractTempletInfo != null) {
            int signTypeValue = contractTempletInfo.getSignType() != null ? contractTempletInfo.getSignType().getValue() : -999;
            logger.error("EmpEleContractTaskFacadeControllerBean reduceLicenseIfSingleSign signTypeValue : " + signTypeValue);
            if (0 == signTypeValue) {
                logger.error("EmpEleContractTaskFacadeControllerBean reduceLicenseIfSingleSign contractNo" + contractNO);
                try {
                    Map serverMap = null;
                    serverMap = TSPServerInstance.getServerInfo((Context)ctx);
                    String serviceId = (String)serverMap.get("service_id");
                    CheckHRCloudLicenseUtils.reduceLicenseCount((Context)ctx, (String)serviceId, (String)"8", (String)"1", (String)contractNO);
                }
                catch (EASBizException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void afterPersonSignCallBackSuccess(Context ctx, ContractBillMiddleInfo contractBillMiddleInfo, Map param, String contractNO) throws BOSException, EASBizException {
    }

    protected void afterPersonSignCallBackFail(Context ctx, ContractBillMiddleInfo contractBillMiddleInfo, Map param, String contractNO) throws BOSException, EASBizException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object _sendCompanySign(Context ctx, IObjectValue empEleContractSignRecord, String contractId) throws BOSException, EASBizException {
        String contractTempletId;
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = (EmpEleContractSignRecordInfo)empEleContractSignRecord;
        IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo employeeContractInfo = EmpElectronicContractUtilsEx.getEmployeeContractInfo(employeeContractLocalInstance, contractId);
        String contractNo = employeeContractInfo.getContractNo();
        ContractTempletInfo contractTemplet = employeeContractInfo.getContractTemplet();
        String string = contractTemplet != null ? (contractTemplet.getId() != null ? contractTemplet.getId().toString() : "") : (contractTempletId = "");
        if (StringUtils.isEmpty((String)contractId) || StringUtils.isEmpty((String)contractNo) || StringUtils.isEmpty((String)contractTempletId)) throw new EmpEleContractException(EmpEleContractException.PARAM_ERROR, new Object[]{"contractId :" + contractId + " contractNo :" + contractNo + " contractTempletId :" + contractTempletId});
        ISHRElectronicTemplate electronicTemplate = SHRElectronicTemplateFactory.getLocalInstance(ctx);
        SHRElectronicTemplateCollection shrElectronicTemplateCollection = electronicTemplate.getSHRElectronicTemplateCollection("where contractTemplet.id = '" + contractTempletId + "'");
        if (shrElectronicTemplateCollection == null || shrElectronicTemplateCollection.size() <= 0) throw new EmpEleContractException(EmpEleContractException.E_TEMPLATE_NOT_FOUND);
        SHRElectronicTemplateInfo shrElectronicTemplateInfo = shrElectronicTemplateCollection.get(0);
        if (!shrElectronicTemplateInfo.isIsRegister()) {
            throw new EmpEleContractException(EmpEleContractException.E_TEMPLATE_NOT_REGISTER);
        }
        LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
        KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
        if (!kdContractConfigInfo.getEnterpriseName().equals(labContractFirstParty.getName())) {
            throw new EmpEleContractException(EmpEleContractException.LABCONTRACTFIRSTPARTY_NAME_NOT_SAME_KDCONTRACTCONFIG);
        }
        String eContractNO = empEleContractSignRecordInfo.getEContractNO();
        String eContractSealTypeId = shrElectronicTemplateInfo.getEContractSealType().getId().toString();
        String signatureId = ElectronicContractUtils.getSignatureId(ctx, eContractSealTypeId, kdContractConfigInfo);
        HashMap<String, String> osfDataMap = new HashMap<String, String>();
        osfDataMap.put("contractNo", eContractNO);
        osfDataMap.put("signatureId", signatureId);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject osfResult = (JSONObject)osfServiceFacade.processService("electronicLaborCompanySignService", osfDataMap);
        logger.error("EmpEleContractTaskFacadeControllerBean.sendCompanySign OSFresult : " + osfResult.toJSONString());
        int resStatus = osfResult.getIntValue("code");
        if (resStatus != 0) throw new EmpEleContractException(EmpEleContractException.COMPANY_SIGN_ERROR, new Object[]{resStatus + " : " + osfResult.getString("msg")});
        EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = EmpElectronicContractUtilsEx.getEmpEleContractCompanyTaskInfo(ctx, eContractNO);
        boolean isAddNew = false;
        if (empEleContractCompanyTaskInfo == null) {
            empEleContractCompanyTaskInfo = new EmpEleContractCompanyTaskInfo();
            empEleContractCompanyTaskInfo.setContractId(employeeContractInfo.getId());
            empEleContractCompanyTaskInfo.setContractNo(eContractNO);
            isAddNew = true;
        }
        empEleContractCompanyTaskInfo.setIsRequest(true);
        empEleContractCompanyTaskInfo.setRequestTime(EmpElectronicContractUtilsEx.getCurTimestamp());
        IEmpEleContractCompanyTask empEleContractCompanyTaskLocalInstance = EmpEleContractCompanyTaskFactory.getLocalInstance(ctx);
        if (isAddNew) {
            empEleContractCompanyTaskLocalInstance.save((CoreBaseInfo)empEleContractCompanyTaskInfo);
            return null;
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isRequest"));
            selector.add(new SelectorItemInfo("requestTime"));
            empEleContractCompanyTaskLocalInstance.updatePartial(empEleContractCompanyTaskInfo, selector);
        }
        return null;
    }
}

