/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.IOtherContractSignBizBillEntry;
import com.kingdee.eas.hr.contract.OtherContractException;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.app.AbstractOtherContractSignBizBillControllerBean;
import com.kingdee.eas.hr.contract.app.OtherContractSignBillBizBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.ContractUtilsEx;
import com.kingdee.eas.hr.contract.util.OtherContractUtils;
import com.kingdee.eas.hr.contract.util.SHRContractUploadAttachmentUtils;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeeOtherContractCollection;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.hr.emp.IEmployeeOtherContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class OtherContractSignBizBillControllerBean
extends AbstractOtherContractSignBizBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(OtherContractSignBizBillControllerBean.class);
    protected static final String CONTRACT_ENTITYNAME = "com.kingdee.eas.hr.emp.app.EmployeeOtherContract";

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.contract.app.OtherContractSignBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return OtherContractSignBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new OtherContractSignBillBizBean();
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        OtherContractSignBizBillEntryInfo csbbeInfo = (OtherContractSignBizBillEntryInfo)entry;
        OtherContractSignBizBillInfo billInfo = csbbeInfo.getBill();
        billInfo = (OtherContractSignBizBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)csbbeInfo.getContractNo()));
        if (billInfo.isIsPreEntry() && csbbeInfo.getPreEntryPerson() != null) {
            filter.getFilterItems().add(new FilterItemInfo("preEntryPerson", (Object)csbbeInfo.getPreEntryPerson().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("employee", (Object)csbbeInfo.getPerson().getId().toString()));
        }
        IEmployeeOtherContract iEmployeeOtherContract = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        if (!iEmployeeOtherContract.exists(filter)) {
            EmployeeOtherContractInfo oContractInfo = new EmployeeOtherContractInfo();
            this.copyValueToEmployeeOtherContractInfo(ctx, entry, oContractInfo);
            IObjectPK contractId = iEmployeeOtherContract.addnew((CoreBaseInfo)oContractInfo);
            oContractInfo.setId(BOSUuid.read((String)contractId.toString()));
            this.addAttachmentForContract(ctx, oContractInfo, csbbeInfo);
            super._entryEffect(ctx, entry);
        }
    }

    protected void copyValueToEmployeeOtherContractInfo(Context ctx, HRBillBaseEntryInfo entry, EmployeeOtherContractInfo oContractInfo) throws EASBizException, BOSException {
        OtherContractSignBizBillEntryInfo csbbeInfo = (OtherContractSignBizBillEntryInfo)entry;
        OtherContractSignBizBillInfo billInfo = csbbeInfo.getBill();
        billInfo = (OtherContractSignBizBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        String entityName = CONTRACT_ENTITYNAME;
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        int size = propColl.size();
        for (int i = 0; i < size; ++i) {
            String propName;
            PropertyInfo propertyInfo = propColl.get(i);
            boolean isMul = false;
            if (propertyInfo instanceof OwnPropertyInfo) {
                isMul = ((OwnPropertyInfo)propertyInfo).isMultilingual();
            }
            if (oContractInfo.get(propName = propColl.get(i).getName()) == null && csbbeInfo.get(propName) != null && !this.isDonotNeedCopyField(propName)) {
                if (isMul) {
                    oContractInfo.put(propName, csbbeInfo.get(propName, LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                    oContractInfo.put(propName, csbbeInfo.get(propName, LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                    oContractInfo.put(propName, csbbeInfo.get(propName, LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                } else {
                    oContractInfo.put(propName, csbbeInfo.get(propName));
                }
            }
            if (oContractInfo.get(propName) != null || billInfo.get(propName) == null || this.isDonotNeedCopyField(propName)) continue;
            if (isMul) {
                oContractInfo.put(propName, billInfo.get(propName, LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                oContractInfo.put(propName, billInfo.get(propName, LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                oContractInfo.put(propName, billInfo.get(propName, LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                continue;
            }
            oContractInfo.put(propName, billInfo.get(propName));
        }
        oContractInfo.setReason(csbbeInfo.getSignReason(), LocaleUtils.locale_l1);
        oContractInfo.setReason(csbbeInfo.getSignReason(), LocaleUtils.locale_l2);
        oContractInfo.setReason(csbbeInfo.getSignReason(), LocaleUtils.locale_l3);
        oContractInfo.setDescription(csbbeInfo.getDescription(), LocaleUtils.locale_l1);
        oContractInfo.setDescription(csbbeInfo.getDescription(), LocaleUtils.locale_l2);
        oContractInfo.setDescription(csbbeInfo.getDescription(), LocaleUtils.locale_l3);
        oContractInfo.setEmployee(csbbeInfo.getPerson());
        oContractInfo.setPreEntryPerson(csbbeInfo.getPreEntryPerson());
        oContractInfo.setDelegatePerson(billInfo.getDelegatePersonText());
        oContractInfo.setEmpIdentityNum(csbbeInfo.getIdCardNo());
        oContractInfo.setEmpPassPortNum(csbbeInfo.getPassportNo());
        oContractInfo.setEmpAddress(csbbeInfo.getAdrress());
        oContractInfo.setEntryID(csbbeInfo.getId().toString());
        if (billInfo.isIsSSCShare()) {
            oContractInfo.setSignStatus(EContractSignState.complete);
            oContractInfo.setContractClassify(ContractClassifyEnum.ElectronicSsc);
        } else {
            oContractInfo.setContractClassify(ContractClassifyEnum.ElectronicEmp);
        }
        oContractInfo.setContractLimit(null);
    }

    protected void _check(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo billInfo = (HRBillBaseInfo)model;
        if (billInfo == null) {
            return;
        }
        IObjectCollection entrys = (IObjectCollection)billInfo.get(this.getEntryField());
        IContractTemplet iContractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx);
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(i);
            ContractTypeInfo typeInfo = (ContractTypeInfo)entryInfo.get("contractType");
            ContractTempletInfo templateInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
            StringBuffer oql = new StringBuffer();
            oql.append("select id where contractType.id='");
            oql.append(typeInfo.getId()).append("' and id='").append(templateInfo.getId()).append("'");
            if (iContractTemplet.exists(oql.toString())) continue;
            throw new EmployeeException(EmployeeException.CONTRACTTYPENOTMATCHWITHTEMPLATE);
        }
        super._check(ctx, pk, model);
    }

    public void setBillRelateInfo(Context ctx, BOSUuid entryID) throws EASBizException, BOSException {
        if (entryID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, (Object)bill);
        }
        this._entryEffect(ctx, entry);
        if (bill != null) {
            this._mappingSubmit(ctx, bill);
        }
    }

    protected boolean isNeedMappingReWrite(Context ctx, HRBillBaseInfo bill) {
        return false;
    }

    protected SelectorItemCollection getBillSelector() throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        return selector;
    }

    protected boolean isDonotNeedCopyField(String key) {
        return key.equalsIgnoreCase("id") || key.equalsIgnoreCase("creator") || key.equalsIgnoreCase("createTime") || key.equalsIgnoreCase("lastUpdateTime") || key.equalsIgnoreCase("lastUpdateUser");
    }

    @Override
    protected HashMap _getParmaValue(Context ctx, String hrId) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        boolean isZTCustomer = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).isZhongTianCustomer();
        String contractOrgRange = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(hrId), (String)"IS_CONTRACT_002");
        boolean isShowLongName = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_CONTRACT_003", null);
        boolean isStrideHRO = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_CONTRACT_ALLHR", null);
        String allHRChoose = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"IS_CONTRACT_ALLHR_NEW", null, (boolean)true);
        paramMap.put("isZTCustomer", isZTCustomer);
        paramMap.put("contractOrgRange", contractOrgRange);
        paramMap.put("isShowLongName", isShowLongName);
        paramMap.put("isStrideHRO", isStrideHRO);
        paramMap.put("allHRChoose", allHRChoose);
        return paramMap;
    }

    protected void setBillData(Context ctx, OtherContractSignBizBillInfo billInfo) throws BOSException, EASBizException {
        CtrlUnitInfo cu = null;
        if (billInfo.getHrOrgUnit() == null) {
            billInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (billInfo.getLabContractFirstParty() != null && !StringUtils.isEmpty((String)billInfo.getLabContractFirstParty().getName())) {
            billInfo.setToUnit(billInfo.getLabContractFirstParty().getName());
        }
        if (billInfo.getCU() == null) {
            billInfo.setCU(cu);
        }
        this.setLabContractFirstPartyField(ctx, billInfo);
    }

    protected void setBillEntryData(Context ctx, OtherContractSignBizBillInfo billInfo, OtherContractSignBizBillEntryInfo entry) throws BOSException, EASBizException {
        this.caculateLimitAuto(entry);
        if (billInfo.isIsPreEntry()) {
            String personID = entry.getPreEntryPerson().getId().toString();
            if (entry.getAdminOrg() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("adminOrg.id"));
                sic.add(new SelectorItemInfo("adminOrg.name"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("talent.id", (Object)personID));
                EntityViewInfo view = new EntityViewInfo();
                view.setSelector(sic);
                view.setFilter(filter);
                PreEntryCollection preEntryColls = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(view);
                entry.setAdminOrg(preEntryColls.get(0).getAdminOrg());
            }
        } else {
            String personID = entry.getPerson().getId().toString();
            if (entry.getAdminOrg() == null) {
                AdminOrgUnitInfo admin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personID));
                entry.setAdminOrg(admin);
            }
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OtherContractSignBizBillInfo csbbInfo = (OtherContractSignBizBillInfo)model;
        this.updateContractSignBillEntryContractNo(ctx, csbbInfo);
        this.checkPersonHasFutureContract(ctx, csbbInfo);
        this.checkBeforeAddnewOrUpdate(ctx, csbbInfo);
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        for (int i = 0; i < entries.size(); ++i) {
            this.setBillUseDefault(ctx, model, entries.getObject(i));
        }
        IObjectPK objectPk = super._addnew(ctx, model);
        return objectPk;
    }

    protected void checkLabPartyIsTheSame(Context ctx, OtherContractSignBizBillInfo csbbInfo) throws BOSException, EASBizException {
        if (!csbbInfo.isIsSSCShare()) {
            return;
        }
        OtherContractSignBizBillEntryCollection entrys = csbbInfo.getEntrys();
        if (entrys != null && entrys.size() > 0) {
            boolean isElec = false;
            for (int dex = 0; dex < entrys.size(); ++dex) {
                OtherContractSignBizBillEntryInfo entryInfo = entrys.get(dex);
                ContractTempletInfo contractTemplet = entryInfo.getContractTemplet();
                if (contractTemplet.get("isElectronicSign") == null) {
                    contractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTemplet.getId()));
                }
                if (!contractTemplet.isIsElectronicSign()) continue;
                isElec = true;
                break;
            }
            if (isElec) {
                LabContractFirstPartyInfo labContractFirstParty = csbbInfo.getLabContractFirstParty();
                LabContractFirstPartyInfo labContractCParty = csbbInfo.getLabContractCParty();
                if (labContractFirstParty != null && labContractFirstParty.getId() != null && labContractCParty != null && labContractCParty.getId() != null && labContractFirstParty.getId().toString().equals(labContractCParty.getId().toString())) {
                    throw new ContractException(ContractException.LABFIRST_PARTY_ISTHE_SAME);
                }
            }
        }
    }

    protected void checkLabPartyIsOpenElec(Context ctx, OtherContractSignBizBillInfo csbbInfo) throws BOSException, EASBizException {
        if (!csbbInfo.isIsSSCShare()) {
            return;
        }
        OtherContractSignBizBillEntryCollection entrys = csbbInfo.getEntrys();
        if (entrys != null && entrys.size() > 0) {
            boolean isElec = false;
            for (int dex = 0; dex < entrys.size(); ++dex) {
                OtherContractSignBizBillEntryInfo entryInfo = entrys.get(dex);
                ContractTempletInfo contractTemplet = entryInfo.getContractTemplet();
                if (contractTemplet.get("isElectronicSign") == null) {
                    contractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTemplet.getId()));
                }
                if (!contractTemplet.isIsElectronicSign()) continue;
                isElec = true;
                break;
            }
            if (isElec) {
                LabContractFirstPartyInfo labContractFirstParty = csbbInfo.getLabContractFirstParty();
                ElectronicContractUtils.checkLabContractFirstPartyIsOpenElec((Context)ctx, (LabContractFirstPartyInfo)labContractFirstParty);
                ElectronicContractUtils.checkKDContractConfigIsAuth((Context)ctx, (LabContractFirstPartyInfo)labContractFirstParty);
                LabContractFirstPartyInfo labContractCParty = csbbInfo.getLabContractCParty();
                ElectronicContractUtils.checkLabContractFirstPartyIsOpenElec((Context)ctx, (LabContractFirstPartyInfo)labContractCParty);
                ElectronicContractUtils.checkKDContractConfigIsAuth((Context)ctx, (LabContractFirstPartyInfo)labContractCParty);
            }
        }
    }

    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        OtherContractSignBizBillEntryCollection entries;
        super.setNumberFromCodingRule(ctx, model);
        if (model instanceof OtherContractSignBizBillInfo && (entries = ((OtherContractSignBizBillInfo)model).getEntrys()) != null) {
            OtherContractSignBizBillEntryInfo entry = null;
            EmployeeOtherContractInfo contractInfo = new EmployeeOtherContractInfo();
            String number = null;
            CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String orgID = curCuInfo.getId().toString();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                this.assembleContractInfoForCoding(ctx, contractInfo, entry);
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (StringUtils.isEmpty((String)orgID) || !iCodingRuleManager.isExist((IObjectValue)contractInfo, orgID)) continue;
                number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)contractInfo, orgID);
                while (OtherContractSignBizBillControllerBean.isEmpContractNumberExist(ctx, number)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)contractInfo, orgID);
                }
                if (number == null) continue;
                entry.setContractNo(number);
            }
        }
        this.updateContractSignBillEntryContractNo(ctx, (OtherContractSignBizBillInfo)model);
    }

    protected void assembleContractInfoForCoding(Context ctx, EmployeeOtherContractInfo contractInfo, OtherContractSignBizBillEntryInfo entry) {
        String entityName = CONTRACT_ENTITYNAME;
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        Enumeration e = entry.keys();
        block0: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.isContractExcludeField(key)) continue;
            int size = propColl.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo propInfo = propColl.get(i);
                String propName = propInfo.getName();
                if (!propName.equalsIgnoreCase(key)) continue;
                Object value = entry.get(propName);
                Object retValue = ContractUtilsEx.getEnumValue(value);
                contractInfo.put(propName, retValue);
                continue block0;
            }
        }
        contractInfo.setEmployee(entry.getPerson());
        contractInfo.setEffectDate(entry.getBizDate());
        contractInfo.setRecordDate(entry.getSignDate());
        contractInfo.setPreEntryPerson(entry.getPreEntryPerson());
    }

    protected boolean isContractExcludeField(String key) {
        return key.equals("id") || key.equals("person") || key.equals("contractNo");
    }

    protected void setBillUseDefault(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        OtherContractSignBizBillInfo billInfo = (OtherContractSignBizBillInfo)model;
        boolean useDefault = true;
        PersonInfo personInfo = (PersonInfo)entry.get("person");
        if (personInfo != null && personInfo.getId() != null) {
            String pId = personInfo.getId().toString();
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("select FUseDefault from T_HR_PersonBURelation where FState = 1");
                sql.append(" and FBizManageTypeID in ('").append("SGuJm3nXW0GshQfKRXenomWJ1dE=").append("')");
                sql.append(" and FPersonID in ('").append(pId).append("')");
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (executeQuery.next()) {
                    if (executeQuery.getInt("FUseDefault") != 0) continue;
                    useDefault = false;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        billInfo.setUseDefault(useDefault);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        OtherContractSignBizBillInfo csbbInfo = (OtherContractSignBizBillInfo)model;
        this.checkBeforeAddnewOrUpdate(ctx, csbbInfo);
        this.preProcess(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void checkBeforeAddnewOrUpdate(Context ctx, OtherContractSignBizBillInfo csbbInfo) throws ContractException, BOSException, EASBizException {
        this.checkBlank(ctx, csbbInfo);
        this.checkToUnit(csbbInfo);
        this.checkDate(ctx, csbbInfo);
        this.checkPersonAndContractType(csbbInfo);
        this.checkContNoIsRepeat(ctx, csbbInfo);
        this.checkHasContractByDate(ctx, (IObjectValue)csbbInfo);
        this.checkProbation(ctx, csbbInfo);
        this.checkLabPartyIsTheSame(ctx, csbbInfo);
        this.checkLabPartyIsOpenElec(ctx, csbbInfo);
    }

    protected void checkBlank(Context ctx, OtherContractSignBizBillInfo csbbInfo) throws BOSException, EASBizException {
        OtherContractSignBizBillEntryCollection entrys = csbbInfo.getEntrys();
        for (int dex = 0; dex < entrys.size(); ++dex) {
            OtherContractSignBizBillEntryInfo entry = entrys.get(dex);
            String contractNo = entry.getContractNo();
            if (contractNo == null || contractNo.equals("")) {
                throw new EmployeeException(EmployeeException.EMPLOYEECONTRACTNO_NOT_EMPTY);
            }
            if (entry.getPerson() == null && entry.getPreEntryPerson() == null) {
                throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_EMP_NOT_NULL);
            }
            if (entry.getContractTemplet() == null) {
                throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_TEMP_NOT_NULL);
            }
            if (entry.getEffectDate() != null) continue;
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_EFFECTDATE_NOT_NULL);
        }
    }

    protected void checkToUnit(OtherContractSignBizBillInfo csbbInfo) throws ContractException {
    }

    protected void checkDate(Context ctx, OtherContractSignBizBillInfo csbbInfo) throws EASBizException, BOSException {
        OtherContractSignBizBillEntryInfo entry = null;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            entry = csbbInfo.getEntrys().get(i);
            Date invalidDate = entry.getContractTemplet().getInvalidDate();
            if (invalidDate != null && new Date().after(invalidDate)) {
                throw new EmployeeException(EmployeeException.ENDDATE_NOT_LESS_TODAY);
            }
            EmployeeOtherContractInfo oContractInfo = new EmployeeOtherContractInfo();
            Date time = new Date();
            if (entry.getRecordDate() == null) {
                entry.setRecordDate(time);
            }
            oContractInfo.setRecordDate(entry.getRecordDate());
            oContractInfo.setEffectDate(entry.getEffectDate());
            oContractInfo.setRecordDate(entry.getRecordDate());
            oContractInfo.setEndDate(entry.getEndDate());
            oContractInfo.setFreeDate(entry.getFreeDate());
            oContractInfo.setEndDateReal(entry.getEndDateReal());
            OtherContractUtils.checkDate(ctx, oContractInfo);
        }
    }

    public static Date getContractEndDateField(OtherContractSignBizBillEntryInfo entry) {
        if (entry.getFreeDate() == null && entry.getEndDateReal() != null) {
            return entry.getEndDateReal();
        }
        return entry.getEndDate();
    }

    protected void setLabContractFirstPartyField(Context ctx, OtherContractSignBizBillInfo billInfo) throws BOSException {
    }

    protected void caculateLimitAuto(OtherContractSignBizBillEntryInfo entry) {
    }

    protected void checkUnique(Context ctx, OtherContractSignBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    protected static boolean isEmpContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeOtherContractFactory.getLocalInstance((Context)ctx).exists(oql);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setLabContractFirstPartyName(ctx, model);
        IObjectPK retValue = super._submit(ctx, model);
        this.afterProcessContractSignData(ctx, model, true);
        return retValue;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setLabContractFirstPartyName(ctx, model);
        IObjectPK retValue = super._save(ctx, model);
        this.afterProcessContractSignData(ctx, model, true);
        return retValue;
    }

    protected void afterProcessContractSignData(Context ctx, IObjectValue model, boolean isAddNew) throws EASBizException, BOSException {
        OtherContractSignBizBillInfo csbbInfo = (OtherContractSignBizBillInfo)model;
        if (!csbbInfo.isIsSSCShare()) {
            return;
        }
        try {
            String clazzName = "com.kingdee.shr.econtractservice.service.ContractBizBillService";
            String methodName = "processEContractData";
            Class<?> clazz = Class.forName(clazzName);
            Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])new Class[]{Context.class, IObjectValue.class, Boolean.class});
            if (method == null) {
                throw new BOSException("can not find com.kingdee.shr.econtractservice.service.ContractBizBillService processEContractData");
            }
            ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])new Object[]{ctx, model, isAddNew});
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof UndeclaredThrowableException) {
                Throwable t = e.getCause();
                logger.error(t.getMessage(), t);
                if (t instanceof EASBizException) {
                    throw (EASBizException)t;
                }
                if (t instanceof BOSException) {
                    throw (BOSException)t;
                }
                throw new BOSException(t.getMessage(), t);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void addAttachmentForContract(Context ctx, EmployeeOtherContractInfo employeeContract, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        IBoAttchAsso boAttchAsso;
        BoAttchAssoCollection boColl;
        List<AttachmentInfo> list;
        String entryField;
        HRBillBaseInfo hRBillBaseInfo = (HRBillBaseInfo)entry.get(this.getBillField());
        String billID = hRBillBaseInfo.getId().toString();
        if (StringUtils.isEmpty((String)billID)) {
            return;
        }
        String boID = "";
        String bosType = BOSUuid.read((String)billID).getType().toString();
        String enrtryID = entry.getId().toString();
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get(entryField = this.getEntryField());
        if (entries.size() > 1) {
            return;
        }
        HRBillBaseEntryInfo hRBillBaseEntryInfo = (HRBillBaseEntryInfo)entries.getObject(0);
        Date bizDate = this.getEffectDate(hRBillBaseEntryInfo);
        if (bizDate != null) {
            bizDate = DateTimeUtils.truncateDate((Date)bizDate);
        }
        ISHRAttachmentExt attachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)billID));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(SHRContractUploadAttachmentUtils.getSHRAttachmentExtSelectorItemCollection());
        SHRAttachmentExtCollection collection = attachmentExt.getSHRAttachmentExtCollection(entityViewInfo);
        String userId = "";
        if (collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                SHRAttachmentExtInfo shrAttachmentExtInfo = collection.get(i);
                String bunding = shrAttachmentExtInfo.getBunding();
                String[] split = bunding.split("#");
                userId = split[0];
                SHRAttachmentExtInfo reverseAttachmentExtInfo = new SHRAttachmentExtInfo();
                AttachmentInfo attachment = shrAttachmentExtInfo.getAttachment();
                reverseAttachmentExtInfo.setAttachment(attachment);
                reverseAttachmentExtInfo.setPropertyName(shrAttachmentExtInfo.getPropertyName());
                reverseAttachmentExtInfo.setType(shrAttachmentExtInfo.getType());
                reverseAttachmentExtInfo.setState(AttachmentState.UNSAVE);
                reverseAttachmentExtInfo.setBunding(userId + "#" + SHRContractUploadAttachmentUtils.getReverseUipk(ctx, bosType));
                reverseAttachmentExtInfo.setName(shrAttachmentExtInfo.getName());
                reverseAttachmentExtInfo.setNumber(shrAttachmentExtInfo.getNumber());
                reverseAttachmentExtInfo.setDescription(shrAttachmentExtInfo.getDescription());
                reverseAttachmentExtInfo.setSimpleName(shrAttachmentExtInfo.getSimpleName());
                attachmentExt.save((CoreBaseInfo)reverseAttachmentExtInfo);
                boID = employeeContract.getId().toString();
                attachmentExt.updateAffterSaveForm(boID, userId + "#" + SHRContractUploadAttachmentUtils.getReverseUipk(ctx, bosType));
            }
        }
        if (!(list = this.getNoPropertyNameAttch(collection, boColl = this.getBoAttchAssoCol(boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx), billID))).isEmpty()) {
            for (AttachmentInfo ai : list) {
                SHRAttachmentExtInfo reverseAttachmentExtInfo = new SHRAttachmentExtInfo();
                reverseAttachmentExtInfo.setAttachment(ai);
                if (ai.getCreator() != null && ai.getCreator().getId() != null) {
                    userId = ai.getCreator().getId().toString();
                }
                reverseAttachmentExtInfo.setPropertyName("null0");
                reverseAttachmentExtInfo.setType(AttachmentTypeEnum.FORM);
                reverseAttachmentExtInfo.setState(AttachmentState.UNSAVE);
                reverseAttachmentExtInfo.setBunding(userId + "#" + SHRContractUploadAttachmentUtils.getReverseUipk(ctx, bosType));
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l1) + "." + ai.getSimpleName(), LocaleUtils.locale_l1);
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l2) + "." + ai.getSimpleName(), LocaleUtils.locale_l2);
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l3) + "." + ai.getSimpleName(), LocaleUtils.locale_l3);
                reverseAttachmentExtInfo.setDescription(ai.getDescription());
                reverseAttachmentExtInfo.setSimpleName(ai.getSimpleName());
                attachmentExt.save((CoreBaseInfo)reverseAttachmentExtInfo);
                boID = employeeContract.getId().toString();
                attachmentExt.updateAffterSaveForm(boID, userId + "#" + SHRContractUploadAttachmentUtils.getReverseUipk(ctx, bosType));
            }
        }
    }

    public BoAttchAssoCollection getBoAttchAssoCol(IBoAttchAsso boAttchAsso, String boid) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boid", (Object)boid));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("attachment.size"));
        sic.add(new SelectorItemInfo("attachment.id"));
        sic.add(new SelectorItemInfo("attachment.name"));
        sic.add(new SelectorItemInfo("attachment.simplename"));
        sic.add(new SelectorItemInfo("attachment.description"));
        sic.add(new SelectorItemInfo("attachment.creator.name"));
        sic.add(new SelectorItemInfo("attachment.createTime"));
        entityViewInfo.setSelector(sic);
        return boAttchAsso.getBoAttchAssoCollection(entityViewInfo);
    }

    public List<AttachmentInfo> getNoPropertyNameAttch(SHRAttachmentExtCollection extColl, BoAttchAssoCollection boColl) {
        ArrayList<AttachmentInfo> list = new ArrayList<AttachmentInfo>();
        ArrayList<String> attchIds = new ArrayList<String>();
        if (extColl.size() == boColl.size()) {
            return list;
        }
        if (extColl.size() > 0) {
            for (int j = 0; j < extColl.size(); ++j) {
                AttachmentInfo attj = extColl.get(j).getAttachment();
                if (attj == null || attj.getId() == null) continue;
                attchIds.add(attj.getId().toString());
            }
        }
        if (boColl.size() > 0) {
            for (int i = 0; i < boColl.size(); ++i) {
                AttachmentInfo atti = boColl.get(i).getAttachment();
                if (atti == null || atti.getId() == null || attchIds.contains(atti.getId().toString())) continue;
                list.add(atti);
            }
        }
        return list;
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        this.beforeAbortBizBill(ctx, billId);
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState)) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
        }
        this.afterAbortBizBill(ctx, billId);
    }

    protected void beforeAbortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
    }

    protected void afterAbortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IObjectPK[] iObjectPKArray = ElectronicContractRelationFactory.getLocalInstance(ctx).delete("where billID = '" + billId + "'");
        }
    }

    protected void updateContractSignBillEntryContractNo(Context ctx, OtherContractSignBizBillInfo billInfo) throws EASBizException, BOSException {
        if (!billInfo.isIsSSCShare()) {
            return;
        }
        OtherContractSignBizBillEntryCollection entryColl = billInfo.getEntrys();
        if (entryColl != null && entryColl.size() > 0) {
            for (int index = 0; index < entryColl.size(); ++index) {
                OtherContractSignBizBillEntryInfo entryInfo = entryColl.get(index);
                ContractTempletInfo templetInfo = entryInfo.getContractTemplet();
                templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
                if (!templetInfo.isIsElectronicSign()) continue;
                String oldNumber = entryInfo.getContractNo();
                String newNumber = ElectronicContractUtils.generateContractNumber((Context)ctx, (String)entryInfo.getContractNo());
                if (newNumber.equals(oldNumber)) continue;
                entryInfo.setContractNo(newNumber);
            }
        }
    }

    protected void setLabContractFirstPartyName(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OtherContractSignBizBillInfo csbbInfo = (OtherContractSignBizBillInfo)model;
        LabContractFirstPartyInfo labContractFirstParty = csbbInfo.getLabContractFirstParty();
        if (labContractFirstParty != null && labContractFirstParty.getId() != null) {
            String labContractFirstPartyName = labContractFirstParty.getName();
            if (StringUtils.isEmpty((String)labContractFirstPartyName)) {
                labContractFirstPartyName = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(labContractFirstParty.getId())).getName();
            }
            csbbInfo.setLCFPName(labContractFirstPartyName);
        }
    }

    protected void checkPersonHasFutureContract(Context ctx, OtherContractSignBizBillInfo csbbInfo) throws EASBizException, BOSException {
    }

    protected void checkPersonAndContractType(OtherContractSignBizBillInfo csbbInfo) throws ContractException {
        OtherContractSignBizBillEntryInfo csbbeInfo1 = null;
        OtherContractSignBizBillEntryInfo csbbeInfo2 = null;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            int j;
            csbbeInfo1 = csbbInfo.getEntrys().get(i);
            boolean isNotSamePerson = false;
            boolean isNotSameContractType = false;
            int rowNum = csbbInfo.getEntrys().size();
            for (j = 0; j < rowNum; ++j) {
                csbbeInfo2 = csbbInfo.getEntrys().get(j);
                if (i == j || csbbeInfo1.getPerson().equals((Object)csbbeInfo2.getPerson())) continue;
                isNotSamePerson = true;
                break;
            }
            rowNum = csbbInfo.getEntrys().size();
            for (j = 0; j < rowNum; ++j) {
                csbbeInfo2 = csbbInfo.getEntrys().get(j);
                if (i == j || csbbeInfo1.getContractType().equals((Object)csbbeInfo2.getContractType())) continue;
                isNotSameContractType = true;
                break;
            }
            if (!isNotSamePerson || !isNotSameContractType) continue;
            throw new ContractException(ContractException.SAVELOSE);
        }
    }

    protected void checkContNoIsRepeat(Context ctx, OtherContractSignBizBillInfo csbbInfo) throws BOSException, EASBizException {
        CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String orgID = curCuInfo.getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        EmployeeOtherContractInfo otherContractInfo = new EmployeeOtherContractInfo();
        if (!(!StringUtils.isEmpty((String)orgID) && iCodingRuleManager.isExist((IObjectValue)otherContractInfo, orgID))) {
            IEmployeeOtherContract employeeContract = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
            IOtherContractSignBizBillEntry iCSBBE = OtherContractSignBizBillEntryFactory.getLocalInstance(ctx);
            EmployeeOtherContractCollection ecCol = null;
            int size = csbbInfo.getEntrys().size();
            for (int i = 0; i < size; ++i) {
                OtherContractSignBizBillEntryInfo csbbeInfo = csbbInfo.getEntrys().get(i);
                StringBuffer sql = new StringBuffer();
                sql.append("select id where contractNo = '" + csbbeInfo.getContractNo() + "'");
                ecCol = employeeContract.getEmployeeOtherContractCollection(sql.toString());
                StringBuffer whereStr = new StringBuffer("where contractNo = '");
                whereStr.append(csbbeInfo.getContractNo());
                if (csbbInfo.getId() != null) {
                    whereStr.append("' and bill <> '");
                    whereStr.append(csbbInfo.getId().toString());
                }
                whereStr.append("' and (bill.billState in (0, 1, 2) or (bill.billState = 3 and bizDate >= ");
                whereStr.append(HRUtil.getCurrentDate());
                whereStr.append("))");
                OtherContractSignBizBillEntryCollection csbbCol = iCSBBE.getOtherContractSignBizBillEntryCollection(whereStr.toString());
                if (ecCol.size() <= 0 && csbbCol.size() <= 0) continue;
                throw new ContractException(ContractException.CONTRACTNO_REPEAT, new Object[]{csbbeInfo.getContractNo()});
            }
        }
    }

    protected void checkHasContractByDate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OtherContractSignBizBillInfo csbbInfo = (OtherContractSignBizBillInfo)model;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            OtherContractSignBizBillEntryInfo otherContractSignBizBillEntryInfo = csbbInfo.getEntrys().get(i);
        }
    }

    protected void checkProbation(Context ctx, OtherContractSignBizBillInfo csbbInfo) throws BOSException, EASBizException {
        OtherContractSignBizBillEntryInfo csbbeInfo = null;
        Object contractInfo = null;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            csbbeInfo = csbbInfo.getEntrys().get(i);
        }
    }

    protected void preProcess(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof OtherContractSignBizBillInfo) {
            OtherContractSignBizBillInfo oldContractSignBizBillInfo = this.getOtherContractSignBizBillInfo(ctx, pk);
            OtherContractSignBizBillEntryCollection oldEntries = null;
            if (oldContractSignBizBillInfo != null) {
                oldEntries = oldContractSignBizBillInfo.getEntrys();
            }
            OtherContractSignBizBillEntryCollection entries = ((OtherContractSignBizBillInfo)model).getEntrys();
            OtherContractSignBizBillEntryInfo oldEntry = null;
            OtherContractSignBizBillEntryInfo entry = null;
            EmployeeOtherContractInfo contractInfo = null;
            if (oldEntries != null) {
                boolean isDelete = true;
                int oldsize = oldEntries.size();
                for (int i = 0; i < oldsize; ++i) {
                    oldEntry = oldEntries.get(i);
                    if (entries != null) {
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            entry = entries.get(j);
                            if (!oldEntry.getId().equals((Object)entry.getId())) continue;
                            isDelete = false;
                            break;
                        }
                    }
                    if (isDelete) {
                        contractInfo = new EmployeeOtherContractInfo();
                        contractInfo.setContractNo(((OtherContractSignBizBillInfo)model).getNumber());
                        contractInfo.setEmployee(entry == null ? null : entry.getPerson());
                        contractInfo.setContractTemplet(entry == null ? null : entry.getContractTemplet());
                        contractInfo.setPreEntryPerson(entry == null ? null : entry.getPreEntryPerson());
                        this._dispachIntermitNumber(ctx, oldEntry, contractInfo);
                        continue;
                    }
                    isDelete = true;
                }
            }
        }
    }

    protected void _dispachIntermitNumber(Context ctx, OtherContractSignBizBillEntryInfo entry, EmployeeOtherContractInfo contractInfo) throws BOSException, EASBizException {
        if (entry != null && entry.getContractNo() != null) {
            CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)contractInfo, null, entry.getContractNo());
        }
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        OtherContractSignBizBillInfo billInfo = this.getOtherContractSignBizBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
        if (billInfo.isIsSSCShare()) {
            return;
        }
        super._untiCheckBizBill(ctx, billId);
        this._afterUntiCeckBizBill(ctx, billInfo);
    }

    protected void _afterUntiCeckBizBill(Context ctx, OtherContractSignBizBillInfo billInfo) throws BOSException, EASBizException {
        OtherContractSignBizBillEntryCollection entrys = billInfo.getEntrys();
        if (entrys == null || entrys.size() <= 0) {
            return;
        }
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int dex = 0; dex < entrys.size(); ++dex) {
            OtherContractSignBizBillEntryInfo billEntryInfo = entrys.get(dex);
            entryIdSet.add(billEntryInfo.getId().toString());
        }
        if (entryIdSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("entryID", entryIdSet, CompareType.INCLUDE));
            EmployeeOtherContractCollection otherContractCollection = ContractUtils.getEmployeeOtherContractInfoByFilter(ctx, filter);
            if (otherContractCollection != null && otherContractCollection.size() > 0) {
                IEmployeeOtherContract iEmployeeOtherContract = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
                for (int dex = 0; dex < otherContractCollection.size(); ++dex) {
                    EmployeeOtherContractInfo otherContractInfo = otherContractCollection.get(dex);
                    EContractSignState signStatus = otherContractInfo.getSignStatus();
                    if (EContractSignState.nosign.equals((Object)signStatus) || EContractSignState.signing.equals((Object)signStatus) || EContractSignState.complete.equals((Object)signStatus) || EContractSignState.partyASigned.equals((Object)signStatus)) {
                        throw new OtherContractException(OtherContractException.CAN_NOT_UNTI_CHECK_HAS_ELEC);
                    }
                    iEmployeeOtherContract.delete((IObjectPK)new ObjectUuidPK(otherContractInfo.getId()));
                }
            }
        }
    }
}

