/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.emp.EmpTypeConvertEnum;
import com.kingdee.eas.hr.emp.EmpTypeConvertException;
import com.kingdee.eas.hr.emp.EmpTypeConvertFacadeFactory;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisCollection;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisFactory;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmpTypeConvertFacade;
import com.kingdee.eas.hr.emp.IEmpTypeConvertHis;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmpTypeConvertBatchEditUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class EmpTypeConvertBatchEditUI
extends AbstractEmpTypeConvertBatchEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpTypeConvertBatchEditUI.class);
    private String resClass = "com.kingdee.eas.hr.emp.EmployeeResource";
    private Color yColor = new Color(250, 250, 220);
    private final Color wColor = new Color(255, 255, 255);
    private final String ID = "id";
    private final String PID = "person.id";
    private final String PNAME = "person.name";
    private final String NOWET = "nowET";
    private final String NOWADMIN = "nowAdmin";
    private final String NOWPOSITION = "nowPosition";
    private final String RETIREDATE = "retireDate";
    private final String RERETAINDATE = "reRetainDate";
    private final String NEWET = "newET";
    private final String NEWADMIN = "newAdmin";
    private final String NEWPOSITION = "newPosition";
    private final String EFFECTDATE = "effectDate";
    private final String STARTDATE = "startDate";
    private final String ENDDATE = "endDate";
    private final String REASON = "reason";
    private final String OPINION = "opinion";
    private final String AUDIT = "audit";
    private final String AUDITDATE = "auditDate";
    private EmployeeTypeInfo etInfo;
    private boolean isAudit;
    private EmpTypeConvertHisCollection hisColl;
    private StringBuffer his_sp;
    private List hisIdList;
    private boolean isStateChanged = false;
    private final String reRetainTypeID = "00000000-0000-0000-0000-000000000015A29E85B3";
    private final String retireTypeID = "00000000-0000-0000-0000-000000000008A29E85B3";
    private boolean newPosValueChanged = false;

    public void onLoad() throws Exception {
        this.isAudit = (Boolean)this.getUIContext().get("isAudit");
        PersonCollection pInfos = (PersonCollection)this.getUIContext().get("personInfos");
        this.etInfo = (EmployeeTypeInfo)this.getUIContext().get("employeeType");
        this.hisIdList = (List)this.getUIContext().get("hisIdList");
        this.btnBatchCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        super.onLoad();
        this.tblMain.checkParsed();
        this.loadPersonData(pInfos);
        if (this.getUIContext().get("cadre") != null) {
            this.setUITitle(EASResource.getString((String)this.resClass, (String)"CADRE_STATE"));
        }
        this.setColVisible();
        this.initColEditor();
        this.btnBatchCopy.setEnabled(true);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                super.editStarting(e);
                if (e.getColIndex() == EmpTypeConvertBatchEditUI.this.tblMain.getColumn("newPosition").getColumnIndex()) {
                    EmpTypeConvertBatchEditUI.this.newPosValueChanged = true;
                }
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension();
        size.setSize(screenSize.getWidth() * 2.0 / 3.0, screenSize.getHeight() / 2.0);
        this.setPreferredSize(size);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        if (this.isAudit) {
            this.actionAudit.setVisible(true);
            this.actionAudit.setEnabled(true);
            this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
            this.actionSubmit.setVisible(false);
            this.actionSubmit.setEnabled(false);
            this.actionRemove.setVisible(false);
            this.actionRemove.setEnabled(false);
        }
    }

    private void initColEditor() {
        KDBizPromptBox prmtET = new KDBizPromptBox();
        prmtET.setQueryInfo("com.kingdee.eas.hr.base.app.EmployeeTypeQuery");
        this.setEmpTypeF7Filter(this.etInfo.getInService().getValue(), prmtET);
        prmtET.setDisplayFormat("$name$");
        prmtET.setCommitFormat("$number$");
        prmtET.setEditFormat("$number$");
        this.tblMain.getColumn("newET").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtET));
        KDBizPromptBox prmtAdmin = new KDBizPromptBox();
        AdminByOrgRangePromptBox adminBox = new AdminByOrgRangePromptBox("false");
        adminBox.setHROFilter((HashSet)this.getUIContext().get("hrSet"));
        prmtAdmin.setSelector((KDPromptSelector)adminBox);
        prmtAdmin.setEditable(false);
        this.tblMain.getColumn("newAdmin").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAdmin));
        KDBizPromptBox prmtPosition = new KDBizPromptBox();
        PositionPromptBox2 positionBox = new PositionPromptBox2();
        positionBox.setSealUp("true");
        positionBox.setHROFilter((HashSet)this.getUIContext().get("hrSet"));
        prmtPosition.setSelector((KDPromptSelector)positionBox);
        prmtPosition.setEditable(false);
        this.tblMain.getColumn("newPosition").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPosition));
        KDDatePicker pkDate = new KDDatePicker();
        pkDate.setMilliSecondEnable(false);
        pkDate.setDateEnabled(true);
        pkDate.setTimeEnabled(false);
        pkDate.setEditable(false);
        this.tblMain.getColumn("retireDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("reRetainDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("effectDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("retireDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        this.tblMain.getColumn("reRetainDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        this.tblMain.getColumn("startDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        this.tblMain.getColumn("endDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        this.tblMain.getColumn("auditDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        this.tblMain.getColumn("effectDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        KDTextField txtReason = new KDTextField();
        txtReason.setMaxLength(250);
        this.tblMain.getColumn("reason").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtReason));
        KDTextField txtOpinion = new KDTextField();
        txtOpinion.setMaxLength(250);
        this.tblMain.getColumn("opinion").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtOpinion));
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
    }

    private void setEmpTypeF7Filter(int fromEmpTypeParent, KDBizPromptBox prmtET) {
        EntityViewInfo empTypeView = new EntityViewInfo();
        FilterInfo empTypeFilter = null;
        if (fromEmpTypeParent == 1) {
            empTypeFilter = new FilterInfo();
            empTypeFilter.getFilterItems().add(new FilterItemInfo("inService", (Object)0));
            empTypeFilter.getFilterItems().add(new FilterItemInfo("inService", (Object)1));
            empTypeFilter.setMaskString("#0 or #1");
            empTypeView.setFilter(empTypeFilter);
        } else if (fromEmpTypeParent == 0) {
            empTypeFilter = new FilterInfo();
            empTypeFilter.getFilterItems().add(new FilterItemInfo("inService", (Object)4, CompareType.NOTEQUALS));
            empTypeView.setFilter(empTypeFilter);
        } else if (fromEmpTypeParent == 2) {
            empTypeFilter = new FilterInfo();
            empTypeFilter.getFilterItems().add(new FilterItemInfo("inService", (Object)0, CompareType.EQUALS));
            empTypeView.setFilter(empTypeFilter);
        }
        prmtET.setEntityViewInfo(empTypeView);
    }

    private void setColVisible() {
        this.tblMain.getColumn("person.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("nowAdmin").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("nowET").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("nowPosition").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("reRetainDate").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("retireDate").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("audit").getStyleAttributes().setLocked(true);
        if (this.etInfo.getInService().getValue() == 0 || this.etInfo.getInService().getValue() == 1) {
            this.tblMain.getColumn("retireDate").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("startDate").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("endDate").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("reRetainDate").getStyleAttributes().setHided(true);
            if (!this.isAudit) {
                this.tblMain.getColumn("newET").getStyleAttributes().setBackground(this.yColor);
            }
        }
        if (this.etInfo.getInService().getValue() == 3) {
            this.tblMain.getColumn("nowPosition").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("reRetainDate").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("retireDate").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("newET").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("newAdmin").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("startDate").getStyleAttributes().setBackground(this.yColor);
            if (!this.isAudit) {
                this.tblMain.getColumn("newPosition").getStyleAttributes().setBackground(this.yColor);
            }
        }
        if (this.etInfo.getInService().getValue() == 4) {
            this.tblMain.getColumn("retireDate").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("startDate").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("newET").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("newPosition").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("reRetainDate").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("endDate").getStyleAttributes().setBackground(this.yColor);
            this.tblMain.getColumn("newAdmin").getStyleAttributes().setBackground(this.yColor);
        }
        if (this.etInfo.getInService().getValue() == 2 && !this.isAudit) {
            this.tblMain.getColumn("newET").getStyleAttributes().setBackground(this.yColor);
        }
        if (!this.isAudit) {
            this.tblMain.getColumn("opinion").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("auditDate").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("effectDate").getStyleAttributes().setBackground(this.yColor);
        } else {
            this.tblMain.getColumn("newET").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("newAdmin").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("newPosition").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("reason").getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("auditDate").getStyleAttributes().setBackground(this.yColor);
        }
    }

    private void loadPersonData(PersonCollection pInfos) throws Exception {
        if (!this.isAudit) {
            ArrayList<String> perList = new ArrayList<String>();
            int size = pInfos.size();
            for (int i = 0; i < size; ++i) {
                perList.add(pInfos.get(i).getId().toString());
            }
            IEmpTypeConvertFacade iEmpTypeConvertFacade = EmpTypeConvertFacadeFactory.getRemoteInstance();
            Map reRetainDateMap = iEmpTypeConvertFacade.getReretainDateMap(perList);
            Map retireDateMap = iEmpTypeConvertFacade.getRetireDateMap(perList);
            PersonPositionCollection ppColl = this.getPerPpInfo(perList);
            for (int j = 0; j < ppColl.size(); ++j) {
                IRow curRow = this.tblMain.addRow();
                this.setCurrentRowEditor(curRow);
                this.addNewRow(curRow, ppColl.get(j), j, reRetainDateMap, retireDateMap);
            }
        } else {
            EmpTypeConvertHisCollection hisColl = this.getHisColl();
            for (int j = 0; j < hisColl.size(); ++j) {
                IRow curRow = this.tblMain.addRow();
                this.setCurrentRowEditor(curRow);
                this.addHisNewRow(curRow, hisColl.get(j));
                this.etInfo = hisColl.get(j).getFromEmpType();
            }
        }
    }

    private EmpTypeConvertHisCollection getHisColl() throws Exception {
        String oql = "select *, employee.id, employee.name, employee.number, fromEmpType.id, fromEmpType.name, fromEmpType.number, fromEmpType.inService, toEmpType.id, toEmpType.name, toEmpType.number, toEmpType.inService, fromUnit.id, fromUnit.name, fromUnit.number, toUnit.id, toUnit.name, toUnit.number, fromPosition.id, fromPosition.name, fromPosition.number, toPosition.id, toPosition.name, toPosition.number where id in" + BenefitUtils.getStrFromList((List)this.hisIdList);
        return ((IEmpTypeConvertHis)this.getBizInterface()).getEmpTypeConvertHisCollection(oql);
    }

    private PersonPositionCollection getPerPpInfo(List perList) throws BOSException, EASBizException {
        IPersonPosition iPersonPosition = PersonPositionFactory.getRemoteInstance();
        String oql = "select person.id, person.name, person.number, personDep.id, personDep.name, personDep.number, primaryPosition.id, primaryPosition.name, primaryPosition.number where person.id in" + BenefitUtils.getStrFromList((List)perList);
        PersonPositionCollection rPersonPositionColl = iPersonPosition.getPersonPositionCollection(oql);
        return rPersonPositionColl;
    }

    private void addNewRow(IRow curRow, PersonPositionInfo ppInfo, int j, Map reRetainDateMap, Map retireDateMap) {
        curRow.getCell("audit").setValue((Object)EmpTypeConvertEnum.NOAUDIT);
        String perId = ppInfo.getPerson().getId().toString();
        curRow.getCell("person.id").setValue((Object)perId);
        curRow.getCell("person.name").setValue((Object)ppInfo.getPerson().getName());
        curRow.getCell("nowET").setValue((Object)this.etInfo);
        curRow.getCell("nowAdmin").setValue((Object)ppInfo.getPersonDep());
        curRow.getCell("nowPosition").setValue((Object)ppInfo.getPrimaryPosition());
        if (this.etInfo.getInService().getValue() == 3) {
            curRow.getCell("retireDate").setValue((Object)((Date)retireDateMap.get(perId)));
            curRow.getCell("newET").setValue((Object)this.getRetireOrRetainType("00000000-0000-0000-0000-000000000015A29E85B3"));
        } else if (this.etInfo.getInService().getValue() == 4) {
            curRow.getCell("reRetainDate").setValue((Object)((Date)reRetainDateMap.get(perId)));
            curRow.getCell("newET").setValue((Object)this.getRetireOrRetainType("00000000-0000-0000-0000-000000000008A29E85B3"));
        }
    }

    private EmployeeTypeInfo getRetireOrRetainType(String empTypeId) {
        String oql = "select id,name,number,inService where id = '" + empTypeId + "'";
        try {
            IEmployeeType iEmployeeType = EmployeeTypeFactory.getRemoteInstance();
            return iEmployeeType.getEmployeeTypeInfo(oql);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
        return null;
    }

    private void addHisNewRow(IRow curRow, EmpTypeConvertHisInfo hisInfo) {
        curRow.getCell("audit").setValue((Object)EmpTypeConvertEnum.AUDITED);
        curRow.getCell("id").setValue((Object)hisInfo.getId().toString());
        curRow.getCell("person.id").setValue((Object)hisInfo.getEmployee().getId().toString());
        curRow.getCell("person.name").setValue((Object)hisInfo.getEmployee().getName());
        curRow.getCell("nowET").setValue((Object)hisInfo.getFromEmpType());
        curRow.getCell("nowAdmin").setValue((Object)hisInfo.getFromUnit());
        curRow.getCell("nowPosition").setValue((Object)hisInfo.getFromPosition());
        curRow.getCell("retireDate").setValue((Object)hisInfo.getRetireDate());
        curRow.getCell("reRetainDate").setValue((Object)hisInfo.getReretainDate());
        curRow.getCell("newET").setValue((Object)hisInfo.getToEmpType());
        curRow.getCell("newAdmin").setValue((Object)hisInfo.getToUnit());
        curRow.getCell("newPosition").setValue((Object)hisInfo.getToPosition());
        curRow.getCell("effectDate").setValue((Object)hisInfo.getEffectDate());
        curRow.getCell("startDate").setValue((Object)hisInfo.getJobStartDate());
        curRow.getCell("endDate").setValue((Object)hisInfo.getJobEndDate());
        curRow.getCell("reason").setValue((Object)hisInfo.getDescription());
        curRow.getCell("opinion").setValue((Object)hisInfo.getAuditOpinion());
        curRow.getCell("audit").setValue((Object)hisInfo.getAuditState());
        if (hisInfo.getAuditDate() != null) {
            curRow.getCell("auditDate").setValue((Object)hisInfo.getAuditDate());
        } else {
            curRow.getCell("auditDate").setValue((Object)new Date());
        }
    }

    private void setCurrentRowEditor(IRow curRow) {
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.hisColl = new EmpTypeConvertHisCollection();
        EmpTypeConvertHisInfo hisInfo = null;
        PersonInfo perInfo = null;
        IRow curRow = null;
        this.his_sp = new StringBuffer();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            curRow = this.tblMain.getRow(i);
            hisInfo = new EmpTypeConvertHisInfo();
            perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)curRow.getCell("person.id").getValue().toString()));
            hisInfo.setEmployee(perInfo);
            if (curRow.getCell("person.name").getValue() != null) {
                this.his_sp.append(curRow.getCell("person.name").getValue().toString());
                this.his_sp.append(";");
            }
            if (curRow.getCell("id").getValue() != null) {
                hisInfo.setId(BOSUuid.read((String)curRow.getCell("id").getValue().toString()));
            }
            hisInfo.setFromEmpType((EmployeeTypeInfo)curRow.getCell("nowET").getValue());
            hisInfo.setToEmpType((EmployeeTypeInfo)curRow.getCell("newET").getValue());
            hisInfo.setFromUnit((AdminOrgUnitInfo)curRow.getCell("nowAdmin").getValue());
            hisInfo.setToUnit((AdminOrgUnitInfo)curRow.getCell("newAdmin").getValue());
            hisInfo.setFromPosition((PositionInfo)curRow.getCell("nowPosition").getValue());
            hisInfo.setToPosition((PositionInfo)curRow.getCell("newPosition").getValue());
            hisInfo.setAuditDate((Date)curRow.getCell("auditDate").getValue());
            hisInfo.setAuditState((EmpTypeConvertEnum)((Object)curRow.getCell("audit").getValue()));
            hisInfo.setAuditOpinion((String)curRow.getCell("opinion").getValue());
            hisInfo.setJobStartDate((Date)curRow.getCell("startDate").getValue());
            hisInfo.setJobEndDate((Date)curRow.getCell("endDate").getValue());
            hisInfo.setEffectDate((Date)curRow.getCell("effectDate").getValue());
            hisInfo.setRetireDate((Date)curRow.getCell("retireDate").getValue());
            hisInfo.setReretainDate((Date)curRow.getCell("reRetainDate").getValue());
            hisInfo.setDescription((String)curRow.getCell("reason").getValue());
            this.hisColl.add(hisInfo);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.checkInput();
        this.storeFields();
        IEmpTypeConvertHis tmpInfo = EmpTypeConvertHisFactory.getRemoteInstance();
        String logstr = null;
        if (this.his_sp.length() > 0) {
            logstr = this.his_sp.toString();
        }
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)tmpInfo.getType(), null, (String)logstr, (String)"empTypeConvert_maintenance");
        ((IEmpTypeConvertHis)this.getBizInterface()).auditBatchEmpTypeConvert(this.hisColl);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.isStateChanged = true;
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"250_EmpTypeConvertBatchEditUI"));
        this.getUIWindow().close();
    }

    public boolean isStateChanged() {
        return this.isStateChanged;
    }

    @Override
    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
        super.tblMain_editStopping(e);
        int rowIndex = e.getRowIndex();
        if (e.getColIndex() == this.tblMain.getColumn("newET").getColumnIndex()) {
            if (this.oprtState.equals(OprtState.ADDNEW) && e.getValue() != null) {
                EmployeeTypeInfo fromEtInfo;
                EmployeeTypeInfo etInfo = (EmployeeTypeInfo)e.getValue();
                int etInService = etInfo.getInService().getValue();
                if (etInService == 1 || etInService == 4) {
                    this.setNewPosEnable(rowIndex);
                    this.tblMain.getCell(rowIndex, "newAdmin").setValue(null);
                } else if (etInService == 0 || etInService == 3 || etInService == 2) {
                    this.setNewPosDisable(rowIndex);
                    this.tblMain.getCell(rowIndex, "newAdmin").getStyleAttributes().setBackground(this.yColor);
                    this.tblMain.getCell(rowIndex, "newPosition").getStyleAttributes().setBackground(this.wColor);
                    fromEtInfo = (EmployeeTypeInfo)this.tblMain.getCell(rowIndex, "nowET").getValue();
                    if (fromEtInfo != null) {
                        this.setDefaultNewAdmin(rowIndex);
                    }
                }
                if (etInfo.getInService().getValue() == 1) {
                    this.tblMain.getCell(rowIndex, "newPosition").getStyleAttributes().setBackground(this.yColor);
                    this.tblMain.getCell(rowIndex, "newAdmin").getStyleAttributes().setBackground(this.wColor);
                    fromEtInfo = (EmployeeTypeInfo)this.tblMain.getCell(e.getRowIndex(), "nowET").getValue();
                    if (fromEtInfo != null && fromEtInfo.getInService().getValue() == 1) {
                        this.setDefaultAdminPosition(rowIndex);
                    }
                }
            }
        } else if (e.getColIndex() == this.tblMain.getColumn("newPosition").getColumnIndex()) {
            if (e.getValue() != null) {
                PositionInfo posInfo = (PositionInfo)e.getValue();
                this.setNewAdminByNewPosition(posInfo, rowIndex);
            } else {
                this.tblMain.getCell(e.getRowIndex(), "newAdmin").setValue(null);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        this.storeFields();
        Map perHisMap = null;
        perHisMap = ((IEmpTypeConvertHis)this.getBizInterface()).hisBatchSubmit(this.hisColl);
        if (this.getUIContext().get("cadre") != null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resClass, (String)"CADRESTATE_SAVEOK"));
        } else {
            MsgBox.showInfo((String)HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"I18NSAVE_SUCCESS", (String[])new String[]{this.getClassAlise()}));
        }
        this.loadHisId(perHisMap);
    }

    private void checkInput() throws EmployeeException, EmpTypeConvertException {
        IRow iRow = null;
        EmployeeTypeInfo nowEtInfo = null;
        EmployeeTypeInfo newEtInfo = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            nowEtInfo = (EmployeeTypeInfo)iRow.getCell("nowET").getValue();
            int nowEtInService = nowEtInfo.getInService().getValue();
            if (iRow.getCell("newET").getValue() == null) {
                iRow.getCell("newET").getStyleAttributes().setLocked(false);
                throw new EmployeeException(EmployeeException.EMPTYPECONVERT_TOTYPE_CANNOTEMPTY);
            }
            if (nowEtInfo == iRow.getCell("newET").getValue()) {
                throw new EmployeeException(EmployeeException.EMPTYPECONVERT_SAMEFROMTO);
            }
            if (iRow.getCell("effectDate").getValue() == null) {
                throw new EmpTypeConvertException(EmpTypeConvertException.NEWEFFECTDATE_NOT_NULL, new Object[]{i + 1});
            }
            newEtInfo = (EmployeeTypeInfo)iRow.getCell("newET").getValue();
            int newEtInService = newEtInfo.getInService().getValue();
            if (!(newEtInService != 0 && newEtInService != 2 && newEtInService != 3 || iRow.getCell("newAdmin").getValue() != null && iRow.getCell("newPosition").getValue() == null)) {
                throw new EmployeeException(EmployeeException.EMPTYPECONVERT_TONOTINPOSITION);
            }
            if (newEtInService == 1 && iRow.getCell("newPosition").getValue() == null) {
                throw new EmployeeException(EmployeeException.EMPTYPECONVERT_TOINPOSITION);
            }
            if (nowEtInService == 3) {
                Date endDate;
                if (iRow.getCell("newPosition").getValue() == null) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.TOPOSITION_NOT_NULL, new Object[]{i + 1});
                }
                if (iRow.getCell("newAdmin").getValue() == null) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.TOUNIT_NOT_NULL, new Object[]{i + 1});
                }
                if (iRow.getCell("startDate").getValue() == null) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.STARTDATE_NOT_NULL, new Object[]{i + 1});
                }
                Date effectDate = (Date)iRow.getCell("effectDate").getValue();
                Date startDate = (Date)iRow.getCell("startDate").getValue();
                if (iRow.getCell("retireDate").getValue() != null) {
                    Date retireDate = (Date)iRow.getCell("retireDate").getValue();
                    if (effectDate.before(retireDate)) {
                        throw new EmpTypeConvertException(EmpTypeConvertException.DATE_NOT_INVALID, new Object[]{i + 1});
                    }
                    if (startDate.before(retireDate)) {
                        throw new EmpTypeConvertException(EmpTypeConvertException.DATE_NOT_INVALID, new Object[]{i + 1});
                    }
                }
                if (iRow.getCell("endDate").getValue() != null && (endDate = (Date)iRow.getCell("endDate").getValue()).before(startDate)) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.START_NOT_END, new Object[]{i + 1});
                }
            }
            if (nowEtInService == 4) {
                Date retainDate;
                if (iRow.getCell("endDate").getValue() == null) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.ENDDATE_NOT_NULL, new Object[]{i + 1});
                }
                if (iRow.getCell("newAdmin").getValue() == null) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.ADMIN_NOT_NULL, new Object[]{i + 1});
                }
                Date retainCancelDate = (Date)iRow.getCell("effectDate").getValue();
                if (iRow.getCell("reRetainDate").getValue() != null && retainCancelDate.before(retainDate = (Date)iRow.getCell("reRetainDate").getValue())) {
                    throw new EmpTypeConvertException(EmpTypeConvertException.DATE_NOVALID, new Object[]{i + 1});
                }
            }
            if (!this.isAudit || iRow.getCell("auditDate").getValue() != null) continue;
            throw new EmployeeException(EmployeeException.EMPTYPECONVERT_AUDITDATA_CANNOTEMPTY);
        }
    }

    private void loadHisId(Map perHisMap) {
        IRow iRow = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            iRow.getCell("id").setValue(perHisMap.get(iRow.getCell("person.id").getValue().toString()));
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            sb = this.tblMain.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            if (row == -1) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            Object adminValue = this.tblMain.getCell(row, "newAdmin").getValue();
            int[] selectDis = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            int k2 = 0;
            for (int k2 : selectDis) {
                if (column == this.tblMain.getColumn("newPosition").getColumnIndex() && !this.tblMain.getCell(k2, "newPosition").getStyleAttributes().isLocked()) {
                    this.tblMain.getCell(k2, "newAdmin").setValue(adminValue);
                }
                if (k2 == row || this.tblMain.getCell(k2, column).getStyleAttributes().isLocked()) continue;
                iCell = this.tblMain.getCell(k2, column);
                iCell.setValue(value);
            }
        }
    }

    protected IObjectValue createNewData() {
        return new EmpTypeConvertHisInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmpTypeConvertHisFactory.getRemoteInstance();
    }

    protected void setNewAdminByNewPosition(PositionInfo posInfo, int rowIndex) {
        if (posInfo != null) {
            this.tblMain.getCell(rowIndex, "newAdmin").setValue((Object)posInfo.getAdminOrgUnit());
        }
    }

    protected void setDefaultNewAdmin(int rowIndex) {
        this.tblMain.getCell(rowIndex, "newAdmin").setValue((Object)((AdminOrgUnitInfo)this.tblMain.getCell(rowIndex, "nowAdmin").getValue()));
    }

    protected void setDefaultAdminPosition(int rowIndex) {
        PositionInfo posInfo = null;
        posInfo = (PositionInfo)this.tblMain.getCell(rowIndex, "nowPosition").getValue();
        posInfo.setAdminOrgUnit((AdminOrgUnitInfo)this.tblMain.getCell(rowIndex, "nowAdmin").getValue());
        this.tblMain.getCell(rowIndex, "newPosition").setValue((Object)posInfo);
        this.tblMain.getCell(rowIndex, "newAdmin").setValue((Object)((AdminOrgUnitInfo)this.tblMain.getCell(rowIndex, "nowAdmin").getValue()));
    }

    protected void setNewPosEnable(int rowIndex) {
        this.tblMain.getCell(rowIndex, "newAdmin").getStyleAttributes().setLocked(true);
        this.tblMain.getCell(rowIndex, "newPosition").getStyleAttributes().setLocked(false);
    }

    protected void setNewPosDisable(int rowIndex) {
        this.tblMain.getCell(rowIndex, "newAdmin").getStyleAttributes().setLocked(false);
        this.tblMain.getCell(rowIndex, "newPosition").getStyleAttributes().setLocked(true);
        this.tblMain.getCell(rowIndex, "newPosition").setValue(null);
    }

    @Override
    public void actionBatchCopy_actionPerformed(ActionEvent e) throws Exception {
        int length;
        boolean newPosIsSelected = false;
        boolean newETIsSelected = false;
        super.actionBatchCopy_actionPerformed(e);
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        if (size > 0 && this.tblMain.getRowCount() > 0) {
            IColumn iColumn;
            sb = this.tblMain.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            if (column == 10) {
                newPosIsSelected = true;
            }
            if (column == 8) {
                newETIsSelected = true;
            }
            if ((iColumn = this.tblMain.getColumn(column)).getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            int length2 = this.tblMain.getRowCount();
            for (int rowIndex = 0; rowIndex < length2; ++rowIndex) {
                if (this.tblMain.getCell(rowIndex, column).getStyleAttributes().isLocked()) continue;
                iCell = this.tblMain.getCell(rowIndex, column);
                iCell.setValue(value);
            }
        }
        if (newPosIsSelected) {
            if (this.newPosValueChanged) {
                length = this.tblMain.getRowCount();
                for (int rowIndex = 0; rowIndex < length; ++rowIndex) {
                    PositionInfo posInfo = (PositionInfo)this.tblMain.getCell(rowIndex, "newPosition").getValue();
                    this.setNewAdminByNewPosition(posInfo, rowIndex);
                }
                this.newPosValueChanged = false;
                newPosIsSelected = false;
            }
        } else if (newETIsSelected) {
            length = this.tblMain.getRowCount();
            for (int rowIndex = 0; rowIndex < length; ++rowIndex) {
                EmployeeTypeInfo fromEtInfo;
                EmployeeTypeInfo etInfo = (EmployeeTypeInfo)this.tblMain.getCell(rowIndex, "newET").getValue();
                if (this.tblMain.getCell(rowIndex, "newET").getValue() == null) continue;
                if (etInfo.getInService().getValue() == 0 || etInfo.getInService().getValue() == 2 || etInfo.getInService().getValue() == 3) {
                    this.setNewPosDisable(rowIndex);
                }
                if (etInfo.getInService().getValue() == 0) {
                    this.tblMain.getCell(rowIndex, "newAdmin").getStyleAttributes().setBackground(this.yColor);
                    this.tblMain.getCell(rowIndex, "newPosition").getStyleAttributes().setBackground(this.wColor);
                    fromEtInfo = null;
                    fromEtInfo = (EmployeeTypeInfo)this.tblMain.getCell(rowIndex, "nowET").getValue();
                    if (fromEtInfo != null) {
                        this.setDefaultNewAdmin(rowIndex);
                    }
                }
                if (etInfo.getInService().getValue() == 1 || etInfo.getInService().getValue() == 4) {
                    this.setNewPosEnable(rowIndex);
                }
                if (etInfo.getInService().getValue() != 1) continue;
                this.tblMain.getCell(rowIndex, "newPosition").getStyleAttributes().setBackground(this.yColor);
                this.tblMain.getCell(rowIndex, "newAdmin").getStyleAttributes().setBackground(this.wColor);
                fromEtInfo = null;
                fromEtInfo = (EmployeeTypeInfo)this.tblMain.getCell(rowIndex, "nowET").getValue();
                if (fromEtInfo == null) continue;
                if (fromEtInfo.getInService().getValue() == 1) {
                    this.setDefaultAdminPosition(rowIndex);
                }
                if (fromEtInfo.getInService().getValue() != 0) continue;
                this.tblMain.getCell(rowIndex, "newAdmin").setValue(null);
                this.tblMain.getCell(rowIndex, "newPosition").setValue(null);
            }
        }
    }
}

