/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewHROF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.base.client.IEmployeeUI;
import com.kingdee.eas.hr.emp.client.AbstractEmployeePerformanceEditUI;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class EmployeePerformanceEditUI
extends AbstractEmployeePerformanceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeePerformanceEditUI.class);
    private IEmployeeUI treeEditUI = null;
    private boolean loaded = false;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        String fromPage = (String)this.getUIContext().get("StandbyPersonUI");
        if ("StandbyPersonUI".equals(fromPage)) {
            this.menuBar.setVisible(false);
            this.btnPre.setVisible(false);
            this.btnLast.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnFirst.setVisible(false);
            this.prmtHrOrgUnit.setEnabled(false);
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("colTotal").getStyleAttributes().setNumberFormat("%r-{0.00}d");
        NewHROF7 f7 = new NewHROF7();
        this.prmtHrOrgUnit.setSelector((KDPromptSelector)f7);
        HROrgUnitInfo currentHRUnit = this.getCurrentHRO();
        this.prmtHrOrgUnit.setValue((Object)currentHRUnit);
        this.setTableData(currentHRUnit);
        this.loaded = true;
        this.prmtHrOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                if (EmployeePerformanceEditUI.this.prmtHrOrgUnit.getValue() != null) {
                    try {
                        EmployeePerformanceEditUI.this.setTableData((HROrgUnitInfo)arg0.getData());
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
            }
        });
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
    }

    protected void inOnload() throws Exception {
    }

    @Override
    public void loadFields() {
        if (this.loaded) {
            HROrgUnitInfo currentHRUnit = this.getCurrentHRO();
            this.prmtHrOrgUnit.setValue((Object)this.getCurrentHRO());
            try {
                this.setTableData(currentHRUnit);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        super.loadFields();
    }

    void setTableData(HROrgUnitInfo hrOrgUnitInfo) throws Exception {
        String hrId;
        String value;
        boolean isShow;
        String personId = (String)this.getUIContext().get("ID");
        if (personId == null) {
            UserInfo uInfo = SysContext.getSysContext().getCurrentUserInfo();
            if (uInfo != null && uInfo.getPerson() != null) {
                personId = uInfo.getPerson().getId().toString();
            } else {
                return;
            }
        }
        this.tblMain.removeRows();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "PerformanceInfoUnionQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("isApproved", (Object)1));
        if (SysContext.getSysContext().getCurrentHRUnit() != null && (isShow = TypeConversionUtils.objToBoolean((Object)(value = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(hrId = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (String)"hr_perf_003"))))) {
            fi.getFilterItems().add(new FilterItemInfo("isShow", (Object)1));
        }
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        if (hrOrgUnitInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitInfo.getId().toString()));
        } else if (SysContext.getSysContext().getCurrentHRUnit() != null) {
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        }
        evi.setFilter(fi);
        SorterItemCollection sorter = evi.getSorter();
        SorterItemInfo si = new SorterItemInfo("assessPeriod.startDate");
        si.setSortType(SortType.DESCEND);
        sorter.add(si);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        BigDecimal score = null;
        String rank = "";
        while (rowSet.next()) {
            IRow curRow = this.tblMain.addRow();
            curRow.getCell("colPosition").setValue((Object)rowSet.getString("position.name"));
            curRow.getCell("colOrg").setValue((Object)rowSet.getString("adminOrgUnit.name"));
            curRow.getCell("colScheme").setValue((Object)rowSet.getString("evaluSolution.name"));
            curRow.getCell("colCircle").setValue((Object)rowSet.getString("assessPeriod.name"));
            score = rowSet.getBigDecimal("modifiedScore");
            if (score == null) {
                score = rowSet.getBigDecimal("evaluScore");
            }
            if ((rank = rowSet.getString("modifiedRank.name")) == null || "".equals(rank.trim())) {
                rank = rowSet.getString("rank.name");
            }
            curRow.getCell("colTotal").setValue((Object)score);
            curRow.getCell("colLevel").setValue((Object)rank);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TargetEvaluStoreFactory.getRemoteInstance();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext() == null || this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo().getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("personId", this.getUIContext().get("ID"));
        request.put("NO_PERMISSION", this.getPermission());
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    private Object getPermission() {
        if (this.getUIContext() == null || this.getUIContext().get("NO_PERMISSION") == null) {
            return null;
        }
        return this.getUIContext().get("NO_PERMISSION");
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
    }
}

