/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.client.AbstractPhotoLeadInOrOutTermUI;
import com.kingdee.eas.hr.emp.client.PersonPhotoErrorImpListUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PhotoLeadInOrOutTermUI
extends AbstractPhotoLeadInOrOutTermUI {
    private static final Logger logger = CoreUIObject.getLogger(PhotoLeadInOrOutTermUI.class);
    private IPersonPhoto iPP = null;
    private ArrayList errorPersonList = null;
    private static int pageSize = 200;

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionConfirm.setEnabled(true);
        AdminByOrgRangePromptBox aSel = new AdminByOrgRangePromptBox("true");
        aSel.showChkSealUp(true);
        this.prmtAdminOrgUnit.setSelector((KDPromptSelector)aSel);
        this.prmtAdminOrgUnit.setEditable(false);
        this.changeAdminState();
    }

    @Override
    protected void rdPhotoLeadIn_itemStateChanged(ItemEvent e) throws Exception {
        this.changeAdminState();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private void changeAdminState() {
        if (this.rdPhotoLeadIn.isSelected()) {
            this.prmtAdminOrgUnit.setEnabled(false);
            this.chkIncludeChild.setEnabled(false);
        } else {
            this.prmtAdminOrgUnit.setEnabled(true);
            this.chkIncludeChild.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.iPP = PersonPhotoFactory.getRemoteInstance();
        if (this.rdPhotoLeadIn.isSelected()) {
            KDFileChooser fileChooser = new KDFileChooser();
            fileChooser.setFileSelectionMode(1);
            int result = fileChooser.showOpenDialog((Component)((Object)this));
            if (result != 0) {
                return;
            }
            this.personBatchImport(fileChooser.getSelectedFile(), new PhotoFilter());
        } else if (this.rdPhotoLeadOut.isSelected()) {
            if (this.prmtAdminOrgUnit.getData() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MUST_SELECT_ADMIN"));
                return;
            }
            KDFileChooser chooser = new KDFileChooser();
            chooser.setDialogType(1);
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.FILE_SELECT"));
            chooser.setApproveButtonText(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CONFIRM"));
            int r = chooser.showSaveDialog((Component)((Object)this));
            if (r == 0) {
                int num;
                String selectFielPath = chooser.getSelectedFile().getAbsolutePath().trim();
                if (selectFielPath.equals("")) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.SELECT_TARGET_FILE"));
                    return;
                }
                HashMap map = null;
                AdminOrgUnitInfo paramAdmin = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData();
                map = this.chkIncludeChild.isSelected() ? ((num = this.iPP.getPersonPhotoDataNumByAdmin(paramAdmin)) > (pageSize = 200) ? this.getPersonPhotoDataBatch(num, paramAdmin) : this.iPP.getPersonPhotoDataByAdmin(paramAdmin, true)) : this.iPP.getPersonPhotoDataByAdmin(paramAdmin, false);
                if (map == null || map.isEmpty()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NO_PERSON_IN_ADMIN"));
                    return;
                }
                Iterator it = map.keySet().iterator();
                ArrayList<PersonInfo> personList = new ArrayList<PersonInfo>();
                HashSet<String> sameNameSet = new HashSet<String>();
                HashSet<String> nameSet = new HashSet<String>();
                while (it.hasNext()) {
                    PersonInfo personInfo = (PersonInfo)it.next();
                    personList.add(personInfo);
                    if (nameSet.contains(personInfo.getName())) {
                        sameNameSet.add(personInfo.getName());
                        continue;
                    }
                    nameSet.add(personInfo.getName());
                }
                FileOutputStream out = null;
                int size = personList.size();
                for (int i = 0; i < size; ++i) {
                    PersonInfo person = (PersonInfo)personList.get(i);
                    try {
                        if (this.rdByName.isSelected()) {
                            out = sameNameSet.contains(person.getName()) ? new FileOutputStream(selectFielPath + "/" + person.getNumber() + "~" + person.getName() + ".jpg") : new FileOutputStream(selectFielPath + "/" + person.getName() + ".jpg");
                        } else if (this.rdByNumber.isSelected()) {
                            out = new FileOutputStream(selectFielPath + "/" + person.getNumber() + ".jpg");
                        }
                        byte[] data = (byte[])map.get(person);
                        out.write(data);
                        out.flush();
                        continue;
                    }
                    catch (FileNotFoundException ex) {
                        SysUtil.abort();
                        ExceptionHandler.handle((Throwable)ex);
                        continue;
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.PERSON_PHOTO_IMPORT_TIP_OUT"));
            }
        }
    }

    private HashMap getPersonPhotoDataBatch(int num, AdminOrgUnitInfo paramAdmin) throws EASBizException, BOSException {
        int i;
        int pageNum = (num - 1) / pageSize;
        HashMap map = this.iPP.getPersonPhotoDataByAdmin(paramAdmin, 0, pageSize);
        for (i = 1; i < pageNum; ++i) {
            map.putAll(this.iPP.getPersonPhotoDataByAdmin(paramAdmin, pageSize * i, pageSize * (i + 1)));
        }
        map.putAll(this.iPP.getPersonPhotoDataByAdmin(paramAdmin, pageSize * i, num));
        return map;
    }

    private void personBatchImport(final File file, final PhotoFilter filter) throws Exception {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                HashMap reMap = PhotoLeadInOrOutTermUI.this.iPP.getPersonDetailInfo();
                PhotoLeadInOrOutTermUI.this.errorPersonList = new ArrayList();
                PhotoLeadInOrOutTermUI.this.searchDirectory(file, filter, reMap);
                if (PhotoLeadInOrOutTermUI.this.rdByName.isSelected() && reMap.get("sameName") != null) {
                    ArrayList sameName = (ArrayList)reMap.get("sameName");
                    PhotoLeadInOrOutTermUI.this.showSameNameDialogue(sameName);
                }
                PhotoLeadInOrOutTermUI.this.showErrorPPUI();
                return null;
            }
        });
        dlg.show();
    }

    private void showSameNameDialogue(ArrayList sameNameList) {
        if (sameNameList.size() > 0) {
            StringBuffer nameStr = new StringBuffer();
            int size = sameNameList.size();
            for (int i = 0; i < size; ++i) {
                if (i == size - 1) {
                    nameStr.append(sameNameList.get(i));
                    continue;
                }
                nameStr.append(sameNameList.get(i) + ",");
            }
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.HAS_SAME_NAME") + nameStr + EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.NOT_IMPORT")));
        }
    }

    private void searchDirectory(File file, PhotoFilter filter, HashMap reMap) throws Exception {
        File[] files = file.listFiles(filter);
        int size = files.length;
        for (int i = 0; i < size; ++i) {
            if (files[i].isFile()) {
                this.insertPersonPhoto(files[i], reMap);
                continue;
            }
            this.searchDirectory(files[i], filter, reMap);
        }
    }

    private void insertPersonPhoto(File file, HashMap reMap) throws Exception {
        ArrayList personList;
        String param = file.getName();
        param = param.substring(0, param.lastIndexOf("."));
        ArrayList sameNameList = (ArrayList)reMap.get("sameNameList");
        if (this.rdByName.isSelected()) {
            ArrayList sameName = null;
            sameName = reMap.get("sameName") == null ? new ArrayList() : (ArrayList)reMap.get("sameName");
            if (sameNameList.contains(param)) {
                sameName.add(param);
                reMap.put("sameName", sameName);
                return;
            }
        }
        if ((personList = (ArrayList)reMap.get("personList")) == null) {
            this.errorPersonList.add("1" + file.getAbsolutePath());
            return;
        }
        PersonInfo person = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        IPerson personfac = PersonFactory.getRemoteInstance();
        ObjectUuidPK userPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPk = null;
        int size = personList.size();
        for (int i = 0; i < size; ++i) {
            person = (PersonInfo)personList.get(i);
            if (this.rdByName.isSelected()) {
                if (param.equals(person.getName())) {
                    orgPk = new ObjectUuidPK(personfac.getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId())).getHrOrgUnit().getId());
                    try {
                        permission.checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "employee_personphoto_batchimport");
                        break;
                    }
                    catch (Exception e) {
                        this.errorPersonList.add("3" + e.getMessage() + "%" + file.getAbsolutePath());
                        return;
                    }
                }
            } else if (this.rdByNumber.isSelected() && param.equals(person.getNumber())) {
                orgPk = new ObjectUuidPK(personfac.getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId())).getHrOrgUnit().getId());
                try {
                    permission.checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "employee_personphoto_batchimport");
                    break;
                }
                catch (Exception e) {
                    this.errorPersonList.add("3" + e.getMessage() + "%" + file.getAbsolutePath());
                    return;
                }
            }
            person = null;
        }
        if (person == null) {
            this.errorPersonList.add("1" + file.getAbsolutePath());
            return;
        }
        try {
            PersonPhotoInfo ppInfo = new PersonPhotoInfo();
            ppInfo.setPerson(person);
            ppInfo.setImageData(HRUtil.convertFileTOBytes((File)file));
            this.iPP.addnew(ppInfo);
        }
        catch (Exception e) {
            this.errorPersonList.add("2" + file.getAbsolutePath());
        }
    }

    private void showErrorPPUI() throws Exception {
        if (this.errorPersonList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.PersonPhoto_Import_Success"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"ERR_LIST", (Object)this.errorPersonList);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(PersonPhotoErrorImpListUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
    }

    private static class PhotoFilter
    implements FileFilter {
        private PhotoFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileUtil.getExtension((File)f);
            if (extension != null) {
                return extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg");
            }
            return false;
        }

        public String getDescription() {
            return "JPEG ( *.jpg;*.jpeg )";
        }
    }
}

