/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.client.EmployeePhoto;
import com.kingdee.eas.hr.emp.client.photoFileFilter;
import com.kingdee.eas.hr.emp.client.photoFileNameFilter;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class PhotoPanel
extends KDPanel {
    private static Logger logger = Logger.getLogger(PhotoPanel.class);
    public static BufferedImage selectImage = null;
    private File selectFile = null;
    private boolean isDelete = false;
    private String oprtStat = null;
    private boolean isHistoryData = false;
    private boolean isSaveCurrent = false;
    private String personID = null;

    public boolean isHistoryData() {
        return this.isHistoryData;
    }

    public void setHistoryData(boolean isHistoryData) {
        this.isHistoryData = isHistoryData;
    }

    public PhotoPanel() {
        this.initial();
    }

    public void setOprtStat(String oprtStat) {
        this.oprtStat = oprtStat;
        this.isDelete = false;
    }

    private void initial() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    PhotoPanel.this.photePanel_mouseClicked(e);
                }
                catch (Exception exc) {
                    logger.error((Object)exc.getMessage());
                }
            }
        });
    }

    protected void photePanel_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.showZoomPhotoDialog();
        } else if (e.getButton() == 3) {
            KDPopupMenu popupMenu = this.CreatePopuMenu();
            this.add((Component)popupMenu);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private KDPopupMenu CreatePopuMenu() {
        KDPopupMenu popuMenu = new KDPopupMenu();
        if (this.oprtStat != null && !this.oprtStat.equals(OprtState.VIEW)) {
            KDMenuItem mItemAdd = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.ADD_NEW_IMAGE"));
            ActionListener lstAdd = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PhotoPanel.this.showZoomPhotoDialog();
                        PhotoPanel.this.isDelete = false;
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage());
                    }
                }
            };
            mItemAdd.addActionListener(lstAdd);
            popuMenu.add((JMenuItem)mItemAdd);
            KDMenuItem mItemDelete = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.DELETE_IMAGE"));
            ActionListener lstDelete = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    selectImage = null;
                    PhotoPanel.this.isDelete = true;
                    try {
                        if (PhotoPanel.this.personID != null) {
                            PersonPhotoFactory.getRemoteInstance().delete("where person = '" + PhotoPanel.this.personID + "'");
                        }
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)e1.getMessage());
                    }
                    catch (BOSException e1) {
                        logger.error((Object)e1.getMessage());
                    }
                    PhotoPanel.this.repaint();
                }
            };
            mItemDelete.addActionListener(lstDelete);
            popuMenu.add((JMenuItem)mItemDelete);
        }
        KDMenuItem mItemSave = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.SAVE_IMAGE"));
        ActionListener lstSave = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (selectImage != null) {
                    PhotoPanel.this.showSaveDialog();
                }
            }
        };
        mItemSave.addActionListener(lstSave);
        popuMenu.add((JMenuItem)mItemSave);
        return popuMenu;
    }

    private void showSaveDialog() {
        KDFileChooser m_chooserSave = new KDFileChooser();
        m_chooserSave.setAcceptAllFileFilterUsed(false);
        m_chooserSave.setFileFilter((FileFilter)new photoFileFilter());
        int result = m_chooserSave.showSaveDialog((Component)((Object)this));
        if (result != 0) {
            return;
        }
        File f = m_chooserSave.getSelectedFile();
    }

    private void showAddImageDialog() throws Exception {
        FileDialog fd = new FileDialog(new Frame(), "", 0);
        fd.setFilenameFilter(new photoFileNameFilter());
        fd.setVisible(true);
        this.selectFile = new File(fd.getDirectory(), fd.getFile());
        selectImage = ImageIO.read(this.selectFile);
        this.repaint();
    }

    private void showZoomPhotoDialog() {
        UIContext map = new UIContext((Object)this);
        map.put((Object)"selectImage", (Object)selectImage);
        map.put((Object)"isSaveCurrent", (Object)this.isSaveCurrent());
        map.put((Object)"personID", (Object)this.getPersonID());
        if (this.oprtStat != null && this.oprtStat.equals(OprtState.VIEW)) {
            map.put((Object)"oprtStat", (Object)OprtState.VIEW);
        }
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(EmployeePhoto.class.getName(), (Map)map);
            curDialog.show();
        }
        catch (UIException ex1) {
            logger.error((Object)ex1.getMessage());
        }
        this.repaint();
    }

    public void paint(Graphics arg0) {
        super.paint(arg0);
        if (!this.isDelete && selectImage != null) {
            arg0.drawImage(selectImage, 0, 0, this.getWidth(), this.getHeight(), null, null);
        } else if (this.oprtStat != null && !this.oprtStat.equals(OprtState.VIEW) && !this.isHistoryData) {
            arg0.drawString(EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"267_PhotoPanel"), 6, 75);
        }
    }

    public BufferedImage getSelectImage() {
        return selectImage;
    }

    public void setSelectImage(BufferedImage image) {
        selectImage = image;
        this.repaint();
    }

    public File getSelectFile() {
        return this.selectFile;
    }

    public boolean isSaveCurrent() {
        return this.isSaveCurrent;
    }

    public void setSaveCurrent(boolean isSaveCurrent) {
        this.isSaveCurrent = isSaveCurrent;
    }

    public String getPersonID() {
        return this.personID;
    }

    public void setPersonID(String personID) {
        this.personID = personID;
    }

    public byte[] getSelectImageBytes() {
        return null;
    }
}

