/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third;

import com.kingdee.bos.openapi.third.AbstractInvoker;
import com.kingdee.bos.openapi.third.DataType;
import com.kingdee.bos.openapi.third.InvokerFactory;
import com.kingdee.bos.openapi.third.OpenApiFactory;
import com.kingdee.bos.openapi.third.OpenApiInfo;
import com.kingdee.bos.openapi.third.exception.BizException;
import com.kingdee.bos.openapi.third.exception.InvokeNetworkException;
import com.kingdee.bos.openapi.third.exception.LoginException;
import com.kingdee.bos.openapi.third.invoker.AbstractLoginContext;
import org.apache.log4j.Logger;

public class OpenApi {
    private static final Logger logger = Logger.getLogger(OpenApi.class);
    private AbstractLoginContext loginCtx = null;
    private volatile AbstractInvoker invoker = null;
    private DataType dataType = DataType.JSON;

    public OpenApi(AbstractLoginContext ctx) {
        this.loginCtx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoke(OpenApiInfo info) throws BizException, LoginException, InvokeNetworkException {
        long t1 = System.currentTimeMillis();
        try {
            if (this.loginCtx == null) {
                logger.error((Object)"loginCtx is null");
                String string = null;
                return string;
            }
            String string = this._invoke(info);
            return string;
        }
        finally {
            long cost = System.currentTimeMillis() - t1;
            if (logger.isDebugEnabled()) {
                String message = "OpenApi invoke cost: " + cost + ",apiInfo: " + info.toString();
                logger.info((Object)message);
            }
        }
    }

    private String _invoke(OpenApiInfo info) throws BizException, LoginException, InvokeNetworkException {
        if (this.invoker == null) {
            this.invoker = InvokerFactory.getInvoker(this.loginCtx.getInvokeType());
        }
        this.invoker.setDataType(this.dataType);
        return this.invoker.invoke(this.loginCtx, info);
    }

    public void closeService() {
        if (this.loginCtx != null && this.invoker != null) {
            try {
                this.invoker.close(this.loginCtx);
            }
            catch (InvokeNetworkException e) {
                logger.error((Object)"close service error", (Throwable)e);
            }
        }
        OpenApiFactory.closeService(this.loginCtx);
    }
}

