/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.app.v2.AbstractADJBaseTableInitDataFacadeControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.AdjSalaryCalculateFacadeFactory;
import com.kingdee.shr.cmpdesign.app.v2.BaseTableInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryDataRecordFactory;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryDataRecordInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADJBaseTableInitDataFacadeControllerBean
extends AbstractADJBaseTableInitDataFacadeControllerBean {
    private static final long serialVersionUID = 316747218070000308L;
    private static final Logger logger = LoggerFactory.getLogger(ADJBaseTableInitDataFacadeControllerBean.class);
    private static final String PRE_SQL = " SELECT distinct ADJUSTEMPORELATION.FID AS ID, PERSON.FID AS PERSONID, HRORGUNIT.FID AS HRORGUNITID, ADMINORG.FID AS ADMINORGID, EMPORGRELATION.FID AS EMPRELATIONID, EMPORGRELATION.fassigntype AS fassigntype, EMPORGRELATION.FPOSITIONID AS POSITIONID FROM T_HR_SAdjustPersonRecord AS PERSONRECORD INNER JOIN T_HR_SAdjustEmpORelation AS ADJUSTEMPORELATION ON ADJUSTEMPORELATION.FPersonRecordID = PERSONRECORD.FID INNER JOIN T_HR_EmpOrgRelation AS EMPORGRELATION ON ADJUSTEMPORELATION.FEmpOrgRelationID = EMPORGRELATION.FID INNER JOIN T_BD_Person AS PERSON ON ADJUSTEMPORELATION.FPersonID = PERSON.FID INNER JOIN T_ORG_HRO AS HRORGUNIT ON PERSONRECORD.FHrOrgUnitID = HRORGUNIT.FID INNER JOIN T_ORG_Admin AS ADMINORG ON EMPORGRELATION.FAdminOrgID = ADMINORG.FID WHERE HRORGUNIT.FID IN (@_ORG_ID) AND ADJUSTEMPORELATION.feffectdate <= @_ENDTIME AND ADJUSTEMPORELATION.fleffectdate >= @_BEGINTIME AND EMPORGRELATION.fissystem = 1 AND EMPORGRELATION.fisinner = 1 AND (@_BILLIDRANGE) AND not exists(  select 1 from T_HR_EmpOrgRelation a  INNER JOIN T_HR_HRBizDefine define on  a.FACTIONID = define.FID   where 1 = 1   and a.fid = EMPORGRELATION.fid  and a.FEFFDT <= @_ENDTIME  and a.FLEFFDT >= @_BEGINTIME  and define.FBIZDEFINETYPE = 4  )ORDER BY ADJUSTEMPORELATION.FID ;";
    private static final String INSERT_DATA_SQL = "insert into @_tablename(fhrorgunitid, fadminorgunitid, fadjustemporelationid, fpositionid, fpersonid, fcalsubmitschemeid, fid)  values (?, ?, ?, ?, ?, ?, ?);";
    private static final int DEFAULT_PAGE_NUM = 2000;

    protected Map<BaseTableInfo, Set<String>> sortDataByHroOrg(Context ctx, Map<String, Set<BaseTableInfo>> ruleHrMapper) throws BOSException, SQLException {
        HashMap<BaseTableInfo, Set<String>> ruleHrResult = new HashMap<BaseTableInfo, Set<String>>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT FID, FLONGNUMBER FROM T_ORG_HRO ORDER BY FLONGNUMBER asc");
        IRowSet rowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        String longNumber = "";
        String hrOrgUnitID = "";
        while (rowSet.next()) {
            longNumber = rowSet.getString("FLONGNUMBER");
            hrOrgUnitID = rowSet.getString("FID");
            Set<BaseTableInfo> adjRuleInfos = this.getRuleIdByLongNumber(longNumber, ruleHrMapper);
            if (adjRuleInfos.size() == 0) continue;
            for (BaseTableInfo rule : adjRuleInfos) {
                Set hrOrgUnitIds = ruleHrResult.containsKey(rule) ? (Set)ruleHrResult.get(rule) : new HashSet();
                hrOrgUnitIds.add(hrOrgUnitID);
                ruleHrResult.put(rule, hrOrgUnitIds);
            }
        }
        return ruleHrResult;
    }

    protected boolean isGeneraRunning(Context ctx) throws BOSException {
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)false));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date zero = calendar.getTime();
            filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)zero, CompareType.GREATER));
            return AdjustSalaryDataRecordFactory.getLocalInstance(ctx).exists(filter);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected String insertRecordData(Context ctx) throws BOSException {
        String insertSQL = "insert into T_HR_SAdjustSalaryDataRecord(FStatus, FCreatorID, FCreateTime, FID) values (?, ?, now(), ?);";
        String recordId = BOSUuid.create((String)"56EE3E5F").toString();
        int status = 0;
        String creatorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Object[] params = new Object[]{status, creatorId, recordId};
        DbUtil.execute((Context)ctx, (String)insertSQL, (Object[])params);
        return recordId;
    }

    @Override
    protected void _generateData(Context ctx, int rowsPerPage) throws BOSException {
        this.realGenerateData(ctx, rowsPerPage, null, null, null);
    }

    protected void realGenerateData(Context ctx, int rowsPerPage, String adjustSalaryRuleId, String selectedIds, String fids) throws BOSException {
        String recordId;
        logger.info("ADJBaseTableInitDataFacadeControllerBean _generateData start " + rowsPerPage);
        if (rowsPerPage <= 0) {
            rowsPerPage = 2000;
        }
        if (StringUtils.isEmpty((String)(recordId = this.insertRecordData(ctx)))) {
            return;
        }
        Map<BaseTableInfo, Set<String>> ruleHrResult = null;
        try {
            Map<String, Set<BaseTableInfo>> ruleHrMapper = this.getNeedGenerateData(ctx, adjustSalaryRuleId);
            if (ruleHrMapper.size() == 0) {
                return;
            }
            ruleHrResult = this.sortDataByHroOrg(ctx, ruleHrMapper);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (ruleHrResult == null || ruleHrResult.size() < 0) {
            return;
        }
        Iterator<Map.Entry<BaseTableInfo, Set<String>>> resultIterator = ruleHrResult.entrySet().iterator();
        String errorMsg = "";
        while (resultIterator.hasNext()) {
            HashMap recordInfo = new HashMap();
            Map.Entry<BaseTableInfo, Set<String>> nextEntry = resultIterator.next();
            BaseTableInfo baseTableInfo = nextEntry.getKey();
            String baseTableName = baseTableInfo.getTableName();
            try {
                String beginDate = baseTableInfo.getBeginDate();
                String endDate = baseTableInfo.getEndDate();
                Set<String> hrOrgIdSet = nextEntry.getValue();
                String hrOrgIdSqlString = CmpStrUtil.convertSetToSqlString(hrOrgIdSet);
                String reaSQL = PRE_SQL.replaceAll("@_ORG_ID", hrOrgIdSqlString).replaceAll("@_BEGINTIME", beginDate).replaceAll("@_ENDTIME", endDate);
                String billIdCondition = "";
                billIdCondition = StringUtils.isEmpty((String)selectedIds) ? "1 = 1" : "ADJUSTEMPORELATION.FID in (" + CmpStrUtil.converStringToSqlString((String)selectedIds, (String)",") + ")";
                reaSQL = reaSQL.replace("@_BILLIDRANGE", billIdCondition);
                List<Object[]> paramsList = this.generateInsertData(ctx, hrOrgIdSet, baseTableInfo, reaSQL, rowsPerPage);
                logger.info("_generateData paramsList.size " + paramsList.size());
                if (paramsList == null || paramsList.size() <= 0) continue;
                String insertSQL = INSERT_DATA_SQL.replaceAll("@_tablename", baseTableName);
                logger.info("_generateData insertSQL " + insertSQL);
                this.executeBatchInsert(ctx, insertSQL, paramsList, baseTableName, selectedIds, fids);
            }
            catch (BOSException e) {
                errorMsg = e.getMessage();
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                errorMsg = e.getMessage();
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                errorMsg = e.getMessage();
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.calculate(ctx, baseTableInfo, selectedIds);
        }
        this.deleteAdjSalaryApplyJunkData(ctx, ruleHrResult);
        this.deleteNoReferebceSubmitBillEntry(ctx);
        this.updateRecordDataStatus(ctx, recordId);
    }

    @Override
    protected void _refreshGenerateData(Context ctx, Map param) throws BOSException {
        String adjSalaryRuldId = String.valueOf(param.get("adjSalaryRuldId"));
        String selectedIds = String.valueOf(param.get("billIds"));
        String fids = String.valueOf(param.get("fids"));
        if (StringUtils.isEmpty((String)adjSalaryRuldId) && StringUtils.isEmpty((String)selectedIds)) {
            return;
        }
        this.realGenerateData(ctx, 2000, adjSalaryRuldId, selectedIds, fids);
    }

    protected void updateRecordDataStatus(Context ctx, String recordId) {
        if (StringUtils.isEmpty((String)recordId)) {
            return;
        }
        AdjustSalaryDataRecordInfo info = new AdjustSalaryDataRecordInfo();
        info.setId(BOSUuid.read((String)recordId));
        info.setStatus(true);
        info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        SelectorItemCollection selector = new SelectorItemCollection();
        try {
            selector.add(new SelectorItemInfo("status"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            AdjustSalaryDataRecordFactory.getLocalInstance(ctx).updatePartial(info, selector);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void calculate(Context ctx, BaseTableInfo baseTableInfo, String selectedIds) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("CALTYPE", "0");
        param.put("calSchemeID", baseTableInfo.getSchemeID());
        String conditionSql = "";
        conditionSql = StringUtils.isEmpty((String)selectedIds) ? "select fid from " + baseTableInfo.getTableName() : "select fid from " + baseTableInfo.getTableName() + " WHERE FADJUSTEMPORELATIONID IN (" + CmpStrUtil.converStringToSqlString((String)selectedIds, (String)",") + ")";
        try {
            param.put("condition", conditionSql);
            AdjSalaryCalculateFacadeFactory.getLocalInstance(ctx).calculate(param);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected List<Object[]> generateInsertData(Context ctx, Set<String> hrOrgNumberSet, BaseTableInfo baseTableInfo, String reaSQL, int pageSize) throws BOSException, SQLException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String adjustSalaryRuleID = baseTableInfo.getSchemeID();
        String countSQL = "SELECT COUNT(*) counts " + reaSQL.substring(reaSQL.indexOf("FROM"), reaSQL.indexOf("ORDER"));
        logger.info("generateInsertData countSQL : " + countSQL);
        IRowSet rowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)countSQL);
        int rowTotalSize = 0;
        while (rowSet.next()) {
            rowTotalSize = rowSet.getInt("counts");
        }
        if (rowTotalSize <= 0) {
            return paramsList;
        }
        int totalPage = 1;
        if (rowTotalSize > pageSize) {
            totalPage = rowTotalSize / pageSize + 1;
        }
        int length = pageSize;
        PagingHelper pageHelper = new PagingHelper();
        String pagingSQL = "";
        String adjuestEmpOrelationId = "";
        String personId = "";
        String hroOrgId = "";
        String adminOrgId = "";
        String positionId = "";
        for (int curPage = 1; curPage < totalPage + 1; ++curPage) {
            if (curPage * pageSize > rowTotalSize) {
                length = rowTotalSize - (curPage - 1) * pageSize;
            }
            pagingSQL = pageHelper.getPagingSqlNoOptmize(ctx, reaSQL, (curPage - 1) * pageSize, length);
            logger.info("generateInsertData pagingSQL : " + pagingSQL);
            IRowSet executeDataSet = SqlUtil.executeQuery((Context)ctx, (String)pagingSQL, (ParamData)pageHelper.getParamData());
            if (executeDataSet == null) continue;
            while (executeDataSet.next()) {
                BOSUuid bosUuid = BOSUuid.create((String)"11436768");
                adjuestEmpOrelationId = executeDataSet.getString("ID");
                personId = executeDataSet.getString("PERSONID");
                hroOrgId = executeDataSet.getString("HRORGUNITID");
                adminOrgId = executeDataSet.getString("ADMINORGID");
                positionId = executeDataSet.getString("POSITIONID");
                Object[] params = new Object[]{hroOrgId, adminOrgId, adjuestEmpOrelationId, positionId, personId, adjustSalaryRuleID, bosUuid.toString()};
                paramsList.add(params);
            }
        }
        return paramsList;
    }

    protected Set<BaseTableInfo> getRuleIdByLongNumber(String longNumber, Map<String, Set<BaseTableInfo>> ruleHrMapper) {
        HashSet<BaseTableInfo> result = new HashSet<BaseTableInfo>();
        Set<Map.Entry<String, Set<BaseTableInfo>>> entrySet = ruleHrMapper.entrySet();
        Iterator<Map.Entry<String, Set<BaseTableInfo>>> iterator = entrySet.iterator();
        String tempNumber = "";
        while (iterator.hasNext()) {
            Map.Entry<String, Set<BaseTableInfo>> tempEntry = iterator.next();
            tempNumber = tempEntry.getKey();
            if (!longNumber.startsWith(tempNumber)) continue;
            result.addAll((Collection<BaseTableInfo>)tempEntry.getValue());
        }
        return result;
    }

    public void executeBatchInsert(Context ctx, String sql, List<Object[]> paramsList, String tablename, String selectedIds, String fids) throws BOSException {
        String deleteSql = "";
        deleteSql = StringUtils.isEmpty((String)selectedIds) ? "DELETE FROM " + tablename + ";" : "DELETE FROM " + tablename + " WHERE FID IN (" + CmpStrUtil.converStringToSqlString((String)fids, (String)",") + ");";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    protected void deleteAdjSalaryApplyJunkData(Context ctx, Map<BaseTableInfo, Set<String>> ruleHrResult) {
        Set<BaseTableInfo> tableSet = ruleHrResult.keySet();
        Iterator<BaseTableInfo> iterator = tableSet.iterator();
        String delSql = "delete from {0} where FBILLID in (select fid from T_HR_sAdjustSalaryApply where fadjustsalaryruleid is null or fnumber is null) or FBILLID not in (select fid from T_HR_sAdjustSalaryApply)";
        while (iterator.hasNext()) {
            BaseTableInfo tableInfo = iterator.next();
            String tableName = tableInfo.getTableName();
            try {
                DbUtil.execute((Context)ctx, (String)MessageFormat.format(delSql, tableName.toUpperCase(Locale.ENGLISH).replace("T_HR_SADJBASETABLE", "T_HR_SADJAPPLYENTRY")));
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            DbUtil.execute((Context)ctx, (String)" delete from T_HR_sAdjustSalaryApply where fadjustsalaryruleid is null or fnumber is null");
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Set<BaseTableInfo>> getNeedGenerateData(Context ctx, String adjustSalaryRuleId) throws BOSException, SQLException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ");
        sqlBuffer.append(" scheme.FID adjRuleID, hro.FID HROID, hro.FLONGNUMBER hrOLongNum, ");
        sqlBuffer.append(" rel.fadjustbasetablename baseTableName, ");
        sqlBuffer.append(" frunEndTimeType,frunEndTime,pla.FRelativePeriodType,pla.FBeginDate,pla.FEndDate ");
        sqlBuffer.append(" FROM T_HR_SCalSubmitScheme scheme ");
        sqlBuffer.append(" INNER JOIN T_HR_SAdjustSalaryPlan pla on pla.fadjustsalaryruleid = scheme.fid ");
        sqlBuffer.append(" INNER JOIN T_ORG_HRO hro on scheme.FHRORGUNITID = hro.FID  ");
        sqlBuffer.append(" INNER JOIN T_HR_SAdjSalaryTableRelation rel on scheme.FID = rel.fadjustsalaryrule ");
        sqlBuffer.append(" where ");
        sqlBuffer.append(" scheme.fsubmitSchemeType = ").append(3);
        sqlBuffer.append(" and scheme.FSTATE = ").append(1);
        if (!StringUtils.isEmpty((String)adjustSalaryRuleId)) {
            sqlBuffer.append(" and scheme.FID = ").append("'").append(adjustSalaryRuleId).append("'");
        }
        HashMap<String, Set<BaseTableInfo>> ruleHrMapper = new HashMap<String, Set<BaseTableInfo>>();
        IRowSet rowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        String adjustSalaryRuleID = "";
        String hrLongNumber = "";
        String hroId = "";
        String baseTableName = "";
        String beginDate = "";
        String endDate = "";
        Date nowDate = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(nowDate);
        instance.set(11, 23);
        instance.set(12, 59);
        instance.set(13, 59);
        instance.set(14, 999);
        String nowDateStr = CmpDateUtil.toKSqlDate((Date)instance.getTime());
        while (rowSet.next()) {
            adjustSalaryRuleID = rowSet.getString("adjRuleID");
            hrLongNumber = rowSet.getString("hrOLongNum");
            hroId = rowSet.getString("HROID");
            baseTableName = rowSet.getString("baseTableName");
            String runEndTimeType = rowSet.getString("frunEndTimeType");
            if ("1".equals(runEndTimeType)) {
                beginDate = endDate = nowDateStr;
            } else if ("2".equals(runEndTimeType)) {
                beginDate = endDate = CmpDateUtil.toKSqlDate((Date)rowSet.getDate("frunEndTime"));
            } else if ("3".equals(runEndTimeType)) {
                int relativePeriodType = rowSet.getInt("FRelativePeriodType");
                beginDate = CmpDateUtil.toKSqlDate((Date)rowSet.getDate("FBeginDate"));
                endDate = CmpDateUtil.toKSqlDate((Date)rowSet.getDate("FEndDate"));
                String beginAndEnd = this.getBeginAndEndDateByPeroid(relativePeriodType, beginDate, endDate);
                beginDate = beginAndEnd.split("_")[0];
                endDate = beginAndEnd.split("_")[1];
            } else {
                beginDate = endDate = nowDateStr;
            }
            BaseTableInfo tableInfo = new BaseTableInfo(adjustSalaryRuleID, hroId, baseTableName, beginDate, endDate);
            Set adjRuleInfos = ruleHrMapper.containsKey(hrLongNumber) ? (Set)ruleHrMapper.get(hrLongNumber) : new HashSet();
            adjRuleInfos.add(tableInfo);
            ruleHrMapper.put(hrLongNumber, adjRuleInfos);
        }
        return ruleHrMapper;
    }

    private String getBeginAndEndDateByPeroid(int relativePeriodType, String beginDate, String endDate) {
        Date nowDate = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(nowDate);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        int quarter = instance.get(2) / 3 + 1;
        switch (relativePeriodType) {
            case 20: {
                instance.set(5, 1);
                beginDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                instance.set(5, instance.getActualMaximum(5));
                endDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                break;
            }
            case 30: {
                instance.add(2, -1);
                instance.set(5, 1);
                beginDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                instance.set(5, instance.getActualMaximum(5));
                endDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                break;
            }
            case 40: {
                instance.add(2, -2);
                instance.set(5, 1);
                beginDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                instance.add(2, 2);
                instance.set(5, instance.getActualMaximum(5));
                endDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                break;
            }
            case 50: {
                instance.add(2, -5);
                instance.set(5, 1);
                beginDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                instance.add(2, 5);
                instance.set(5, instance.getActualMaximum(5));
                endDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                break;
            }
            case 60: {
                instance.set(2, 0);
                instance.set(5, 1);
                beginDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                instance.set(2, 11);
                instance.set(5, instance.getActualMaximum(5));
                endDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                break;
            }
            case 70: {
                instance.add(1, -1);
                instance.set(2, 0);
                instance.set(5, 1);
                beginDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                instance.set(2, 11);
                instance.set(5, instance.getActualMaximum(5));
                endDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                break;
            }
            case 80: {
                instance.set(2, (quarter - 1) * 3);
                instance.set(5, 1);
                beginDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                instance.set(2, quarter * 3 - 1);
                instance.set(5, instance.getActualMaximum(5));
                endDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                break;
            }
            case 90: {
                instance.set(2, (quarter - 1) * 3);
                instance.add(2, -3);
                instance.set(5, 1);
                beginDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
                instance.add(2, 2);
                instance.set(5, instance.getActualMaximum(5));
                endDate = CmpDateUtil.toKSqlDate((Date)instance.getTime());
            }
        }
        return beginDate + "_" + endDate;
    }

    protected void deleteNoReferebceSubmitBillEntry(Context ctx) {
        String sql = "SELECT fbillentrytablename FROM T_HR_SCalShemeTableRelation";
        try {
            String relDeleteSql;
            IRowSet rowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)sql);
            String deleteSql = "DELETE FROM {0} entry WHERE NOT EXISTS (SELECT 1 FROM T_HR_SBatchSubmitShemeBill bill WHERE entry.FBillId = bill.FID)";
            while (rowSet.next()) {
                String entryTableName = rowSet.getString("fbillentrytablename");
                relDeleteSql = MessageFormat.format(deleteSql, entryTableName);
                CmpSQLUtil.execute((Context)ctx, (String)relDeleteSql);
            }
            relDeleteSql = MessageFormat.format(deleteSql, "T_HR_SchemeBillEntry");
            CmpSQLUtil.execute((Context)ctx, (String)relDeleteSql);
        }
        catch (BOSException e) {
            logger.error("\u6e05\u9664\u63d0\u62a5\u5355\u5206\u5f55\u65e0\u5f15\u7528\u6570\u636e\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
        }
        catch (SQLException e) {
            logger.error("\u6e05\u9664\u63d0\u62a5\u5355\u5206\u5f55\u65e0\u5f15\u7528\u6570\u636e\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
        }
    }
}

