/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.app.v2.AbstractAdjSalaryCalculateFacadeControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemCollection;
import com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemFactory;
import com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemInfo;
import com.kingdee.shr.cmpdesign.exception.AdjustBillException;
import com.kingdee.shr.cmpdesign.util.AdjustSalaryUtils;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.SalaryCalculatorProxy2;
import com.kingdee.shr.validaterule.formula.SalayCalculatorMgr2;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AdjSalaryCalculateFacadeControllerBean
extends AbstractAdjSalaryCalculateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.cmpdesign.app.v2.AdjSalaryCalculateFacadeControllerBean");

    @Override
    protected Map _calculate(Context ctx, Map param) throws BOSException, EASBizException {
        String calType = (String)param.get("CALTYPE");
        String calSchemeID = (String)param.get("calSchemeID");
        String condition = (String)param.get("condition");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select frunEndTimeType,frunEndTime from T_HR_SAdjustSalaryPlan where fadjustsalaryruleid = '").append(calSchemeID).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        String runEndTimeType = "";
        Date endDate = new Date();
        try {
            while (rowSet.next()) {
                runEndTimeType = rowSet.getString("frunEndTimeType");
                if ("1".equals(runEndTimeType)) {
                    endDate = new Date();
                    continue;
                }
                if ("2".equals(runEndTimeType)) {
                    endDate = new Date(rowSet.getDate("frunEndTime").getTime());
                    continue;
                }
                endDate = new Date();
            }
        }
        catch (SQLException e) {
            endDate = new Date();
        }
        String mainTable = this.getMainTable(ctx, calSchemeID, calType);
        BaseFormulaCollection formulaCollection = "2".equals(calType) ? new BaseFormulaCollection() : this.initCalFormula(ctx, calSchemeID, calType, mainTable);
        formulaCollection = this.addVerificationRule(ctx, calSchemeID, formulaCollection, mainTable, calType);
        if (null == formulaCollection || formulaCollection.size() == 0) {
            return null;
        }
        this.post(ctx, mainTable, calSchemeID, formulaCollection, condition, endDate);
        return null;
    }

    protected String getMainTable(Context ctx, String calSchemeID, String calType) throws BOSException {
        if ("0".equals(calType)) {
            return AdjustSalaryUtils.getCalShemeBaseTableName(ctx, calSchemeID);
        }
        if ("1".equals(calType) || "2".equals(calType)) {
            return AdjustSalaryUtils.getCalShemeTableName(ctx, calSchemeID);
        }
        return AdjustSalaryUtils.getCalShemeBaseTableName(ctx, calSchemeID);
    }

    protected BaseFormulaCollection initCalFormula(Context ctx, String calSchemeID, String calType, String mainTable) throws BOSException, EASBizException {
        BaseFormulaCollection formulaCollection = null;
        BaseFormulaCollection realFormulaColl = new BaseFormulaCollection();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select id,name,calItem,express,listItem,listFunc,listVar,listTable,sortSn,bigExpress ");
        sqlBuffer.append(" where isCal = 1 and businessRelationConfig.businessId = '").append(calSchemeID).append("' \r\n");
        sqlBuffer.append(" order by sortSn");
        try {
            formulaCollection = BaseFormulaFactory.getLocalInstance((Context)ctx).getBaseFormulaCollection(sqlBuffer.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new AdjustBillException(AdjustBillException.GETFORMULAERR, e);
        }
        if ("0".equals(calType)) {
            realFormulaColl = formulaCollection;
        } else if ("1".equals(calType)) {
            String baseTableName = AdjustSalaryUtils.getCalShemeBaseTableName(ctx, calSchemeID);
            sqlBuffer = new StringBuffer();
            sqlBuffer.append(" select id,isAdjustRuleShow,calSubmitScheme.id,adjustSalaryItem.id,adjustSalaryItem.fieldSn,adjustSalaryItem.dataType ");
            sqlBuffer.append(" where isAdjustRuleShow = ").append(1);
            sqlBuffer.append(" and calSubmitScheme.id = '").append(calSchemeID).append("'");
            BatchAdjustRuleItemCollection batchAdjustRuleItemCollection = BatchAdjustRuleItemFactory.getLocalInstance(ctx).getBatchAdjustRuleItemCollection(sqlBuffer.toString());
            HashSet<String> billShowSet = new HashSet<String>();
            int size = batchAdjustRuleItemCollection.size();
            for (int i = 0; i < size; ++i) {
                BatchAdjustRuleItemInfo batchAdjustRuleItemInfo = batchAdjustRuleItemCollection.get(i);
                billShowSet.add("S" + batchAdjustRuleItemInfo.getAdjustSalaryItem().getFieldSn());
            }
            String express = "";
            String listItem = "";
            String item = "";
            String bigExpress = "";
            int size2 = formulaCollection.size();
            block3: for (int i = 0; i < size2; ++i) {
                String[] itemListArr;
                BaseFormulaInfo verificationRule = formulaCollection.get(i);
                express = verificationRule.getExpress();
                bigExpress = verificationRule.getBigExpress();
                express = StringUtils.isEmpty((CharSequence)express) ? null : express.replace(baseTableName, mainTable);
                bigExpress = StringUtils.isEmpty((CharSequence)bigExpress) ? null : bigExpress.replace(baseTableName, mainTable);
                verificationRule.setExpress(express);
                verificationRule.setBigExpress(bigExpress);
                listItem = verificationRule.getListItem();
                listItem = StringUtils.isEmpty((CharSequence)listItem) ? null : listItem.replace(baseTableName, mainTable);
                verificationRule.setListItem(listItem);
                if (StringUtils.isEmpty((CharSequence)listItem) && !StringUtils.isEmpty((CharSequence)verificationRule.getListVar())) {
                    realFormulaColl.add(verificationRule);
                    continue;
                }
                for (String itemList : itemListArr = StringUtils.isEmpty((CharSequence)listItem) ? new String[]{} : listItem.split(";")) {
                    item = itemList.split("~")[2];
                    if (!billShowSet.contains(item)) continue;
                    realFormulaColl.add(verificationRule);
                    continue block3;
                }
            }
        }
        return realFormulaColl;
    }

    protected BaseFormulaCollection addVerificationRule(Context ctx, String calSchemeID, BaseFormulaCollection realFormulaColl, String mainTable, String calType) throws BOSException {
        BaseFormulaInfo verificationRule;
        StringBuffer sqlBuffer = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" SELECT D.FID,B.FNAME_").append(language).append(" NAME,D.FEXPRESS,D.FBIGEXPRESS,D.FLISTITEM,D.FLISTFUNC,D.FLISTVAR \r\n");
        sqlBuffer.append(" FROM T_HR_SADJVERIFICATIONRULE A \r\n");
        sqlBuffer.append(" INNER JOIN T_HR_SVERIFICATIONRULE B ON A.FVERIFICATIONRULEID = B.FID \r\n");
        sqlBuffer.append(" INNER JOIN T_HR_SBUSINESSRELATIONCONFIG C ON B.FID = C.FBUSINESSID \r\n");
        sqlBuffer.append(" INNER JOIN T_HR_SBASEFORMULA D ON D.FBUSINESSRELATIONCONFIGID = C.FID \r\n");
        sqlBuffer.append(" WHERE A.FADJUSTSALARYRULEID = '").append(calSchemeID).append("' \r\n");
        sqlBuffer.append("   AND exists ( ");
        sqlBuffer.append("    select 1 from T_HR_SAdjVerificationRuleRel r ");
        sqlBuffer.append("     inner join T_HR_SVerificationRuleNode n on r.FVerificationRuleNodeID = n.fid ");
        sqlBuffer.append("     where r.FVerificationRuleID = a.FID ");
        if ("0".equalsIgnoreCase(calType)) {
            sqlBuffer.append(" and n.fnumber='AdjBaseTable-Refresh' ");
        } else if ("1".equalsIgnoreCase(calType) || "2".equalsIgnoreCase(calType)) {
            sqlBuffer.append(" and n.fnumber='AdjSalaryBill-Verification' ");
        }
        sqlBuffer.append("   ) ");
        sqlBuffer.append(" ORDER BY A.FSORTCODE \r\n");
        IRowSet rowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        StringBuffer expressBuf = new StringBuffer();
        expressBuf.append(mainTable).append("_forwarncontent = \"\" ");
        StringBuffer listVarBuf = new StringBuffer();
        int index = 0;
        int size = rowSet.size();
        try {
            String id = "";
            String name = "";
            String express = "";
            String bigExpress = "";
            String listItem = "";
            String listFunc = "";
            String listVar = "";
            String var = "";
            while (rowSet.next()) {
                id = rowSet.getString("FID");
                name = rowSet.getString("NAME");
                express = rowSet.getString("FEXPRESS");
                bigExpress = rowSet.getString("FBIGEXPRESS");
                express = null != express && express.contains("T_HR_SAdjustSalaryApplyEntry") ? express.replace("T_HR_SAdjustSalaryApplyEntry", mainTable) : express;
                bigExpress = null != bigExpress && bigExpress.contains("T_HR_SAdjustSalaryApplyEntry") ? bigExpress.replace("T_HR_SAdjustSalaryApplyEntry", mainTable) : bigExpress;
                listItem = rowSet.getString("FLISTITEM");
                listItem = null != listItem && listItem.contains("T_HR_SAdjustSalaryApplyEntry") ? listItem.replace("T_HR_SAdjustSalaryApplyEntry", mainTable) : listItem;
                listFunc = rowSet.getString("FLISTFUNC");
                listVar = rowSet.getString("FLISTVAR");
                verificationRule = new BaseFormulaInfo();
                verificationRule.setId(BOSUuid.read((String)id));
                verificationRule.setName(name);
                verificationRule.setExpress(express);
                verificationRule.setBigExpress(bigExpress);
                verificationRule.setListItem(listItem);
                verificationRule.setListFunc(listFunc);
                verificationRule.setListVar(listVar);
                var = listVar.split("~")[2].substring(1);
                expressBuf.append(" + (\"\".equals(").append(var).append(") ? \"\" : (").append(var);
                if (index < size - 1) {
                    expressBuf.append(" + \";\"");
                }
                expressBuf.append("))");
                listVarBuf.append(";").append(listVar);
                ++index;
                realFormulaColl.add(verificationRule);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        verificationRule = new BaseFormulaInfo();
        verificationRule.setName(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryApplyResource", (String)"label24", (Locale)ctx.getLocale()));
        verificationRule.setCalItem("forwarncontent");
        verificationRule.setListItem("String~" + mainTable + "~forwarncontent");
        if (index > 0) {
            verificationRule.setListVar(listVarBuf.toString().replaceFirst(";", ""));
        }
        expressBuf.append(";");
        verificationRule.setExpress(expressBuf.toString());
        realFormulaColl.add(verificationRule);
        return realFormulaColl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void post(Context ctx, String mainTable, String calSchemeID, BaseFormulaCollection formulaCollection, String condition, Date endDate) {
        SalaryCalculator2 cal = new SalaryCalculator2();
        SalayCalculatorMgr2.addTask((SalaryCalculator2)cal);
        String uid = cal.getUID();
        try {
            SalaryCalculatorProxy2 cal2 = new SalaryCalculatorProxy2(uid, true);
            cal2.setMainTableName(mainTable);
            cal2.setMainTableAlias("CMP_SMT001");
            cal2.setCalCategoryNum("CMP_ADJ_001");
            cal2.setSchemeID(calSchemeID);
            cal2.setCtx(ctx);
            cal2.setEndDate(endDate);
            cal2.setCalFormulaColl(formulaCollection);
            cal2.setMainTableRowFilter(condition);
            cal2.post();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            SalayCalculatorMgr2.removeTask((String)uid, (String)"");
        }
    }
}

