/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.v2.notice.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.baseconfig.QueryConfigCollection;
import com.kingdee.shr.baseconfig.QueryConfigFactory;
import com.kingdee.shr.baseconfig.QueryConfigFieldCollection;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.QueryConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyFactory;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjSalaryNoticeConfirmType;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeBillCollection;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeBillFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeBillInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryCollection;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeException;
import com.kingdee.shr.cmpdesign.app.v2.notice.CommonFieldType;
import com.kingdee.shr.cmpdesign.app.v2.notice.ConfirmStateEnum;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeParamFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeParamInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateCFieldCollection;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateCFieldFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateCFieldInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.TimeUnitEnum;
import com.kingdee.shr.cmpdesign.filter.AdjustPermFilter;
import com.kingdee.shr.cmpdesign.util.AdjustSalaryUtils;
import com.kingdee.shr.compensation.AdjustEmpORelationCollection;
import com.kingdee.shr.compensation.AdjustEmpORelationFactory;
import com.kingdee.shr.compensation.AdjustEmpORelationInfo;
import com.kingdee.shr.compensation.app.config.CloudHubMessageConfigInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateCollection;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateFactory;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateInfo;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oadd.org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class NoticeDaoUtils {
    private static final Logger LOG = Logger.getLogger(NoticeDaoUtils.class);

    public static NoticeParamInfo getNoticeParamInfo(Context ctx) throws BOSException {
        NoticeParamInfo paramInfo;
        ObjectUuidPK uuidPK = new ObjectUuidPK("krnQEnH9Yk2E6ILPfnm9iyWj6Rs=");
        try {
            paramInfo = NoticeParamFactory.getLocalInstance(ctx).getNoticeParamInfo((IObjectPK)uuidPK);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return paramInfo;
    }

    public static AdjustSalaryApplyInfo getAdjBillInfo(Context ctx, String adjBillId) throws EASBizException, BOSException {
        String oql = "select id,hrOrgUnit.id, adjustSalaryRule.id, adjustSalaryRule.noticeTemplate.id, adjustSalaryRule.noticeTemplate.historyRelate.id where id = '" + adjBillId + "'";
        return AdjustSalaryApplyFactory.getLocalInstance(ctx).getAdjustSalaryApplyInfo(oql);
    }

    public static AdjustSalaryNoticeBillInfo getNoticeBillInfo(Context ctx, String adjBillId) throws EASBizException, BOSException {
        String oql = "select id, adjBill.id where adjBill.id='" + adjBillId + "' and (isRemove<>1 or isRemove is null)";
        AdjustSalaryNoticeBillCollection col = AdjustSalaryNoticeBillFactory.getLocalInstance(ctx).getAdjustSalaryNoticeBillCollection(oql);
        return col.size() > 0 ? col.get(0) : null;
    }

    public static AdjustSalaryNoticeBillInfo getNoticeBillInfoById(Context ctx, String billId) throws EASBizException, BOSException {
        String oql = "select id, adjBill.id, adjBill.hrOrgUnit.id where id='" + billId + "' ";
        AdjustSalaryNoticeBillCollection col = AdjustSalaryNoticeBillFactory.getLocalInstance(ctx).getAdjustSalaryNoticeBillCollection(oql);
        return col.size() > 0 ? col.get(0) : null;
    }

    public static AdjustSalaryNoticeBillCollection getNoticeBillColById(Context ctx, String billIds) throws EASBizException, BOSException {
        String oql = "select id, adjBill.id, adjBill.hrOrgUnit.id where id in " + CmpStrUtil.buildInSql((String)billIds);
        AdjustSalaryNoticeBillCollection col = AdjustSalaryNoticeBillFactory.getLocalInstance(ctx).getAdjustSalaryNoticeBillCollection(oql);
        return col;
    }

    public static List<Map<String, Object>> assembleAdjEntryData(Context ctx, String billId) throws BOSException, EASBizException {
        AdjustSalaryApplyInfo billInfo = NoticeDaoUtils.getAdjBillInfo(ctx, billId);
        String adjustSalaryRuleId = billInfo.getAdjustSalaryRule().getId().toString();
        String billEntryTableName = AdjustSalaryUtils.getCalShemeTableName(ctx, adjustSalaryRuleId);
        Map<String, Object> entryMap = AdjustSalaryUtils._getBillColumnListAndBillEntryTableName(ctx, adjustSalaryRuleId, true);
        List colNames = (List)entryMap.get("colNames");
        boolean existAdjReason = AdjustSalaryUtils.checkAdjustReason(ctx, adjustSalaryRuleId);
        return AdjustSalaryUtils.assembleAdjBaseTableData(ctx, billEntryTableName, null, billId.toString(), colNames, existAdjReason);
    }

    public static List<Map<String, Object>> assembleExtendNoticeEntryData(Context ctx, List<Map<String, Object>> adjEntryData) throws BOSException {
        if (adjEntryData == null || adjEntryData.isEmpty()) {
            return adjEntryData;
        }
        List empId = adjEntryData.stream().map(entry -> entry.get("FAdjustEmpORelationID").toString()).collect(Collectors.toList());
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String empIdInSql = cmpInSql.createInSqlBaseOnFId(ctx, empId);
        AdjustEmpORelationCollection empIdCol = AdjustEmpORelationFactory.getLocalInstance((Context)ctx).getAdjustEmpORelationCollection("select id, useDefault, personRecord.id where id in " + empIdInSql);
        HashMap<String, Boolean> empIdMap = new HashMap<String, Boolean>();
        HashMap<String, String> recordIdMap = new HashMap<String, String>();
        if (empIdCol.isEmpty()) {
            return adjEntryData;
        }
        for (int i = 0; i < empIdCol.size(); ++i) {
            AdjustEmpORelationInfo empInfo = empIdCol.get(i);
            empIdMap.put(empInfo.getId().toString(), empInfo.isUseDefault());
            if (empInfo.getPersonRecord() == null || empInfo.getPersonRecord().getId() == null) continue;
            recordIdMap.put(empInfo.getId().toString(), empInfo.getPersonRecord().getId().toString());
        }
        adjEntryData.forEach(entry -> {
            if (entry.get("FAdjustEmpORelationID") != null && !StringUtils.isEmpty((CharSequence)entry.get("FAdjustEmpORelationID").toString())) {
                entry.put("useDefault", empIdMap.get(entry.get("FAdjustEmpORelationID").toString()));
                entry.put("FPersonRecordId", recordIdMap.get(entry.get("FAdjustEmpORelationID").toString()));
            }
        });
        return adjEntryData;
    }

    public static Map<String, Integer> queryNoticeEntryCount(Context ctx, List<String> billIds, String filterSql) throws BOSException, SQLException {
        HashMap<String, Integer> entryCountMap = new HashMap<String, Integer>();
        if (billIds == null || billIds.isEmpty()) {
            return entryCountMap;
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String billIdInSql = cmpInSql.createInSqlBaseOnFId(ctx, billIds);
        StringBuilder queryCountSql = new StringBuilder();
        queryCountSql.append("SELECT FNoticeBillId, count(fid) entryCount FROM T_HR_SAdjustSalaryNoticeEntry where  FNoticeBillId in ").append(billIdInSql);
        if (!StringUtils.isEmpty((CharSequence)filterSql)) {
            queryCountSql.append(filterSql);
        }
        queryCountSql.append(" group by FNoticeBillId");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryCountSql.toString());
        while (rs.next()) {
            entryCountMap.put(rs.getString("FNoticeBillId"), rs.getInt("entryCount"));
        }
        return entryCountMap;
    }

    public static void resetEntryData(Context ctx, String billIds, String entryIds, boolean confirmAuth) throws BOSException {
        billIds = StringEscapeUtils.escapeSql((String)billIds);
        entryIds = StringEscapeUtils.escapeSql((String)entryIds);
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuilder updateSql = new StringBuilder();
        String confirmState = confirmAuth ? "5" : "null";
        updateSql.append("update T_HR_SAdjustSalaryNoticeEntry  set FSendState=2,FSendTime=null,FViewState=0,FViewTime=null,FConfirmState=" + confirmState + ",FResetTime=null,FConfirmTime=null,FConfirmType=null,fhtmlcontent='',FPdfAttachmentId='',FSignatureAttachmentId='',FLastUpdateUserID=?,FLastUpdateTime=now() where (FIsRemove<>1 or FIsRemove is null) ");
        if (!StringUtils.isEmpty((CharSequence)billIds)) {
            updateSql.append(" and FNoticeBillId in ").append(CmpStrUtil.buildInSql((String)billIds));
        }
        if (!StringUtils.isEmpty((CharSequence)entryIds)) {
            String createInSql = CmpSQLUtil.createInSql((Context)ctx, (String[])entryIds.split(","), (String)"T_HR_SAdjustSalaryNoticeEntry", (String)"fid");
            updateSql.append(" and fid in ").append("(" + createInSql + ")");
        }
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{currentUserInfo.getId().toString()});
    }

    public static AdjustSalaryNoticeTemplateInfo getNoticeTemplateInfo(Context ctx, String billId) throws EASBizException, BOSException {
        return AdjustSalaryNoticeTemplateFactory.getLocalInstance((Context)ctx).getAdjustSalaryNoticeTemplateInfo((IObjectPK)new ObjectUuidPK(billId));
    }

    public static void updateEntryTemplate(Context ctx, String billIds, String entryIds, String templateId, String hrOrgUnitId, String permItemId) throws BOSException, EASBizException {
        entryIds = StringEscapeUtils.escapeSql((String)entryIds);
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String oql = "select historyRelate.id where id = '" + templateId + "'";
        AdjustSalaryNoticeTemplateCollection templates = AdjustSalaryNoticeTemplateFactory.getLocalInstance((Context)ctx).getAdjustSalaryNoticeTemplateCollection(oql);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update T_HR_SAdjustSalaryNoticeEntry set FTemplateId = ?,FPdfAttachmentId='',FNoticeTitle=null,FHtmlContent=null,FSignatureAttachmentId=null ,FLastUpdateUserID=?,FLastUpdateTime=now() where  FSendState in (0,2,-1) and FAdjEntryState!=3");
        if (!StringUtils.isEmpty((CharSequence)billIds)) {
            updateSql.append(" and FNoticeBillId in ").append(CmpStrUtil.buildInSql((String)billIds));
        }
        if (!StringUtils.isEmpty((CharSequence)entryIds)) {
            String createInSql = CmpSQLUtil.createInSql((Context)ctx, (String[])entryIds.split(","), (String)"T_HR_SAdjustSalaryNoticeEntry", (String)"fid");
            updateSql.append(" and fid in ").append("(").append(createInSql).append(")");
        }
        if (!StringUtils.isEmpty((CharSequence)permItemId)) {
            String permSql;
            String adminSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
            updateSql.append(" and (FuseDefault = 1 and FAdminOrgUnitId in (" + adminSql + ") or fuseDefault = 0 or fuseDefault is null)");
            if (!StringUtils.isEmpty((CharSequence)hrOrgUnitId) && !StringUtils.isEmpty((CharSequence)(permSql = AdjustPermFilter.getAdjustPersonPermFilterByOrg(ctx, permItemId, hrOrgUnitId, "fpersonid", true)))) {
                updateSql.append(" and ").append(permSql);
            }
        }
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{templates.get(0).getHistoryRelate().getId().toString(), currentUserInfo.getId().toString()});
    }

    public static void updateEntryTemplate(Context ctx, String templateIds) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)templateIds)) {
            return;
        }
        templateIds = StringEscapeUtils.escapeSql((String)templateIds);
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update T_HR_SAdjustSalaryNoticeEntry  set FPdfAttachmentId='',FNoticeTitle=null,FHtmlContent=null,FSignatureAttachmentId=null ,FLastUpdateUserID=?,FLastUpdateTime=now()  where ( FSendState in (0,-1,2) and FAdjEntryState!=3)");
        updateSql.append(" and FTemplateId in (SELECT fid FROM T_HR_SAdjSalNoticeTemplateHIS where FHistoryRelateId in " + CmpStrUtil.buildInSql((String)templateIds) + ")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{currentUserInfo.getId().toString()});
    }

    public static void updateBatchEntryTemplate(Context ctx, List<AdjustSalaryNoticeEntryInfo> updateList) throws BOSException {
        if (updateList == null || updateList.isEmpty()) {
            return;
        }
        ArrayList batchUpdateEntryParams = new ArrayList();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = currentUserInfo.getId().toString();
        updateList.forEach(entryInfo -> {
            String billId;
            String templateId = entryInfo.getTemplate() == null || entryInfo.getTemplate().getId() == null ? "" : entryInfo.getTemplate().getId().toString();
            String personId = entryInfo.getPerson() == null || entryInfo.getPerson().getId() == null ? "" : entryInfo.getPerson().getId().toString();
            String string = billId = entryInfo.getNoticeBill() == null || entryInfo.getNoticeBill().getId() == null ? "" : entryInfo.getNoticeBill().getId().toString();
            if (StringUtils.isEmpty((CharSequence)personId) || StringUtils.isEmpty((CharSequence)billId)) {
                return;
            }
            batchUpdateEntryParams.add(new Object[]{templateId, userId, personId, billId});
        });
        if (batchUpdateEntryParams.isEmpty()) {
            return;
        }
        String updateSql = "update T_HR_SAdjustSalaryNoticeEntry set FTemplateId=?,FPdfAttachmentId='',FNoticeTitle=null,FHtmlContent=null,FSignatureAttachmentId=null ,FLastUpdateUserID=?,FLastUpdateTime=now() where FPersonId=? and FNoticeBillId=? ";
        DbUtil.executeBatch((Context)ctx, (String)updateSql, batchUpdateEntryParams);
    }

    public static void updateBatchEntryConfirmState(Context ctx, List<AdjustSalaryNoticeEntryInfo> updateList) throws BOSException {
        if (updateList == null || updateList.isEmpty()) {
            return;
        }
        ArrayList batchUpdateEntryParams = new ArrayList();
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = currentUserInfo.getId().toString();
        Date now = new Date(System.currentTimeMillis());
        updateList.forEach(entryInfo -> {
            int confirmValue = entryInfo.getConfirmState().getValue();
            Integer confirmType = entryInfo.getConfirmType() == null ? null : Integer.valueOf(entryInfo.getConfirmType().getValue());
            String entryId = entryInfo.getId().toString();
            Date nowvalue = null;
            if (entryInfo.getConfirmState() != ConfirmStateEnum.EXPIRED) {
                nowvalue = now;
            }
            batchUpdateEntryParams.add(new Object[]{confirmValue, confirmType, nowvalue, userId, now, entryId});
        });
        String updateSql = "update T_HR_SAdjustSalaryNoticeEntry set FConfirmState=?,fconfirmtype=?,FConfirmTime=?,FLastUpdateUserID=?,FLastUpdateTime=?  where fid = ? and FAdjEntryState !=3 and FConfirmState in (5,4) ";
        DbUtil.executeBatch((Context)ctx, (String)updateSql, batchUpdateEntryParams);
    }

    public static String getMultiLan(Context ctx, String label) {
        return EASResource.getString((String)"com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeResource", (String)label, (Locale)ctx.getLocale());
    }

    public static JSONArray combineBaseFields(Context ctx) throws BOSException {
        String oql = "select id,type,structureColumn.name, adjustItem.name, name, description order by lastUpdateTime";
        NoticeTemplateCFieldCollection collection = NoticeTemplateCFieldFactory.getLocalInstance(ctx).getNoticeTemplateCFieldCollection(oql);
        JSONArray commonFields = new JSONArray();
        JSONObject obj = new JSONObject();
        String COMMONS = "COMMONS";
        obj.put("id", (Object)COMMONS);
        obj.put("pId", (Object)"");
        obj.put("name", (Object)NoticeDaoUtils.getMultiLan(ctx, "label9"));
        obj.put("open", (Object)true);
        commonFields.add((Object)obj);
        obj = new JSONObject();
        obj.put("id", (Object)CommonFieldType.SERIES.getName());
        obj.put("pId", (Object)"");
        obj.put("name", (Object)NoticeDaoUtils.getMultiLan(ctx, "label10"));
        obj.put("open", (Object)true);
        commonFields.add((Object)obj);
        obj = new JSONObject();
        obj.put("id", (Object)CommonFieldType.SIGNATURE.getName());
        obj.put("pId", (Object)"");
        obj.put("name", (Object)NoticeDaoUtils.getMultiLan(ctx, "label12"));
        obj.put("open", (Object)true);
        commonFields.add((Object)obj);
        for (int i = 0; i < collection.size(); ++i) {
            String description;
            NoticeTemplateCFieldInfo cf = collection.get(i);
            String typeName = COMMONS;
            boolean isOften = true;
            boolean isHidden = false;
            obj = new JSONObject();
            String id = "";
            String name = "";
            if (cf.getType() == null) {
                isHidden = true;
                id = cf.getId().toString();
            } else if (CommonFieldType.SIGNATURE == cf.getType() || CommonFieldType.SERIES == cf.getType()) {
                typeName = cf.getType().getName();
                id = cf.getId().toString();
                isOften = false;
                isHidden = true;
            }
            String string = description = cf.getDescription() == null ? "" : cf.getDescription();
            if (!StringUtils.isEmpty((CharSequence)cf.getName())) {
                name = cf.getName();
            }
            if (cf.getType() == CommonFieldType.INFO_SET && null != cf.getStructureColumn()) {
                if (StringUtils.isEmpty((CharSequence)name)) {
                    name = cf.getStructureColumn().getName();
                }
                id = cf.getStructureColumn().getId().toString();
            } else if (cf.getType() == CommonFieldType.ADJ_ITEM && null != cf.getAdjustItem()) {
                if (StringUtils.isEmpty((CharSequence)name)) {
                    name = cf.getAdjustItem().getName();
                }
                id = cf.getAdjustItem().getId().toString();
            }
            if (StringUtils.isEmpty((CharSequence)id)) continue;
            obj.put("id", (Object)id);
            obj.put("name", (Object)name);
            obj.put("pId", (Object)typeName);
            obj.put("title", (Object)description);
            obj.put("isOften", (Object)isOften);
            obj.put("isHidden", (Object)isHidden);
            obj.put("isLeaf", (Object)true);
            obj.put("type", cf.getType() != null ? Integer.valueOf(cf.getType().getValue()) : null);
            commonFields.add((Object)obj);
        }
        return commonFields;
    }

    public static JSONArray combineQueryFields(Context ctx, JSONArray commonFields, Map<String, Object> commonIdsMap) throws BOSException {
        String oql = "select id,name,fields.id,fields.alias,fields.factField.number,fields.factField.structureConfig.EntityName,parent.id,fields.factField.structureConfig.clientNumber where scheme.number in ('006_CMP_ADJ')  and id not in ('8r0AAAANXew+uK4f') and (parent.id not in ('8r0AAAANXew+uK4f') or parent.id is null)  order by number,fields.index";
        QueryConfigCollection configs = QueryConfigFactory.getLocalInstance((Context)ctx).getQueryConfigCollection(oql);
        if (configs.isEmpty()) {
            return commonFields;
        }
        if (commonFields == null) {
            commonFields = new JSONArray();
        }
        for (int i = 0; i < configs.size(); ++i) {
            QueryConfigInfo c = configs.get(i);
            String tableId = c.getId().toString();
            String parentId = c.getParent() == null ? "" : c.getParent().getId().toString();
            String name = c.getName();
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)tableId);
            obj.put("pId", (Object)parentId);
            obj.put("name", (Object)name);
            obj.put("title", (Object)name);
            commonFields.add((Object)obj);
            QueryConfigFieldCollection fs = c.getFields();
            if (fs == null || fs.isEmpty()) continue;
            for (int j = 0; j < fs.size(); ++j) {
                QueryConfigFieldInfo f = fs.get(j);
                if (f.getFactField() == null || "yytsB50UTbWMbC/sPbuIgm/xHHM=".equals(f.getFactField().getId().toString()) || "4i4AAAABY35v8Rxz".equals(f.getFactField().getId().toString())) continue;
                obj = new JSONObject();
                String fId = f.getFactField().getId().toString();
                obj.put("id", (Object)fId);
                obj.put("pId", (Object)tableId);
                obj.put("name", (Object)f.getAlias());
                obj.put("title", (Object)f.getAlias());
                obj.put("isOften", (Object)(commonIdsMap != null && commonIdsMap.containsKey(fId) ? 1 : 0));
                obj.put("isLeaf", (Object)true);
                obj.put("type", (Object)1);
                commonFields.add((Object)obj);
            }
        }
        return commonFields;
    }

    public static void deleteCommonField(Context ctx, String fieldId, Integer type) throws EASBizException, BOSException {
        String delSql;
        if (2 == type) {
            delSql = "delete from T_HR_SNTemplateCField where FAdjustItemId=?";
            DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{fieldId});
        } else if (1 == type) {
            delSql = "delete from T_HR_SNTemplateCField where FStructureColumnId=?";
            DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{fieldId});
        }
        delSql = "delete from T_HR_SNTemplateCField where fid=?";
        DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{fieldId});
    }

    public static void addCommonField(Context ctx, String fieldId, String number, String name, Integer type) throws EASBizException, BOSException {
        NoticeTemplateCFieldInfo fieldInfo = new NoticeTemplateCFieldInfo();
        fieldInfo.setNumber(number);
        fieldInfo.setName(name);
        if (2 == type) {
            fieldInfo.setType(CommonFieldType.ADJ_ITEM);
            AdjustSalaryItemInfo itemInfo = new AdjustSalaryItemInfo();
            itemInfo.setId(BOSUuid.read((String)fieldId));
            fieldInfo.setAdjustItem(itemInfo);
        } else if (1 == type) {
            fieldInfo.setType(CommonFieldType.INFO_SET);
            StructureConfigColumnsInfo columnsInfo = new StructureConfigColumnsInfo();
            columnsInfo.setId(BOSUuid.read((String)fieldId));
            fieldInfo.setStructureColumn(columnsInfo);
        }
        NoticeTemplateCFieldFactory.getLocalInstance(ctx).addnew(fieldInfo);
    }

    public static String validateEntryTemplateBeforeUpdate(Context ctx, String billIds, String permItemId, String hrOrgUnitId) throws BOSException, SQLException, EASBizException {
        AdjustSalaryNoticeEntryCollection col;
        if (!StringUtils.isEmpty((CharSequence)hrOrgUnitId) && hrOrgUnitId.contains(",")) {
            throw new AdjustSalaryNoticeException(AdjustSalaryNoticeException.EXCEPTION0);
        }
        StringBuilder oql = new StringBuilder();
        oql.append("select sendState, noticeBill.adjBill.hrOrgUnit.id  where sendState in (0,2,-1)  and (adjEntryState!=3 or adjEntryState is null) ");
        oql.append(" and noticeBill.id in " + CmpStrUtil.buildInSql((String)billIds));
        if (!StringUtils.isEmpty((CharSequence)permItemId)) {
            String permSql;
            String adminSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
            oql.append(" and (useDefault = 1 and adminOrgUnit.id in (" + adminSql + ") or useDefault = 0 or useDefault is null)");
            if (!StringUtils.isEmpty((CharSequence)hrOrgUnitId) && !StringUtils.isEmpty((CharSequence)(permSql = AdjustPermFilter.getAdjustPersonPermFilterByOrg(ctx, permItemId, hrOrgUnitId, "person.id", true)))) {
                oql.append(" and ").append(permSql);
            }
        }
        if ((col = AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).getAdjustSalaryNoticeEntryCollection(oql.toString())).isEmpty()) {
            throw new AdjustSalaryNoticeException(AdjustSalaryNoticeException.EXCEPTION4);
        }
        return hrOrgUnitId;
    }

    public static void validateEntryBeforeDelete(Context ctx, String billIds) throws BOSException, SQLException, EASBizException {
        String billNumber;
        String querySql = "SELECT distinct sapply.fnumber FROM T_HR_SAdjustSalaryNoticeEntry nentry  left join  T_HR_SAdjustSalaryNoticeBill nbill on nentry.FNoticeBillId = nbill.fid  left join T_HR_SAdjustSalaryApply sapply on sapply.fid=nbill.FAdjBillId  where FAdjEntryState!=3 and nentry.FSendState in (1,3) and nbill.fid in " + CmpStrUtil.buildInSql((String)billIds);
        IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)querySql);
        List numberList = new ArrayList<String>();
        while (rs.next()) {
            String number = rs.getString("fnumber");
            numberList.add(number);
        }
        if (numberList.size() > 3) {
            numberList = numberList.subList(0, 3);
            billNumber = CmpStrUtil.join(numberList, (String)",", null) + "...";
        } else {
            billNumber = CmpStrUtil.join(numberList, (String)",", null);
        }
        if (!numberList.isEmpty()) {
            throw new AdjustSalaryNoticeException(AdjustSalaryNoticeException.EXCEPTION3, new Object[]{billNumber});
        }
    }

    public static void validateEntryBeforeAntiApproval(Context ctx, String billIds) throws BOSException, SQLException, EASBizException {
        String billNumber;
        String querySql = "SELECT distinct sapply.fnumber FROM T_HR_SAdjustSalaryNoticeEntry nentry  left join  T_HR_SAdjustSalaryNoticeBill nbill on nentry.FNoticeBillId = nbill.fid  left join T_HR_SAdjustSalaryApply sapply on sapply.fid=nbill.FAdjBillId  where (nentry.FIsRemove<>1 or nentry.FIsRemove is null) and FAdjEntryState!=3 and nentry.FSendState in (1,3) and sapply.fid in " + CmpStrUtil.buildInSql((String)billIds);
        IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)querySql);
        List numberList = new ArrayList<String>();
        while (rs.next()) {
            String number = rs.getString("fnumber");
            numberList.add(number);
        }
        if (numberList.size() > 3) {
            numberList = numberList.subList(0, 3);
            billNumber = CmpStrUtil.join(numberList, (String)",", null) + "...";
        } else {
            billNumber = CmpStrUtil.join(numberList, (String)",", null);
        }
        if (!numberList.isEmpty()) {
            throw new AdjustSalaryNoticeException(AdjustSalaryNoticeException.EXCEPTION5, new Object[]{billNumber});
        }
    }

    public static AdjustSalaryNoticeEntryCollection getNoticeEntryData(Context ctx, String billIds, String entryIds, String hrOrgUnitId, String permItemId) throws BOSException, EASBizException {
        StringBuilder oql = new StringBuilder("select id,person.id,person.number,person.name,sendState,confirmState,adjEntryState,template.id,template.historyRelate.confirmContent, template.historyRelate.confirmEmail,adjEntry.id,noticeBill.id where (isRemove<>1 or isRemove is null) ");
        if (!StringUtils.isEmpty((CharSequence)entryIds)) {
            String createInSql = CmpSQLUtil.createInSql((Context)ctx, (String[])entryIds.split(","), (String)"T_HR_SAdjustSalaryNoticeEntry", (String)"fid");
            oql.append(" and id in ").append("(" + createInSql + ")");
        }
        if (!StringUtils.isEmpty((CharSequence)billIds)) {
            oql.append(" and noticeBill.id in " + CmpStrUtil.buildInSql((String)billIds));
        }
        if (!StringUtils.isEmpty((CharSequence)permItemId)) {
            String permSql;
            String adminSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
            oql.append(" and (useDefault = 1 and adminOrgUnit.id in (" + adminSql + ") or useDefault = 0 or useDefault is null)");
            if (!StringUtils.isEmpty((CharSequence)hrOrgUnitId) && !StringUtils.isEmpty((CharSequence)(permSql = AdjustPermFilter.getAdjustPersonPermFilterByOrg(ctx, permItemId, hrOrgUnitId, "person.id", true)))) {
                oql.append(" and ").append(permSql);
            }
        }
        return AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).getAdjustSalaryNoticeEntryCollection(oql.toString());
    }

    public static AdjustSalaryNoticeEntryCollection checkTemplateUsed(Context ctx, String billIds) throws EASBizException, BOSException {
        StringBuilder oql = new StringBuilder("select template.id, template.historyRelate.id, template.historyRelate.number,noticeBill.adjBill.number where (isRemove<>1 or isRemove is null) and (noticeBill.isRemove<>1 or noticeBill.isRemove is null)  and template.historyRelate.id in " + CmpStrUtil.buildInSql((String)billIds) + " and sendState in (" + 0 + "," + 2 + "," + -1 + ")  and adjEntryState!=" + 3);
        return AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).getAdjustSalaryNoticeEntryCollection(oql.toString());
    }

    public static Set<String> getTemplateUsedSended(Context ctx, String billIds) throws EASBizException, BOSException {
        StringBuilder oql = new StringBuilder("select template.id, template.historyRelate.id, template.number,noticeBill.adjBill.number where (isRemove<>1 or isRemove is null)  and template.historyRelate.id in " + CmpStrUtil.buildInSql((String)billIds) + " and sendState in (" + 1 + "," + 3 + ")  and adjEntryState!=" + 3);
        AdjustSalaryNoticeEntryCollection entryCol = AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).getAdjustSalaryNoticeEntryCollection(oql.toString());
        HashSet<String> usedTemplateIds = new HashSet<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            AdjustSalaryNoticeEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getTemplate() == null || entryInfo.getTemplate().getHistoryRelate() == null) continue;
            usedTemplateIds.add(entryInfo.getTemplate().getHistoryRelate().getId().toString());
        }
        return usedTemplateIds;
    }

    public static AdjustSalaryNoticeTemplateCollection getTemplateData(Context ctx, String billIds) throws BOSException {
        String oql = "select id, state, sendState, historyRelate.id, adjEntryState where id in " + CmpStrUtil.buildInSql((String)billIds);
        return AdjustSalaryNoticeTemplateFactory.getLocalInstance((Context)ctx).getAdjustSalaryNoticeTemplateCollection(oql);
    }

    public static void deleteTemplateById(Context ctx, String templateIdInSql) throws EASBizException, BOSException {
        String oql = " where id in " + templateIdInSql + "";
        AdjustSalaryNoticeTemplateFactory.getLocalInstance((Context)ctx).delete(oql);
    }

    public static void sendCloudMessage(Context ctx, List<String> personIds, String content, CloudHubMessageConfigInfo adjSalaryNoticeConf) throws EASBizException, BOSException {
        if (personIds == null || personIds.isEmpty() || StringUtils.isEmpty((CharSequence)content)) {
            return;
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String personRange = cmpInSql.createInSqlBaseOnFId(ctx, personIds);
        String userOql = "select id, email, person.id where person.id in " + personRange;
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(userOql);
        if (userCollection.isEmpty()) {
            return;
        }
        String url = adjSalaryNoticeConf.getUrl();
        url = MessageFormat.format(url, adjSalaryNoticeConf.getAppId(), adjSalaryNoticeConf.getEid());
        HttpResultVo result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextLinkMessageToUser(content, adjSalaryNoticeConf.getAppId(), url, userCollection, adjSalaryNoticeConf.getPubaccName(), adjSalaryNoticeConf.isIsPrivate());
        if (result.getStatus() != 200) {
            throw new BOSException(NoticeDaoUtils.getMultiLan(ctx, "label30"));
        }
    }

    public static String getBillHrOrgUnitId(Context ctx, String billIds) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((CharSequence)billIds)) {
            return null;
        }
        HashSet<String> hrOrgIdSet = new HashSet<String>();
        AdjustSalaryNoticeBillCollection billCol = NoticeDaoUtils.getNoticeBillColById(ctx, billIds);
        for (int i = 0; i < billCol.size(); ++i) {
            AdjustSalaryNoticeBillInfo billInfo = billCol.get(i);
            if (billInfo.getAdjBill() == null || billInfo.getAdjBill().getHrOrgUnit() == null) continue;
            hrOrgIdSet.add(billInfo.getAdjBill().getHrOrgUnit().getId().toString());
        }
        return CmpStrUtil.convertSetToStringNew(hrOrgIdSet);
    }

    public static Set<String> getSchemeUsed(Context ctx, String billIds) throws BOSException {
        String oql = "select noticeTemplate.historyRelate.id where noticeTemplate.historyRelate.id in " + CmpStrUtil.buildInSql((String)billIds);
        CalSubmitSchemeCollection schemeCol = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeCollection(oql);
        HashSet<String> usedTemplateIds = new HashSet<String>();
        for (int i = 0; i < schemeCol.size(); ++i) {
            CalSubmitSchemeInfo schemeInfo = schemeCol.get(i);
            if (schemeInfo.getNoticeTemplate() == null || schemeInfo.getNoticeTemplate().getHistoryRelate() == null) continue;
            usedTemplateIds.add(schemeInfo.getNoticeTemplate().getHistoryRelate().getId().toString());
        }
        return usedTemplateIds;
    }

    public static int getOsfConfirmStatus(AdjustSalaryNoticeEntryInfo entryInfo, NoticeParamInfo paramInfo) {
        ConfirmStateEnum confirmState = entryInfo.getConfirmState();
        if (null == entryInfo.getConfirmState()) {
            return -1;
        }
        if (entryInfo.getConfirmState() == ConfirmStateEnum.CONFIRMED) {
            int autoConfirmed = 6;
            return entryInfo.getConfirmType() == AdjSalaryNoticeConfirmType.AUTO ? autoConfirmed : 1;
        }
        if (paramInfo.isEnableExpiration() && (ConfirmStateEnum.UNCONFIRMED == confirmState || ConfirmStateEnum.UNCONFIRM2 == confirmState)) {
            TimeUnitEnum unit;
            int days;
            boolean autoAuth;
            java.util.Date sendTime = entryInfo.getResetTime() != null ? entryInfo.getResetTime() : entryInfo.getSendTime();
            java.util.Date now = new java.util.Date();
            boolean bl = autoAuth = !paramInfo.isAutoAuth();
            if (autoAuth) {
                days = paramInfo.getAuthAfterDay();
                unit = paramInfo.getUnit();
            } else {
                days = paramInfo.getExpiredDays();
                unit = paramInfo.getExpiredUnit();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(sendTime);
            if (unit == TimeUnitEnum.MINUTE) {
                calendar.add(12, days);
            } else if (unit == TimeUnitEnum.HOUR) {
                calendar.add(10, days);
            } else {
                calendar.add(5, days);
            }
            sendTime = calendar.getTime();
            if (sendTime.compareTo(now) <= 0) {
                int confirmValue;
                if (autoAuth) {
                    entryInfo.setConfirmType(AdjSalaryNoticeConfirmType.AUTO);
                    entryInfo.setConfirmState(ConfirmStateEnum.CONFIRMED);
                    confirmValue = 6;
                } else {
                    entryInfo.setConfirmState(ConfirmStateEnum.EXPIRED);
                    confirmValue = 3;
                }
                return confirmValue;
            }
        }
        return entryInfo.getConfirmState().getValue();
    }

    public static String replaceFieldNull(Context ctx, NoticeTemplateCFieldCollection signatureFields, String htmlContent) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)htmlContent)) {
            return htmlContent;
        }
        if (signatureFields == null) {
            String oql = "select name, number, description where type =4";
            signatureFields = NoticeTemplateCFieldFactory.getLocalInstance(ctx).getNoticeTemplateCFieldCollection(oql);
        }
        NoticeTemplateCFieldInfo sigField = NoticeDaoUtils.filterByNumber("signature", signatureFields);
        String signatureField = "##" + sigField.getName() + "##";
        NoticeTemplateCFieldInfo signingDayField = NoticeDaoUtils.filterByNumber("Signing_Day", signatureFields);
        String signingDay = "##" + signingDayField.getName() + "##";
        htmlContent = htmlContent.replace(signatureField, "&nbsp;&nbsp;");
        htmlContent = htmlContent.replace(signingDay, "&nbsp;&nbsp;");
        return htmlContent;
    }

    public static NoticeTemplateCFieldInfo filterByNumber(String number, NoticeTemplateCFieldCollection signatureFields) {
        for (int i = 0; i < signatureFields.size(); ++i) {
            if (!number.equals(signatureFields.get(i).getNumber())) continue;
            return signatureFields.get(i);
        }
        return signatureFields.get(0);
    }
}

