/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.econtractservice.SSCEContractRecordFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.SSCEContractTaskFactory;
import com.kingdee.shr.econtractservice.SSCEContractTaskInfo;
import com.kingdee.shr.econtractservice.service.EContractService;
import com.kingdee.shr.econtractservice.service.IEContractTask;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractCompanyTask
implements IEContractTask {
    private static final Logger logger = LoggerFactory.getLogger(EContractCompanyTask.class);
    private Context ctx;
    private String taskKey;
    private String billId;
    private String jobId;
    private SSCEContractTaskInfo taskInfo;
    private SSCEContractRecordInfo recordInfo;
    private boolean hasNotice = false;
    private boolean success = false;

    public EContractCompanyTask(Context ctx, SSCEContractRecordInfo recordInfo, SSCEContractTaskInfo taskInfo) {
        this.ctx = ctx;
        this.recordInfo = recordInfo;
        this.taskInfo = taskInfo;
        this.billId = recordInfo.getBillId().toString();
        this.taskKey = this.billId + "_COMPANY_TASK";
        this.jobId = taskInfo.getJobId();
        this.hasNotice = false;
        this.success = false;
    }

    @Override
    public Object processSuccess() throws EASBizException, BOSException {
        this.hasNotice = true;
        this.success = true;
        Timestamp curTimestamp = EContractService.getCurTimestamp();
        this.recordInfo.setIsCompanySign(true);
        this.recordInfo.setCompanySignTime(curTimestamp);
        this.recordInfo.setIsSigned(true);
        this.recordInfo.setSignedTime(curTimestamp);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isCompanySign"));
        selector.add(new SelectorItemInfo("companySignTime"));
        selector.add(new SelectorItemInfo("isSigned"));
        selector.add(new SelectorItemInfo("signedTime"));
        if (!this.recordInfo.isIsPersonSign()) {
            this.recordInfo.setIsPersonSign(true);
            this.recordInfo.setPersonSignTime(curTimestamp);
            selector.add(new SelectorItemInfo("isPersonSign"));
            selector.add(new SelectorItemInfo("personSignTime"));
        }
        SSCEContractRecordFactory.getLocalInstance(this.ctx).updatePartial(this.recordInfo, selector);
        this.taskInfo.setIsAutoClose(false);
        this.taskInfo.setIsProcess(true);
        this.taskInfo.setProcessTime(curTimestamp);
        this.taskInfo.setCallbackTime(curTimestamp);
        selector.clear();
        selector.add(new SelectorItemInfo("isAutoClose"));
        selector.add(new SelectorItemInfo("isProcess"));
        selector.add(new SelectorItemInfo("processTime"));
        selector.add(new SelectorItemInfo("callbackTime"));
        SSCEContractTaskFactory.getLocalInstance(this.ctx).updatePartial(this.taskInfo, selector);
        return null;
    }

    @Override
    public Object processFail() throws EASBizException, BOSException {
        this.hasNotice = true;
        this.success = false;
        this.taskInfo.setIsProcess(false);
        this.taskInfo.setProcessTime(null);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isProcess"));
        selector.add(new SelectorItemInfo("processTime"));
        SSCEContractTaskFactory.getLocalInstance(this.ctx).updatePartial((CoreBaseInfo)this.recordInfo, selector);
        return this.recordInfo;
    }

    public String getBillId() {
        return this.billId;
    }

    public String getJobId() {
        return this.jobId;
    }

    @Override
    public boolean isHasNotice() {
        return this.hasNotice;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String getTaskKey() {
        return this.taskKey;
    }

    public String toString() {
        return "EContractCompanyTask [taskKey=" + this.taskKey + ", billId=" + this.billId + ", jobId=" + this.jobId + ", taskInfo=" + JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.taskInfo) + ", recordInfo=" + JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.recordInfo) + ", hasNotice=" + this.hasNotice + ", success=" + this.success + "]";
    }

    @Override
    public int status() {
        if (this.isHasNotice() && !this.isSuccess()) {
            return -1;
        }
        if (this.isHasNotice() && this.isSuccess()) {
            return 1;
        }
        if (!this.isHasNotice()) {
            return 9;
        }
        return 0;
    }
}

