/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.util.ShrSubSystemUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class ShrTableStructureGenerator {
    private Context ctx;

    public ShrTableStructureGenerator(Context ctx) {
        this.ctx = ctx;
    }

    public void doGenerate() throws BOSException, EASBizException {
        DefaultKingdeeTreeNode node = ShrSubSystemUtil.getSubSystem((String)"com_kingdee_eas_base_subsystemEntity", (String)"com.kingdee.eas.hr");
        HashMap<String, StringBuilder> resultEnUS = new HashMap<String, StringBuilder>();
        HashMap<String, StringBuilder> resultZhTw = new HashMap<String, StringBuilder>();
        this.genSqlContent(node, resultEnUS, resultZhTw);
        try {
            this.genFile(SHRSyssettingUtil.getIotmpdir(), resultEnUS, "en_US");
            this.genFile(SHRSyssettingUtil.getIotmpdir(), resultZhTw, "zh_TW");
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genFile(String iotmpdir, Map<String, StringBuilder> content, String sub) throws IOException {
        for (Map.Entry<String, StringBuilder> entry : content.entrySet()) {
            File f;
            String file = iotmpdir + File.separator + "extendTableMultiLanField" + File.separator + entry.getKey().replace(".", "_") + "_" + sub + ".sql";
            File dir = new File(iotmpdir + File.separator + "extendTableMultiLanField");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((f = new File(file)).exists()) {
                f.delete();
            }
            FileOutputStream fo = null;
            BufferedOutputStream bo = null;
            try {
                f.createNewFile();
                fo = new FileOutputStream(f);
                bo = new BufferedOutputStream(fo);
                bo.write(entry.getValue().toString().getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (bo != null) {
                    try {
                        bo.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        bo.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fo == null) continue;
                try {
                    fo.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void genSqlContent(DefaultKingdeeTreeNode node, Map<String, StringBuilder> resultEnUS, Map<String, StringBuilder> resultZhTw) throws BOSException, EASBizException {
        if (!node.isLeaf()) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode nextElement = (DefaultKingdeeTreeNode)children.nextElement();
                this.genSqlContent(nextElement, resultEnUS, resultZhTw);
            }
        } else {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
            MetaDataBriefInfo pUserObject = (MetaDataBriefInfo)parent.getUserObject();
            MetaDataBriefInfo userObject = (MetaDataBriefInfo)node.getUserObject();
            pUserObject.getPackgeName();
            userObject.getMetaDataPK();
            StringBuilder sbEnUs = resultEnUS.get(pUserObject.getPackgeName());
            StringBuilder sbZhTw = resultZhTw.get(pUserObject.getPackgeName());
            if (null == sbEnUs) {
                sbEnUs = new StringBuilder();
                resultEnUS.put(pUserObject.getPackgeName(), sbEnUs);
            }
            if (null == sbZhTw) {
                sbZhTw = new StringBuilder();
                resultZhTw.put(pUserObject.getPackgeName(), sbZhTw);
            }
            this.addSqlContent(sbEnUs, sbZhTw, userObject);
        }
    }

    private void addSqlContent(StringBuilder sbEnUs, StringBuilder sbZhTw, MetaDataBriefInfo userObject) {
        EntityObjectInfo eo = BaseMetaDataUtil.getEntityObjectInfo((Context)this.ctx, (BOSObjectType)userObject.getBOType());
        if (eo.getBOSType() == null) {
            return;
        }
        if (eo.isAbstract()) {
            return;
        }
        DataTableInfo dt = eo.getTable();
        if (dt == null) {
            return;
        }
        try {
            PropertyCollection p = eo.getPropertiesRuntime();
            if (p == null || p.size() <= 0) {
                return;
            }
            OwnPropertyInfo p0 = null;
            ColumnInfo ci = null;
            String fieldName_en = null;
            String fieldName_tw = null;
            String fieldTemplate = "{0}_{1}";
            String sql = "If exists (select * from KSQL_USERTABLES where KSQL_TABNAME =''{0}'') \n begin \n If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME =''{1}'' and KSQL_COL_TABNAME=''{2}'' and KSQL_COL_LENGTH < {3}) \n ALTER TABLE {4} alter {5} NVARCHAR({6}) \n end;";
            int total = p.size();
            for (int i = 0; i < total; ++i) {
                if (!(p.get(i) instanceof OwnPropertyInfo) || !(p0 = (OwnPropertyInfo)p.get(i)).isMultilingual() || (ci = p0.getMappingField()).getLength() > 1000 || SQLType.NVARCHAR.getSQLType() != ci.getSQLType() && SQLType.VARCHAR.getSQLType() != ci.getSQLType()) continue;
                fieldName_en = MessageFormat.format(fieldTemplate, ci.getName(), "l1");
                fieldName_tw = MessageFormat.format(fieldTemplate, ci.getName(), "l3");
                String length = String.valueOf(ci.getLength() * 2).replace(",", "");
                sbEnUs.append(MessageFormat.format(sql, dt.getName(), fieldName_en, dt.getName(), length, dt.getName(), fieldName_en, length)).append("\n");
                sbZhTw.append(MessageFormat.format(sql, dt.getName(), fieldName_tw, dt.getName(), length, dt.getName(), fieldName_tw, length)).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

