/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.tools.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.ml.tools.metadata.IGenMetadata;
import com.kingdee.util.STConverter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class AbstractGenMetadata
implements IGenMetadata {
    private Document getDocument(Element metadataConfigRootElement) {
        Element rootElement = new Element(metadataConfigRootElement.getAttributeValue("rootName"), metadataConfigRootElement.getAttributeValue("rootXmlns"));
        List<Map<String, String>> commonList = this.addCommonElements(metadataConfigRootElement, rootElement);
        List<Map<String, String>> privateList = this.addPrivateElements(metadataConfigRootElement, rootElement);
        Element resource = new Element("resource");
        this.addResourceElements(resource, commonList);
        this.addResourceElements(resource, privateList);
        rootElement.addContent((Content)resource);
        Document d = new Document(rootElement);
        return d;
    }

    private void addResourceElements(Element resource, List<Map<String, String>> list) {
        if (list == null || list.size() <= 0) {
            return;
        }
        Element rs = null;
        for (Map<String, String> m : list) {
            rs = new Element("rs");
            rs.setAttribute("key", m.get("key"));
            this.addMultiLanElements(rs, m.get("value"));
            resource.addContent((Content)rs);
        }
    }

    protected final void addMultiLanElements(Element rs, String value) {
        this.addLangElement(rs, "en_US", value);
        this.addLangElement(rs, "zh_CN", value);
        this.addLangElement(rs, "zh_TW", value);
    }

    private void addLangElement(Element rs, String locale, String value) {
        Element lang = new Element("lang");
        lang.setAttribute("locale", locale);
        if ("en_US".equals(locale)) {
            lang.setAttribute("value", "null");
        } else if ("zh_TW".equals(locale)) {
            lang.setAttribute("value", STConverter.sc2tc((String)value));
        } else {
            lang.setAttribute("value", value);
        }
        rs.addContent((Content)lang);
    }

    public abstract List<Map<String, String>> addPrivateElements(Element var1, Element var2);

    protected final String getCommonKey(Element metadataConfigRootElement, String currentElementName) {
        return MessageFormat.format("{0}[{1}].{2}", metadataConfigRootElement.getAttributeValue("rootName"), this.getFullName(metadataConfigRootElement), currentElementName);
    }

    protected final String getFullName(Element metadataConfigRootElement) {
        String fullName = MessageFormat.format("{0}.app.{1}", metadataConfigRootElement.getAttributeValue("pkg"), metadataConfigRootElement.getAttributeValue("name"));
        String metaType = metadataConfigRootElement.getAttributeValue("metaType");
        if ("resource".equals(metaType) || "enum".equals(metaType) || "exception".equals(metaType)) {
            fullName = MessageFormat.format("{0}.{1}", metadataConfigRootElement.getAttributeValue("pkg"), metadataConfigRootElement.getAttributeValue("name"));
        } else if ("ui".equals(metaType)) {
            fullName = MessageFormat.format("{0}.client.{1}", metadataConfigRootElement.getAttributeValue("pkg"), metadataConfigRootElement.getAttributeValue("name"));
        }
        return fullName;
    }

    private List<Map<String, String>> addCommonElements(Element metadataConfigRootElement, Element rootElement) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Element e = new Element("package");
        e.setText(metadataConfigRootElement.getAttributeValue("pkg"));
        rootElement.addContent((Content)e);
        e = new Element("name");
        e.setText(metadataConfigRootElement.getAttributeValue("name"));
        rootElement.addContent((Content)e);
        HashMap<String, String> map = new HashMap<String, String>();
        e = new Element("alias");
        map.put("key", this.getCommonKey(metadataConfigRootElement, e.getName()));
        map.put("value", metadataConfigRootElement.getAttributeValue(e.getName()));
        e.setText((String)map.get("key"));
        list.add(map);
        rootElement.addContent((Content)e);
        map = new HashMap();
        e = new Element("description");
        map.put("key", this.getCommonKey(metadataConfigRootElement, e.getName()));
        map.put("value", metadataConfigRootElement.getAttributeValue(e.getName()));
        e.setText((String)map.get("key"));
        list.add(map);
        rootElement.addContent((Content)e);
        e = new Element("userDefined");
        e.setText("false");
        rootElement.addContent((Content)e);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void genMetadata() throws BOSException {
        try {
            Document configs = SHRSyssettingUtil.getXmlFileByPath((String)SHRSyssettingUtil.getMetadataconfigPathByFileName((String)"ResourceMetadataConfig.xml"));
            List l = configs.getRootElement().getChildren("config");
            if (null == l || l.size() <= 0) {
                return;
            }
            StringBuffer s = new StringBuffer();
            s.append(SHRSyssettingUtil.getEASHomePath()).append(File.separator).append("work_metadata");
            File dir = new File(s.toString());
            if (!dir.exists()) {
                dir.mkdir();
            }
            for (Element metadataConfigRootElement : l) {
                String context = XMLUtil.getXMLOutputter().outputString(this.getDocument(metadataConfigRootElement));
                context = context.replace(" xmlns=\"\"", "");
                s = new StringBuffer();
                s.append(dir.getAbsolutePath()).append(File.separator).append(metadataConfigRootElement.getAttributeValue("name")).append(".").append(metadataConfigRootElement.getAttributeValue("metaType"));
                File f0 = new File(s.toString());
                if (f0.exists()) {
                    f0.delete();
                }
                FileOutputStream fo = null;
                FilterOutputStream bo = null;
                try {
                    f0.createNewFile();
                    fo = new FileOutputStream(f0);
                    bo = new BufferedOutputStream(fo);
                    bo.write(context.toString().getBytes());
                    ((BufferedOutputStream)bo).flush();
                }
                finally {
                    if (bo != null) {
                        bo.close();
                    }
                    if (fo == null) continue;
                    fo.close();
                }
            }
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

